/*
** nester - NES emulator
** Copyright (C) 2000  Darren Ranalli
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, 
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
** Library General Public License for more details.  To obtain a 
** copy of the GNU Library General Public License, write to the Free 
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** Any permitted reproduction of these routines, in whole or in part,
** must bear this legend.
*/

#ifndef _SCREEN_MGR_H_
#define _SCREEN_MGR_H_

#include "types.h"
#include "pixmap.h"

//uint32 SCRMGR_get_width();
//uint32 SCRMGR_get_height();

boolean SCRMGR_lock(pixmap *p);
boolean SCRMGR_unlock();

void SCRMGR_blt();
void SCRMGR_flip();

void SCRMGR_clear(PIXEL color);

boolean SCRMGR_set_palette(const uint8 pal[256][3]);
boolean SCRMGR_get_palette(uint8 pal[256][3]);
boolean SCRMGR_set_palette_section(uint8 start, uint8 len);
boolean SCRMGR_get_palette_section(uint8 start, uint8 len, uint8 pal[][3]);

void assert_palette();

#endif
