/*
** nester - NES emulator
** Copyright (C) 2000  Darren Ranalli
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, 
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
** Library General Public License for more details.  To obtain a 
** copy of the GNU Library General Public License, write to the Free 
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** Any permitted reproduction of these routines, in whole or in part,
** must bear this legend.
*/

#include <stdio.h>
#include <string.h>
//#include <malloc.h>
#include "../GBA_main.h"
#include "NES_ROM.h"

#include "../GBA_globals.h"
#include "../debug/debug.h"

struct NES_header ROM_header;
uint8 ROM_mapper;

uint8* ROM_trainer;
uint8* ROM_ROM_banks;
uint8* ROM_VROM_banks;

char* ROM_rom_name; // filename w/out ".NES"
char* ROM_rom_name_ext; // filename w/ ".NES"
char* ROM_rom_path; // rom file path

//rww begin
int CheckROMStatus(void)
{
	return globals->nesRom->romLen;
}
//rww end

extern void *GBA_RomAlloc(int size);

void ROM_OldConstructFunc(void)
{
  FILE* fp;
  int l;
  int i;
  int n;
  int sLen;
  static char inf[4096];

  fp         = 0;

  ROM_trainer    = 0;
  ROM_ROM_banks  = 0;
  ROM_VROM_banks = 0;

  ROM_rom_name = 0;
  ROM_rom_path = 0;

  l = 14;//strlen("INSERTROMHERE:");
  i = 0;

  n = sizeof(struct NES_header);
  memcpy_gba(&ROM_header, globals->nesRom->romData, n);
  i += n;

  sLen = (int)strlen(globals->nesRom->romName+l);
  ROM_rom_name = (char *)nestermalloc(sLen+1);
  strcpy(ROM_rom_name, globals->nesRom->romName+l);
  strlwr(ROM_rom_name);

  ROM_rom_name_ext = (char *)nestermalloc(sLen+1);
  strcpy(ROM_rom_name_ext, globals->nesRom->romName+l);
  strlwr(ROM_rom_name_ext);

  ROM_rom_path = (char *)nestermalloc(sLen+1);
  strcpy(ROM_rom_path, globals->nesRom->romName+l);
  strlwr(ROM_rom_path);

  if(strncmp((const char*)ROM_header.id, "NES", 3) || (ROM_header.ctrl_z != 0x1A))
  {
	  GBA_Log("unexpected header...");
  }

  sprintf(inf, "rom name-%s\nlen-%i", ROM_rom_name, globals->nesRom->romLen);
  GBA_Log(inf);

  if (ROM_has_trainer())
  {
	  n = ROM_TRAINER_LEN;
	  //trainer = &globals->nesRom->romData[i];
	  ROM_trainer = (uint8*)nestermalloc(n);
	  memcpy(ROM_trainer, &globals->nesRom->romData[i], n);

	  i += n;
	  GBA_Log("trainer detected");
  }

  n = (16*1024)*ROM_header.num_16k_rom_banks;
  //ROM_ROM_banks = &globals->nesRom->romData[i];
  ROM_ROM_banks = (uint8 *)GBA_RomAlloc(n);
  if (!ROM_ROM_banks)
  {
	  GBA_Log("ran out of memory");
  }
  else
  {
	  GBA_Log("allocated rom space");
  }
  memcpy_gba(ROM_ROM_banks, &globals->nesRom->romData[i], n);

  i += n;

  n = (8*1024)*ROM_header.num_8k_vrom_banks;
  //ROM_VROM_banks = &globals->nesRom->romData[i];
  ROM_VROM_banks = (uint8*)GBA_RomAlloc(n);
  if (!ROM_VROM_banks)
  {
	  GBA_Log("ran out of memory");
  }
  memcpy_gba(ROM_VROM_banks, &globals->nesRom->romData[i], n);

  i += n;

  /*
  sprintf(inf, "%i 8k vrom banks\n%i 16k rom banks", header.num_8k_vrom_banks, header.num_16k_rom_banks);
  GBA_Log(inf);

  sprintf(inf, "header size %i, %i", sizeof(NES_header), sizeof(nesRom_t));
  GBA_Log(inf);
  */

  // figure out mapper number
  ROM_mapper = (ROM_header.flags_1 >> 4);

  // if there is anything in the reserved bytes,
  // don't trust the high nybble of the mapper number
  for(/*uint32*/ i = 0; i < (int)sizeof(ROM_header.reserved); i++)
  {
    if(ROM_header.reserved[i] != 0x00) return;
  }
  ROM_mapper |= (ROM_header.flags_2 & 0xF0);

}

void ROM_GetPathInfo(const char* fn)
{
  // find index of first letter of actual ROM file name (after path)
  uint32 i = (uint32)strlen(fn); // start at end of string

  while(1)
  {
    // look for directory delimiter
    if((fn[i] == '\\') || (fn[i] == '/'))
    {
      i++;
      break;
    }

    i--;
    if(!i) break;
  }

  // copy rom name w/o extension
  {
    uint32 j = i;
    uint32 a = 0;

    // copy up to period
    while(1)
    {
      if(!fn[j]) break;
      if(fn[j] == '.') break;

      ROM_rom_name[a] = fn[j];

      a++;
      j++;
    }

    // terminate rom name string
    ROM_rom_name[a] = '\0';
  }

  // copy rom name w/ extension
  {
    uint32 j = i;
    uint32 a = 0;

    // copy up to period
    while(1)
    {
      if(!fn[j]) break;

      ROM_rom_name_ext[a] = fn[j];

      a++;
      j++;
    }

    // terminate rom name string
    ROM_rom_name_ext[a] = '\0';
  }

  // copy rom path
  {
    uint32 j = 0;

    // copy up to rom file name
    while(j < i)
    {
      ROM_rom_path[j] = fn[j];
      j++;
    }

    // terminate rom path string
    ROM_rom_path[i] = '\0';
  }

}
