unit _exif;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, FileCtrl;

procedure InitExif;
function LoadExif(fn:string):boolean;

var
  ExifStr_ImageDescription:string; // Tag:0x010e
  ExifStr_Make:string; // Tag:0x010f
  ExifStr_Model:string; // Tag:0x0110
  ExifStr_Software:string; // Tag:0x0131
  ExifStr_DateTime:string; // Tag:0x0132
  ExifStr_Copyright:string; // Tag:0x8298

implementation

procedure InitExif;
begin
  ExifStr_ImageDescription:='';
  ExifStr_Make:='';
  ExifStr_Model:='';
  ExifStr_Software:='';
  ExifStr_DateTime:='';
  ExifStr_Copyright:='';
end;

const ExifIDSize=10;
var
  ExifID:array[0..ExifIDSize-1] of byte=($FF,$E1,$FE,$FE,$45,$78,$69,$66,$00,$00);

function LoadExif(fn:string):boolean;
var
  rfs:TFileStream;
  bufsize:integer;
  buf:array of byte;
  Offset:integer;
  TIFFOffset:integer;
  IntelOrder:boolean;
  EntryIndex,EntryCount:integer;
  TagID:word;
  TagOffset:dword;
  Offset_ImageDescription:integer;
  Offset_Make:integer;
  Offset_Model:integer;
  Offset_Software:integer;
  Offset_DateTime:integer;
  Offset_Copyright:integer;
  t:string;
  function FindExifID:integer;
  var
    ofs:integer;
    v:integer;
    chk:boolean;
  begin
    for ofs:=0 to bufsize-ExifIDSize-1 do begin
      chk:=True;
      for v:=0 to ExifIDSize-1 do begin
        if ExifID[v]<>$fe then begin
          if buf[ofs+v]<>ExifID[v] then chk:=False;
        end;
      end;
      if chk=True then begin
        Result:=ofs+ExifIDSize;
        exit;
      end;
    end;
    Result:=-1;
  end;
  function Read8:byte;
  begin
    if bufsize<(Offset+1) then begin
      Result:=0;
      exit;
    end;
    Result:=buf[Offset];
    inc(Offset);
  end;
  function Read16:word;
  var
    ofs:integer;
  begin
    if bufsize<(Offset+2) then begin
      Result:=0;
      exit;
    end;
    ofs:=Offset;
    Result:=0;
    if IntelOrder=False then begin
      Result:=(Result shl 8) or buf[ofs+0];
      Result:=(Result shl 8) or buf[ofs+1];
      end else begin
      Result:=(Result shl 8) or buf[ofs+1];
      Result:=(Result shl 8) or buf[ofs+0];
    end;
    Offset:=ofs+2;
  end;
  function Read32:dword;
  var
    ofs:integer;
  begin
    if bufsize<(Offset+4) then begin
      Result:=0;
      exit;
    end;
    ofs:=Offset;
    Result:=0;
    if IntelOrder=False then begin
      Result:=(Result shl 8) or buf[ofs+0];
      Result:=(Result shl 8) or buf[ofs+1];
      Result:=(Result shl 8) or buf[ofs+2];
      Result:=(Result shl 8) or buf[ofs+3];
      end else begin
      Result:=(Result shl 8) or buf[ofs+3];
      Result:=(Result shl 8) or buf[ofs+2];
      Result:=(Result shl 8) or buf[ofs+1];
      Result:=(Result shl 8) or buf[ofs+0];
    end;
    Offset:=ofs+4;
  end;
  function ReadStr(ofs:integer):string;
  var
    chkspace:boolean;
  begin
    Result:='';
    chkspace:=True;
    if ofs=-1 then exit;
    while(buf[ofs]<>$00) do begin
      Result:=Result+char(buf[ofs]);
      if buf[ofs]<>byte(' ') then chkspace:=False;
      inc(ofs);
    end;
    if chkspace=True then Result:='';
  end;
begin
  Result:=False;

  if lowercase(ExtractFileExt(fn))<>'.jpg' then exit;
  if FileExists(fn)=False then exit;

  rfs:=TFileStream.Create(fn,fmOpenRead);
  bufsize:=rfs.Size;
  setlength(buf,bufsize);
  rfs.ReadBuffer(buf[0],bufsize);
  rfs.Free;

  Offset:=FindExifID;
  if Offset=-1 then exit;

  TIFFOffset:=Offset;

  if (buf[Offset+0]=$4d) and (buf[Offset+1]=$4d) and (buf[Offset+2]=$00) and (buf[Offset+3]=$2a) then begin
    IntelOrder:=False;
    end else begin
    if (buf[Offset+0]=$49) and (buf[Offset+1]=$49) and (buf[Offset+2]=$2a) and (buf[Offset+3]=$00) then begin
      IntelOrder:=True;
      end else begin
      exit;
    end;
  end;
  inc(Offset,4);

  Read32; // Offset to first IFD

  EntryCount:=Read16;
  Offset_ImageDescription:=-1;
  Offset_Make:=-1;
  Offset_Model:=-1;
  Offset_Software:=-1;
  Offset_DateTime:=-1;
  Offset_Copyright:=-1;

  for EntryIndex:=0 to EntryCount-1 do begin
    TagID:=Read16;
    Read16; // DataFormat
    Read32; // DataCount
    TagOffset:=TIFFOffset+integer(Read32);
    if TagID=$010e then Offset_ImageDescription:=TagOffset;
    if TagID=$010f then Offset_Make:=TagOffset;
    if TagID=$0110 then Offset_Model:=TagOffset;
    if TagID=$0131 then Offset_Software:=TagOffset;
    if TagID=$0132 then Offset_DateTime:=TagOffset;
    if TagID=$8298 then Offset_Copyright:=TagOffset;
  end;

  ExifStr_ImageDescription:=ReadStr(Offset_ImageDescription);
  ExifStr_Make:=ReadStr(Offset_Make);
  ExifStr_Model:=ReadStr(Offset_Model);
  ExifStr_Software:=ReadStr(Offset_Software);
  ExifStr_DateTime:=ReadStr(Offset_DateTime);
  ExifStr_Copyright:=ReadStr(Offset_Copyright);

//  if (ExifStr_ImageDescription='') and (ExifStr_DateTime='') then exit;

  t:=ExifStr_ImageDescription;
  t:=trim(t);
  ExifStr_ImageDescription:=copy(t,1,254);

  t:=ExifStr_DateTime;
  t:=copy(t,1,20);
  if 10<=length(t) then begin
    if t[5]=':' then t[5]:='/';
    if t[8]=':' then t[8]:='/';
  end;
  t:=trim(t);
  ExifStr_DateTime:=copy(t,1,20);

  Result:=True;
end;

end.
