unit _inifile;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ExtCtrls, Buttons, INIFiles, _m_Tools;

procedure LoadINI;
procedure SaveINI;

implementation

uses MainWin;

const CRLF:string=char($0d)+char($0a);

function GetINIFilename:string;
begin
  Result:=ChangeFileExt(Application.ExeName,'.ini');
end;

procedure LoadINI;
var
  fini:TINIFile;
  Section:string;
  chk:boolean;
begin
  fini:=TINIFile.Create(GetINIFilename);

  Section:='ConvertSettings';

  chk:=fini.ReadBool(Section,'ColorDepth8bit',Main.ColorDepth8bitRadio.Checked);
  Main.ColorDepth8bitRadio.Checked:=chk;
  Main.ColorDepth24bitRadio.Checked:=not chk;

  Main.InsideClipChk.Checked:=fini.ReadBool(Section,'InsideClip',Main.InsideClipChk.Checked);
  BorderColor:=fini.ReadInteger(Section,'BorderColor',BorderColor);

  fini.Free;
end;

procedure SaveINI;
var
  fini:TINIFile;
  Section:string;
begin
  fini:=TINIFile.Create(GetINIFilename);

  Section:='ConvertSettings';

  fini.WriteBool(Section,'ColorDepth8bit',Main.ColorDepth8bitRadio.Checked);

  fini.WriteBool(Section,'InsideClip',Main.InsideClipChk.Checked);
  fini.WriteInteger(Section,'BorderColor',BorderColor);

  fini.Free;
end;

end.
