unit MainWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, Buttons, ExtDlgs, Menus,ShellAPI;

type
  TMain = class(TForm)
    StartupTimer: TTimer;
    ReadmeMemo: TMemo;
    PrgBar: TProgressBar;
    DDLbl: TLabel;
    LargeThumbChk: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure StartupTimerTimer(Sender: TObject);
  private
    { Private 錾 }
    procedure WMDROPFILES(var msg:TWMDROPFILES);message WM_DROPFILES;
    procedure CreateThumb(basepath:string);
  public
    { Public 錾 }
  end;

var
  Main: TMain;

implementation

{$R *.dfm}

uses _inifile, SelMLWin,_SplitML,_PicTools,_m_Tools,_loadimage,zlib;

const CRLF:string=char($0d)+char($0a);

var
  StartPath:string;

procedure TMain.FormCreate(Sender: TObject);
begin
  StartPath:=ExtractFilePath(Application.ExeName);

  Application.Title:='Thumbnail icon maker for MoonShell2.';
  Main.Caption:=Application.Title;

  DragAcceptFiles(Main.handle,True); // D&D Start

  StartupTimer.Enabled:=True;
end;

procedure TMain.StartupTimerTimer(Sender: TObject);
begin
  StartupTimer.Enabled:=False;

  ReadmeMemo.Clear;
  ReadmeMemo.Height:=Main.ClientHeight-ReadmeMemo.Top;

  if GetMLTypeLoaded=False then begin
    if SelML.ShowModal=mrCancel then begin
      Application.Terminate;
      exit;
    end;
  end;

  LoadINI;

  SetMLLbl(DDLbl);
  SetMLChk(LargeThumbChk);
  
  ReadmeMemo.Lines.LoadFromFile(StartPath+GetMLStr('readme_eng.txt|readme_jpn.txt'));
end;

procedure TMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  SaveINI;
  DragAcceptFiles(Main.handle,False); // D&D Stop
end;

procedure TMain.WMDROPFILES(var msg:TWMDROPFILES);
var
  Drop:hdrop;
  index:longint;
  idx:integer;
  Filename:string;
  filebuf:array[0..1024] of char;
  cnt:integer;
begin
  Filename:=StringOfChar(' ',1024);
  Drop:=msg.Drop;
  index:=DragQueryFile(Drop,$FFFFFFFF,nil,0);

  for idx:=0 to index-1 do begin
    DragQueryFileA(Drop,idx,filebuf,1024);
    Filename:='';
    cnt:=0;
    while ((filebuf[cnt]<>char($00)) and (cnt<1024)) do begin
      Filename:=Filename+filebuf[cnt];
      inc(cnt);
    end;
    if DirectoryExists(Filename)=False then begin
      ShowMessage(GetMLStr('Please drag and drop folder.|tH_hbOhbvĂB')+CRLF+Filename);
      end else begin
      if copy(Filename,length(Filename),1)<>'\' then Filename:=Filename+'\';
      CreateThumb(Filename);
    end;
  end;

  DragFinish(Drop);
end;

// -------------------------------------------------------

type
  TImgFile=record
    FilenameW:widestring;
    ofsFilenameW:dword;
    Img4832bm:TBitmap;
    ofsImg4832:dword;
    Img6448bm:TBitmap;
    ofsImg6448:dword;
    ofsImg256192:dword;
  end;

var
  ImgFiles:array of TImgFile;
  ImgFilesCount:integer;

procedure CreateImage(var srcbm,dstbm:TBitmap;w,h:integer);
var
  bm:TBitmap;
  x,y:integer;
  pb:PByteArray;
  bmw,bmh:integer;
begin
  MakeBlankBM(dstbm,w,h,pf24bit);
  BitBlt(dstbm.Canvas.Handle,0,0,w,h,srcbm.Canvas.Handle,0,0,SRCCOPY);

  bm:=TBitmap.Create;

  LoadImage_Reduce(srcbm,bm,w,h);

  bmw:=bm.Width;
  bmh:=bm.Height;
  for y:=0 to bmh-1 do begin
    pb:=bm.ScanLine[y];
    for x:=0 to bmw-1 do begin
      if (pb[x*3+0]=$00) and (pb[x*3+1]=$ff) and (pb[x*3+2]=$00) then pb[x*3+1]:=$fe;
    end;
  end;

  dstbm.Canvas.Brush.Color:=$00ff00;
  dstbm.Canvas.FillRect(Rect(0,0,w,h));

  x:=(48-bm.Width) div 2;
  if x<1 then x:=1;
  y:=(h-bm.Height) div 2;
  BitBlt(dstbm.Canvas.Handle,x,y,w,h,bm.Canvas.Handle,0,0,SRCCOPY);

  bm.Free;
end;

procedure ConvertImage(basepath:string;var ImgFile:TImgFile);
var
  srcbm:TBitmap;
begin
  srcbm:=TBitmap.Create;
  if LoadImage_LoadFromFile(srcbm,basepath+ImgFile.FilenameW)=False then begin
    ShowMessage('Image file load error.'+CRLF+basepath+ImgFile.FilenameW);
    exit;
  end;

  CreateImage(srcbm,ImgFile.Img4832bm,48,32);
  CreateImage(srcbm,ImgFile.Img6448bm,64,48);

  srcbm.Free;
end;

// --------------------------------------------------------------------

procedure zlibCompressBuf(const InBuf: Pointer; InBytes: Integer;
                      out OutBuf: Pointer; out OutBytes: Integer);
var
  strm: TZStreamRec;
  P: Pointer;
  function CCheck(code: Integer): Integer;
  begin
    Result := code;
    if code < 0 then raise ECompressionError.Create('ZLIB compress error!!'); //!!
  end;
begin
  FillChar(strm, sizeof(strm), 0);
  strm.zalloc := zlibAllocMem;
  strm.zfree := zlibFreeMem;
  OutBytes := ((InBytes + (InBytes div 10) + 12) + 255) and not 255;
  GetMem(OutBuf, OutBytes);
  try
    strm.next_in := InBuf;
    strm.avail_in := InBytes;
    strm.next_out := OutBuf;
    strm.avail_out := OutBytes;
    CCheck(deflateInit_(strm, 1, zlib_version, sizeof(strm)));
    try
      while CCheck(deflate(strm, Z_FINISH)) <> Z_STREAM_END do
      begin
        P := OutBuf;
        Inc(OutBytes, 256);
        ReallocMem(OutBuf, OutBytes);
        strm.next_out := PChar(Integer(OutBuf) + (Integer(strm.next_out) - Integer(P)));
        strm.avail_out := 256;
      end;
    finally
      CCheck(deflateEnd(strm));
    end;
    ReallocMem(OutBuf, strm.total_out);
    OutBytes := strm.total_out;
  except
    FreeMem(OutBuf);
    raise
  end;
end;

type
  TZLIB=record
    DecompSize:integer;
    DecompData:array of byte;
    CompSize:integer;
    CompData:array of byte;
  end;

procedure zlibCompress(var pZLIB:TZLIB);
var
  _EncData:PByteArray;
  _EncDataSize:integer;
begin
  pZLIB.CompSize:=0;

  if pZLIB.DecompSize<=0 then exit;

  zlibCompressBuf(pointer(pZLIB.DecompData),pZLIB.DecompSize,pointer(_EncData),_EncDataSize);

  if (_EncData=nil) or (_EncDataSize=0) then exit;

  pZLIB.CompSize:=_EncDataSize;
  setlength(pZLIB.CompData,pZLIB.CompSize);
  MoveMemory(@pZLIB.CompData[0],@_EncData[0],pZLIB.CompSize);

  pZLIB.CompSize:=(pZLIB.CompSize+3) and not 3;
  setlength(pZLIB.CompData,pZLIB.CompSize);

  FreeMem(_EncData,_EncDataSize);
end;

// --------------------------------------------------------------------

const ThumbIconFileID:dword=$30474d49;

procedure TMain.CreateThumb(basepath:string);
var
  FileLst:TStringList;
  idx:integer;
  wfs:TFileStream;
  HeaderSize:integer;
  procedure w8(dw:dword);
  begin
    wfs.WriteBuffer(dw,1);
  end;
  procedure w16(dw:dword);
  begin
    wfs.WriteBuffer(dw,2);
  end;
  procedure w32(dw:dword);
  begin
    wfs.WriteBuffer(dw,4);
  end;
  procedure wwidestr(ws:widestring);
  var
    tmp:widestring;
  begin
    tmp:=ws+widechar(0);
    w16(length(tmp));
    wfs.WriteBuffer(tmp[1],length(tmp)*2);
  end;
  procedure WriteHeader;
  var
    idx:integer;
  begin
    w32(ThumbIconFileID);
    w32(ImgFilesCount);
    w32(HeaderSize);

    for idx:=0 to ImgFilesCount-1 do begin
      with ImgFiles[idx] do begin
        w32(ofsFilenameW);
        w32(ofsImg4832);
        w32(ofsImg6448);
        w32(ofsImg256192);
      end;
    end;
  end;
  procedure WriteBitmap_Flat(var bm:TBitmap);
  var
    x,y,w,h:integer;
    pb:pbytearray;
    r,g,b:dword;
    col15:dword;
  begin
    w:=bm.Width;
    h:=bm.Height;
    for y:=0 to h-1 do begin
      pb:=bm.ScanLine[y];
      for x:=0 to w-1 do begin
        b:=pb[x*3+0];
        g:=pb[x*3+1];
        r:=pb[x*3+2];
        if (b=$00) and (g=$ff) and (r=$00) then begin
          col15:=0;
          end else begin
          col15:=((r shr 3) shl 0) or ((g shr 3) shl 5) or ((b shr 3) shl 10) or (1 shl 15);
        end;
        w16(col15);
      end;
    end;
  end;
  procedure WriteBitmap_ZLIB(var bm:TBitmap);
  var
    x,y,w,h:integer;
    pb:pbytearray;
    r,g,b:dword;
    col15:dword;
    buf:array of word;
    bufcnt:integer;
    z:TZLIB;
  begin
    w:=bm.Width;
    h:=bm.Height;
    setlength(buf,w*h);
    bufcnt:=0;
    for y:=0 to h-1 do begin
      pb:=bm.ScanLine[y];
      for x:=0 to w-1 do begin
        b:=pb[x*3+0];
        g:=pb[x*3+1];
        r:=pb[x*3+2];
        if (b=$00) and (g=$ff) and (r=$00) then begin
          col15:=0;
          end else begin
          col15:=((r shr 3) shl 0) or ((g shr 3) shl 5) or ((b shr 3) shl 10) or (1 shl 15);
        end;
        buf[bufcnt]:=col15;
        inc(bufcnt);
      end;
    end;
    z.DecompSize:=bufcnt*2;
    z.DecompData:=addr(buf[0]);
    z.CompSize:=0;
    setlength(z.CompData,z.DecompSize);
    zlibCompress(z);
    w32(z.CompSize);
    wfs.WriteBuffer(z.CompData[0],z.CompSize);
    while((wfs.Position and 3)<>0) do begin
      w8(0);
    end;
  end;
begin
  FileLst:=TStringList.Create;
  LoadImage_GetFilesLst(FileLst,basepath);

  if FileLst.Count=0 then begin
    ShowMessage(GetMLStr('Not found image files in folder.|tH_̒ɉ摜t@C܂B')+CRLF+basepath);
    FileLst.Free;
    exit;
  end;

  ImgFilesCount:=FileLst.Count;
  setlength(ImgFiles,ImgFilesCount);
  for idx:=0 to ImgFilesCount-1 do begin
    with ImgFiles[idx] do begin
      FilenameW:=FileLst[idx];
      ofsFilenameW:=0;
      ofsImg4832:=0;
      ofsImg6448:=0;
      ofsImg256192:=0;
    end;
  end;

  FileLst.Free;

  wfs:=TFileStream.Create(basepath+'_msthumb.dat',fmCreate);

  HeaderSize:=0;

  WriteHeader;

  for idx:=0 to ImgFilesCount-1 do begin
    with ImgFiles[idx] do begin
      ofsFilenameW:=wfs.Position-(4*3);
      wwidestr(FilenameW);
      while((wfs.Position and 3)<>0) do begin
        w8(0);
      end;
    end;
  end;

  HeaderSize:=wfs.Position;

  PrgBar.Position:=0;
  PrgBar.Max:=ImgFilesCount;
  for idx:=0 to ImgFilesCount-1 do begin
    PrgBar.Position:=idx;
    DDLbl.Caption:=GetMLStr('converting...|ϊc')+format(' %d/%d %s',[1+idx,ImgFilesCount,ImgFiles[idx].FilenameW]);
    Main.Refresh;
    with ImgFiles[idx] do begin
      Img4832bm:=TBitmap.Create;
      Img6448bm:=TBitmap.Create;
      ConvertImage(basepath,ImgFiles[idx]);
      ofsImg4832:=wfs.Position;
      WriteBitmap_ZLIB(Img4832bm);
      if LargeThumbChk.Checked=False then begin
        ofsImg6448:=0;
        end else begin
        ofsImg6448:=wfs.Position;
        WriteBitmap_ZLIB(Img6448bm);
      end;
      ofsImg256192:=0;
{
      ofsImg256192:=wfs.Position;
      WriteBitmap(Img256192bm);
}
      Img4832bm.Free;
      Img6448bm.Free;
    end;
  end;
  PrgBar.Position:=0;

  wfs.Position:=0;
  WriteHeader;

  wfs.Free;

  DDLbl.Caption:=GetMLStr('Thumbnail file "_msthumb.dat" created.|TlCt@C "_msthumb.dat" 쐬܂B');
  Main.Refresh;
end;

end.

