#include <nds.h>

/*
** nester - NES emulator
** Copyright (C) 2000  Darren Ranalli
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, 
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
** Library General Public License for more details.  To obtain a 
** copy of the GNU Library General Public License, write to the Free 
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** Any permitted reproduction of these routines, in whole or in part,
** must bear this legend.
*/

#include "NES_6502.h"
#include "../NES.h"
#include <stdio.h>
#include "../../debug/debug.h"

#include "../../GBA_globals.h"

#ifndef ASSERT
#define ASSERT(EXPR)
#endif

static uint8 CPUINT_MemoryRead(uint32 addr)
{
  return NES_MemoryRead(addr);
}

static void CPUINT_MemoryWrite(uint32 addr, uint8 data)
{
  NES_MemoryWrite(addr, data);
}

void NES_write(uint32 address, uint8 value)
{
  CPUINT_MemoryWrite(address, value);
}

uint8 NES_read(uint32 address)
{
  return CPUINT_MemoryRead(address);
}

//4294967296 == -1 (unsigned int)
NESTER_STATIC_VAR_EXPL_Q NESTER_VAR_CONST nes6502_memread NESReadHandler[] =
{
   /* $0 - $7FF is RAM */
   { 0x0800, 0xFFFF, NES_read },
   { (unsigned int)-1,     (unsigned int)-1,     0 }
};

NESTER_STATIC_VAR_EXPL_Q NESTER_VAR_CONST nes6502_memwrite NESWriteHandler[] =
{
   /* $0 - $7FF is RAM */
   { 0x0800, 0xFFFF, NES_write },
   { (unsigned int)-1,     (unsigned int)-1,     0}
};

void CPUINT_FakeConstructor()
{
}

// Context get/set
void CPUINT_SetContext(CPUINT_Context *cpu)
{
  ASSERT(0x00000000 == (cpu->pc_reg & 0xFFFF0000));
  cpu->read_handler = NESReadHandler;
  cpu->write_handler = NESWriteHandler;
  nes6502_setcontext(cpu);
}

void CPUINT_GetContext(CPUINT_Context *cpu)
{
  nes6502_getcontext(cpu);
  cpu->read_handler = NESReadHandler;
  cpu->write_handler = NESWriteHandler;
}
