#include "../GBA_main.h"

#include "../nes/nes.h"
#include "../nes/NES_screen_mgr.h"
#include "../nes/NES_ROM.h"
#include "../nes/ppu/NES_PPU.h"

#include "../GBA_globals.h"

//memmove
void memmove_gba(void *to, const void *from, int size)
{
	memmove(to, from, size);
}

//for dword-aligned blocks
void memset_dword(DWORD *b, DWORD value, int size)
{
	int i = 0;
	while (i < size)
	{
		b[i] = value;
		i++;
	}
}

//memset func
void memset_gba(void *addr, int val, int size)
{
#if 0
	BYTE *b = (BYTE *)addr;
	int i = 0;
	while (i < size)
	{
		b[i] = val;
		i++;
	}
#else //rely on library function
	memset(addr, val, size);
#endif
}

//memcpy
void memcpy_gba(void *to, const void *from, int size)
{
#if 0
	BYTE *b = (BYTE *)to;
	const BYTE *bFrom = (const BYTE *)from;
	int i = 0;
	while (i < size)
	{
		b[i] = bFrom[i];
		i++;
	}
#else //rely on library function
	memcpy(to, from, size);
#endif
}
