unit _Models;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,Dialogs,Forms;

type
  TModelLinePoint=record
    x,y:double;
    NormalLen:double;
  end;

type
  TModelLine=record
    TotalLen:double;
    fx,fy:double;
    PointsCount:integer;
    Points:array of TModelLinePoint;
  end;

type
  TModel=record
    wc:widechar;
    LinesCount:integer;
    Lines:array of TModelLine;
  end;

var
  ModelsCount:integer;
  Models:array of TModel;

procedure ModelLine_DirectToRelay(var pml:TModelLine);
procedure ModelLine_CreateLength(var pml:TModelLine;wc:WideChar);
function ModelFit(const SrcModel:TModel;var DstModel:TModel):boolean;
procedure ModelLine_ProcDiv(const SrcLine:TModelLine;var DstLine:TModelLine;const Divider:integer);
function Model_isEqual(const Model1,Model2:TModel):boolean;

procedure ModelSaveToText(fn:string;tagmidx:integer);
function ModelLoadFromText(fn:string):string;
procedure ModelSaveToBin(fn:string);
procedure ModelLoadFromBin(fn:string);

procedure ModelDraw(var Model:TModel;DrawCanvas:TCanvas);

procedure ModelCopy(const SrcModel:TModel;var DstModel:TModel);

implementation

procedure ModelLine_DirectToRelay(var pml:TModelLine);
var
  pidx:integer;
begin
  with pml do begin
    fx:=Points[0].x;
    fy:=Points[0].y;
    for pidx:=0 to PointsCount-1-1 do begin
      with Points[pidx] do begin
        x:=Points[pidx+1].x-x;
        y:=Points[pidx+1].y-y;
      end;
    end;
    dec(PointsCount);
  end;
end;

procedure ModelLine_CreateLength(var pml:TModelLine;wc:WideChar);
var
  pidx:integer;
begin
  with pml do begin
    TotalLen:=0;
    for pidx:=0 to PointsCount-1 do begin
      with Points[pidx] do begin
        NormalLen:=sqrt(x*x+y*y);
        TotalLen:=TotalLen+NormalLen;
      end;
    end;
    if TotalLen=0 then begin
      ShowMessage('length err. $'+inttohex(integer(wc),4)+' '+wc);
    end;
    for pidx:=0 to PointsCount-1 do begin
      with Points[pidx] do begin
        NormalLen:=NormalLen/TotalLen;
      end;
    end;
  end;
end;

function ModelFit(const SrcModel:TModel;var DstModel:TModel):boolean;
var
  lidx,pidx:integer;
  minx,miny,maxx,maxy:double;
  px,py:double;
  w,h:double;
  ofsx,ofsy,ratiox,ratioy:double;
  ratioadd:double;
  procedure chk(x,y:double);
  begin
    if x<minx then minx:=x;
    if maxx<x then maxx:=x;
    if y<miny then miny:=y;
    if maxy<y then maxy:=y;
  end;
begin
  minx:=10000; miny:=10000;
  maxx:=-10000; maxy:=-10000;

  for lidx:=0 to SrcModel.LinesCount-1 do begin
    with SrcModel.Lines[lidx] do begin
      px:=fx;
      py:=fy;
      chk(px,py);
      for pidx:=0 to PointsCount-1 do begin
        px:=px+Points[pidx].x;
        py:=py+Points[pidx].y;
        chk(px,py);
      end;
    end;
  end;

  Result:=False;
  if (64<=minx) and (96<=miny) then begin
    if (128<=maxx) and (192<=maxy) then begin
      Result:=True;
    end;
  end;

//  Main.UserModelLogLst.Items.Add(format('min=%f, %f, max=%f, %f.',[minx,miny,maxx,maxy]));
  w:=maxx-minx;
  h:=maxy-miny;
  if w=0 then begin
    ratiox:=1;
    end else begin
    ratiox:=256/w;
  end;
  if h=0 then begin
    ratioy:=1;
    end else begin
    ratioy:=256/h;
  end;
  if ratiox<ratioy then begin
    ratioadd:=(ratioy-ratiox)/4;
    ratioy:=ratiox+ratioadd;
    end else begin
    ratioadd:=(ratiox-ratioy)/4;
    ratiox:=ratioy+ratioadd;
  end;
  ofsx:=(256-(w*ratiox))/2;
  ofsy:=(256-(h*ratioy))/2;
  if 5<ratiox then ratiox:=5;
  if 5<ratioy then ratioy:=5;
//  Main.UserModelLogLst.Items.Add(format('ratio=%f,%f, radd=%f, ofs=%f, %f.',[ratiox,ratioy,ratioadd,ofsx,ofsy]));

  DstModel.wc:=SrcModel.wc;
  DstModel.LinesCount:=SrcModel.LinesCount;
  setlength(DstModel.Lines,DstModel.LinesCount);
  for lidx:=0 to DstModel.LinesCount-1 do begin
    DstModel.Lines[lidx].TotalLen:=SrcModel.Lines[lidx].TotalLen;
    DstModel.Lines[lidx].fx:=(SrcModel.Lines[lidx].fx-minx)*ratiox+ofsx;
    DstModel.Lines[lidx].fy:=(SrcModel.Lines[lidx].fy-miny)*ratioy+ofsy;
    DstModel.Lines[lidx].PointsCount:=SrcModel.Lines[lidx].PointsCount;
    setlength(DstModel.Lines[lidx].Points,DstModel.Lines[lidx].PointsCount);
    for pidx:=0 to DstModel.Lines[lidx].PointsCount-1 do begin
      DstModel.Lines[lidx].Points[pidx].x:=SrcModel.Lines[lidx].Points[pidx].x*ratiox;
      DstModel.Lines[lidx].Points[pidx].y:=SrcModel.Lines[lidx].Points[pidx].y*ratioy;
      DstModel.Lines[lidx].Points[pidx].NormalLen:=SrcModel.Lines[lidx].Points[pidx].NormalLen;
    end;
  end;

  for lidx:=0 to DstModel.LinesCount-1 do begin
    ModelLine_CreateLength(DstModel.Lines[lidx],DstModel.wc);
  end;
end;

function Model_isEqual(const Model1,Model2:TModel):boolean;
var
  lidx,pidx:integer;
begin
  Result:=False;
  if Model1.wc<>Model2.wc then exit;
  if Model1.LinesCount<>Model2.LinesCount then exit;
  for lidx:=0 to Model1.LinesCount-1 do begin
    if 1<abs(Model1.Lines[lidx].fx-Model2.Lines[lidx].fx) then exit;
    if 1<abs(Model1.Lines[lidx].fy-Model2.Lines[lidx].fy) then exit;
    if Model1.Lines[lidx].PointsCount<>Model2.Lines[lidx].PointsCount then exit;
    for pidx:=0 to Model1.Lines[lidx].PointsCount-1 do begin
      if 1<abs(Model1.Lines[lidx].Points[pidx].x-Model2.Lines[lidx].Points[pidx].x) then exit;
      if 1<abs(Model1.Lines[lidx].Points[pidx].y-Model2.Lines[lidx].Points[pidx].y) then exit;
    end;
  end;
  Result:=True;
end;

procedure ModelLine_ProcDiv(const SrcLine:TModelLine;var DstLine:TModelLine;const Divider:integer);
var
  pidx:integer;
  procedure GetPoint(const Line:TModelLine;TagLen:double;out dstx,dsty:double);
  var
    len:double;
    pidx:integer;
  begin
    dstx:=0;
    dsty:=0;
    for pidx:=0 to Line.PointsCount-1 do begin
      len:=Line.Points[pidx].NormalLen;
      if TagLen<=len then begin
        dstx:=dstx+(Line.Points[pidx].x*TagLen/len);
        dsty:=dsty+(Line.Points[pidx].y*TagLen/len);
        exit;
      end;
      TagLen:=TagLen-len;
      dstx:=dstx+Line.Points[pidx].x;
      dsty:=dsty+Line.Points[pidx].y;
    end;
  end;
begin
  DstLine.fx:=SrcLine.fx;
  DstLine.fy:=SrcLine.fy;

  DstLine.PointsCount:=Divider;
  setlength(DstLine.Points,DstLine.PointsCount);
  for pidx:=0 to DstLine.PointsCount-1 do begin
    with DstLine.Points[pidx] do begin
      GetPoint(SrcLine,(1+pidx)/DstLine.PointsCount,x,y);
    end;
  end;
  for pidx:=DstLine.PointsCount-1 downto 1 do begin
    with DstLine.Points[pidx] do begin
      x:=x-DstLine.Points[pidx-1].x;
      y:=y-DstLine.Points[pidx-1].y;
    end;
  end;

  ModelLine_CreateLength(DstLine,WideChar(0));
end;

procedure ModelSaveToText(fn:string;tagmidx:integer);
var
  useflag:boolean;
  strlst:TStringList;
  midx,lidx,pidx:integer;
  ox,oy:double;
begin
  strlst:=TStringList.Create;

  for midx:=0 to ModelsCount-1 do begin
    useflag:=False;
    if tagmidx=-1 then begin
      useflag:=True;
      end else begin
      if tagmidx=midx then useflag:=True;
    end;
    if useflag=True then begin
      with Models[midx] do begin
        strlst.Add(format('#ModelStart U+%s ; %d %s ------------------------------------------',[inttohex(dword(wc),4),midx,string(wc)]));
        for lidx:=0 to LinesCount-1 do begin
          with Lines[lidx] do begin
            ox:=fx; oy:=fy;
            strlst.Add(format('#Point %s,%s ; %d',[FloatToStr(ox),FloatToStr(oy),0]));
            for pidx:=0 to PointsCount-1 do begin
              with Points[pidx] do begin
                ox:=ox+x; oy:=oy+y;
                strlst.Add(format('#Point %s,%s ; %d',[FloatToStr(ox),FloatToStr(oy),1+pidx]));
              end;
            end;
            strlst.Add('#ModelLineEnd');
          end;
        end;
        strlst.Add('#ModelEnd');
      end;
    end;
  end;

  strlst.SaveToFile(fn);
end;

function ModelLoadFromText(fn:string):string;
var
  srcidx:integer;
  srcstrs:TStringList;
  tmpModel:TModel;
  tmpLine:TModelLine;
  srcName:string;
  srcwc:widechar;
  srcx,srcy:double;
  findidx:integer;
  readcount,ignorecount:integer;
  procedure GetSourceLine(str:string);
  var
    p:integer;
  begin
    srcwc:=widechar(0);
    srcx:=0;
    srcy:=0;

    if str='' then exit;
    if str[1]<>'#' then exit;

    p:=pos(';',str);
    if p<>0 then str:=copy(str,1,p-1);
    str:=trim(str);

    p:=pos(' ',str);
    if p=0 then begin
      srcName:=str;
      exit;
    end;
    srcName:=copy(str,1,p-1);
    str:=trim(copy(str,1+p,255));
    if str[1]='U' then srcwc:=widechar(strtoint('$'+copy(str,3,255)));
    p:=pos(',',str);
    if p<>0 then begin
      srcx:=StrToFloat(copy(str,1,p-1));
      srcy:=StrToFloat(copy(str,1+p,255));
    end;
  end;
begin
  readcount:=0;
  ignorecount:=0;

  srcstrs:=TStringList.Create;
  srcstrs.LoadFromFile(fn);

  tmpModel.wc:=WideChar(0);
  tmpModel.LinesCount:=0;
  tmpLine.PointsCount:=0;

  for srcidx:=0 to srcstrs.Count-1 do begin
    GetSourceLine(srcstrs[srcidx]);

    if srcName='#ModelStart' then begin
      tmpModel.wc:=srcwc;
      tmpModel.LinesCount:=0;
      tmpLine.PointsCount:=0;
    end;

    if srcName='#Point' then begin
      setlength(tmpLine.Points,tmpLine.PointsCount+1);
      tmpLine.Points[tmpLine.PointsCount].x:=srcx;
      tmpLine.Points[tmpLine.PointsCount].y:=srcy;
      inc(tmpLine.PointsCount);
    end;

    if srcName='#ModelLineEnd' then begin
      setlength(tmpModel.Lines,tmpModel.LinesCount+1);
      ModelLine_DirectToRelay(tmpLine);
      ModelLine_CreateLength(tmpLine,tmpModel.wc);
      if (tmpLine.PointsCount=1) or (tmpLine.PointsCount=32) then begin
        tmpModel.Lines[tmpModel.LinesCount]:=tmpLine;
        end else begin
        ModelLine_ProcDiv(tmpLine,tmpModel.Lines[tmpModel.LinesCount],32);
      end;
      inc(tmpModel.LinesCount);
      tmpLine.PointsCount:=0;
    end;

    if srcName='#ModelEnd' then begin
      if tmpModel.wc<>widechar(0) then begin
        setlength(Models,ModelsCount+1);
        ModelFit(tmpModel,Models[ModelsCount]);
        ModelCopy(tmpModel,Models[ModelsCount]);
        inc(ModelsCount);
        inc(readcount);
        for findidx:=0 to ModelsCount-1-1 do begin
          if Model_isEqual(Models[findidx],Models[ModelsCount-1])=True then begin
            dec(ModelsCount);
            dec(readcount);
            inc(ignorecount);
            break;
          end;
        end;
      end;
      tmpModel.wc:=widechar(0);
    end;
  end;

  srcstrs.Free;

  Result:='';
  if ignorecount<>0 then Result:=Result+inttostr(ignorecount)+'̃fǍσfƓꂾ̂Ŗ܂B';
  Result:=Result+inttostr(readcount)+'̃fǍ݂܂B';
end;

procedure ModelSaveToBin(fn:string);
var
  wfs:TFileStream;
  midx,lidx,pidx:integer;
  procedure wu8(data:byte);
  begin
    wfs.WriteBuffer(data,1);
  end;
  procedure ws8(data:shortint);
  begin
    wfs.WriteBuffer(data,1);
  end;
  procedure wu16(data:word);
  begin
    wfs.WriteBuffer(data,2);
  end;
  procedure ws16(data:smallint);
  begin
    wfs.WriteBuffer(data,2);
  end;
  procedure wud(data:double);
  begin
    data:=trunc(data*$100);
    if data<0 then data:=0;
    if $ffff<data then data:=$ffff;
    wu16(trunc(data));
  end;
  procedure wsd(data:double);
  begin
    data:=trunc(data*$100);
    if data<-$8000 then data:=-$8000;
    if $7fff<data then data:=$7fff;
    ws16(trunc(data));
  end;
  procedure w16(data:widechar);
  begin
    wfs.WriteBuffer(data,2);
  end;
  procedure wu32(data:dword);
  begin
    wfs.WriteBuffer(data,4);
  end;
  procedure wstr(str:string);
  var
    len:byte;
  begin
    str:=str+char(0);
    len:=Length(str);
    wfs.WriteBuffer(len,1);
    wfs.WriteBuffer(str[1],len);
  end;
begin
  wfs:=TFileStream.Create(fn,fmCreate);

  wu32($314d5748);
  wstr('Hand write models format Type.1');

  wu32(ModelsCount);
  for midx:=0 to ModelsCount-1 do begin
    with Models[midx] do begin
      w16(wc);
      wu8(LinesCount);
      for lidx:=0 to LinesCount-1 do begin
        with Lines[lidx] do begin
//          wud(TotalLen);
          wud(fx);
          wud(fy);
          wu8(PointsCount);
          for pidx:=0 to PointsCount-1 do begin
            with Points[pidx] do begin
              wsd(x/2);
              wsd(y/2);
//              wud(NormalLen);
            end;
          end;
        end;
      end;
    end;
  end;

  wfs.Free;
end;

procedure ModelLoadFromBin(fn:string);
var
  rfs:TFileStream;
  midx,lidx,pidx:integer;
  function ru8:byte;
  begin
    rfs.ReadBuffer(Result,1);
  end;
  function rs8:shortint;
  begin
    rfs.ReadBuffer(Result,1);
  end;
  function ru16:word;
  begin
    rfs.ReadBuffer(Result,2);
  end;
  function rs16:smallint;
  begin
    rfs.ReadBuffer(Result,2);
  end;
  function rud:double;
  begin
    Result:=ru16/$100;
  end;
  function rsd:double;
  begin
    Result:=rs16/$100;
  end;
  function r16:widechar;
  begin
    rfs.ReadBuffer(Result,2);
  end;
  function ru32:dword;
  begin
    rfs.ReadBuffer(Result,4);
  end;
  procedure rskipstr;
  var
    len:byte;
  begin
    len:=ru8;
    rfs.Position:=rfs.Position+len;
  end;
begin
  rfs:=TFileStream.Create(fn,fmOpenRead);

  ru32;
  rskipstr;

  ModelsCount:=ru32;
  setlength(Models,ModelsCount);
  for midx:=0 to ModelsCount-1 do begin
    with Models[midx] do begin
      wc:=r16;
      LinesCount:=ru8;
      setlength(Lines,LinesCount);
      for lidx:=0 to LinesCount-1 do begin
        with Lines[lidx] do begin
          TotalLen:=0;
          fx:=rud;
          fy:=rud;
          PointsCount:=ru8;
          setlength(Points,PointsCount);
          for pidx:=0 to PointsCount-1 do begin
            with Points[pidx] do begin
              x:=rsd*2;
              y:=rsd*2;
              NormalLen:=sqrt(x*x+y*y);
              TotalLen:=TotalLen+NormalLen;
            end;
          end;
          for pidx:=0 to PointsCount-1 do begin
            with Points[pidx] do begin
              NormalLen:=NormalLen/TotalLen;
            end;
          end;
        end;
      end;
    end;
  end;

  rfs.Free;
end;

procedure ModelDraw(var Model:TModel;DrawCanvas:TCanvas);
var
  lidx,pidx:integer;
  px,py:double;
  procedure print(x,y:double;str:string);
  var
    w,h:integer;
  begin
    w:=DrawCanvas.TextWidth(str);
    h:=DrawCanvas.TextHeight(str);
    x:=x-(w/2);
    y:=y-(h/2);
    if x<0 then x:=0;
    if y<0 then y:=0;
    if (256-w)<x then x:=256-w;
    if (256-h)<y then y:=256-h;
    DrawCanvas.TextOut(trunc(x),trunc(y),str);
  end;
begin
  DrawCanvas.Brush.Color:=$ffffff;
  DrawCanvas.FillRect(Rect(0,0,256,256));
  for lidx:=0 to Model.LinesCount-1 do begin
    with Model.Lines[lidx] do begin
      px:=fx;
      py:=fy;
      DrawCanvas.Pen.Color:=$ff0000;
      DrawCanvas.MoveTo(trunc(px),trunc(py));
      for pidx:=0 to PointsCount-1 do begin
        px:=px+Points[pidx].x;
        py:=py+Points[pidx].y;
        DrawCanvas.LineTo(trunc(px),trunc(py));
      end;
    end;
  end;
  for lidx:=0 to Model.LinesCount-1 do begin
    with Model.Lines[lidx] do begin
      px:=fx;
      py:=fy;
      DrawCanvas.Brush.Style:=bsSolid;
      DrawCanvas.Font.Color:=$000000;
      print(px,py,format('[%d]',[1+lidx]));
      for pidx:=0 to PointsCount-1 do begin
        px:=px+Points[pidx].x;
        py:=py+Points[pidx].y;
        if (PointsCount=1) or ((pidx and 1)=1) then print(px,py,format('%d',[1+pidx]));
      end;
    end;
  end;
  for lidx:=0 to Model.LinesCount-1 do begin
    with Model.Lines[lidx] do begin
      px:=fx;
      py:=fy;
      DrawCanvas.Brush.Style:=bsClear;
      DrawCanvas.Font.Color:=$000000;
      print(px,py,format('[%d]',[1+lidx]));
      for pidx:=0 to PointsCount-1 do begin
        px:=px+Points[pidx].x;
        py:=py+Points[pidx].y;
        if (PointsCount=1) or ((pidx and 1)=1) then print(px,py,format('%d',[1+pidx]));
      end;
    end;
  end;
end;

procedure ModelCopy(const SrcModel:TModel;var DstModel:TModel);
var
  lidx,pidx:integer;
begin
  DstModel.wc:=SrcModel.wc;
  DstModel.LinesCount:=SrcModel.LinesCount;
  setlength(DstModel.Lines,DstModel.LinesCount);
  for lidx:=0 to DstModel.LinesCount-1 do begin
    DstModel.Lines[lidx].TotalLen:=SrcModel.Lines[lidx].TotalLen;
    DstModel.Lines[lidx].fx:=SrcModel.Lines[lidx].fx;
    DstModel.Lines[lidx].fy:=SrcModel.Lines[lidx].fy;
    DstModel.Lines[lidx].PointsCount:=SrcModel.Lines[lidx].PointsCount;
    setlength(DstModel.Lines[lidx].Points,DstModel.Lines[lidx].PointsCount);
    for pidx:=0 to DstModel.Lines[lidx].PointsCount-1 do begin
      DstModel.Lines[lidx].Points[pidx].x:=SrcModel.Lines[lidx].Points[pidx].x;
      DstModel.Lines[lidx].Points[pidx].y:=SrcModel.Lines[lidx].Points[pidx].y;
      DstModel.Lines[lidx].Points[pidx].NormalLen:=SrcModel.Lines[lidx].Points[pidx].NormalLen;
    end;
  end;

  for lidx:=0 to DstModel.LinesCount-1 do begin
    ModelLine_CreateLength(DstModel.Lines[lidx],DstModel.wc);
  end;
end;

end.

