unit dpgplay_MainWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, ComCtrls,_PicTools, StdCtrls;

type
  TMain = class(TForm)
    DPGOpenDlg: TOpenDialog;
    Timer1: TTimer;
    DPGInfoMemo: TMemo;
    StatusBar1: TStatusBar;
    PreviewImg: TPaintBox;
    FilesLst: TListBox;
    OpenTimer: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FilesLstClick(Sender: TObject);
    procedure FilesLstDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure OpenTimerTimer(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Main: TMain;

implementation

uses dpgplay_PreviewWin, _dpg_const, dpgplay_DSSupportWin, dpgplay_inifile;

{$R *.dfm}

const AppID='dpgplay';

var
  ReqIndex,PlayIndex:integer;
  dpgpath:string;

type
  TThumbnail=record
    bm:TBitmap;
  end;

var
  Thumbnails:array of TThumbnail;
  ThumbnailsCount:integer;

procedure TMain.FormCreate(Sender: TObject);
begin
  Application.Title:=AppID;
  Preview.Caption:=AppID;

  LoadINI;
  SaveINI;

  ReqIndex:=-1;
  PlayIndex:=-1;

  dpgpath:='';

  FilesLst.Clear;

  ThumbnailsCount:=0;
  setlength(Thumbnails,ThumbnailsCount);

  Timer1.Enabled:=True;
end;

procedure TMain.Timer1Timer(Sender: TObject);
var
  dpgfn:string;
  res:integer;
  SearchRec:TSearchRec;
  fname:string;
  idx:integer;
begin
  Timer1.Enabled:=False;

  dpgfn:=ParamStr(1);
  if FileExists(dpgfn)=False then dpgfn:='';

  if dpgfn='' then begin
    if DPGOpenDlg.Execute=True then dpgfn:=DPGOpenDlg.FileName;
  end;

  if (dpgfn='') or (FileExists(dpgfn)=False) then begin
    Application.Terminate;
    exit;
  end;

  dpgpath:=ExtractFilePath(dpgfn);

  FilesLst.Clear;

  res:=FindFirst(dpgpath+'*.dpg', (FaAnyFile), SearchRec);
  while(res=0) do begin
    fname:=SearchRec.Name;
    if (SearchRec.Attr and faDirectory)=0 then begin
      FilesLst.Items.Add(fname);
    end;
    res:=FindNext(SearchRec);
  end;
  FindClose(SearchRec);

  ThumbnailsCount:=FilesLst.Count;
  setlength(Thumbnails,ThumbnailsCount);
  for idx:=0 to ThumbnailsCount-1 do begin
    Thumbnails[idx].bm:=nil;
  end;
end;

procedure TMain.FormResize(Sender: TObject);
var
  cw,ch:integer;
begin
  cw:=Main.ClientWidth;
  ch:=Main.ClientHeight-StatusBar1.Height;

  FilesLst.Width:=cw-PreviewImg.Width;
  FilesLst.Height:=ch;

  PreviewImg.Left:=cw-PreviewImg.Width;

  DPGInfoMemo.Left:=cw-DPGInfoMemo.Width;
  DPGInfoMemo.Height:=ch-DPGInfoMemo.Top;
end;

var
  isCanClose:boolean=True;

procedure TMain.FilesLstClick(Sender: TObject);
begin
  if isCanClose=False then exit;

  isCanClose:=False;

  if PlayIndex<>-1 then Preview.StopDPG;

  ReqIndex:=FilesLst.ItemIndex;

  OpenTimer.Enabled:=True;
end;

procedure TMain.OpenTimerTimer(Sender: TObject);
begin
  OpenTimer.Enabled:=False;

  PlayIndex:=ReqIndex;
  ReqIndex:=-1;

  Preview.OpenDPG(dpgpath+'\'+FilesLst.Items[PlayIndex]);
  
  isCanClose:=True;
end;

procedure TMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
  idx:integer;
begin
  if isCanClose=False then begin
    CanClose:=False;
    exit;
  end;

  if PlayIndex<>-1 then Preview.StopDPG;
  PlayIndex:=-1;

  for idx:=0 to ThumbnailsCount-1 do begin
    if assigned(Thumbnails[idx].bm)=True then begin
      Thumbnails[idx].bm.Free; Thumbnails[idx].bm:=nil;
    end;
  end;

  CanClose:=True;
end;

procedure TMain.FilesLstDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var
  LB :TListBox;
  dpgfn:string;
  DPGINFO:TDPGINFO;
  FileSize:integer;
  rfs:TFileStream;
  x,y:integer;
  rgb:TRGB;
  pb:pbytearray;
  function GetRGB24:TRGB;
  var
    col15:word;
  begin
    rfs.ReadBuffer(col15,2);
    Result.r:=((col15 shr 10) and 31) shl 3;
    Result.g:=((col15 shr 5) and 31) shl 3;
    Result.b:=((col15 shr 0) and 31) shl 3;
  end;
begin
  LB :=Control as TListBox;

  with LB.Canvas do begin
    FillRect(Rect);

    if (0<=Index) and (Index<ThumbnailsCount) then begin
      if assigned(Thumbnails[Index].bm)=False then begin
        dpgfn:=dpgpath+'\'+LB.Items[Index];
        if LoadDPGINFO(DPGINFO,dpgfn,FileSize)<>0 then begin
          if (DPGINFO.isExistsThumbnailImage=True) and (DPGINFO.ThumbnailImageOffset<>0) then begin
            Thumbnails[Index].bm:=TBitmap.Create;
            MakeBlankBM(Thumbnails[Index].bm,256,192,pf24bit);
            rfs:=TFileStream.Create(dpgfn,fmOpenRead);
            rfs.Position:=DPGINFO.ThumbnailImageOffset;
            for y:=0 to 192-1 do begin
              pb:=Thumbnails[Index].bm.ScanLine[y];
              for x:=0 to 256-1 do begin
                rgb:=GetRGB24;
                pb[x*3+0]:=rgb.r;
                pb[x*3+1]:=rgb.g;
                pb[x*3+2]:=rgb.b;
              end;
            end;
            rfs.Free;
          end;
        end;
      end;

      if assigned(Thumbnails[Index].bm)=True then begin
        SetStretchBltMode(LB.Canvas.Handle,HALFTONE);
        StretchBlt(LB.Canvas.Handle,Rect.Left+2,Rect.Top+2,256 div 4,192 div 4,Thumbnails[Index].bm.Canvas.Handle,0,0,256,192,SRCCOPY);
      end;
    end;

    Textout(Rect.Left+2+(256 div 4)+4,Rect.Top+((Rect.Bottom-Rect.Top-TextHeight(LB.Items[Index])) div 2),LB.Items[Index]);
  end;
end;

end.
