unit _inifile;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ExtCtrls, Buttons, INIFiles, _m_Tools;

procedure CreateINI;
procedure LoadINI;
procedure SaveINI;

var
  INI_MaxSize_Width:integer;
  INI_MaxSize_Height:integer;
  INI_OutputPath:string;
  INI_InputPath:string;

implementation

uses MainWin,ImgOptWin;

const CRLF:string=char($0d)+char($0a);

function GetINIFilename:string;
begin
  Result:=ChangeFileExt(Application.ExeName,'.ini');
end;

procedure CreateINI;
var
  ress:TResourceStream;
  fn:string;
  wfs:TFileStream;
  buf:array of byte;
  bufsize:integer;
begin
  fn:=GetINIFilename;
  if FileExists(fn)=True then exit;

  ress:=TResourceStream.Create(MainInstance,'res_img2ipk_ini','UTF8STRING');
  bufsize:=ress.Size;
  setlength(buf,bufsize);
  ress.ReadBuffer(buf[0],bufsize);
  ress.Free;

  wfs:=TFileStream.Create(fn,fmCreate);
  wfs.WriteBuffer(buf[0],bufsize);
  wfs.Free;

{
  fn:=ExtractFilename(fn);
  ShowMessage('Wݒ'+fn+'쐬܂B'+CRLF+CRLF+''+fn+' of a standard setting was made.');
}
end;

procedure LoadINI;
var
  fini:TINIFile;
  Section:string;
begin
  fini:=TINIFile.Create(GetINIFilename);

  Section:='System';

  Main.MenuOptShowCompletionDialog.Checked:=fini.ReadBool(Section,'ShowCompletionDialog',True);
  
  INI_OutputPath:=fini.ReadString(Section,'OutputPath',GetDesktopPath+'\');
  INI_InputPath:=fini.ReadString(Section,'InputPath',GetDesktopPath+'\');

  Section:='MaxSize';

  INI_MaxSize_Width:=fini.ReadInteger(Section,'Width',0);
  INI_MaxSize_Height:=fini.ReadInteger(Section,'Height',0);

  Section:='ThumbnailOption';

  Main.MenuOptThumb4864_15bit.Checked:=fini.ReadBool(Section,'Thumb4864_15bit',Main.MenuOptThumb4864_15bit.Checked);
  Main.MenuOptThumb192256_15bit.Checked:=fini.ReadBool(Section,'Thumb192256_15bit',Main.MenuOptThumb192256_15bit.Checked);

  Section:='ImageOption';

  Main.MenuOptUseExif.Checked:=fini.ReadBool(Section,'UseExif',Main.MenuOptUseExif.Checked);
  ImgOpt.FormatLst.ItemIndex:=fini.ReadInteger(Section,'Format',ImgOpt.FormatLst.ItemIndex);
  ImgOpt.zlib_Dither15bitChk.Checked:=fini.ReadBool(Section,'zlib_Dither15bitChk',ImgOpt.zlib_Dither15bitChk.Checked);
  ImgOpt.customjpeg_QualityBar.Position:=fini.ReadInteger(Section,'customjpeg_QualityBar',ImgOpt.customjpeg_QualityBar.Position);

  fini.Free;
end;

procedure SaveINI;
var
  fini:TINIFile;
  Section:string;
begin
  fini:=TINIFile.Create(GetINIFilename);

  Section:='System';

  fini.WriteBool(Section,'ShowCompletionDialog',Main.MenuOptShowCompletionDialog.Checked);

  fini.WriteString(Section,'OutputPath',INI_OutputPath);
  fini.WriteString(Section,'InputPath',INI_InputPath);

  Section:='MaxSize';

  fini.WriteInteger(Section,'Width',INI_MaxSize_Width);
  fini.WriteInteger(Section,'Height',INI_MaxSize_Height);

  Section:='ThumbnailOption';

  fini.WriteBool(Section,'Thumb4864_15bit',Main.MenuOptThumb4864_15bit.Checked);
  fini.WriteBool(Section,'Thumb192256_15bit',Main.MenuOptThumb192256_15bit.Checked);

  Section:='ImageOption';

  fini.WriteBool(Section,'UseExif',Main.MenuOptUseExif.Checked);
  fini.WriteInteger(Section,'Format',ImgOpt.FormatLst.ItemIndex);
  fini.WriteBool(Section,'zlib_Dither15bitChk',ImgOpt.zlib_Dither15bitChk.Checked);
  fini.WriteInteger(Section,'customjpeg_QualityBar',ImgOpt.customjpeg_QualityBar.Position);

  fini.Free;
end;

end.
