unit MainWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, MMSystem, StdCtrls;

type
  TMain = class(TForm)
    Memo1: TMemo;
    procedure FormCreate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Main: TMain;

implementation

{$R *.dfm}

var
  err:boolean;

type
  TWave=record
    Filename:string;
    ofs,smpcnt:integer;
    chs,smprate:integer;
  end;

var
  WavesCount:integer;
  Waves:array[0..32] of TWave;

procedure LoadWave(fn:string;wfs:TFileStream;var chs,rate:integer);
var
  wfex:TWaveFormatEx;
  rfs:TFileStream;
  DataOfs:integer;
  idx:integer;
  data:dword;
  buf:array of byte;
  bufsize:integer;
  s:integer;
  procedure addpad32;
  begin
    while((wfs.Position and 3)<>0) do begin
      s:=0;
      wfs.WriteBuffer(s,1);
    end;
  end;
begin
  Main.Memo1.Lines.Add('--------------------------------');
  Main.Memo1.Lines.Add('Load ['+fn+']');

  if FileExists(fn)=False then begin
    Main.Memo1.Lines.Add('File not found.');
    err:=True;
    exit;
  end;

  rfs:=TFileStream.Create(fn,fmOpenRead);

  rfs.Position:=$14;
  rfs.ReadBuffer(wfex,sizeof(TWaveFormatEx));

  DataOfs:=0;

  for idx:=0 to rfs.Size-4-1 do begin
    rfs.Position:=idx;
    rfs.ReadBuffer(data,4);
    if data=$61746164 then begin
      Main.Memo1.Lines.Add('Data offset: $'+inttohex(idx,8));
      DataOfs:=idx+4;
      break;
    end;
  end;

  if DataOfs=0 then begin
    Main.Memo1.Lines.Add('Data chunk not found.');
    err:=True;
    exit;
  end;

  if wfex.wFormatTag<>$0001 then begin
    Main.Memo1.Lines.Add('Illigal CompressFormat Error. wFormatTag=0x'+inttohex(wfex.wFormatTag,4));
    err:=True;
    exit;
  end;

  if (wfex.nChannels<>1) and (wfex.nChannels<>2) then begin
    Main.Memo1.Lines.Add('Channels Error. nChannels='+inttostr(wfex.nChannels));
    err:=True;
    exit;
  end;

  if (wfex.wBitsPerSample<>8) then begin
    Main.Memo1.Lines.Add('Not support bits size. bits='+inttostr(wfex.wBitsPerSample));
    err:=True;
    exit;
  end;

  Main.Memo1.Lines.Add(format('format=%d, chs=%d, bits=%d, rate=%d.',[wfex.wFormatTag,wfex.nChannels,wfex.wBitsPerSample,wfex.nSamplesPerSec]));

  rfs.Position:=DataOfs;
  rfs.ReadBuffer(bufsize,4);
  setlength(buf,bufsize);
  rfs.ReadBuffer(buf[0],bufsize);

  rfs.Free;

  chs:=wfex.nChannels;
  if chs=2 then bufsize:=bufsize div 2;
  rate:=wfex.nSamplesPerSec;

  if chs=1 then begin
    for idx:=0 to bufsize-1 do begin
      s:=buf[idx]-$80;
      wfs.WriteBuffer(s,1);
    end;
    addpad32;
    end else begin
    for idx:=0 to bufsize-1 do begin
      s:=buf[idx*2+0]-$80;
      wfs.WriteBuffer(s,1);
    end;
    addpad32;
    for idx:=0 to bufsize-1 do begin
      s:=buf[idx*2+1]-$80;
      wfs.WriteBuffer(s,1);
    end;
    addpad32;
  end;
end;

procedure TMain.FormCreate(Sender: TObject);
var
  idx:integer;
  wfs:TFileStream;
  procedure WriteHeader;
  var
    idx:integer;
  begin
    wfs.Position:=0;
    wfs.WriteBuffer(WavesCount,4);
    for idx:=0 to WavesCount-1 do begin
      with Waves[idx] do begin
        wfs.WriteBuffer(ofs,4);
        wfs.WriteBuffer(smpcnt,4);
        wfs.WriteBuffer(chs,2);
        wfs.WriteBuffer(smprate,2);
      end;
    end;
  end;
begin
  Main.Show;
  
  Memo1.Clear;
  
  err:=False;

  WavesCount:=0;
  Waves[WavesCount].Filename:='opening.wav'; inc(WavesCount);
  Waves[WavesCount].Filename:='snd_click.wav'; inc(WavesCount);
  Waves[WavesCount].Filename:='snd_movepage.wav'; inc(WavesCount);
  Waves[WavesCount].Filename:='snd_notify.wav'; inc(WavesCount);
  Waves[WavesCount].Filename:='snd_open.wav'; inc(WavesCount);
  Waves[WavesCount].Filename:='snd_longtap.wav'; inc(WavesCount);
  Waves[WavesCount].Filename:='snd_poweroff.wav'; inc(WavesCount);
  Waves[WavesCount].Filename:='snd_memopendown.wav'; inc(WavesCount);
  Waves[WavesCount].Filename:='snd_memoerase.wav'; inc(WavesCount);
  Waves[WavesCount].Filename:='snd_memoundo.wav'; inc(WavesCount);

  wfs:=TFileStream.Create('sndeff.dat',fmCreate);
  WriteHeader;

  for idx:=0 to WavesCount-1 do begin
    with Waves[idx] do begin
      ofs:=wfs.Position;
      LoadWave(Filename,wfs,chs,smprate);
      smpcnt:=(wfs.Position-ofs) div chs;
      Main.Memo1.Lines.Add(format('Stored. ID=%d, ofs=%d, smpcnt=%d.',[idx,ofs,smpcnt]));
    end;
  end;

  WriteHeader;

  wfs.Free;

  if err=True then begin
    Memo1.Lines.Add('ERROR!');
    DeleteFile('sndeff.dat');
    exit;
  end;

  Main.Memo1.Lines.Add('--------------------------------');
  Main.Memo1.Lines.Add('Created. [sndeff.dat]');
end;

end.
