unit MainWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, Buttons, ExtDlgs, Menus,ShellAPI;

type
  TMain = class(TForm)
    StartupTimer: TTimer;
    SaveDlg: TSaveDialog;
    OpenDlg: TOpenPictureDialog;
    ReadmeMemo: TMemo;
    ColorDepthGrp: TGroupBox;
    ColorDepth8bitRadio: TRadioButton;
    ColorDepth24bitRadio: TRadioButton;
    BorderColorLbl: TLabel;
    BorderColorImg: TImage;
    ConvertBtn: TBitBtn;
    InsideClipChk: TCheckBox;
    PrvImg: TImage;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure StartupTimerTimer(Sender: TObject);
    procedure InsideClipChkClick(Sender: TObject);
    procedure ConvertBtnClick(Sender: TObject);
    procedure BorderColorImgClick(Sender: TObject);
  private
    { Private 錾 }
    procedure WMDROPFILES(var msg:TWMDROPFILES);message WM_DROPFILES;
    procedure ConvertImage(fn:string);
    function CreateImage(var bm:TBitmap;fn:string):boolean;
    procedure RefreshBorderImg;
  public
    { Public 錾 }
  end;

var
  Main: TMain;

var
  BorderColor:dword;

implementation

{$R *.dfm}

uses _inifile, SelMLWin,_SplitML,_PicTools,_m_Tools,_loadimage,
  ColorPickWin;

const CRLF:string=char($0d)+char($0a);

var
  StartPath:string;

procedure TMain.FormCreate(Sender: TObject);
begin
  StartPath:=ExtractFilePath(Application.ExeName);

  Application.Title:='Jacket image converter for MoonShell2.';
  Main.Caption:=Application.Title;

  DragAcceptFiles(Main.handle,True); // D&D Start

  StartupTimer.Enabled:=True;
end;

procedure TMain.WMDROPFILES(var msg:TWMDROPFILES);
var
  Drop:hdrop;
  index:longint;
  idx:integer;
  Filename:string;
  filebuf:array[0..1024] of char;
  cnt:integer;
begin
  Filename:=StringOfChar(' ',1024);
  Drop:=msg.Drop;
  index:=DragQueryFile(Drop,$FFFFFFFF,nil,0);

  if 1<index then index:=1; // t@CnĂȂB

  for idx:=0 to index-1 do begin
    DragQueryFileA(Drop,idx,filebuf,1024);
    Filename:='';
    cnt:=0;
    while ((filebuf[cnt]<>char($00)) and (cnt<1024)) do begin
      Filename:=Filename+filebuf[cnt];
      inc(cnt);
    end;
    if DirectoryExists(Filename)=True then begin
      ShowMessage(GetMLStr('Please drag and drop image file.|摜t@ChbOhbvĂB')+CRLF+Filename);
      end else begin
      ConvertImage(Filename);
    end;
  end;

  DragFinish(Drop);
end;

procedure TMain.RefreshBorderImg;
begin
  with BorderColorImg do begin
    Canvas.Brush.Color:=BorderColor;
    Canvas.FillRect(Rect(0,0,Width,Height));
    Canvas.Pen.Color:=$000000;
    Canvas.MoveTo(0,0);
    Canvas.LineTo(Width-1,0);
    Canvas.LineTo(Width-1,Height-1);
    Canvas.LineTo(0,Height-1);
    Canvas.LineTo(0,0);
  end;
end;

procedure TMain.StartupTimerTimer(Sender: TObject);
begin
  StartupTimer.Enabled:=False;

  ReadmeMemo.Clear;
  ReadmeMemo.Height:=Main.ClientHeight-ReadmeMemo.Top;

  if GetMLTypeLoaded=False then begin
    if SelML.ShowModal=mrCancel then begin
      Application.Terminate;
      exit;
    end;
  end;

  BorderColor:=$808080;

  LoadINI;

  SetMLBitBtn(ConvertBtn);

  SetMLGrp(ColorDepthGrp);
  SetMLRadio(ColorDepth8bitRadio);
  SetMLRadio(ColorDepth24bitRadio);

  SetMLChk(InsideClipChk);
  SetMLLbl(BorderColorLbl);

  ReadmeMemo.Lines.LoadFromFile(StartPath+GetMLStr('readme_eng.txt|readme_jpn.txt'));

  PrvImg.Left:=8;
  PrvImg.Top:=ReadmeMemo.Top;
  PrvImg.Width:=256;
  PrvImg.Height:=192;
  MakeBlankImg(PrvImg,pf24bit);

  RefreshBorderImg;
end;

procedure TMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  SaveINI;
  DragAcceptFiles(Main.handle,False); // D&D Stop
end;

procedure TMain.InsideClipChkClick(Sender: TObject);
begin
  BorderColorLbl.Visible:=InsideClipChk.Checked;
  BorderColorImg.Visible:=InsideClipChk.Checked;
end;

procedure TMain.ConvertBtnClick(Sender: TObject);
begin
  OpenDlg.Title:=GetMLStr('Select source image file.|ϊ̉摜t@Cw肵ĉB');
  if OpenDlg.Execute=False then exit;
  ConvertImage(OpenDlg.FileName);
end;

procedure TMain.ConvertImage(fn:string);
var
  curbm:TBitmap;
begin
  curbm:=TBitmap.Create;

  if CreateImage(curbm,fn)=False then begin
    curbm.Free;
    exit;
  end;

  BitBlt(PrvImg.Canvas.Handle,0,0,256,192,curbm.Canvas.Handle,0,0,SRCCOPY);

  ReadmeMemo.Visible:=False;
  PrvImg.Refresh;

  SaveDlg.Title:=GetMLStr('Select output folder. Do not change file name. Please specify the same folder as the music file.|ۑtH_w肵ĉBiyt@CƓtH_w肵ĉBjit@C͕ύXȂłBj');
  SaveDlg.InitialDir:=ExtractFilePath(fn);
  SaveDlg.FileName:='jacket.bmp';
  if SaveDlg.Execute=False then begin
    curbm.Free;
    exit;
  end;

  curbm.SaveToFile(SaveDlg.FileName);

  curbm.Free;
end;

function TMain.CreateImage(var bm:TBitmap;fn:string):boolean;
var
  bmsrc,bmdst:TBitmap;
  x,y:integer;
begin
  if LoadImage_LoadFromFile(bmsrc,fn)=False then begin
    ShowMessage('Image file load error.');
    Result:=False;
    exit;
  end;

  MakeBlankBM(bm,256,192,pf24bit);

  if InsideClipChk.Checked=True then begin
    LoadImage_Reduce(bmsrc,bmdst,256,192);
    bm.Canvas.Brush.Color:=BorderColor;
    bm.Canvas.FillRect(Rect(0,0,256,192));
    x:=(256-bmdst.Width) div 2;
    y:=192-bmdst.Height;
    BitBlt(bm.Canvas.Handle,x,y,256,192,bmdst.Canvas.Handle,0,0,SRCCOPY);
    end else begin
    LoadImage_ReduceFull(bmsrc,bmdst,256,192);
    caption:=inttostr(bmdst.Width)+' '+inttostr(bmdst.Height);
    x:=(bmdst.Width-256) div 2;
    y:=(bmdst.Height-192) div 2;
    BitBlt(bm.Canvas.Handle,0,0,256,192,bmdst.Canvas.Handle,x,y,SRCCOPY);
  end;

  bmsrc.Free;
  bmdst.Free;

  if ColorDepth8bitRadio.Checked=True then LoadImage_Convert8bit(bm);

  Result:=True;
end;

procedure TMain.BorderColorImgClick(Sender: TObject);
begin
  ColorPick.StartPick(BorderColor);
  if ColorPick.ShowModal=mrOK then begin
    BorderColor:=ColorPick.PickColor;
    RefreshBorderImg;
  end;
end;

end.

