
typedef signed char s8;
typedef signed short s16;
typedef signed long s32;

typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned long u32;

#define abs(v) (v<0 ? -v : v)

//#define INLINE inline
#define INLINE 

#include "g721dec.h"

#include "g721dec_ins_g72x.h"
#include "g721dec_ins_g721.h"

extern u32 EXTCPP_g721decode(u8 *pblock,u32 blocksize,s16 *psamples);
u32 EXTCPP_g721decode(u8 *pblock,u32 blocksize,s16 *psamples)
{
  TG721State state;
  u32 idx;
  u32 samplescount;
  
#define ru8(x) { \
  u8 *p=(u8*)pblock; \
  x=*p; \
  pblock+=1; \
  blocksize-=1; \
}

#define rs8(x) { \
  s8 *p=(s8*)pblock; \
  x=*p; \
  pblock+=1; \
  blocksize-=1; \
}

#define ru16(x) { \
  u16 *p=(u16*)pblock; \
  x=*p; \
  pblock+=2; \
  blocksize-=2; \
}

#define rs16(x) { \
  s16 *p=(s16*)pblock; \
  x=*p; \
  pblock+=2; \
  blocksize-=2; \
}

#define ru32(x) { \
  u32 *p=(u32*)pblock; \
  x=*p; \
  pblock+=4; \
  blocksize-=4; \
}

#define rs32(x) { \
  s32 *p=(s32*)pblock; \
  x=*p; \
  pblock+=4; \
  blocksize-=4; \
}

  rs32(state.yl);
  rs16(state.yu);
  rs16(state.dms);
  rs16(state.dml);
  rs16(state.ap);
  for(idx=0;idx<2;idx++) rs16(state.a[idx]);
  for(idx=0;idx<6;idx++) rs16(state.b[idx]);
  for(idx=0;idx<2;idx++) rs16(state.pk[idx]);
  for(idx=0;idx<6;idx++) rs16(state.dq[idx]);
  for(idx=0;idx<2;idx++) rs16(state.sr[idx]);
  rs32(state.td);
  
  samplescount=blocksize*2;
  g721_blkdecoder(pblock,psamples,samplescount,&state);
  
  return(samplescount);
}

