unit G721Player_MainWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ExtCtrls, StdCtrls, Buttons, MMSystem, ddsd;

type
  TMain = class(TForm)
    TrkBar: TTrackBar;
    StartupTimer: TTimer;
    OpenDlg: TOpenDialog;
    CancelBtn: TBitBtn;
    IntervalTimer: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure StartupTimerTimer(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure IntervalTimerTimer(Sender: TObject);
    procedure TrkBarChange(Sender: TObject);
  private
    { Private 錾 }
    rfs:TFileStream;
    ReqCancel:boolean;
    procedure UpdateWaveMonitor(Sender:TDDSDGenWave; Player:TDDSDChannel; ofs,len:Cardinal);
  public
    { Public 錾 }
  end;

var
  Main: TMain;

implementation

{$R *.dfm}

uses _g721lib;

var
  HeaderSize,SrcFreq,SrcChs,BlockSize,BlocksCount,BlocksIndex,BlocksSeekIndex:integer;

var
  DDSD:TDDSD;
  WaveMonitor:TDDSDWaveData;
  PCMBusy:boolean;
  PCMBufSize:integer;

function PCMOut_Start(Freq:word):boolean;
var
  PCMBuffer:array[0..16384*2] of smallint;
begin
  PCMBusy:=False;

  DDSD:=TDDSD.Create(Main);
  DDSD.forceInitialize;
  if DDSD.Initialized=False then begin
    Result:=False;
    exit;
  end;

  with DDSD do begin
    ChannelCount:=1;
    StickyFocus:=True;
    Use3D:=False;
    DebugOption:=[dsoHaltOnError];
  end;

  DDSD[0].Stop;
  if WaveMonitor<>nil then WaveMonitor.Free;

  PCMBufSize:=Freq*2*1; // 16bits/1ch.
  ZeroMemory(@PCMBuffer[0],PCMBufSize);

  DDSD.SetPrimaryBufferFotmat(Freq,16,False);
  WaveMonitor:=TDDSDWaveData.CreateStream(DDSD,Freq,16,False,PCMBufSize*2);
  WaveMonitor.OnUpdate:=Main.UpdateWaveMonitor;
  DDSD[0].WaveData:=WaveMonitor;
  DDSD[0].Stop;
  WaveMonitor.BlockCopy(0, @PCMBuffer, PCMBufSize);
  WaveMonitor.BlockCopy(PCMBufSize, @PCMBuffer, PCMBufSize);
  DDSD[0].LoopPlay;

  Result:=True;
end;

procedure PCMOut_Free;
var
  WaitTick:dword;
begin
  DDSD[0].Stop;           
  WaveMonitor.OnUpdate:=nil;
  Application.ProcessMessages;
  while (DDSD[0].Status<>0) do begin
    sleep(16);
    Application.ProcessMessages;
  end;
  WaitTick:=timeGetTime;
  while ((WaitTick+1000)>timeGetTime) do begin
    sleep(16);
    Application.ProcessMessages;
  end;
  WaveMonitor.Free;
end;

function OpenG721(rfs:TFileStream):boolean;
var
  buf:array[0..12-1] of byte;
  chk:boolean;
  bufpos:integer;
  function Readu8:byte;
  begin
    Result:=buf[bufpos];
    inc(bufpos);
  end;
  function Readu16:word;
  begin
    Result:=Readu8;
    Result:=Result or (Readu8 shl 8);
  end;
  function ReadID:string;
  begin
    Result:=char(Readu8);
    Result:=Result+char(Readu8);
    Result:=Result+char(Readu8);
    Result:=Result+char(Readu8);
  end;
begin
  HeaderSize:=12;
  rfs.ReadBuffer(buf[0],HeaderSize);
  bufpos:=0;

  chk:=True;
  if ReadID<>'VREC' then chk:=False;
  if ReadID<>'G721' then chk:=False;

  if chk=False then begin
    Result:=False;
    exit;
  end;

  SrcFreq:=Readu16;
  SrcChs:=Readu16;

  BlockSize:=56+(SrcFreq div 2);
  BlocksCount:=(rfs.Size-HeaderSize+(BlockSize-1)) div BlockSize;
  BlocksIndex:=0;
  BlocksSeekIndex:=-1;

  Result:=True;
end;

procedure TMain.UpdateWaveMonitor(Sender:TDDSDGenWave; Player:TDDSDChannel; ofs,len:Cardinal);
var
  SamplesCount:integer;
  srcbuf:array of byte;
  srcbufsize:integer;
begin
  if PCMBusy=True then exit;
  PCMBusy:=True;

  if rfs.Position=rfs.Size then begin
    ReqCancel:=True;
    PCMBusy:=False;
    exit;
  end;

  SamplesCount:=len div 2;
  if SamplesCount=SrcFreq then begin
    if BlocksSeekIndex<>-1 then begin
      BlocksIndex:=BlocksSeekIndex;
      BlocksSeekIndex:=-1;
      rfs.Position:=HeaderSize+(BlocksIndex*BlockSize);
    end;

    inc(BlocksIndex);

    srcbufsize:=rfs.Size-rfs.Position;
    if BlockSize<srcbufsize then srcbufsize:=BlockSize;
    setlength(srcbuf,srcbufsize);
    rfs.ReadBuffer(srcbuf[0],srcbufsize);

    G721Decode(SrcFreq,srcbuf,srcbufsize);
    if dstbufsize<>0 then WaveMonitor.BlockCopy(ofs,dstbuf,dstbufsize*2);
  end;


  PCMBusy:=False;
end;

procedure TMain.FormCreate(Sender: TObject);
begin
  StartupTimer.Enabled:=True;

  rfs:=nil;
  ReqCancel:=False;
end;

procedure TMain.StartupTimerTimer(Sender: TObject);
var
  srcfn:string;
begin
  StartupTimer.Enabled:=False;

  srcfn:='';

  if ParamCount=1 then begin
    srcfn:=ParamStr(1);
    end else begin
    if OpenDlg.Execute=False then begin
      Application.Terminate;
      exit;
    end;
    srcfn:=OpenDlg.FileName;
  end;

  if FileExists(srcfn)=False then begin
    ShowMessage('File not found. ['+srcfn+']');
    Application.Terminate;
    exit;
  end;

  rfs:=TFileStream.Create(srcfn,fmOpenRead);
  if OpenG721(rfs)=False then begin
    Application.Terminate;
    exit;
  end;

  if PCMOut_Start(SrcFreq)=False then begin
    ShowMessage('DirectSound start error.');
    Application.Terminate;
    exit;
  end;

  TrkBar.Max:=BlocksCount;

  IntervalTimer.Enabled:=True;
end;

procedure TMain.CancelBtnClick(Sender: TObject);
begin
  ReqCancel:=True;
end;

procedure TMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  ReqCancel:=True;
  CanClose:=False;
end;

procedure TMain.IntervalTimerTimer(Sender: TObject);
begin
  if BlocksSeekIndex<>-1 then begin
    Main.Caption:=format('Seeking to %d:%0.2d:%0.2d',[BlocksSeekIndex div 60 div 60,(BlocksSeekIndex div 60) mod 60,BlocksSeekIndex mod 60]);
    end else begin
    TrkBar.OnChange:=nil;
    TrkBar.Position:=BlocksIndex;
    TrkBar.OnChange:=TrkBarChange;
    Main.Caption:=format('Play... %d:%0.2d:%0.2d / %d:%0.2d:%0.2d',[BlocksIndex div 60 div 60,(BlocksIndex div 60) mod 60,BlocksIndex mod 60,BlocksCount div 60 div 60,(BlocksCount div 60) mod 60,BlocksCount mod 60]);
  end;

  if ReqCancel=False then exit;

  IntervalTimer.Enabled:=False;

  Caption:='Terminate...';
  CancelBtn.Enabled:=False;
  Application.ProcessMessages;

  PCMOut_Free();

  rfs.Free;

  Application.Terminate;
end;

procedure TMain.TrkBarChange(Sender: TObject);
begin
  BlocksSeekIndex:=TrkBar.Position;
end;

end.
