unit MainWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls,_PicTools, _m_Tools, ExtCtrls, Buttons, Menus, ComCtrls;

type
  TMain = class(TForm)
    HWMOpenDlg: TOpenDialog;
    ModelsLst: TListBox;
    ModelImg: TImage;
    TextOpenDlg: TOpenDialog;
    ModelImgFontLbl: TLabel;
    ModelsLstPopup: TPopupMenu;
    ModelsLstPopup_ChgChar: TMenuItem;
    TextSaveDlg: TSaveDialog;
    N1: TMenuItem;
    ModelsLstPopup_Delete: TMenuItem;
    MainMenu1: TMainMenu;
    F1: TMenuItem;
    X1: TMenuItem;
    M1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    N5: TMenuItem;
    StatusBar1: TStatusBar;
    N6: TMenuItem;
    N7: TMenuItem;
    N8: TMenuItem;
    N9: TMenuItem;
    dakutenstrs: TListBox;
    handakutenstrs: TListBox;
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure ModelsLstClick(Sender: TObject);
    procedure ModelsLstMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ModelsLstPopup_ChgCharClick(Sender: TObject);
    procedure ModelsLstPopup_DeleteClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure ModelsLstKeyPress(Sender: TObject; var Key: Char);
    procedure N2Click(Sender: TObject);
    procedure N4Click(Sender: TObject);
    procedure N5Click(Sender: TObject);
    procedure X1Click(Sender: TObject);
    procedure N7Click(Sender: TObject);
    procedure N8Click(Sender: TObject);
  private
    { Private 錾 }
    procedure RefreshModelsLst;
  public
    { Public 錾 }
  end;

var
  Main: TMain;

implementation

{$R *.dfm}

uses _Models, CloseDlgWin;

var
  HWMFilename:string;
  ChangedFlag:boolean;

procedure TMain.RefreshModelsLst;
var
  TopIndex,ItemIndex:integer;
  midx:integer;
  strs:TStringList;
begin
  TopIndex:=ModelsLst.TopIndex;
  ItemIndex:=ModelsLst.ItemIndex;

  strs:=TStringList.Create;
  for midx:=0 to ModelsCount-1 do begin
    strs.Add(format('%d: U+%s %s',[1+midx,inttohex(integer(Models[midx].wc),4),string(Models[midx].wc)]));
  end;
  ModelsLst.Items:=strs;
  strs.Free;

  if (ModelsLst.Items.Count-1)<TopIndex then TopIndex:=ModelsLst.Items.Count-1;
  ModelsLst.TopIndex:=TopIndex;
  if (ModelsLst.Items.Count-1)<ItemIndex then ItemIndex:=ModelsLst.Items.Count-1;
  ModelsLst.ItemIndex:=ItemIndex;

  StatusBar1.SimpleText:=inttostr(ModelsCount)+' models loaded.';
end;

procedure TMain.FormCreate(Sender: TObject);
begin
  Application.Title:='菑f}l[W';
  Main.Caption:=Application.Title;

  Show;

  ModelImg.Canvas.Font:=ModelImgFontLbl.Font;

  if HWMOpenDlg.Execute=False then begin
    Application.Terminate;
    exit;
  end;
  HWMFilename:=HWMOpenDlg.FileName;

//  HWMFilename:='hwmodels.hwm';

  ModelLoadFromBin(HWMFilename);
  ChangedFlag:=False;

  RefreshModelsLst;
  ModelsLst.ItemIndex:=ModelsLst.Items.Count-1;
  ModelsLstClick(nil);
end;

procedure TMain.FormResize(Sender: TObject);
begin
  ModelsLst.Height:=Main.ClientHeight-StatusBar1.Height;
end;

procedure TMain.ModelsLstClick(Sender: TObject);
begin
  MakeBlankImg(ModelImg,pf24bit);
  ModelDraw(Models[ModelsLst.ItemIndex],ModelImg.Canvas);
end;

procedure TMain.ModelsLstMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  idx:integer;
begin
  if Button=mbRight then begin
    idx:=y div ModelsLst.ItemHeight+ModelsLst.TopIndex;
    if ModelsLst.Items.Count<=idx then exit;
    ModelsLst.ItemIndex:=idx;
    ModelsLstClick(self);
    ModelsLstPopup.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y);
  end;
end;

procedure TMain.ModelsLstPopup_ChgCharClick(Sender: TObject);
var
  srcwc,dstwc:widechar;
  str:widestring;
  idx:integer;
begin
  idx:=ModelsLst.ItemIndex;
  srcwc:=Models[idx].wc;
  str:=InputBox('F̕ύX','Fꕶ͂ĂB',srcwc);
  if str='' then exit;
  if length(str)<>1 then begin
    ShowMessage(inttostr(length(str))+'w肳܂Bꕶw肵ĂB');
    exit;
  end;
  dstwc:=str[1];
  Models[idx].wc:=dstwc;
  ChangedFlag:=True;

  RefreshModelsLst;

  str:=srcwc+'"  "'+dstwc+'" ɕύX܂B';
  str:='fԍ '+inttostr(1+idx)+'  "'+str;
  StatusBar1.SimpleText:=str;
end;

procedure TMain.ModelsLstPopup_DeleteClick(Sender: TObject);
var
  wc:widechar;
  tagidx:integer;
  idx:integer;
  str:widestring;
begin
  if ModelsCount=0 then exit;

  tagidx:=ModelsLst.ItemIndex;
  wc:=Models[tagidx].wc;

  for idx:=tagidx to ModelsCount-1-1 do begin
    ModelCopy(Models[idx+1],Models[idx+0]);
  end;
  dec(ModelsCount);
  ChangedFlag:=True;

  RefreshModelsLst;

  ModelsLstClick(nil);

  str:=wc+'" 폜܂B';
  str:='fԍ '+inttostr(1+tagidx)+'  "'+str;
  StatusBar1.SimpleText:=str;
end;

procedure TMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
  res:integer;
begin
  if ChangedFlag=False then begin
    CanClose:=True;
    exit;
  end;

  res:=CloseDlg.ShowModal;

  if res=mrYes then begin
    ModelSaveToBin(HWMFilename);
    CanClose:=True;
    exit;
  end;

  if res=mrIgnore then begin
    CanClose:=True;
    exit;
  end;

  if res=mrCancel then begin
    CanClose:=False;
    exit;
  end;

end;

procedure TMain.ModelsLstKeyPress(Sender: TObject; var Key: Char);
begin
  if UpperCase(key)='C' then ModelsLstPopup_ChgCharClick(nil);
  if UpperCase(key)='D' then ModelsLstPopup_DeleteClick(nil);
end;

procedure TMain.N4Click(Sender: TObject);
var
  resstr:string;
begin
  TextOpenDlg.Title:='ǂݍ݌eLXgt@Cw肵ĂB';
  if TextOpenDlg.Execute=False then exit;

  resstr:=ModelLoadFromText(TextOpenDlg.FileName);
  ChangedFlag:=True;
  RefreshModelsLst;

  StatusBar1.SimpleText:=resstr;
end;

procedure TMain.N5Click(Sender: TObject);
var
  resstr:string;
begin
  if MessageDlg('ǂݍݍς݃f[^Sč폜āAeLXgt@CǍł낵łH',mtConfirmation,mbOKCancel,0)<>mrOk then exit;

  TextOpenDlg.Title:='VKǂݍ݌eLXgt@Cw肵ĂB';
  if TextOpenDlg.Execute=False then exit;

  ModelsCount:=0;

  resstr:=ModelLoadFromText(TextOpenDlg.FileName);
  ChangedFlag:=True;
  RefreshModelsLst;

  ModelsLstClick(nil);

  StatusBar1.SimpleText:=resstr;
end;

procedure TMain.N2Click(Sender: TObject);
begin
  TextSaveDlg.Title:='oeLXgt@Cw肵ĂB';
  if TextSaveDlg.Execute=False then exit;
  if FileExists(TextSaveDlg.FileName)=True then begin
    if MessageDlg('t@C݂܂B㏑ۑĂ낵łH',mtConfirmation,mbOKCancel,0)<>mrOk then exit;
  end;
  ModelSaveToText(TextSaveDlg.FileName,-1);
  StatusBar1.SimpleText:='eLXgt@Cۑ܂B';
end;

procedure TMain.X1Click(Sender: TObject);
begin
  Main.Close;
end;

procedure TMain.N7Click(Sender: TObject);
var
  midx:integer;
begin
  midx:=ModelsLst.ItemIndex;
  TextSaveDlg.Title:=inttostr(1+midx)+': "'+Models[midx].wc+'" oeLXgt@Cw肵ĂB';
  TextSaveDlg.FileName:='Model-U+'+inttohex(word(Models[midx].wc),4)+' ('+inttostr(1+midx)+').txt';
  if TextSaveDlg.Execute=False then exit;
  if FileExists(TextSaveDlg.FileName)=True then begin
    if MessageDlg('t@C݂܂B㏑ۑĂ낵łH',mtConfirmation,mbOKCancel,0)<>mrOk then exit;
  end;
  ModelSaveToText(TextSaveDlg.FileName,midx);
  StatusBar1.SimpleText:='1̃eLXgt@Cۑ܂B';
end;

procedure TMain.N8Click(Sender: TObject);
var
  basefn,baseext:string;
  fn:string;
  midx:integer;
begin
  if MessageDlg('ff[^ʃ[hŕۑƁA ('+inttostr(ModelsCount)+') ̃eLXgt@C쐬܂B'+CRLF+'ʏ킱̃[h͎gp܂Bs܂H',mtConfirmation,[mbYes,mbCancel],0)<>mrYes then exit;

  TextSaveDlg.Title:='oeLXgt@Cw肵ĂB';
  TextSaveDlg.FileName:='ModelsNum.txt';
  if TextSaveDlg.Execute=False then exit;

  basefn:=ChangeFileExt(TextSaveDlg.FileName,'');
  baseext:=ExtractFileExt(TextSaveDlg.FileName);
  for midx:=0 to ModelsCount-1 do begin
    fn:=basefn+format('%4.4d',[1+midx])+baseext;
    ModelSaveToText(fn,midx);
  end;

  StatusBar1.SimpleText:=inttostr(ModelsCount)+'̃eLXgt@Cۑ܂B';
end;

end.
