unit dpgplay_PreviewWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, ComCtrls,_PicTools, MPlayer, MMSystem ,dpgplay_PCMOut,
  StdCtrls;

type
  TPreview = class(TForm)
    IntervalTimer: TTimer;
    procedure IntervalTimerTimer(Sender: TObject);
  private
    { Private 錾 }
    PCMOut:TPCMOut;
    procedure playmovie;
  public
    { Public 錾 }
    procedure OpenDPG(DPGFilename:string);
    procedure StopDPG;
    function UpdateWaveMonitor(buf:PSmallInt;SamplesCount:integer):boolean;
  end;

var
  Preview: TPreview;

implementation

{$R *.dfm}

uses _dpg_const, dpgplay_DSSupportWin, dpgplay_inifile, dpgplay_MainWin;

procedure CopyData(itemname:string;srcfn,dstfn:string;pos,size:integer);
var
  rfs,wfs:TFileStream;
  buf:array of byte;
  blocksize:integer;
begin
  setlength(buf,size);

  Main.Caption:=itemname+' ReadData.';

  rfs:=TFileStream.Create(srcfn,fmOpenRead or fmShareDenyWrite);
  rfs.Position:=pos;
  wfs:=TFileStream.Create(dstfn,fmCreate);
  wfs.Position:=0;

  while(size<>0) do begin
    blocksize:=1*1024*1024;
    if size<blocksize then blocksize:=size;
    setlength(buf,blocksize);
    rfs.ReadBuffer(buf[0],blocksize);
    wfs.WriteBuffer(buf[0],blocksize);
    dec(size,blocksize);
    Main.StatusBar1.SimpleText:=format(' %dbyte',[size]);
    Main.StatusBar1.Refresh;
    Application.ProcessMessages;
  end;

  Main.StatusBar1.SimpleText:='';
  Main.StatusBar1.Refresh;

  rfs.Free;
  wfs.Free;
end;

var
  dpgfn,mp2fn,oggfn,m1vfn:string;
  DPGINFO:TDPGINFO;
  SourceFPS:double;
  VideoWidth,VideoHeight:integer;

function GetDSInfo(m1vfn:string):boolean;
begin
  DSSupport.DSOpen(m1vfn,0,0,0);
  SourceFPS:=DSSupport.GetSourceFPS;
  DSSupport.DSClose;

  VideoWidth:=DSSupport.VideoWidth;
  VideoHeight:=DSSupport.VideoHeight;

  Result:=True;
  if SourceFPS=0 then Result:=False;
  if (VideoWidth=0) or (VideoHeight=0) then Result:=False;
end;

procedure TPreview.OpenDPG(DPGFilename:string);
var
  StartPath:string;
  backcaption:string;
  fsize:integer;
  path:string;
  wh:integer;
begin
  dpgfn:=DPGFilename;

  backcaption:=Main.Caption;
  Main.Caption:='Read DPGINFO...';

  if LoadDPGINFO(DPGINFO,path+dpgfn,fsize)=0 then begin
    ShowMessage('ΉĂȂo[WłB');
    exit;
  end;

  path:=ExtractFilePath(dpgfn);
  dpgfn:=ExtractFilename(dpgfn);

  StartPath:=ExtractFilePath(Application.ExeName);
  mp2fn:=StartPath+'$$$tmp_'+ChangeFileExt(dpgfn,'.mp2');
  oggfn:=StartPath+'$$$tmp_'+ChangeFileExt(dpgfn,'.ogg');
  m1vfn:=StartPath+'$$$tmp_'+ChangeFileExt(dpgfn,'.m1v');
  dpgfn:=path+dpgfn;

  if DPGINFO.SndCh=0 then begin
    CopyData('Audio',dpgfn,mp2fn,DPGINFO.AudioPos,DPGINFO.AudioSize);
  end;
  if (DPGINFO.SndCh=1) or (DPGINFO.SndCh=2) then begin
    ShowMessage('Can not decode GSM audio. (old DPG?)');
    exit;
  end;
  if DPGINFO.SndCh=3 then begin
    CopyData('Audio',dpgfn,oggfn,DPGINFO.AudioPos,DPGINFO.AudioSize);
  end;

  CopyData('Movie',dpgfn,m1vfn,DPGINFO.MoviePos,DPGINFO.MovieSize);

  Main.Caption:='Open DPG...';
  GetDSInfo(m1vfn);

  Main.DPGInfoMemo.Lines.Text:=LoadDPGINFOString(dpgfn);

  Main.Caption:=backcaption;

  playmovie;
end;

var
  FrameIndex:integer;
  FrameCount:integer;
  LastTick:dword;

procedure TPreview.playmovie;
var
  tc:TTIMECAPS;
begin
  timeGetDevCaps(@tc,sizeof(TTIMECAPS));
  timeBeginPeriod(tc.wPeriodMin);

  FrameCount:=DPGINFO.TotalFrame;
  FrameIndex:=0;

  DSSupport.DSOpen(m1vfn,DPGINFO.FPS,VideoWidth,VideoHeight);

  PCMOut:=TPCMOut.Create;
  PCMOut.Init(200,DPGINFO.SndFreq);

  if DPGINFO.SndCh=0 then begin
    GetRAWPCM_Start(mp2fn,PCMOut.PCMBufSize div 2);
  end;
  if (DPGINFO.SndCh=1) or (DPGINFO.SndCh=2) then begin
  end;
  if DPGINFO.SndCh=3 then begin
    GetRAWPCM_Start(oggfn,PCMOut.PCMBufSize div 2);
  end;
  PCMOut.StartDSound;

  LastTick:=GetTickCount+(200*2);

  IntervalTimer.Enabled:=True;
end;

function TPreview.UpdateWaveMonitor(buf:PSmallInt;SamplesCount:integer):boolean;
begin
  Result:=GetRAWPCM_Decode(buf,SamplesCount);
end;

procedure TPreview.IntervalTimerTimer(Sender: TObject);
var
  bm:TBitmap;
  procedure ConvertPixelFormat;
  var
    pb:PByteArray;
    x,y:integer;
    shift:integer;
    c:dword;
  begin
    case DPGINFO.PixelFormat of
      DPGPixelFormat_RGB15: shift:=3;
      DPGPixelFormat_RGB18: shift:=2;
      DPGPixelFormat_RGB21: shift:=1;
      DPGPixelFormat_RGB24: shift:=0;
      else shift:=0;
    end;
    if shift<>0 then begin
      for y:=0 to VideoHeight-1 do begin
        pb:=bm.ScanLine[y];
        for x:=0 to (VideoWidth*3)-1 do begin
          c:=pb[x] shl shift;
          if $ff<c then c:=$ff;
          pb[x]:=c;
        end;
      end;
    end;
  end;
begin
  IntervalTimer.Enabled:=False;

  if FrameIndex=FrameCount then exit;

  if GetTickCount<trunc(lasttick+(FrameIndex/DPGINFO.FPS*1000)) then begin
    IntervalTimer.Enabled:=True;
    exit;
  end;

  bm:=TBitmap.Create;
  MakeBlankBM(bm,VideoWidth,VideoHeight,pf24bit);

  DSSupport.GetStretchBitmap(FrameIndex,bm,False);
  ConvertPixelFormat;

  BitBlt(Main.PreviewImg.Canvas.Handle,0,(Main.PreviewImg.Height-VideoHeight) div 2,VideoWidth,VideoHeight,bm.Canvas.Handle,0,0,SRCCOPY);

  bm.Free;

  inc(FrameIndex);

  Main.StatusBar1.SimpleText:=format(' %d/%dframes %d/%dsec.',[FrameIndex,FrameCount,trunc(FrameIndex/DPGINFO.FPS),trunc(FrameCount/DPGINFO.FPS)]);

  IntervalTimer.Enabled:=True;
end;

procedure TPreview.StopDPG;
begin
  IntervalTimer.Enabled:=False;

  with Main.PreviewImg do begin
    Canvas.FillRect(Rect(0,0,Width,Height));
    Refresh;
  end;

  PCMOut.StopDriver;
  PCMOut.FreeMemory;

  GetRAWPCM_End;

  DSSupport.DSClose;

  if FileExists(mp2fn)=True then DeleteFile(mp2fn);
  if FileExists(oggfn)=True then DeleteFile(oggfn);
  if FileExists(m1vfn)=True then DeleteFile(m1vfn);

  timeEndPeriod(1);
end;

end.
