unit _encaudio;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls,_dpg_const;

function DemuxAudioConvert_DirectShow(reqerr:boolean;avifn:string;wavfn:string;Volume:integer;DstFreq,FakeFreq:integer;VideoTimeSec:double):boolean;

function EncodeMP2_HQ32768Hz_twolame(reqerr:boolean;srcfn,dstfn:string;freq:integer;kbps:integer):boolean;

var
  encaudio_StartPath:string;
  encaudio_PluginPath:string;

implementation

uses _m_Tools,_queue,_dosbox,dpgenc_language,MainWin,enclogWin,DSSupport_audio;

const CRLF:string=char($0d)+char($0a);

const RiffHeaderSize=11;

procedure RewriteWaveHeader(var wfs:TFileStream;rate:integer;is16bit:boolean);
var
  oldpos:integer;
  Count:integer;
  RiffHeader:array[0..RiffHeaderSize-1] of dword;
  fsize:integer;
  function SwapHiLow(d:dword):dword;
  begin
    Result:=dword((int64(d) div $1000000 and $FF)+((int64(d) div $10000 and $FF)*$100)+((int64(d) div $100 and $FF)*$10000)+((int64(d) and $FF)*$1000000));
  end;
begin
  // RiffWave Header of 44.1khz 16bit stereo
  RiffHeader[ 0]:=$52494646; // RIFF Header
  RiffHeader[ 1]:=$00000000; // TotalFileSize-8;
  RiffHeader[ 2]:=$57415645; // WAVE Header
  RiffHeader[ 3]:=$666D7420; // fmt  Header
  RiffHeader[ 4]:=$10000000;
  RiffHeader[ 5]:=$01000200; // (word)wFormatTag,(word)nChannels
  RiffHeader[ 6]:=$44AC0000; // (dword)nSamplesPerSec(44kHz)
  RiffHeader[ 7]:=$10B10200; // (dword)nAvgBytesPerSec(44kHz*4)
  RiffHeader[ 8]:=$04001000; // (word)nBlockAlign,(word)wBitsPerSample
  if is16bit=False then RiffHeader[8]:=RiffHeader[8] div 2;
  RiffHeader[ 9]:=$64617461; // data Header
  RiffHeader[10]:=$00000000; // WaveSize (bytesize)

  RiffHeader[ 6]:=SwapHiLow(rate);
  RiffHeader[ 7]:=SwapHiLow(rate*4);

  if wfs.Size<=(RiffHeaderSize*4) then begin
    fsize:=RiffHeaderSize*4;
    end else begin
    fsize:=wfs.Size-(RiffHeaderSize*4);
  end;
  RiffHeader[ 1]:=SwapHiLow(fsize-8);
  RiffHeader[10]:=SwapHiLow(fsize-44);

  // Swap Hi Low
  for Count:=0 to RiffHeaderSize-1 do begin
    RiffHeader[Count]:=SwapHiLow(RiffHeader[Count]);
  end;

  oldpos:=wfs.Position;
  wfs.Position:=0;
  wfs.WriteBuffer(RiffHeader[0],RiffHeaderSize*4);
  wfs.Position:=oldpos;
end;

function DemuxAudioConvert_CreateBlankFile(reqerr:boolean;avifn:string;wavfn:string;Volume:integer;DstFreq,FakeFreq:integer;VideoTimeSec:double):boolean;
var
  wfs:TFileStream;
  TotalSamplesCount:integer;
  buf:array[0..128*1024] of dword; // NULL,16bit2chs
  bufsize:integer;
  idx:integer;
  prgpos:integer;
begin
  TotalSamplesCount:=trunc(VideoTimeSec*DstFreq);
//  TotalSamplesCount:=TotalSamplesCount div 2; // rfI艹ZARM7~łȂȂB

  SetPrgBarPos(0,'');
  SetPrgBarMax(TotalSamplesCount);
  prgpos:=0;

  wfs:=TFileStream.Create(wavfn,fmCreate);
  RewriteWaveHeader(wfs,DstFreq,True);

  for idx:=0 to 128*1024 do begin
    buf[idx]:=0;
  end;

  while(0<TotalSamplesCount) do begin
    bufsize:=TotalSamplesCount;
    if 128*1024<bufsize then bufsize:=128*1024;
    wfs.WriteBuffer(buf[0],bufsize*4);
    dec(TotalSamplesCount,bufsize);
    inc(prgpos,bufsize);
    SetPrgBarPos(prgpos,'');
  end;

  RewriteWaveHeader(wfs,FakeFreq,True);

  wfs.Free;

  enclog.Caption:='Encode Terminate';
  SetPrgBarPos(0,'Encode Terminate');

  Result:=True;
end;

type
  PSmallIntArray = ^TSmallIntArray;
  TSmallIntArray = array[0..65536*100] of SmallInt;

function DemuxAudioConvert_DirectShow(reqerr:boolean;avifn:string;wavfn:string;Volume:integer;DstFreq,FakeFreq:integer;VideoTimeSec:double):boolean;
var
  wfs:TFileStream;
  TimeoutCount:integer;
  sampletime:double;
  lasttick:dword;
  sc_l,sc_r,sc_ll,sc_lr:smallint;
  sc_cur,sc_add,sc_vol:double;
  procedure WriteBuffer(pbuf:PSmallIntArray;bufcnt:integer);
  var
    l,r,ll,lr:smallint;
    cur:double;
    srcpos:integer;
    dstbuf:array of smallint;
    dstpos:integer;
    a,ia:double;
    fs:double;
  begin
    bufcnt:=bufcnt div 2; // 2chs

    setlength(dstbuf,bufcnt*2*16); // 16{(Œ2kHz)܂

    l:=sc_l; r:=sc_r;
    ll:=sc_ll; lr:=sc_lr;
    cur:=sc_cur;

    srcpos:=0;
    dstpos:=0;

    while(True) do begin
      while(1<=cur) do begin
        if bufcnt<=srcpos then begin
          sc_l:=l; sc_r:=r;
          sc_ll:=ll; sc_lr:=lr;
          sc_cur:=cur;
          wfs.WriteBuffer(dstbuf[0],dstpos*2*2); // 2ch16bits
          exit;
        end;

        ll:=l; lr:=r;
        l:=pbuf[srcpos*2+0]; r:=pbuf[srcpos*2+1];
        inc(srcpos);
        cur:=cur-1;
      end;

      a:=cur; ia:=1-a;
      fs:=((ll*ia)+(l*a))*sc_vol;
      if fs<-32768 then fs:=-32768;
      if 32767<fs then fs:=32767;
      dstbuf[dstpos*2+0]:=trunc(fs);
      fs:=((lr*ia)+(r*a))*sc_vol;
      if fs<-32768 then fs:=-32768;
      if 32767<fs then fs:=32767;
      dstbuf[dstpos*2+1]:=trunc(fs);
      inc(dstpos);

      cur:=cur+sc_add;
    end;
  end;
begin
  enclog.loglst.Lines.Add(format('Start DemuxAudio_DirectShow(%s,%s,%d);',[avifn,wavfn,Volume]));

  if DSAudio_Start(avifn,DPGEncode.StartTimeSec,DPGEncode.EndTimeSec)=False then begin
    if DSAudio_NoAudioStream=True then begin
      Result:=DemuxAudioConvert_CreateBlankFile(reqerr,avifn,wavfn,Volume,DstFreq,FakeFreq,VideoTimeSec);
      exit;
    end;
    enclog.loglst.Lines.Add(DSAudio_GetLastError);
    if reqerr=True then Current_SetError(lng(LI_GetAudioError),'');
    Result:=False;
    exit;
  end;

  if DSAudio_Run=False then begin
    enclog.loglst.Lines.Add(DSAudio_GetLastError);
    if reqerr=True then Current_SetError(lng(LI_GetAudioError),'');
    Result:=False;
    exit;
  end;

  enclog.loglst.Lines.Add(format('SampleRate=%dHz %dbits %dchannels',[DSAudio_GetSampleRate,DSAudio_GetSampleBits,DSAudio_GetSampleChs]));
  enclog.loglst.Lines.Add(format('TotalTime=%fsec',[DSAudio_GetTotalTimeSec]));

  if (DSAudio_GetSampleBits<>8) and (DSAudio_GetSampleBits<>16) then begin
    if reqerr=True then Current_SetError(format('Not support bits count. (%dbits)',[DSAudio_GetSampleBits]),'');
    DSAudio_Close;
    Result:=False;
    exit;
  end;

  if (DSAudio_GetSampleChs<>1) and (DSAudio_GetSampleChs<>2) then begin
    if reqerr=True then Current_SetError(format('Not support channels count. (%dchs)',[DSAudio_GetSampleChs]),'');
    DSAudio_Close;
    Result:=False;
    exit;
  end;

  SetMainTitle('Decode to wave and freqrate... (use DirectShow)');

  if DPGEncode.StartTimeSec<>0 then enclog.loglst.Lines.Add(format('Audio seeking to %fsec',[DPGEncode.StartTimeSec]));

  SetPrgBarPos(0,'');
  SetPrgBarMax(trunc(DSAudio_GetTotalTimeSec*10));

  wfs:=TFileStream.Create(wavfn,fmCreate);
  RewriteWaveHeader(wfs,DstFreq,True);

  sc_l:=0; sc_r:=0;
  sc_ll:=0; sc_lr:=0;
  sc_cur:=1;
  sc_add:=DSAudio_GetSampleRate/DstFreq;
  sc_vol:=Volume/100;

  TimeoutCount:=30*100; // first timeout is 30sec.

  lasttick:=GetTickCount-1000;

  while(True) do begin
    if AudioSampleGrabber.GetSampleStart=True then begin
      sampletime:=AudioSampleGrabber.SamplesCurrentTime;
      WriteBuffer(addr(AudioSampleGrabber.SamplesBuf[0]),AudioSampleGrabber.SamplesPosition);
      AudioSampleGrabber.SamplesPosition:=0;
      AudioSampleGrabber.GetSampleEnd;

      if DSAudio_GetTotalTimeSec<=DSAudio_GetCurrentTimeSec then break;

      if (1000<=(GetTickCount-lasttick)) then begin
        lasttick:=GetTickCount;
        SetPrgBarPos(trunc(sampletime*10),'');
      end;

      TimeoutCount:=2*100; // timeout is 2sec.
    end;
    Application.ProcessMessages;
    if Current_GetRequestCancel=True then break;

    dec(TimeoutCount);
    if TimeoutCount=0 then break;
    sleep(10);
  end;

  enclog.Caption:='Encode Terminate';
  SetPrgBarPos(0,'Encode Terminate');

  DSAudio_Close;

  RewriteWaveHeader(wfs,FakeFreq,True);

  wfs.Free;

  enclog.loglst.Lines.Add('Close DirectShow');

  try
    enclog.loglst.Lines.SaveToFile(changefileext(Application.ExeName,'')+'_encode.log');
    except else begin
    end;
  end;

  Result:=True;
end;

function EncodeMP2_HQ32768Hz_twolame(reqerr:boolean;srcfn,dstfn:string;freq:integer;kbps:integer):boolean;
var
  hInputRead,hInputWrite:THANDLE;
  hOutputRead,hOutputWrite:THANDLE;
  ErrorStr:string;
  PipeBufStr:string;
  PipeBufFlag:boolean;
  lasttick:dword;
  CaptionText:string;
  perlen:integer;
  permax:integer;
  perstr:string;
  perint:integer;
  batfn:string;
  function CreatePipes(ReadBufSize:dword):boolean;
  var
    SA:SECURITY_ATTRIBUTES;
    SD:TSecurityDescriptor;
  begin
    hInputRead:=0;
    hInputWrite:=0;
    hOutputRead:=0;
    hOutputWrite:=0;

    sa.nLength:=sizeof(SECURITY_ATTRIBUTES);
    sa.lpSecurityDescriptor:=nil;
    sa.bInheritHandle:=True;
    InitializeSecurityDescriptor(@SD,SECURITY_DESCRIPTOR_REVISION);
    SetSecurityDescriptorDacl(@SD,True,nil,False);
    sa.lpSecurityDescriptor:=@SD;

    if CreatePipe(hInputRead,hInputWrite,@sa,ReadBufSize)=False then begin
      if reqerr=True then Current_SetError(lng(LI_PipeErrorCreate),'');
      Result:=False;
      exit;
    end;
    if DuplicateHandle(GetCurrentProcess(),hInputWrite,GetCurrentProcess(),nil,0,False,DUPLICATE_SAME_ACCESS)=False then begin
      if reqerr=True then Current_SetError(lng(LI_PipeErrorAttribute),'');
      Result:=False;
      exit;
    end;

    if CreatePipe(hOutputRead,hOutputWrite,@sa,0)=False then begin
      if reqerr=True then Current_SetError(lng(LI_PipeErrorCreate),'');
      Result:=False;
      exit;
    end;
    if DuplicateHandle(GetCurrentProcess(),hOutputRead,GetCurrentProcess(),nil,0,False,DUPLICATE_SAME_ACCESS)=False then begin
      if reqerr=True then Current_SetError(lng(LI_PipeErrorAttribute),'');
      Result:=False;
      exit;
    end;

    Result:=True;
  end;
  function StartEncode:boolean;
  var
    appfn:string;
    cmdline:string;
    wfs:TFileStream;
    str:string;
  begin
    appfn:=encaudio_PluginPath+'twolame.exe';
    batfn:=ChangeFileExt(appfn,'.bat');

    if fileexists(appfn)=False then begin
      if reqerr=True then Current_SetError('not found plugin.',appfn);
      Result:=False;
      exit;
    end;

    if CreatePipes(1024)=False then begin
      Result:=False;
      exit;
    end;

    cmdline:=format('-t 4 -b %d -m j "'+srcfn+'" "'+dstfn+'"',[kbps]);
    enclog.loglst.Lines.Add(appfn);
    enclog.loglst.Lines.Add(cmdline);
    enclog.loglst.Lines.Add('');

    wfs:=TFileStream.Create(batfn,fmCreate);
    str:='"'+ChangeFileExt(appfn,'.exe')+'" '+cmdline;
    wfs.WriteBuffer(str[1],length(str));
    wfs.Free;

    cmdline:='';
    if CreateDOSBOX2(encaudio_PluginPath,hInputRead,hOutputWrite,hOutputWrite,batfn,cmdline)=False then begin
      if reqerr=True then Current_SetError('CreateDOSBOX error.','');
      Result:=False;
      exit;
    end;

    Result:=True;
  end;
  function ReadPipe(hnd:THANDLE):string;
  var
    ansistr:array[0..1024] of ansichar;
    i:integer;
    len:dword;
    readsize:dword;
    c:ansichar;
  begin
    Result:='';

    len:=0;
    if PeekNamedPipe(hnd, nil, 0, nil,@len,nil)=True then begin
      if len<>0 then begin
        if 1024<=len then len:=1024;
        if ReadFile(hnd,ansistr[0],len,readsize,nil)=True then begin
          for i:=0 to readsize-1 do begin
            c:=ansistr[i];
            if PipeBufFlag=False then begin
              if c=ansichar($0d) then begin
                PipeBufFlag:=True;
                end else begin
                PipeBufStr:=PipeBufStr+c;
              end;
              end else begin
              PipeBufFlag:=False;
              if c=ansichar($0a) then begin
                Result:=Result+PipeBufStr+CRLF;
                PipeBufStr:='';
                end else begin
                CaptionText:=PipeBufStr;
                PipeBufStr:=c;
              end;
            end;
          end;
        end;
      end;
    end;
  end;
  procedure EndEncode;
  begin
    CloseDOSBOX2(False); // I҂Ȃ

    ErrorStr:=ReadPipe(hOutputRead);
    if ErrorStr<>'' then begin
      enclog.loglst.Lines.Add(ErrorStr);
      enclog.loglst.Refresh;
    end;
    try
      enclog.loglst.Lines.SaveToFile(changefileext(Application.ExeName,'')+'_mencoder.log');
      except else begin
      end;
    end;

    CloseHandle(hInputRead);
    CloseHandle(hInputWrite);
    CloseHandle(hOutputRead);
    CloseHandle(hOutputWrite);
  end;
begin
  if DSAudio_NoAudioStream=True then kbps:=32;
  
  if StartEncode=False then begin
    Result:=False;
    exit;
  end;

  SetMainTitle('High quality encode to mp2... (use twolame)');

  permax:=GetFileSize(srcfn) div 6000;

  SetPrgBarPos(0,'');
  SetPrgBarMax(permax);

  PipeBufStr:='';
  PipeBufFlag:=False;
  CaptionText:='';

  lasttick:=GetTickCount-1000;

  while(isTerminatedDOSBOX2=False) do begin
    if (1000<=(GetTickCount-lasttick)) then begin
      lasttick:=GetTickCount;
      PerStr:=CaptionText;
      PerLen:=length(PerStr);
      if (6<=PerLen) and (PerLen<10) then begin
        if (PerStr[1]='[') and (PerStr[PerLen]=']') then begin
          PerStr:=copy(PerStr,2,PerLen-2);
          PerInt:=strtointdef(PerStr,0);
          if perint<permax then SetPrgBarPos(PerInt,'');
          enclog.Caption:=CaptionText;
        end;
        CaptionText:='';
      end;
    end;

    ErrorStr:=ReadPipe(hOutputRead);
    if ErrorStr<>'' then begin
      enclog.loglst.Lines.Add(ErrorStr);
      enclog.loglst.Refresh;
    end;

    Application.ProcessMessages;
//    if Current_GetRequestCancel=True then break;

    sleep(100);
  end;

  enclog.Caption:='Encode Terminate';
  SetPrgBarPos(0,'Encode Terminate');

  EndEncode;

  DeleteFile(batfn);

  if Current_GetRequestCancel=True then begin
    Result:=False;
    exit;
  end;

  if GetFileSize(dstfn)=0 then begin
    if reqerr=True then Current_SetError('error func EncodeMP2_HQ32768Hz_twolame','');
    Result:=False;
    exit;
  end;

  Result:=True;
end;

end.

