unit NetworkWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, IdBaseComponent, IdComponent,
  IdTCPConnection, IdTCPClient, IdHTTP, IdAntiFreezeBase, IdAntiFreeze;

type
  TNetwork = class(TForm)
    LogMemo: TMemo;
    PrgBar: TProgressBar;
    URLEdt: TEdit;
    Label1: TLabel;
    StartBtn: TBitBtn;
    GroupBox1: TGroupBox;
    StatusLbl: TLabel;
    fmt22Chk: TCheckBox;
    fmt18Chk: TCheckBox;
    fmt6Chk: TCheckBox;
    fmt0Chk: TCheckBox;
    IdHTTP1: TIdHTTP;
    CancelBtn: TBitBtn;
    IdAntiFreeze1: TIdAntiFreeze;
    procedure URLEdtClick(Sender: TObject);
    procedure URLEdtKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure URLEdtMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure StartBtnClick(Sender: TObject);
    procedure IdHTTP1WorkBegin(Sender: TObject; AWorkMode: TWorkMode;
      const AWorkCountMax: Integer);
    procedure IdHTTP1Work(Sender: TObject; AWorkMode: TWorkMode;
      const AWorkCount: Integer);
    procedure IdHTTP1WorkEnd(Sender: TObject; AWorkMode: TWorkMode);
    procedure CancelBtnClick(Sender: TObject);
  private
    { Private 錾 }
    procedure FormDisabled;
    procedure FormEnabled;
  public
    { Public 錾 }
    OptOutputPath:string;
    VideoFilename:string;
    procedure Start(_OptOutputPath:string);
  end;

var
  Network: TNetwork;

implementation

{$R *.dfm}

const EditMessage='Please input YouTube address.';

var
  fsize:integer;
  showhttplog:boolean;
  WorkCaption:string;
  RequestCancel:boolean;

procedure TNetwork.IdHTTP1WorkBegin(Sender: TObject; AWorkMode: TWorkMode;
  const AWorkCountMax: Integer);
begin
  if showhttplog=False then exit;
  LogMemo.Lines.Add('Connect to '+WorkCaption+'.');
  fsize:=AWorkCountMax;
  if fsize<4096 then exit;
  LogMemo.Lines.Add('HTTP: Download. ('+inttostr(fsize div 1024)+'kbyte)');
  PrgBar.Position:=0;
  PrgBar.Max:=fsize;
end;

procedure TNetwork.IdHTTP1Work(Sender: TObject; AWorkMode: TWorkMode;
  const AWorkCount: Integer);
var
  fpos:integer;
begin
  IdAntiFreeze1.Process;
  if showhttplog=False then exit;
  if fsize<4096 then exit;
  fpos:=AWorkCount;
  PrgBar.Position:=fpos;
  StatusLbl.Caption:=format('Download. %d%% (%d/%dk)',[trunc(fpos/fsize*100),fpos div 1024,fsize div 1024]);
end;

procedure TNetwork.IdHTTP1WorkEnd(Sender: TObject; AWorkMode: TWorkMode);
begin
  if showhttplog=False then exit;
  if fsize<4096 then exit;
  Caption:='Downloaded.';
  PrgBar.Position:=0;
end;

// ----------------------------------------------------

procedure TNetwork.FormDisabled;
begin
  StartBtn.Enabled:=False;
//  CancelBtn.Enabled:=False;
  StatusLbl.Caption:='Standby...';
  RequestCancel:=False;
end;

procedure TNetwork.FormEnabled;
begin
  StartBtn.Enabled:=True;
  CancelBtn.Enabled:=True;
  StatusLbl.Caption:='Standby...';
  RequestCancel:=False;
end;

procedure TNetwork.Start(_OptOutputPath:string);
begin
  FormEnabled;
  URLEdt.Text:=EditMessage;

  LogMemo.Clear;

  LogMemo.Lines.Add('g̐ݒō掿̓ɂƁA쐬铮YɂȂ܂AGR[hԂȂ܂B');
  LogMemo.Lines.Add('');
  LogMemo.Lines.Add('When you specify the video of a high resolution by setting the left.');
  LogMemo.Lines.Add('The output DPG video becomes a little beautiful, and the encode time becomes long.');

  fsize:=0;
  showhttplog:=False;

  OptOutputPath:=_OptOutputPath;
  VideoFilename:='';
end;

// ----------------------------------------------------

procedure TNetwork.URLEdtClick(Sender: TObject);
begin
  if URLEdt.Text=EditMessage then URLEdt.Text:='';
end;

procedure TNetwork.URLEdtKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if URLEdt.Text=EditMessage then URLEdt.Text:='';
end;

procedure TNetwork.URLEdtMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if URLEdt.Text=EditMessage then URLEdt.Text:='';
end;

// ----------------------------------------------------

procedure TNetwork.StartBtnClick(Sender: TObject);
var
  htmlstr:string;
  whtmlstr:widestring;
  wfs:TFileStream;
  Title,Description,Keywords:string;
  VideoID,OneShotID:string;
  DownloadURL:string;
  flvdata:string;
  function GetMetaData(ID:string):string;
  var
    pos:integer;
  begin
    pos:=ansipos(ID,htmlstr);
    if pos=0 then begin
      ID:=ansilowercase(ID);
      pos:=ansipos(ID,htmlstr);
      if pos=0 then begin
        Result:='not found meta data.';
        exit;
      end;
    end;
    Result:=copy(htmlstr,pos+length(ID),length(htmlstr));
    pos:=ansipos('"',Result);
    Result:=copy(Result,1,pos-1);
  end;
  function IgnoreIlligalCharsOfFilename(fn:widestring):widestring;
  var
    idx:integer;
    wc:widechar;
  begin
    Result:='';
    for idx:=1 to length(fn) do begin
      wc:=fn[idx];
      if wc='\' then wc:=widechar(0);
      if wc='/' then wc:=widechar(0);
      if wc=':' then wc:=widechar(0);
      if wc='*' then wc:=widechar(0);
      if wc='?' then wc:=widechar(0);
      if wc='"' then wc:=widechar(0);
      if wc='<' then wc:=widechar(0);
      if wc='>' then wc:=widechar(0);
      if wc='|' then wc:=widechar(0);
      if wc<>widechar(0) then Result:=Result+wc;
    end;
  end;
  procedure ProcCancel;
  begin
    FormEnabled;
    Caption:='User canceled.';
    LogMemo.Lines.Add('User canceled.');
  end;
begin
  ModalResult:=mrNone;

  FormDisabled;

  LogMemo.Clear;

  fsize:=0;
  showhttplog:=False;

  StatusLbl.Caption:='Try connect YouTube server.';

  try
    htmlstr:=IdHTTP1.Get(URLEdt.Text);
    whtmlstr:=UTF8Decode(htmlstr);
    htmlstr:=whtmlstr;
    except else begin
      LogMemo.Lines.Add('Network error.');
      FormEnabled;
      exit;
    end;
  end;

  Title:=GetMetaData('<meta name="Title" content="');
  Description:=GetMetaData('<meta name="Description" content="');
  Keywords:=GetMetaData('<meta name="Keywords" content="');

  VideoID:=GetMetaData('"video_id": "');
  OneShotID:=GetMetaData('"t": "');

  DownloadURL:=format('http://youtube.com/get_video.php?video_id=%s&t=%s',[VideoID,OneShotID]);

  VideoFilename:=OptOutputPath+formatDateTime('yyyymmdd-hhnnss',now)+' '+IgnoreIlligalCharsOfFilename(Title);

  LogMemo.Lines.Add('--- YouTube information.');
  LogMemo.Lines.Add('Title: '+Title);
  LogMemo.Lines.Add('Description: '+Description);
  LogMemo.Lines.Add('Keywords: '+Keywords);
  LogMemo.Lines.Add('Video ID: '+VideoID);
  LogMemo.Lines.Add('OneShot ID: '+OneShotID);
  LogMemo.Lines.Add('Download URL: '+DownloadURL);

  flvdata:='';

  showhttplog:=True;

  if (flvdata='') and (fmt22Chk.Checked=True) then begin
    try
      WorkCaption:='fmt=22 1280x720 MP4';
      flvdata:=IdHTTP1.Get(DownloadURL+'&fmt=22');
      VideoFilename:=VideoFilename+'.mp4';
      except else begin
        if RequestCancel=True then begin
          ProcCancel;
          exit;
        end;
        flvdata:='';
        LogMemo.Lines.Add('Not found ['+WorkCaption+'] format data.');
      end;
    end;
  end;

  if (flvdata='') and (fmt18Chk.Checked=True) then begin
    try
      WorkCaption:='fmt=18 480x360 MP4';
      flvdata:=IdHTTP1.Get(DownloadURL+'&fmt=18');
      VideoFilename:=VideoFilename+'.mp4';
      except else begin
        if RequestCancel=True then begin
          ProcCancel;
          exit;
        end;
        flvdata:='';
        LogMemo.Lines.Add('Not found ['+WorkCaption+'] format data.');
      end;
    end;
  end;

  if (flvdata='') and (fmt6Chk.Checked=True) then begin
    try
      WorkCaption:='fmt=6 448x336 FLV';
      flvdata:=IdHTTP1.Get(DownloadURL+'&fmt=6');
      VideoFilename:=VideoFilename+'.flv';
      except else begin
        if RequestCancel=True then begin
          ProcCancel;
          exit;
        end;
        flvdata:='';
        LogMemo.Lines.Add('Not found ['+WorkCaption+'] format data.');
      end;
    end;
  end;

  if (flvdata='') and (fmt0Chk.Checked=True) then begin
    try
      WorkCaption:='default 320x240 FLV';
      flvdata:=IdHTTP1.Get(DownloadURL);
      VideoFilename:=VideoFilename+'.flv';
      except else begin
        if RequestCancel=True then begin
          ProcCancel;
          exit;
        end;
        flvdata:='';
        LogMemo.Lines.Add('Not found ['+WorkCaption+'] format data.');
      end;
    end;
  end;

  StatusLbl.Caption:='';

  showhttplog:=False;

  if flvdata='' then begin
    LogMemo.Lines.Add('Fatal error: Not found video file.');
    FormEnabled;
    exit;
  end;

  LogMemo.Lines.Add('Video filename: '+VideoFilename);

  wfs:=TFileStream.Create(VideoFilename,fmCreate);
  wfs.WriteBuffer(flvdata[1],length(flvdata));
  wfs.Free;

  LogMemo.Lines.Add('Download successed. Regist to main queue.');

  LogMemo.Lines.SaveToFile(changefileext(Application.ExeName,'')+'_YouTubeDownloader.log');

  FormEnabled;

  ModalResult:=mrOk;
end;

procedure TNetwork.CancelBtnClick(Sender: TObject);
begin
  if StartBtn.Enabled=True then begin
    ModalResult:=mrCancel;
    exit;
  end;

  CancelBtn.Enabled:=False;
  CancelBtn.Refresh;
  RequestCancel:=True;
  IdHTTP1.Disconnect;
end;

end.
