unit _dldi;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls,INIFiles;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

type
  TDLDIInfo_Header=packed record
    MagicNumber:dword;
    IdentifyingMagicString:array[0..8-1] of byte;
    VersionNumber:byte;
    DriverSize:byte;
    SectionsFixFlags:byte;
    Dummy:byte;
    TextIdentifier:array[0..48-1] of char;
    addrs:array[0..8-1] of dword;
    DeviceID:array[0..4-1] of char;
    CapFlags:dword;
    ptrs:array[0..6-1] of dword;
  end;

type
  TDLDIInfo=record
    Header:TDLDIInfo_Header;
    DeviceName,DeviceID:string;
    Version:string;
    FileExt:string;
    BootStrap:string;
    FixGameCode:string;
    FixDeviceName:string;
    Author:string;
    CanRead,CanWrite:boolean;
    Tested:boolean;
    Manufacturer:string;
    LastModified:string;
  end;

function GetDLDIInfo(DLDIFilename:string;var DLDIInfo:TDLDIInfo):boolean;

implementation

uses _dlditool;

const CRLF:string=char($0d)+char($0a);

const DLDI_Header_MagicNumber:dword=$BF8DA5ED;

const DLDI_Header_MaxDriverSize:byte=$0f;

const DLDI_Header_FEATURE_MEDIUM_CANREAD=$00000001;
const DLDI_Header_FEATURE_MEDIUM_CANWRITE=$00000002;

function GetDLDIInfo(DLDIFilename:string;var DLDIInfo:TDLDIInfo):boolean;
var
  dldifn,inifn:string;
  ini:TINIFile;
  rfs:TFileStream;
  s:string;
begin
  Result:=False;

  dldifn:=changefileext(DLDIFilename,'.dldi');
  inifn:=changefileext(DLDIFilename,'.ini');

  if FileExists(dldifn)=False then begin
    ShowMessage(dldifn+CRLF+'Not found file.');
    exit;
  end;
  if FileExists(inifn)=False then begin
    ShowMessage(inifn+CRLF+'Not found file.');
    exit;
  end;

  rfs:=TFileStream.Create(dldifn,fmOpenRead);
  rfs.ReadBuffer(DLDIInfo.Header,sizeof(TDLDIInfo_Header));
  rfs.Free;

  if DLDIInfo.Header.MagicNumber<>DLDI_Header_MagicNumber then begin
    ShowMessage(dldifn+CRLF+'Illigal MagicNumber');
    exit;
  end;
  if DLDIInfo.Header.VersionNumber=0 then begin
    ShowMessage(dldifn+CRLF+'Illigal VersionNumber');
    exit;
  end;
  if DLDI_Header_MaxDriverSize<DLDIInfo.Header.DriverSize then begin
    ShowMessage(dldifn+CRLF+'Overflow DriverSize');
    exit;
  end;

  DLDIInfo.DeviceName:=trim(DLDIInfo.Header.TextIdentifier);
  DLDIInfo.DeviceID:=trim(DLDIInfo.Header.DeviceID[0]+DLDIInfo.Header.DeviceID[1]+DLDIInfo.Header.DeviceID[2]+DLDIInfo.Header.DeviceID[3]);
  DLDIInfo.Version:=char(byte('0')+DLDIInfo.Header.VersionNumber);
  DLDIInfo.CanRead:=(DLDIInfo.Header.CapFlags and DLDI_Header_FEATURE_MEDIUM_CANREAD)<>0;
  DLDIInfo.CanWrite:=(DLDIInfo.Header.CapFlags and DLDI_Header_FEATURE_MEDIUM_CANWRITE)<>0;

  if DLDIInfo.DeviceName='' then begin
    ShowMessage(dldifn+CRLF+'Illigal DeviceName');
    exit;
  end;
  if DLDIInfo.DeviceID='' then begin
    ShowMessage(dldifn+CRLF+'Illigal DeviceID');
    exit;
  end;

  ini:=TINIFile.Create(inifn);

  DLDIInfo.FileExt:=ini.ReadString('DLDI','FileExt','');
  DLDIInfo.BootStrap:=ini.ReadString('DLDI','BootStrap','');
  DLDIInfo.FixGameCode:=ini.ReadString('DLDI','FixGameCode','');
  DLDIInfo.FixDeviceName:=ini.ReadString('DLDI','FixDeviceName','');
  DLDIInfo.Author:=ini.ReadString('DLDI','Author','');

  s:=ini.ReadString('DLDI','Tested','');
  if uppercase(s)='YES' then begin
    DLDIInfo.Tested:=True;
    end else begin
    DLDIInfo.Tested:=False;
  end;

  DLDIInfo.Manufacturer:=ini.ReadString('DLDI','Manufacturer','');
  DLDIInfo.LastModified:=ini.ReadString('DLDI','LastModified','');

  ini.Free;

  Result:=True;
end;


end.


