unit G721Decorder_MainWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, Buttons, ExtCtrls;

type
  TMain = class(TForm)
    PrgBar: TProgressBar;
    BitBtn1: TBitBtn;
    StartupTimer: TTimer;
    OpenDlg: TOpenDialog;
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure StartupTimerTimer(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Main: TMain;

implementation

{$R *.dfm}

uses _g721lib;

var
  HeaderSize,SrcFreq,SrcChs,BlockSize,BlocksCount:integer;

type
  TWaveHeader=record
    IDTag_RIFF:dword;
    TotalFileSize8:dword;
    IDTag_WAVE:dword;
    IDTag_fmtZ:dword;
    FormatSize16:dword;
    wFormatTag:word;
    nChannels:word;
    nSamplesPerSec:dword;
    nAvgBytesPerSec:dword;
    nBlockAlign:word;
    wBitsPerSample:word;
    IDTag_data:dword;
    DataSize126:dword;
  end;

procedure WriteWaveHeader(wfs:TFileStream;freq,chs:integer);
var
  FileSize:integer;
  wh:TWaveHeader;
  bps:integer;
  function IDTag(ID:string):dword;
  begin
    Result:=dword(ID[1]) shl 0;
    Result:=Result or (dword(ID[2]) shl 8);
    Result:=Result or (dword(ID[3]) shl 16);
    Result:=Result or (dword(ID[4]) shl 24);
  end;
begin
  FileSize:=wfs.Size;
  if FileSize=0 then FileSize:=126;

  bps:=16;

  wh.IDTag_RIFF:=IDTag('RIFF');
  wh.TotalFileSize8:=FileSize-8;
  wh.IDTag_WAVE:=IDTag('WAVE');
  wh.IDTag_fmtZ:=IDTag('fmt ');
  wh.FormatSize16:=16;
  wh.wFormatTag:=1;
  wh.nChannels:=chs;
  wh.nSamplesPerSec:=freq;
  wh.nAvgBytesPerSec:=freq*(bps div 8);
  wh.nBlockAlign:=bps div 8;
  wh.wBitsPerSample:=bps;
  wh.IDTag_data:=IDTag('data');
  wh.DataSize126:=FileSize-126;

  wfs.Position:=0;
  wfs.WriteBuffer(wh,sizeof(TWaveHeader));
end;

function ConvertHeaderG721toWave(rfs,wfs:TFileStream):boolean;
var
  buf:array[0..12-1] of byte;
  chk:boolean;
  bufpos:integer;
  function Readu8:byte;
  begin
    Result:=buf[bufpos];
    inc(bufpos);
  end;
  function Readu16:word;
  begin
    Result:=Readu8;
    Result:=Result or (Readu8 shl 8);
  end;
  function ReadID:string;
  begin
    Result:=char(Readu8);
    Result:=Result+char(Readu8);
    Result:=Result+char(Readu8);
    Result:=Result+char(Readu8);
  end;
begin
  HeaderSize:=12;
  rfs.ReadBuffer(buf[0],HeaderSize);
  bufpos:=0;

  chk:=True;
  if ReadID<>'VREC' then chk:=False;
  if ReadID<>'G721' then chk:=False;

  if chk=False then begin
    Result:=False;
    exit;
  end;

  SrcFreq:=Readu16;
  SrcChs:=Readu16;

  WriteWaveHeader(wfs,SrcFreq,SrcChs);

  BlockSize:=56+(SrcFreq div 2);
  BlocksCount:=(rfs.Size-HeaderSize+(BlockSize-1)) div BlockSize;

  Result:=True;
end;

var
  ReqCancel:boolean;

procedure TMain.FormCreate(Sender: TObject);
begin
  ReqCancel:=False;
  StartupTimer.Enabled:=True;
end;

procedure TMain.BitBtn1Click(Sender: TObject);
begin
  ReqCancel:=True;
end;

procedure TMain.StartupTimerTimer(Sender: TObject);
var
  srcfn,dstfn:string;
  rfs,wfs:TFileStream;
  bufidx:integer;
  srcbuf:array of byte;
  srcbufsize:integer;
begin
  StartupTimer.Enabled:=False;

  srcfn:='';
  
  if ParamCount=1 then begin
    srcfn:=ParamStr(1);
    end else begin
    if OpenDlg.Execute=False then begin
      Application.Terminate;
      exit;
    end;
    srcfn:=OpenDlg.FileName;
  end;

  if FileExists(srcfn)=False then begin
    ShowMessage('File not found. ['+srcfn+']');
    Application.Terminate;
    exit;
  end;

  dstfn:=ChangeFileExt(srcfn,'.wav');

  rfs:=TFileStream.Create(srcfn,fmOpenRead);
  wfs:=TFileStream.Create(dstfn,fmCreate);

  if ConvertHeaderG721toWave(rfs,wfs)=False then begin
    rfs.Free;
    wfs.Free;
    DeleteFile(dstfn);
    ShowMessage('Illigal G.721 file.');
    Application.Terminate;
    exit;
  end;

  PrgBar.Max:=BlocksCount;
  PrgBar.Position:=0;

  for bufidx:=0 to BlocksCount-1 do begin
    if (bufidx mod 60)=0 then begin
      PrgBar.Position:=bufidx;
      Main.Caption:=format('Decoding... %d/%dmins.',[bufidx div 60,BlocksCount div 60]);
      Application.ProcessMessages;
    end;
    
    srcbufsize:=rfs.Size-rfs.Position;
    if BlockSize<srcbufsize then srcbufsize:=BlockSize;
    setlength(srcbuf,srcbufsize);
    rfs.ReadBuffer(srcbuf[0],srcbufsize);

    G721Decode(SrcFreq,srcbuf,srcbufsize);
    if dstbufsize=0 then break;
    wfs.WriteBuffer(dstbuf[0],dstbufsize*2);

    if ReqCancel=True then break;
  end;

  PrgBar.Position:=0;

  WriteWaveHeader(wfs,SrcFreq,SrcChs);

  rfs.Free;
  wfs.Free;

  if ReqCancel=True then DeleteFile(dstfn);

  Application.Terminate;
end;

procedure TMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  ReqCancel:=True;
  CanClose:=False;
end;

end.
