unit _customjpeg;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls,Math;

var
  CustomJpegData:array of byte;
  CustomJpegDataCount:integer;

procedure customjpeg_SetQuality(q:integer);
function customjpeg_GetQuantizeData(idx:integer):SmallInt;
procedure customjpeg_CompressYUV111(var bm:TBitmap;Preview:boolean);
procedure customjpeg_CompressYUV411(var bm:TBitmap;Preview:boolean);
procedure customjpeg_WriteToFile(fn:string);

implementation

uses zlib, _PicTools,_dctlib;

const DCTSIZE=8; // The basic DCT block is 8x8 samples
const DCTSIZE2=DCTSIZE*DCTSIZE; // DCTSIZE squared; # of elements in a block

const QuantizeTable_Master:array[0..DCTSIZE2-1] of SmallInt=(
0,11,10,16,24,40,51,61,
12,12,14,19,26,58,60,55,
14,13,16,24,40,57,69,56,
14,17,22,29,51,87,80,62,
18,22,37,56,68,109,103,77,
24,35,55,64,81,104,113,92,
49,64,78,87,103,121,120,101,
72,92,95,98,112,100,103,99);

var
  QuantizeTable:array[0..DCTSIZE2-1] of SmallInt;

var
  DataDCs:array of SmallInt;
  DataACs:array of Shortint;
  DataDCCount,DataACCount:integer;

const jpeg_zigzag_order:array[0..DCTSIZE2-1] of dword=(
   0,  1,  5,  6, 14, 15, 27, 28,
   2,  4,  7, 13, 16, 26, 29, 42,
   3,  8, 12, 17, 25, 30, 41, 43,
   9, 11, 18, 24, 31, 40, 44, 53,
  10, 19, 23, 32, 39, 45, 52, 54,
  20, 22, 33, 38, 46, 51, 55, 60,
  21, 34, 37, 47, 50, 56, 59, 61,
  35, 36, 48, 49, 57, 58, 62, 63);

procedure DCT(pdata:PInteger;Preview:boolean);                          
var
  pdatatmp:Pinteger;
  tmp:array[0..DCTSIZE2-1] of integer;
  idx:integer;
  datacnt:integer;
  ztmp:array[0..(DCTSIZE2-1)-1] of Shortint;
  zo:integer;
begin
  pdatatmp:=pdata;
  for idx:=0 to DCTSIZE2-1 do begin
    tmp[idx]:=pdatatmp^;
    inc(pdatatmp,1);
  end;

  FDCT(addr(tmp[0]));

  for idx:=0 to DCTSIZE2-1 do begin
    tmp[idx]:=tmp[idx] div 2;
    tmp[idx]:=tmp[idx] div QuantizeTable[idx];
  end;

//  if (tmp[0]<-16384) or (16383<tmp[0]) then ShowMessage(inttostr(tmp[0]));
  tmp[0]:=min(max(tmp[0],-16384),16383);
  DataDCs[DataDCCount]:=tmp[0];
  inc(DataDCCount);

  for idx:=1 to DCTSIZE2-1 do begin
    zo:=jpeg_zigzag_order[idx];
//    if (tmp[idx]<-128) or (127<tmp[idx]) then ShowMessage(inttostr(tmp[idx]));
    ztmp[zo-1]:=MIN(MAX(tmp[idx],-128),127);
  end;

  datacnt:=0;
  for idx:=0 to (DCTSIZE2-1)-1 do begin
    if ztmp[idx]<>0 then datacnt:=idx+1;
  end;
  DataACs[DataACCount]:=datacnt;
  inc(DataACCount);
  for idx:=0 to datacnt-1 do begin
    DataACs[DataACCount]:=ztmp[idx];
    inc(DataACCount);
  end;

  if Preview=False then exit;

  for idx:=1 to DCTSIZE2-1 do begin
    zo:=jpeg_zigzag_order[idx];
    tmp[idx]:=ztmp[zo-1];
  end;

  for idx:=0 to DCTSIZE2-1 do begin
    tmp[idx]:=tmp[idx]*QuantizeTable[idx];
    tmp[idx]:=tmp[idx]*2;
  end;

  IDCT(addr(tmp[0]));

  pdatatmp:=pdata;
  for idx:=0 to DCTSIZE2-1 do begin
    pdatatmp^:=tmp[idx];
    inc(pdatatmp,1);
  end;
end;

procedure PackedCompressYUV111(BlockX,BlockY:integer;var bm:TBitmap;Preview:boolean);
var
  pbuf:PByteArray;
  ofsx,ofsy,ofs,x,y,idx:integer;
  r,g,b:integer;
  ty,tcb,tcr:integer;
  _y,_cb,_cr:array[0..DCTSIZE2-1] of integer;
  gr,gg,gb:integer;
begin
  ofsx:=BlockX*DCTSIZE;
  ofsy:=BlockY*DCTSIZE;

  for y:=0 to DCTSIZE-1 do begin
    pbuf:=bm.ScanLine[ofsy+y];
    for x:=0 to DCTSIZE-1 do begin
      ofs:=(ofsx+x)*3;
      b:=pbuf[ofs+0] shr 1;
      g:=pbuf[ofs+1] shr 1;
      r:=pbuf[ofs+2] shr 1;
      idx:=x+(y*DCTSIZE);
      ty :=trunc(( 0.2990*r)+( 0.5870*g)+( 0.1140*b)+0.5+64)+2;
      tcb:=trunc((-0.1684*r)+(-0.3316*g)+( 0.5000*b)+0.5+64);
      tcr:=trunc(( 0.5000*r)+(-0.4187*g)+(-0.0813*b)+0.5+64);
      if ty<8 then ty:=8;
      if tcb<0 then tcb:=0;
      if tcr<0 then tcr:=0;
      _y[idx]:=ty;
      _cb[idx]:=tcb;
      _cr[idx]:=tcr;
    end;
  end;

  DCT(addr(_y[0]),Preview);
  DCT(addr(_cb[0]),Preview);
  DCT(addr(_cr[0]),Preview);

  if Preview=False then exit;

  gr:=0;gg:=0;gb:=0;
  
  for y:=0 to DCTSIZE-1 do begin
    pbuf:=bm.ScanLine[ofsy+y];
    for x:=0 to DCTSIZE-1 do begin
      idx:=x+(y*DCTSIZE);
      ty:=_y[idx]-64;
      tcb:=_cb[idx]-64;
      tcr:=_cr[idx]-64;
      r:=trunc(ty              +( 1.4020*tcr)) shl 1;
      g:=trunc(ty+(-0.3441*tcb)+(-0.7139*tcr)) shl 1;
      b:=trunc(ty+( 1.7718*tcb)+(-0.0012*tcr)) shl 1;
      inc(r,gr); gr:=r and $7; r:=r and not $7;
      inc(g,gg); gg:=g and $7; g:=g and not $7;
      inc(b,gb); gb:=b and $7; b:=b and not $7;
      if (dword(r) and not $ff)<>0 then r:=MIN(MAX(r,0),$ff);
      if (dword(g) and not $ff)<>0 then g:=MIN(MAX(g,0),$ff);
      if (dword(b) and not $ff)<>0 then b:=MIN(MAX(b,0),$ff);
      ofs:=(ofsx+x)*3;
      pbuf[ofs+0]:=b;
      pbuf[ofs+1]:=g;
      pbuf[ofs+2]:=r;
    end;
  end;
end;

const YUV_yofs=128;

procedure PackedCompressYUV411(BlockX,BlockY:integer;var bm:TBitmap;Preview:boolean);
var
  pbuf:PByteArray;
  pbuf0,pbuf1:PByteArray;
  ofsx,ofsy,ofs,x,y,idx:integer;
  r,g,b:integer;
  ty,tcb,tcr:integer;
  _y0,_y1,_y2,_y3,_cb,_cr:array[0..DCTSIZE2-1] of integer;
  gr,gg,gb:integer;
begin
  ofsx:=BlockX*DCTSIZE*2;
  ofsy:=BlockY*DCTSIZE*2;

  for y:=0 to DCTSIZE-1 do begin
    pbuf:=bm.ScanLine[ofsy+(DCTSIZE*0)+y];
    for x:=0 to DCTSIZE-1 do begin
      ofs:=(ofsx+(DCTSIZE*0)+x)*3;
      b:=pbuf[ofs+0];
      g:=pbuf[ofs+1];
      r:=pbuf[ofs+2];
      idx:=x+(y*DCTSIZE);
      _y0[idx]:=trunc(( 0.2990*r)+( 0.5870*g)+( 0.1140*b)+0.5-YUV_yofs)+2;
    end;
  end;

  for y:=0 to DCTSIZE-1 do begin
    pbuf:=bm.ScanLine[ofsy+(DCTSIZE*0)+y];
    for x:=0 to DCTSIZE-1 do begin
      ofs:=(ofsx+(DCTSIZE*1)+x)*3;
      b:=pbuf[ofs+0];
      g:=pbuf[ofs+1];
      r:=pbuf[ofs+2];
      idx:=x+(y*DCTSIZE);
      _y1[idx]:=trunc(( 0.2990*r)+( 0.5870*g)+( 0.1140*b)+0.5-YUV_yofs)+2;
    end;
  end;

  for y:=0 to DCTSIZE-1 do begin
    pbuf:=bm.ScanLine[ofsy+(DCTSIZE*1)+y];
    for x:=0 to DCTSIZE-1 do begin
      ofs:=(ofsx+(DCTSIZE*0)+x)*3;
      b:=pbuf[ofs+0];
      g:=pbuf[ofs+1];
      r:=pbuf[ofs+2];
      idx:=x+(y*DCTSIZE);
      _y2[idx]:=trunc(( 0.2990*r)+( 0.5870*g)+( 0.1140*b)+0.5-YUV_yofs)+2;
    end;
  end;

  for y:=0 to DCTSIZE-1 do begin
    pbuf:=bm.ScanLine[ofsy+(DCTSIZE*1)+y];
    for x:=0 to DCTSIZE-1 do begin
      ofs:=(ofsx+(DCTSIZE*1)+x)*3;
      b:=pbuf[ofs+0];
      g:=pbuf[ofs+1];
      r:=pbuf[ofs+2];
      idx:=x+(y*DCTSIZE);
      _y3[idx]:=trunc(( 0.2990*r)+( 0.5870*g)+( 0.1140*b)+0.5-YUV_yofs)+2;
    end;
  end;

  for y:=0 to DCTSIZE-1 do begin
    pbuf0:=bm.ScanLine[ofsy+(y*2)+0];
    pbuf1:=bm.ScanLine[ofsy+(y*2)+1];
    for x:=0 to DCTSIZE-1 do begin
      ofs:=(ofsx+(x*2))*3;
      b:=((integer(pbuf0[ofs+0])+integer(pbuf0[ofs+3])+integer(pbuf1[ofs+0])+integer(pbuf1[ofs+3])) div 4);
      g:=((integer(pbuf0[ofs+1])+integer(pbuf0[ofs+4])+integer(pbuf1[ofs+1])+integer(pbuf1[ofs+4])) div 4);
      r:=((integer(pbuf0[ofs+2])+integer(pbuf0[ofs+5])+integer(pbuf1[ofs+2])+integer(pbuf1[ofs+5])) div 4);
      idx:=x+(y*DCTSIZE);
      _cb[idx]:=trunc((-0.1684*r)+(-0.3316*g)+( 0.5000*b)+0.5);
      _cr[idx]:=trunc(( 0.5000*r)+(-0.4187*g)+(-0.0813*b)+0.5);
    end;
  end;

  DCT(addr(_y0[0]),Preview);
  DCT(addr(_y1[0]),Preview);
  DCT(addr(_y2[0]),Preview);
  DCT(addr(_y3[0]),Preview);
  DCT(addr(_cb[0]),Preview);
  DCT(addr(_cr[0]),Preview);

  if Preview=False then exit;

  gr:=0;gg:=0;gb:=0;

  for y:=0 to DCTSIZE*2-1 do begin
    pbuf:=bm.ScanLine[ofsy+y];
    for x:=0 to DCTSIZE*2-1 do begin
      idx:=(x mod DCTSIZE)+((y mod DCTSIZE)*DCTSIZE);
      ty:=0;
      if (x<DCTSIZE) and (y<DCTSIZE) then ty:=_y0[idx]+YUV_yofs;
      if (DCTSIZE<=x) and (y<DCTSIZE) then ty:=_y1[idx]+YUV_yofs;
      if (x<DCTSIZE) and (DCTSIZE<=y) then ty:=_y2[idx]+YUV_yofs;
      if (DCTSIZE<=x) and (DCTSIZE<=y) then ty:=_y3[idx]+YUV_yofs;
      idx:=(x div 2)+((y div 2)*DCTSIZE);
      tcb:=_cb[idx];
      tcr:=_cr[idx];
      r:=trunc(ty              +( 1.4020*tcr));
      g:=trunc(ty+(-0.3441*tcb)+(-0.7139*tcr));
      b:=trunc(ty+( 1.7718*tcb)              );
      r:=MAX(r,0);
      g:=MAX(g,0);
      b:=MAX(b,0);
      inc(r,gr); gr:=r and $7; r:=r shr 3;
      inc(g,gg); gg:=g and $7; g:=g shr 3;
      inc(b,gb); gb:=b and $7; b:=b shr 3;
      r:=MIN(r,$1f);
      g:=MIN(g,$1f);
      b:=MIN(b,$1f);
      ofs:=(ofsx+x)*3;
      pbuf[ofs+0]:=b shl 3;
      pbuf[ofs+1]:=g shl 3;
      pbuf[ofs+2]:=r shl 3;
    end;
  end;
end;

procedure customjpeg_SetQuality(q:integer);
var
  idx:integer;
begin
  if q=0 then q:=1;

  QuantizeTable[0]:=1;
  for idx:=1 to DCTSIZE2-1 do begin
    QuantizeTable[idx]:=(QuantizeTable_Master[idx]*(100 div 1)) div q;
    QuantizeTable[idx]:=QuantizeTable[idx]*2;
    if QuantizeTable[idx]=0 then QuantizeTable[idx]:=1;
  end;
end;

function customjpeg_GetQuantizeData(idx:integer):SmallInt;
begin
  Result:=QuantizeTable[idx];
end;

procedure customjpeg_WriteToFile(fn:string);
var
  wfs:TFileStream;
  idx:integer;
begin
  wfs:=TFileStream.Create(fn,fmCreate);
  for idx:=0 to DCTSIZE2-1 do begin
    wfs.WriteBuffer(QuantizeTable[idx],2);
  end;
  wfs.Free;
end;

procedure customjpeg_CompressYUV111(var bm:TBitmap;Preview:boolean);
var
  x,y,w,h:integer;
  procedure InitCustomJpegData;
  begin
    DataDCCount:=0;
    setlength(DataDCs,((w div (DCTSIZE*1))*(h div (DCTSIZE*1)))*3);
    DataACCount:=0;
    setlength(DataACs,((w div (DCTSIZE*1))*(h div (DCTSIZE*1)))*3*(DCTSIZE2+1));
  end;
  procedure PackedCustomJpegData;
  begin
    setlength(DataDCs,DataDCCount);
    setlength(DataACs,DataACCount);

    CustomJpegDataCount:=(DataDCCount*2)+DataACCount;
    setlength(CustomJpegData,CustomJpegDataCount);
    if DataDCCount<>0 then MoveMemory(addr(CustomJpegData[0]),addr(DataDCs[0]),DataDCCount*2);
    if DataACCount<>0 then MoveMemory(addr(CustomJpegData[DataDCCount*2]),addr(DataACs[0]),DataACCount);
  end;
begin
  if (bm.Width<>(DCTSIZE*8)) or (bm.Height<>(DCTSIZE*8)) then begin
    ShowMessage('MCU Size error.');
    exit;
  end;

  w:=bm.Width;
  h:=bm.Height;

  InitCustomJpegData;

  for y:=0 to (h div (DCTSIZE*1))-1 do begin
    for x:=0 to (w div (DCTSIZE*1))-1 do begin
      PackedCompressYUV111(x,y,bm,Preview);
    end;
  end;

  PackedCustomJpegData;
end;

const MCUSIZE=16;

procedure customjpeg_CompressYUV411(var bm:TBitmap;Preview:boolean);
var
  x,y,w,h:integer;
  procedure InitCustomJpegData;
  begin
    DataDCCount:=0;
    setlength(DataDCs,((w div MCUSIZE)*(h div MCUSIZE))*6);
    DataACCount:=0;
    setlength(DataACs,((w div MCUSIZE)*(h div MCUSIZE))*6*(1+DCTSIZE2-1));
  end;
  procedure PackedCustomJpegData;
  begin
    setlength(DataDCs,DataDCCount);
    setlength(DataACs,DataACCount);

    CustomJpegDataCount:=(DataDCCount*2)+DataACCount;
    setlength(CustomJpegData,CustomJpegDataCount);
    if DataDCCount<>0 then MoveMemory(addr(CustomJpegData[0]),addr(DataDCs[0]),DataDCCount*2);
    if DataACCount<>0 then MoveMemory(addr(CustomJpegData[DataDCCount*2]),addr(DataACs[0]),DataACCount);
  end;
begin
  if (bm.Width<>(DCTSIZE*8)) or (bm.Height<>(DCTSIZE*8)) then begin
    ShowMessage('MCU Size error.');
    exit;
  end;

  w:=bm.Width;
  h:=bm.Height;

  InitCustomJpegData;

  for y:=0 to (h div MCUSIZE)-1 do begin
    for x:=0 to (w div MCUSIZE)-1 do begin
      PackedCompressYUV411(x,y,bm,Preview);
    end;
  end;

  PackedCustomJpegData;
end;

end.
