// modified test code provided by EZTeam

#include <nds.h>
#include <malloc.h>
#include "dscard.h"
#include "console.h"
#include "gba_nds_fat.h"

#define LEN 0x8000//1mbit NOR page size

#ifndef NULL
#define NULL __null
#endif

void setShake(int Shake)
{
    switch(Shake)
    {
        case 1:
            SetShake(0xF0);
            break;
        case 2:
            SetShake(0xF1);
            break;
        case 3:
            SetShake(0xF2);
            break;
    }
    *(vu16 *)0x8000000 = 0x00;//witre any value for vibration.
    *(vu16 *)0x8000000 = 0x02;
    return;
}
//---------------------------------------------------------------------------------
int main(void) {
//---------------------------------------------------------------------------------
    videoSetMode(MODE_FB1); //not using the main screen
    videoSetModeSub(MODE_0_2D | DISPLAY_BG0_ACTIVE); //sub bg 0 will be used to print text
    vramSetBankC(VRAM_C_SUB_BG);

    SUB_BG0_CR = BG_MAP_BASE(31);
    BG_PALETTE_SUB[255] = RGB15(31,31,31); //by default font will be rendered with color 255
    consoleInitDefault((u16*)SCREEN_BASE_BLOCK_SUB(31), (u16*)CHAR_BASE_BLOCK_SUB(0), 16);

    u8 *pSrc;
    u8 *pDes;
    u32 loop;
    u16 Value[]= {0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x10,
              0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,
              0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,
              0x40,0x41,0x42,0x43,0x45,0x46,0x47,0x48,
             };
    u16 Value2[]={0x99,0x89,0x97,0x96,0x95,0x94,0x93,0x92,
              0x89,0x79,0x69,0x59,0x49,0x39,0x29,0x19,
              0x43,0x35,0x84,0x99,0x22,0x23,0x77,0x88,
              0x87,0x81,0x86,0x76,0x65,0x54,0x43,0x21    
             };
    int i;
    FAT_FILE *h;  
    WAIT_CR &= ~0x8080;
    OpenNorWrite();
    uint32 id = ReadNorFlashID();
    CloseNorWrite();
    consolePrintf("Nor Flash  id=0x%x.\n",id);
    if(id!=0x227E2218)
    {
        consolePrintf("Nor Flash  err\n",id);
        while(1);
    }

    pSrc = (u8*)malloc(LEN);
    if(pSrc==NULL)
    {
        consolePrintf("can not alloc pSrc mem\n");
    }
    pDes= (u8*)malloc(LEN);
    if(pDes==NULL)
    {
        consolePrintf("can not alloc pDes mem\n");
    }

    consolePrintf("********start checks********\n\n");
    //flash test
    consolePrintf("--1--start NOR flash check.\n");    
    WAIT_CR &= ~0x8080;
    OpenNorWrite();
    SetSerialMode();
    for(u32 kk=0;kk<0x40000;kk+=0x40000)
    {
        consolePrintf("Erasing %x(%x)\n",kk,0x2000000);
        Block_Erase(kk);
    }
    //read check
    chip_reset();
    ReadNorFlash(pSrc,0,0x8000);
    for(loop=0;loop<0x8000;loop++)
    {
        if(pSrc[loop] !=0xFF)
        {
            consolePrintf("2--Erase Err add=%x,Data]=%x",loop,pSrc[loop]);
            while(1);
        }
    }
    CloseNorWrite();

    Enable_Arm9DS();
    FAT_InitFiles();
    FAT_chdir("/"); 

    h=FAT_fopen("/0001.gba","r");
    if(h==NULL)
        consolePrintf("can not open 0001.gba file\n");
    else
    {
        consolePrintf("open file 0001.gba OK\n");
        for(u32 kk=0;kk<0x40000;kk+=LEN)
        {
            FAT_fread(pSrc,LEN,1,h);
            WAIT_CR &= ~0x8080;
            //    Enable_Arm7DS();
            OpenNorWrite();
            SetSerialMode();
            WriteNorFlash(kk,pSrc,LEN);
            ReadNorFlash(pDes,kk,0x8000);
            for(loop=0;loop<LEN;loop++)
            {
                if(pSrc[loop]!=pDes[loop])
                {
                    consolePrintf("write Err:Add=%x,S=%x,D=%x",loop,pSrc[loop],pDes[loop]);
                    while(1);
                }
            }
            consolePrintf("2--Des--%02x %02x %02x %02x\n",pDes[0],pDes[1],pDes[2],pDes[3]);
            CloseNorWrite();
            Enable_Arm9DS();
        }
        FAT_fclose(h);
    }
    FAT_FreeFiles();
    consolePrintf("--1--NOR flash check done.\n\n");        

    consolePrintf("--2--start SRAM check.\n");
    Enable_Arm9DS();
    //SetARM9_REG_WaitCR();
    FAT_InitFiles();
    FAT_chdir("/");
    h=FAT_fopen("/0001.gba","r");        
    if(h==NULL)
          consolePrintf("can not open 0001.gba file\n");
    else
    {
         //consolePrintf("open file 0001.gba OK\n");
        for(u32 kk=0;kk<0x80000;kk+=LEN)
        {
            FAT_fread(pSrc,LEN,1,h);
            //consolePrintf("---%x %x %x %x\n",pSrc[0],pSrc[1],pSrc[2],pSrc[3]);
            //write nor flash
            WAIT_CR &= ~0x8080;
            //    Enable_Arm7DS();
            OpenNorWrite();
            SetRampage(kk/0x1000);
            WriteSram(0xA000000,pSrc,LEN);
            ReadSram(0xA000000,pDes,LEN);
            for(loop=0;loop<LEN;loop++)
            {
                if(pSrc[loop]!=pDes[loop])
                {
                    consolePrintf("write Err:Add=%x,S=%x,D=%x",loop,pSrc[loop],pDes[loop]);
                    while(1);
                }
                CloseNorWrite();
                Enable_Arm9DS();
            }
            Enable_Arm9DS();
            //consolePrintf("progress %x(%x)\n",kk,0x80000);
        }
        FAT_fclose(h);
    }
    FAT_FreeFiles();
    consolePrintf("--2--SRAM check done.\n\n");    

    //2--begin psram check
    u16* pPSram=(u16*)_Ez5PsRAM;
    consolePrintf("--3--start PSRAM check.\n");

    WAIT_CR &= ~0x8080;
    //    Enable_Arm7DS();
    CloseNorWrite();
    SetRompage(384);
    OpenNorWrite();

    for(loop=0;loop<0x10000;loop++)
    {
        pPSram[loop] = loop ;
    }

    for(loop=0;loop<0x10000;loop++)
    {
        if( pPSram[loop] !=loop)
        {
            consolePrintf("--2 PSRAM data line check fail\n");    
            consolePrintf("--2 add=%x,Src=%x,Des=%x\n",loop,loop,pPSram[loop]);            
            while(1);
        }
    }

    pPSram[0] = 0x5A;

    for(i=0;i<22;i++)
    {
        pPSram[1<<i] = Value[i];        
    }

    for(i=0;i<22;i++)
    {
        if(pPSram[1<<i] != Value[i])
        {
            consolePrintf("--2 add=%x,Src=%x,Des=%x\n",1<<i,Value[i],pPSram[1<<i]);
            while(1);
        }
    }

    for(i=0;i<22;i++)
    {
        pPSram[ (~(1<<i))&0x7FFFFF] = Value2[i];        
    }

    for(i=0;i<22;i++)
    {
        if(pPSram[ (~(1<<i))&0x7FFFFF] != Value2[i])
        {
            consolePrintf("--2 i=%d,add=%x,Src=%x,Des=%x\n",i,~(1<<i)&0x7FFFFF,Value2[i],pPSram[(~(1<<i))&0x7FFFFF]);
            while(1);
        }
    }
    consolePrintf("--3--PSRAM check done.\n\n");    
    CloseNorWrite();
    if(pSrc)
    {
        free(pSrc);
        pSrc=NULL;
    }
    if(pDes)
    {
        free(pDes);
        pDes=NULL;

    }
    consolePrintf("***Finished OK***\n");
    consolePrintf("Rumble enabled\n");

    int rum = 1;
    setShake(rum);
    uint16 keys, keysP;
    scanKeys();
    keysP = keysHeld();
    while(1)
    {
        scanKeys();
        keys = keysHeld();
        if(keys & KEY_R)
        {
            rum = rum + 1;
            if (rum == 4) rum = 1;
            setShake(rum);
        }
        else if (keys & KEY_L)
        {
            rum = rum + 1;
            if (rum == 4) rum = 1;
            setShake(rum);
        }
        else if (keysP != keys)
        {
            *(vu16 *)0x8000000 = 0x00;//witre any value for vibration.
            *(vu16 *)0x8000000 = 0x02;
        }
    }
    return 0;
}
