/*
 * Decompiled with CFR 0.152.
 */
package dk.wkjeldsen.func;

import dk.wkjeldsen.func.KeyBinder;
import dk.wkjeldsen.func.Server;
import dk.wkjeldsen.func.ServerLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;

public class TCPClientHandler
implements Runnable {
    private BufferedReader input;
    private Socket clntSock;

    public TCPClientHandler(Socket socket) {
        this.clntSock = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.input = new BufferedReader(new InputStreamReader(this.clntSock.getInputStream()));
            this.clntSock.setSoTimeout(12000);
            ServerLogger.getInstance().addLogMessage("Client " + this.clntSock.getRemoteSocketAddress().toString() + " connected (TCP).");
            StringBuffer command = new StringBuffer();
            char lastRead = '\u0000';
            int i = 0;
            while (Server.getInstance().isActive() && lastRead != '\uffff') {
                lastRead = (char)this.input.read();
                if (lastRead != '\uffffffff' && lastRead != '\u0000') {
                    command.append(lastRead);
                    ++i;
                }
                if (i != 9) continue;
                KeyBinder.getInstance().handleCommand(command.toString());
                ServerLogger.getInstance().addLogMessage("Received command (TCP): " + command.toString());
                command = new StringBuffer();
                i = 0;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                this.clntSock.close();
                ServerLogger.getInstance().addLogMessage("Client " + this.clntSock.getRemoteSocketAddress().toString() + " disconnected (TCP).");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

