/*
 * Decompiled with CFR 0.152.
 */
package dk.wkjeldsen.func;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;

public class ServerLogger {
    private static ServerLogger instance;
    private ArrayList<String> log;
    private Queue<String> lastLogs = new LinkedList<String>();

    private ServerLogger() {
        this.log = new ArrayList();
    }

    public static ServerLogger getInstance() {
        if (instance == null) {
            instance = new ServerLogger();
        }
        return instance;
    }

    public void addLogMessage(String message) {
        this.log.add(" " + message + "\n");
        this.lastLogs.add(" " + message + "\n");
        System.out.println("Message added to log.\n");
    }

    public String getLastLogMessage() {
        if (!this.lastLogs.isEmpty()) {
            return this.lastLogs.poll();
        }
        return "";
    }

    public String getLogMessages() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.log.size(); ++i) {
            result.append(this.log.get(i));
        }
        return result.toString();
    }

    public void clearLogMessages() {
        this.log.clear();
    }

    public void clearLastLogMessages() {
        this.lastLogs.clear();
    }
}

