/*
 * Decompiled with CFR 0.152.
 */
package dk.wkjeldsen.func;

import dk.wkjeldsen.func.ServerLogger;
import dk.wkjeldsen.func.TCPClientHandler;
import dk.wkjeldsen.func.UDPClientHandler;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;

public class Server
implements Runnable {
    public final String VERSION = "0.6";
    private static Server instance;
    private Thread serverJob;
    private int port;
    private boolean active = false;
    private ServerSocket TCPConn;
    private boolean activity;

    public static Server getInstance() {
        if (instance == null) {
            instance = new Server();
        }
        return instance;
    }

    private Server() {
    }

    public void start(int port) {
        this.port = port;
        if (this.active) {
            this.stop();
        }
        this.setActive(true);
        this.serverJob = new Thread(this);
        this.serverJob.start();
        ServerLogger.getInstance().addLogMessage("Server started.");
        ServerLogger.getInstance().addLogMessage("Listening for new connections on port: " + port);
    }

    public void stop() {
        this.setActive(false);
        ServerLogger.getInstance().addLogMessage("Server stopped.");
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void run() {
        ServerSocket servSockTCP = null;
        DatagramSocket servSockUDP = null;
        while (this.isActive()) {
            try {
                servSockTCP = new ServerSocket(this.port);
                servSockUDP = new DatagramSocket(this.port);
                servSockTCP.setSoTimeout(5000);
                Thread tcpClnt = new Thread(new TCPClientHandler(servSockTCP.accept()));
                Thread udpClnt = new Thread(new UDPClientHandler(servSockUDP));
                tcpClnt.start();
                udpClnt.start();
                tcpClnt.join();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                servSockTCP.close();
                servSockUDP.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

