/*
 * Decompiled with CFR 0.152.
 */
package dk.wkjeldsen.func;

import dk.wkjeldsen.func.RobotSerializable;
import dk.wkjeldsen.func.ServerLogger;
import java.awt.AWTException;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public class KeyBinder
implements Serializable {
    private static KeyBinder instance;
    private static final String saveFileNameKeyBindings = "keybindings";
    private HashMap<String, Integer> keyboardLetters = new HashMap();
    private HashMap<String, Integer> keyboardKeysUp;
    private HashMap<String, Integer> keyboardKeysDown = new HashMap();
    private HashMap<String, Integer> mouseKeysDown;
    private HashMap<String, Integer> mouseKeysUp;
    RobotSerializable robot;
    String MOUSE_INPUT = "G";
    String KEYBOARD_INPUT = "K";
    String TOUCH_INPUT = "X";
    String SYSTEM_INPUT = "S";
    String KEY_R_DOWN = "RDOWN000G";
    String KEY_R_UP = "RUP00000G";
    String KEY_L_DOWN = "LDOWN000G";
    String KEY_L_UP = "LUP00000G";
    String KEY_Y_DOWN = "YDOWN000G";
    String KEY_Y_UP = "YUP00000G";
    String KEY_A_DOWN = "ADOWN000G";
    String KEY_A_UP = "AUP00000G";
    String KEY_X_UP = "XUP00000G";
    String KEY_X_DOWN = "XDOWN000G";
    String KEY_B_UP = "BUP00000G";
    String KEY_B_DOWN = "BDOWN000G";
    String KEY_UP_UP = "UPUP0000G";
    String KEY_UP_DOWN = "UPDOWN00G";
    String KEY_DOWN_UP = "DOWNUP00G";
    String KEY_DOWN_DOWN = "DOWNDOWNG";
    String KEY_RIGHT_UP = "RGHTUP00G";
    String KEY_RIGHT_DOWN = "RGHTDOWNG";
    String KEY_LEFT_UP = "LEFTUP00G";
    String KEY_LEFT_DOWN = "LEFTDOWNG";
    String TCP_ALIVE = "00000000A";
    String VKKEY_0 = "00000000K";
    String VKKEY_1 = "10000000K";
    String VKKEY_2 = "20000000K";
    String VKKEY_3 = "30000000K";
    String VKKEY_4 = "40000000K";
    String VKKEY_5 = "50000000K";
    String VKKEY_6 = "60000000K";
    String VKKEY_7 = "70000000K";
    String VKKEY_8 = "80000000K";
    String VKKEY_9 = "90000000K";
    String VKKEY_A = "A0000000K";
    String VKKEY_B = "B0000000K";
    String VKKEY_C = "C0000000K";
    String VKKEY_D = "D0000000K";
    String VKKEY_E = "E0000000K";
    String VKKEY_F = "F0000000K";
    String VKKEY_G = "G0000000K";
    String VKKEY_H = "H0000000K";
    String VKKEY_I = "I0000000K";
    String VKKEY_J = "J0000000K";
    String VKKEY_K = "K0000000K";
    String VKKEY_L = "L0000000K";
    String VKKEY_M = "M0000000K";
    String VKKEY_N = "N0000000K";
    String VKKEY_O = "O0000000K";
    String VKKEY_P = "P0000000K";
    String VKKEY_Q = "Q0000000K";
    String VKKEY_R = "R0000000K";
    String VKKEY_S = "S0000000K";
    String VKKEY_T = "T0000000K";
    String VKKEY_U = "U0000000K";
    String VKKEY_V = "V0000000K";
    String VKKEY_W = "W0000000K";
    String VKKEY_X = "X0000000K";
    String VKKEY_Y = "Y0000000K";
    String VKKEY_Z = "Z0000000K";
    String VKKEY_RETURN_DOWN = "RETURNDNK";
    String VKKEY_RETURN_UP = "RETURNUPK";
    String VKKEY_BACK = "BACK0000K";
    String VKKEY_DOT = ".0000000K";
    String VKKEY_SPACE = "SPACE000K";
    String VKKEY_DASH = "-0000000K";
    String VKKEY_SLASH = "/0000000K";
    String VKKEY_COLON = ":0000000K";
    String VKKEY_AT = "@0000000K";
    String VKKEY_LPARAN = "(0000000K";
    String VKKEY_RPARAN = ")0000000K";
    String VKKEY_SEMICOLON = ";0000000K";
    String VKKEY_DOLLAR = "$0000000K";
    String VKKEY_AND = "&0000000K";
    String VKKEY_QUOTE = "\"0000000K";
    String VKKEY_COMMA = ",0000000K";
    String VKKEY_QUESTION = "?0000000K";
    String VKKEY_EXCLAMATION = "!0000000K";
    String VKKEY_SEMIQUOTE = "'0000000K";
    String VKKEY_PLAYPAUSE = "PLAYPAUSK";
    String VKKEY_STOP = "STOP0000K";
    String VKKEY_NEXT = "NEXT0000K";
    String VKKEY_PREV = "PREV0000K";
    String VKKEY_VOLUP = "VOLUP000K";
    String VKKEY_VOLDOWN = "VOLDOWN0K";
    String VKKEY_VOLMUTE = "VOLMUTE0K";
    String VKKEY_UP_UP = "UPUP0000K";
    String VKKEY_UP_DOWN = "UPDOWN00K";
    String VKKEY_DOWN_UP = "DOWNUP00K";
    String VKKEY_DOWN_DOWN = "DOWNDOWNK";
    String VKKEY_LEFT = "LEFT0000K";
    String VKKEY_RIGHT = "RIGHT000K";
    String SYS_SHUTDOWN = "SHUTDOWNS";
    String SYS_RESTART = "RESTART0S";

    private KeyBinder() {
        this.keyboardKeysUp = new HashMap();
        this.mouseKeysDown = new HashMap();
        this.mouseKeysUp = new HashMap();
        try {
            this.robot = new RobotSerializable();
        }
        catch (AWTException ex) {
            ex.printStackTrace();
        }
        this.mouseKeysUp.put(this.KEY_LEFT_UP, 16);
        this.mouseKeysDown.put(this.KEY_LEFT_DOWN, 16);
        this.mouseKeysDown.put(this.KEY_RIGHT_DOWN, 4);
        this.mouseKeysUp.put(this.KEY_RIGHT_UP, 4);
        this.mouseKeysUp.put(this.KEY_L_UP, 16);
        this.mouseKeysDown.put(this.KEY_L_DOWN, 16);
        this.mouseKeysDown.put(this.KEY_R_DOWN, 4);
        this.mouseKeysUp.put(this.KEY_R_UP, 4);
        this.keyboardLetters.put("00000000K", 48);
        this.keyboardLetters.put("10000000K", 49);
        this.keyboardLetters.put("20000000K", 50);
        this.keyboardLetters.put("30000000K", 51);
        this.keyboardLetters.put("40000000K", 52);
        this.keyboardLetters.put("50000000K", 53);
        this.keyboardLetters.put("60000000K", 54);
        this.keyboardLetters.put("70000000K", 55);
        this.keyboardLetters.put("80000000K", 56);
        this.keyboardLetters.put("90000000K", 57);
        this.keyboardLetters.put("A0000000K", 65);
        this.keyboardLetters.put("B0000000K", 66);
        this.keyboardLetters.put("C0000000K", 67);
        this.keyboardLetters.put("D0000000K", 68);
        this.keyboardLetters.put("E0000000K", 69);
        this.keyboardLetters.put("F0000000K", 70);
        this.keyboardLetters.put("G0000000K", 71);
        this.keyboardLetters.put("A0000000K", 65);
        this.keyboardLetters.put("H0000000K", 72);
        this.keyboardLetters.put("I0000000K", 73);
        this.keyboardLetters.put("J0000000K", 74);
        this.keyboardLetters.put("K0000000K", 75);
        this.keyboardLetters.put("L0000000K", 76);
        this.keyboardLetters.put("N0000000K", 78);
        this.keyboardLetters.put("M0000000K", 77);
        this.keyboardLetters.put("O0000000K", 79);
        this.keyboardLetters.put("P0000000K", 80);
        this.keyboardLetters.put("Q0000000K", 81);
        this.keyboardLetters.put("R0000000K", 82);
        this.keyboardLetters.put("S0000000K", 83);
        this.keyboardLetters.put("T0000000K", 84);
        this.keyboardLetters.put("U0000000K", 85);
        this.keyboardLetters.put("V0000000K", 86);
        this.keyboardLetters.put("W0000000K", 87);
        this.keyboardLetters.put("X0000000K", 88);
        this.keyboardLetters.put("Y0000000K", 89);
        this.keyboardLetters.put("Z0000000K", 90);
        this.keyboardLetters.put("BACK0000K", 8);
        this.keyboardLetters.put(".0000000K", 46);
        this.keyboardLetters.put("SPACE000K", 32);
        this.keyboardLetters.put("-0000000K", 45);
        this.keyboardLetters.put("/0000000K", 47);
        this.keyboardLetters.put("/0000000K", 47);
        this.keyboardLetters.put(":0000000K", 513);
        this.keyboardLetters.put("@0000000K", 512);
        this.keyboardLetters.put("(0000000K", 519);
        this.keyboardLetters.put(")0000000K", 522);
        this.keyboardLetters.put(";0000000K", 59);
        this.keyboardLetters.put("$0000000K", 515);
        this.keyboardLetters.put("&0000000K", 150);
        this.keyboardLetters.put("\"0000000K", 222);
        this.keyboardLetters.put(",0000000K", 44);
        this.keyboardLetters.put("?0000000K", 152);
        this.keyboardLetters.put("!0000000K", 517);
        this.keyboardLetters.put("'0000000K", 152);
        this.keyboardLetters.put("LEFT0000K", 37);
        this.keyboardLetters.put("RIGHT000K", 39);
        this.keyboardKeysDown.put("RETURNDNK", 10);
        this.keyboardKeysDown.put("UPDOWN00K", 38);
        this.keyboardKeysDown.put("DOWNDOWNK", 40);
        this.keyboardKeysDown.put("YDOWN000K", 18);
        this.keyboardKeysDown.put("ADOWN000K", 9);
        this.keyboardKeysUp.put("AUP00000K", 9);
        this.keyboardKeysUp.put("YUP00000K", 18);
        this.keyboardKeysUp.put("DOWNUP00K", 40);
        this.keyboardKeysUp.put("UPUP0000K", 38);
        this.keyboardKeysUp.put("RETURNUPK", 10);
        this.keyboardKeysUp.put(this.KEY_Y_UP, 18);
        this.keyboardKeysDown.put(this.KEY_Y_DOWN, 18);
        this.keyboardKeysUp.put(this.KEY_A_UP, 9);
        this.keyboardKeysDown.put(this.KEY_A_DOWN, 9);
        this.keyboardKeysUp.put(this.KEY_X_UP, 38);
        this.keyboardKeysDown.put(this.KEY_X_DOWN, 38);
        this.keyboardKeysUp.put(this.KEY_B_UP, 40);
        this.keyboardKeysDown.put(this.KEY_B_DOWN, 40);
    }

    public static KeyBinder getInstance() {
        if (instance == null) {
            instance = KeyBinder.loadKeyBinder();
        }
        return instance;
    }

    public void handleCommand(String command) {
        if (this.mouseKeysDown.containsKey(command)) {
            this.robot.mousePress(this.mouseKeysDown.get(command));
        } else if (this.mouseKeysUp.containsKey(command)) {
            this.robot.mouseRelease(this.mouseKeysUp.get(command));
        } else if (this.keyboardLetters.containsKey(command)) {
            if (command.equals("?0000000K")) {
                this.robot.keyPress(16);
                this.robot.keyPress(this.keyboardLetters.get(command));
                this.robot.keyRelease(this.keyboardLetters.get(command));
                return;
            }
            this.robot.keyPress(this.keyboardLetters.get(command));
            this.robot.keyRelease(this.keyboardLetters.get(command));
        } else if (this.keyboardKeysDown.containsKey(command)) {
            this.robot.keyPress(this.keyboardKeysDown.get(command));
        } else if (this.keyboardKeysUp.containsKey(command)) {
            this.robot.keyRelease(this.keyboardKeysUp.get(command));
        } else if (command.equals(this.VKKEY_PLAYPAUSE) || command.equals(this.VKKEY_STOP) || command.equals(this.VKKEY_NEXT) || command.equals(this.VKKEY_PREV) || command.equals(this.VKKEY_VOLUP) || command.equals(this.VKKEY_VOLDOWN) || command.equals(this.VKKEY_VOLMUTE)) {
            this.handleMediaKeyCommand(command);
        } else if (command.equals(this.SYS_SHUTDOWN) || command.equals(this.SYS_RESTART)) {
            this.handleSystemCommand(command);
        }
    }

    void handleMediaKeyCommand(String command) {
        try {
            if (System.getProperty("os.name").contains("Windows")) {
                Runtime.getRuntime().exec("mediakeyinvoker-win.exe " + command);
                ServerLogger.getInstance().addLogMessage("Windows media key sent.");
            }
            if (System.getProperty("os.name").contains("unix")) {
                Runtime.getRuntime().exec("./mediakeyinvoker-unix " + command);
                ServerLogger.getInstance().addLogMessage("unix media key sent.");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    void handleSystemCommand(String command) {
        try {
            if (System.getProperty("os.name").contains("Windows")) {
                if (command.equals(this.SYS_SHUTDOWN)) {
                    Runtime.getRuntime().exec("shutdown -s -f -t 0");
                    ServerLogger.getInstance().addLogMessage("Shutdown command received.");
                } else if (command.equals(this.SYS_RESTART)) {
                    Runtime.getRuntime().exec("shutdown -r -f -t 0");
                    ServerLogger.getInstance().addLogMessage("Restart command received.");
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void configKeyboardKey(String keyToMap, int keyCode) {
        if (keyToMap.equals("A")) {
            this.keyboardKeysDown.put(this.KEY_A_DOWN, keyCode);
            this.keyboardKeysUp.put(this.KEY_A_UP, keyCode);
        } else if (keyToMap.equals("B")) {
            this.keyboardKeysDown.put(this.KEY_B_DOWN, keyCode);
            this.keyboardKeysUp.put(this.KEY_B_UP, keyCode);
        } else if (keyToMap.equals("X")) {
            this.keyboardKeysDown.put(this.KEY_X_DOWN, keyCode);
            this.keyboardKeysUp.put(this.KEY_X_UP, keyCode);
        } else if (keyToMap.equals("Y")) {
            this.keyboardKeysDown.put(this.KEY_Y_DOWN, keyCode);
            this.keyboardKeysUp.put(this.KEY_Y_UP, keyCode);
        } else if (keyToMap.equals("Left")) {
            this.keyboardKeysDown.put(this.KEY_LEFT_DOWN, keyCode);
            this.keyboardKeysUp.put(this.KEY_LEFT_UP, keyCode);
        } else if (keyToMap.equals("Right")) {
            this.keyboardKeysDown.put(this.KEY_RIGHT_DOWN, keyCode);
            this.keyboardKeysUp.put(this.KEY_RIGHT_UP, keyCode);
        } else if (keyToMap.equals("Up")) {
            this.keyboardKeysDown.put(this.KEY_UP_DOWN, keyCode);
            this.keyboardKeysUp.put(this.KEY_UP_UP, keyCode);
        } else if (keyToMap.equals("Down")) {
            this.keyboardKeysDown.put(this.KEY_DOWN_DOWN, keyCode);
            this.keyboardKeysUp.put(this.KEY_DOWN_UP, keyCode);
        } else if (keyToMap.equals("L")) {
            this.keyboardKeysDown.put(this.KEY_L_DOWN, keyCode);
            this.keyboardKeysUp.put(this.KEY_L_UP, keyCode);
        } else if (keyToMap.equals("R")) {
            this.keyboardKeysDown.put(this.KEY_R_DOWN, keyCode);
            this.keyboardKeysUp.put(this.KEY_R_UP, keyCode);
        }
        this.saveKeyBinder();
    }

    public void configMouseKey(String keyToMap, int keyCode) {
        if (keyToMap.equals("A")) {
            this.mouseKeysDown.put(this.KEY_A_DOWN, keyCode);
            this.mouseKeysUp.put(this.KEY_A_UP, keyCode);
        } else if (keyToMap.equals("B")) {
            this.mouseKeysDown.put(this.KEY_B_DOWN, keyCode);
            this.mouseKeysUp.put(this.KEY_B_UP, keyCode);
        } else if (keyToMap.equals("X")) {
            this.mouseKeysDown.put(this.KEY_X_DOWN, keyCode);
            this.mouseKeysUp.put(this.KEY_X_UP, keyCode);
        } else if (keyToMap.equals("Y")) {
            this.mouseKeysDown.put(this.KEY_Y_DOWN, keyCode);
            this.mouseKeysUp.put(this.KEY_Y_UP, keyCode);
        } else if (keyToMap.equals("Left")) {
            this.mouseKeysDown.put(this.KEY_LEFT_DOWN, keyCode);
            this.mouseKeysUp.put(this.KEY_LEFT_UP, keyCode);
        } else if (keyToMap.equals("Right")) {
            this.mouseKeysDown.put(this.KEY_RIGHT_DOWN, keyCode);
            this.mouseKeysUp.put(this.KEY_RIGHT_UP, keyCode);
        } else if (keyToMap.equals("Up")) {
            this.mouseKeysDown.put(this.KEY_UP_DOWN, keyCode);
            this.mouseKeysUp.put(this.KEY_UP_UP, keyCode);
        } else if (keyToMap.equals("Down")) {
            this.mouseKeysDown.put(this.KEY_DOWN_DOWN, keyCode);
            this.mouseKeysUp.put(this.KEY_DOWN_UP, keyCode);
        } else if (keyToMap.equals("L")) {
            this.mouseKeysDown.put(this.KEY_L_DOWN, keyCode);
            this.mouseKeysUp.put(this.KEY_L_UP, keyCode);
        } else if (keyToMap.equals("R")) {
            this.mouseKeysDown.put(this.KEY_R_DOWN, keyCode);
            this.mouseKeysUp.put(this.KEY_R_UP, keyCode);
        }
        this.saveKeyBinder();
    }

    public String getKey(String key) {
        String result = "";
        if (key.equals("A")) {
            if (this.keyboardKeysDown.get(this.KEY_A_DOWN) != null) {
                result = KeyEvent.getKeyText(this.keyboardKeysDown.get(this.KEY_A_DOWN));
            }
            if (this.mouseKeysDown.get(this.KEY_A_DOWN) != null) {
                result = result + " " + MouseEvent.getMouseModifiersText(this.mouseKeysDown.get(this.KEY_A_DOWN));
            }
        } else if (key.equals("B")) {
            if (this.keyboardKeysDown.get(this.KEY_B_DOWN) != null) {
                result = result + KeyEvent.getKeyText(this.keyboardKeysDown.get(this.KEY_B_DOWN));
            }
            if (this.mouseKeysDown.get(this.KEY_B_DOWN) != null) {
                result = result + " " + MouseEvent.getMouseModifiersText(this.mouseKeysDown.get(this.KEY_B_DOWN));
            }
        } else if (key.equals("X")) {
            if (this.keyboardKeysDown.get(this.KEY_X_DOWN) != null) {
                result = result + KeyEvent.getKeyText(this.keyboardKeysDown.get(this.KEY_X_DOWN));
            }
            if (this.mouseKeysDown.get(this.KEY_X_DOWN) != null) {
                result = result + " " + MouseEvent.getMouseModifiersText(this.mouseKeysDown.get(this.KEY_X_DOWN));
            }
        } else if (key.equals("Y")) {
            if (this.keyboardKeysDown.get(this.KEY_Y_DOWN) != null) {
                result = result + KeyEvent.getKeyText(this.keyboardKeysDown.get(this.KEY_Y_DOWN));
            }
            if (this.mouseKeysDown.get(this.KEY_Y_DOWN) != null) {
                result = result + " " + MouseEvent.getMouseModifiersText(this.mouseKeysDown.get(this.KEY_Y_DOWN));
            }
        } else if (key.equals("Left")) {
            if (this.keyboardKeysDown.get(this.KEY_LEFT_DOWN) != null) {
                result = result + KeyEvent.getKeyText(this.keyboardKeysDown.get(this.KEY_LEFT_DOWN));
            }
            if (this.mouseKeysDown.get(this.KEY_LEFT_DOWN) != null) {
                result = result + " " + MouseEvent.getMouseModifiersText(this.mouseKeysDown.get(this.KEY_LEFT_DOWN));
            }
        } else if (key.equals("Right")) {
            if (this.keyboardKeysDown.get(this.KEY_RIGHT_DOWN) != null) {
                result = result + KeyEvent.getKeyText(this.keyboardKeysDown.get(this.KEY_RIGHT_DOWN));
            }
            if (this.mouseKeysDown.get(this.KEY_RIGHT_DOWN) != null) {
                result = result + " " + MouseEvent.getMouseModifiersText(this.mouseKeysDown.get(this.KEY_RIGHT_DOWN));
            }
        } else if (key.equals("Up")) {
            if (this.keyboardKeysDown.get(this.KEY_UP_DOWN) != null) {
                result = result + KeyEvent.getKeyText(this.keyboardKeysDown.get(this.KEY_UP_DOWN));
            }
            if (this.mouseKeysDown.get(this.KEY_UP_DOWN) != null) {
                result = result + " " + MouseEvent.getMouseModifiersText(this.mouseKeysDown.get(this.KEY_UP_DOWN));
            }
        } else if (key.equals("Down")) {
            if (this.keyboardKeysDown.get(this.KEY_DOWN_DOWN) != null) {
                result = result + KeyEvent.getKeyText(this.keyboardKeysDown.get(this.KEY_DOWN_DOWN));
            }
            if (this.mouseKeysDown.get(this.KEY_DOWN_DOWN) != null) {
                result = result + " " + MouseEvent.getMouseModifiersText(this.mouseKeysDown.get(this.KEY_DOWN_DOWN));
            }
        } else if (key.equals("L")) {
            if (this.keyboardKeysDown.get(this.KEY_L_DOWN) != null) {
                result = result + KeyEvent.getKeyText(this.keyboardKeysDown.get(this.KEY_L_DOWN));
            }
            if (this.mouseKeysDown.get(this.KEY_L_DOWN) != null) {
                result = result + " " + MouseEvent.getMouseModifiersText(this.mouseKeysDown.get(this.KEY_L_DOWN));
            }
        } else if (key.equals("R")) {
            if (this.keyboardKeysDown.get(this.KEY_R_DOWN) != null) {
                result = result + KeyEvent.getKeyText(this.keyboardKeysDown.get(this.KEY_R_DOWN));
            }
            if (this.mouseKeysDown.get(this.KEY_R_DOWN) != null) {
                result = result + " " + MouseEvent.getMouseModifiersText(this.mouseKeysDown.get(this.KEY_R_DOWN));
            }
        }
        return result;
    }

    public void clearKeyboardKey(String key) {
        this.keyboardKeysDown.remove(key);
        this.keyboardKeysUp.remove(key);
    }

    public void clearKey(String key) {
        if (key.equals("A")) {
            this.mouseKeysDown.remove(this.KEY_A_DOWN);
            this.mouseKeysUp.remove(this.KEY_A_UP);
            this.keyboardKeysDown.remove(this.KEY_A_DOWN);
            this.keyboardKeysUp.remove(this.KEY_A_UP);
        } else if (key.equals("B")) {
            this.mouseKeysDown.remove(this.KEY_B_DOWN);
            this.mouseKeysUp.remove(this.KEY_B_UP);
            this.keyboardKeysDown.remove(this.KEY_B_DOWN);
            this.keyboardKeysUp.remove(this.KEY_B_UP);
        } else if (key.equals("X")) {
            this.mouseKeysDown.remove(this.KEY_X_DOWN);
            this.mouseKeysUp.remove(this.KEY_X_UP);
            this.keyboardKeysDown.remove(this.KEY_X_DOWN);
            this.keyboardKeysUp.remove(this.KEY_X_UP);
        } else if (key.equals("Y")) {
            this.mouseKeysDown.remove(this.KEY_Y_DOWN);
            this.mouseKeysUp.remove(this.KEY_Y_UP);
            this.keyboardKeysDown.remove(this.KEY_Y_DOWN);
            this.keyboardKeysUp.remove(this.KEY_Y_UP);
        } else if (key.equals("Left")) {
            this.mouseKeysDown.remove(this.KEY_LEFT_DOWN);
            this.mouseKeysUp.remove(this.KEY_LEFT_UP);
            this.keyboardKeysDown.remove(this.KEY_LEFT_DOWN);
            this.keyboardKeysUp.remove(this.KEY_LEFT_UP);
        } else if (key.equals("Right")) {
            this.mouseKeysDown.remove(this.KEY_RIGHT_DOWN);
            this.mouseKeysUp.remove(this.KEY_RIGHT_UP);
            this.keyboardKeysDown.remove(this.KEY_RIGHT_DOWN);
            this.keyboardKeysUp.remove(this.KEY_RIGHT_UP);
        } else if (key.equals("Up")) {
            this.mouseKeysDown.remove(this.KEY_UP_DOWN);
            this.mouseKeysUp.remove(this.KEY_UP_UP);
            this.keyboardKeysDown.remove(this.KEY_UP_DOWN);
            this.keyboardKeysUp.remove(this.KEY_UP_UP);
        } else if (key.equals("Down")) {
            this.mouseKeysDown.remove(this.KEY_DOWN_DOWN);
            this.mouseKeysUp.remove(this.KEY_DOWN_UP);
            this.keyboardKeysDown.remove(this.KEY_DOWN_DOWN);
            this.keyboardKeysUp.remove(this.KEY_DOWN_UP);
        } else if (key.equals("L")) {
            this.mouseKeysDown.remove(this.KEY_L_DOWN);
            this.mouseKeysUp.remove(this.KEY_L_UP);
            this.keyboardKeysDown.remove(this.KEY_L_DOWN);
            this.keyboardKeysUp.remove(this.KEY_L_UP);
        } else if (key.equals("R")) {
            this.mouseKeysDown.remove(this.KEY_R_DOWN);
            this.mouseKeysUp.remove(this.KEY_R_UP);
            this.keyboardKeysDown.remove(this.KEY_R_DOWN);
            this.keyboardKeysUp.remove(this.KEY_R_UP);
        }
        this.saveKeyBinder();
    }

    public void mouseMove(int x, int y) {
        this.robot.mouseMove(x, y);
    }

    public static KeyBinder loadKeyBinder() {
        KeyBinder res = null;
        try {
            ObjectInputStream print = new ObjectInputStream(new BufferedInputStream(new FileInputStream(saveFileNameKeyBindings)));
            res = (KeyBinder)print.readObject();
        }
        catch (IOException e) {
            System.out.println("No save file found!");
        }
        catch (ClassNotFoundException e) {
            System.out.println("Wrong class!");
        }
        if (res == null) {
            res = new KeyBinder();
        }
        return res;
    }

    public void saveKeyBinder() {
        try {
            ObjectOutputStream skriv = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(saveFileNameKeyBindings)));
            skriv.writeObject(this);
            skriv.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }
}

