/******************************************
  sample.c (ARM9)
	Card Dump Sample Program
				by Rudolph
*******************************************/

#include <nds.h>
#include <stdio.h>

#include <LibCardDump.h>



#define KEY_TBL_ADR	(*(vu32*)0x027FFDFC)	// use IPC


int inp_key()
{
	scanKeys();
	return(keysUp());
}


int main(void)
{
	char	*key_tbl;	// key table from the NDS ARM7 BIOS
	u32	romID;
	char	data[512];

	consoleDemoInit();

	sysSetBusOwners(BUS_OWNER_ARM9, BUS_OWNER_ARM9);

	key_tbl = (char *)malloc(0x1200);
	KEY_TBL_ADR = (u32)key_tbl;

	swiWaitForVBlank();
	iprintf("Card Dump Sample\n\n");
	swiWaitForVBlank();

	while(1) {
		iprintf("Set(change) a Target card.\n  <A>:OK\n");
		while(!(inp_key() & KEY_A));

		romID = Card_Open(key_tbl);
		while(romID == 0xFFFFFFFF) {
			iprintf("Cannot be recognized.\n Set it again.  <A>:OK\n");
			while(!(inp_key() & KEY_A));

			romID = Card_Retry();
		}

		iprintf("\n\n\n ====== Card Infomation ======\n\n");

		Card_Read(0x0000, data);	// Read Header Area (0x0000-0x3FFF)
		iprintf(" Game Code: %c%c%c%c Size:%dMB\n\n", data[12], data[13], data[14], data[15], (128 << data[20])/1024);
		iprintf(" 0000:%02X %02X %02X %02X %02X %02X %02X %02X\n", data[0], data[1], data[2], data[3], data[4], data[5], data[6], data[7]);

		Card_Read(0x4000, data);	// Read Secure Area (0x4000-0x7FFF)
		iprintf(" 4000:%02X %02X %02X %02X %02X %02X %02X %02X\n", data[0], data[1], data[2], data[3], data[4], data[5], data[6], data[7]);

		Card_Read(0x8000, data);	// Read Main Data Area (0x8000-)
		iprintf(" 8000:%02X %02X %02X %02X %02X %02X %02X %02X\n", data[0], data[1], data[2], data[3], data[4], data[5], data[6], data[7]);

		iprintf("\n =============================\n\n\n");
		Card_Close();
	}

	return(0);
}
