unit MainWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, Buttons, ExtDlgs, Menus,ShellAPI;

type
  TMain = class(TForm)
    DDLbl: TLabel;
    SrcPathLst: TListBox;
    GLDPNGMemo: TMemo;
    StartBtn: TBitBtn;
    PrgPanel: TPanel;
    IPKFilenameLbl: TLabel;
    BMFilenameLbl: TLabel;
    IPKPrgBar: TProgressBar;
    BMPrgBar: TProgressBar;
    StartupTimer: TTimer;
    IPKSaveDlg: TSaveDialog;
    OpenDlg: TOpenPictureDialog;
    MainMenu: TMainMenu;
    MenuFile: TMenuItem;
    MenuFileAddFolder: TMenuItem;
    MenuFileStart: TMenuItem;
    N1: TMenuItem;
    MenuFileExit: TMenuItem;
    MenuOpt: TMenuItem;
    MenuOptThumb4864_15bit: TMenuItem;
    MenuOptThumb192256_15bit: TMenuItem;
    MenuOptThumb: TMenuItem;
    MenuOptImage: TMenuItem;
    MenuOptOutputPath: TMenuItem;
    MenuAbout: TMenuItem;
    MenuOptShowCompletionDialog: TMenuItem;
    MenuOptUseExif: TMenuItem;
    SrcPathPopupMenu: TPopupMenu;
    PopupRemoveFolder: TMenuItem;
    N2: TMenuItem;
    PopupBootCoverMaker: TMenuItem;
    MenuFileBootCoverMaker: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure StartBtnClick(Sender: TObject);
    procedure StartupTimerTimer(Sender: TObject);
    procedure MenuOptImageClick(Sender: TObject);
    procedure MenuFileAddFolderClick(Sender: TObject);
    procedure MenuFileStartClick(Sender: TObject);
    procedure MenuFileExitClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure MenuOptShowCompletionDialogClick(Sender: TObject);
    procedure MenuOptOutputPathClick(Sender: TObject);
    procedure MenuOptThumb4864_15bitClick(Sender: TObject);
    procedure MenuOptThumb192256_15bitClick(Sender: TObject);
    procedure MenuAboutClick(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SrcPathLstMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PopupRemoveFolderClick(Sender: TObject);
    procedure PopupBootCoverMakerClick(Sender: TObject);
    procedure MenuFileBootCoverMakerClick(Sender: TObject);
  private
    { Private 錾 }
    procedure WMDROPFILES(var msg:TWMDROPFILES);message WM_DROPFILES;
  public
    { Public 錾 }
    function AddSourcePath(srcpath:string):boolean;
    function CreateIPK(BasePath:string;ipkfn:string):boolean;
  end;

var
  Main: TMain;

implementation

{$R *.dfm}

uses _inifile, SelMLWin,_SplitML,_PicTools,_m_Tools,_customjpeg,_ipk,_loadimage,
  ImgOptWin,_zlibhelper,_exif;

const VersionStr='Version 1.0';
const CRLF:string=char($0d)+char($0a);

var
  Encoding:boolean;
  ReqStop:boolean;

procedure TMain.WMDROPFILES(var msg:TWMDROPFILES);
var
  Drop:hdrop;
  index:longint;
  idx:integer;
  Filename:string;
  filebuf:array[0..1024] of char;
  cnt:integer;
begin
  Filename:=StringOfChar(' ',1024);
  Drop:=msg.Drop;
  index:=DragQueryFile(Drop,$FFFFFFFF,nil,0);

  for idx:=0 to index-1 do begin
    DragQueryFileA(Drop,idx,filebuf,1024);
    Filename:='';
    cnt:=0;
    while ((filebuf[cnt]<>char($00)) and (cnt<1024)) do begin
      Filename:=Filename+filebuf[cnt];
      inc(cnt);
    end;
    if AddSourcePath(Filename)=False then begin
      // break;
    end;
  end;

  DragFinish(Drop);
end;

function GetIPKFilename(srcpath:string):string;
var
  dstfn:string;
begin
  dstfn:=copy(srcpath,1,length(srcpath)-1);
  dstfn:=INI_OutputPath+ExtractFilename(dstfn)+'.ipk';

  Result:=dstfn;
end;

function TMain.AddSourcePath(srcpath:string):boolean;
var
  idx:integer;
  FilesLst:TStringList;
  FilesCount:integer;
begin
  if FileExists(srcpath)=True then begin
    ShowMessage(GetMLStr('Can not add file. Request folder.'+CRLF+srcpath+'|t@CP̂͒ǉł܂B'+CRLF+'tH_hbOhbvĂB'+CRLF+srcpath));
    Result:=False;
    exit;
  end;

  if copy(srcpath,length(srcpath),1)<>'\' then srcpath:=srcpath+'\';

  if DirectoryExists(srcpath)=False then begin
    ShowMessage(GetMLStr('not found folder.'+CRLF+srcpath+'|tH_܂B'+CRLF+srcpath));
    Result:=False;
    exit;
  end;

  for idx:=0 to SrcPathLst.Items.Count-1 do begin
    if LowerCase(srcpath)=LowerCase(SrcPathLst.Items[idx]) then begin
      Result:=True;
      exit;
    end;
  end;

  FilesLst:=TStringList.Create;
  LoadImage_GetFilesLst(FilesLst,srcpath);
  FilesCount:=FilesLst.Count;
  FilesLst.Free;

  if FilesCount=0 then begin
    ShowMessage(GetMLStr('not found image files.'+CRLF+srcpath+'|摜t@C܂B'+CRLF+srcpath));
    Result:=False;
    exit;
  end;

  SrcPathLst.Items.Add(srcpath);

  StartBtn.Enabled:=True;
  MenuFileStart.Enabled:=StartBtn.Enabled;

  Result:=True;
end;

var
  DataSize:array[0..5-1] of integer;

procedure WriteImgData(var wfs:TFileStream;var imgdata:TImgData);
var
  idx:integer;
  ofs:integer;
  procedure w8(dw:dword);
  begin
    wfs.WriteBuffer(dw,1);
  end;
  procedure w16(dw:dword);
  begin
    wfs.WriteBuffer(dw,2);
  end;
  procedure w32(dw:dword);
  begin
    wfs.WriteBuffer(dw,4);
  end;
  procedure WriteBody(var body:TImgDataBody);
  begin
    w32(body.bm.Width);
    w32(body.bm.Height);
    w32(trunc(body.ratio*$10000));
    w32(body.decmpsize);
    w32(body.cmpsize);
    wfs.WriteBuffer(body.cmpdata[0],body.cmpsize);
  end;
  procedure WriteBodyDummy(var body:TImgDataBody);
  begin
    w32(body.bm.Width);
    w32(body.bm.Height);
    w32(trunc(body.ratio*$10000));
    w32(body.decmpsize);
    w32(0);
  end;
  procedure wansistr(s:ansistring);
  var
    idx:integer;
  begin
    for idx:=1 to length(s) do begin
      w8(byte(s[idx]));
    end;
    w8(0);
  end;
  procedure WriteFileInfo;
  var
    wfn:WideString;
    UseExif:boolean;
    TopPos,EndPos:integer;
  begin
    TopPos:=wfs.Position;
    w32(0);

    wfn:=WideString(imgdata.Filename);
    wfn:=wfn+widechar(0);
    wfs.WriteBuffer(wfn[1],length(wfn)*2);

    w8(0);

    UseExif:=False;
    if Main.MenuOptUseExif.Checked=True then begin
      if (ExifStr_ImageDescription<>'') or (ExifStr_DateTime<>'') then begin
        UseExif:=True;
      end;
    end;

    if UseExif=False then begin
      w8(0);
      end else begin
      w8(1);
      wansistr(ExifStr_ImageDescription);
      wansistr(ExifStr_DateTime);
      w8(0);
      w8(0);
    end;

    EndPos:=wfs.Position;
    wfs.Position:=TopPos;
    w32(EndPos-(TopPos+4));
    wfs.Position:=EndPos;
  end;
begin
  with imgdata do begin
    WriteFileInfo;

    ofs:=wfs.Position;
    WriteBody(body4864);
    inc(DataSize[0],wfs.Position-ofs);
    ofs:=wfs.Position;
    WriteBody(body6448);
    inc(DataSize[1],wfs.Position-ofs);
    ofs:=wfs.Position;
    WriteBody(body192256);
    inc(DataSize[2],wfs.Position-ofs);
    ofs:=wfs.Position;
    WriteBody(body256192);
    inc(DataSize[3],wfs.Position-ofs);

    ofs:=wfs.Position;
    w32(imgdata.bmmst.Width);
    w32(imgdata.bmmst.Height);
    w16(imgdata.MCUXCount);
    w16(0);
    w16(imgdata.MCUYCount);
    w16(word(imgdata.BodyFormat));

    if (imgdata.BodyFormat=EIPKBF_CustomJpegYUV111) or (imgdata.BodyFormat=EIPKBF_CustomJpegYUV411) then begin
      for idx:=0 to 64-1 do begin
        w16(customjpeg_GetQuantizeData(idx));
      end;
    end;

    for idx:=0 to (MCUXCount*MCUYCount)-1 do begin
      with imgdata.MCUs[idx] do begin
        w16(cmpsize);
        w16(decmpsize);
        wfs.WriteBuffer(cmpdata[0],cmpsize);
      end;
    end;
    inc(DataSize[4],wfs.Position-ofs);
  end;
end;

procedure FreeImgData(var ImgData:TImgData);
var
  idx:integer;
  procedure f(var body:TImgDataBody);
  begin
    if Assigned(body.bm)=True then body.bm.Free;
    body.bm:=nil;
    if Assigned(body.cmpdata)=True then FreeMem(body.cmpdata);
    body.cmpdata:=nil;
  end;
begin
  with ImgData do begin
    if Assigned(bmmst)=True then bmmst.Free;
    f(body4864);
    f(body6448);
    f(body192256);
    f(body256192);

    for idx:=0 to (MCUXCount*MCUYCount)-1 do begin
      with imgdata.MCUs[idx] do begin
        bm.Free;
        bm:=nil;
        FreeMem(cmpdata);
        cmpdata:=nil;
      end;
    end;
  end;
end;

procedure TMain.FormCreate(Sender: TObject);
begin
  Application.Title:=ExtractFilename(Application.ExeName)+' '+VersionStr;
  Main.Caption:=Application.Title;

  DragAcceptFiles(Main.handle,True); // D&D Start

  SrcPathLst.Clear;

  PrgPanel.Visible:=False;

  with GLDPNGMemo do begin
    Top:=PrgPanel.Top+8;
    Left:=(Main.ClientWidth-Width) div 2;
    Visible:=True;
  end;

  StartBtn.Enabled:=False;
  MenuFileStart.Enabled:=StartBtn.Enabled;

  if ParamStr(1)<>'' then AddSourcePath(ParamStr(1));

  Encoding:=False;
  ReqStop:=False;


  StartupTimer.Enabled:=True;
end;

procedure TMain.StartupTimerTimer(Sender: TObject);
begin
  StartupTimer.Enabled:=False;

  CreateINI;

  if GetMLTypeLoaded=False then begin
    if SelML.ShowModal=mrCancel then begin
      Application.Terminate;
      exit;
    end;
  end;

  LoadINI;
  
  SetMLLbl(DDLbl);

  SetMLMenuItem(PopupRemoveFolder);
  SetMLMenuItem(PopupBootCoverMaker);

  StartBtn.Kind:=bkOk;
  StartBtn.Kind:=bkCustom;
  StartBtn.Caption:=GetMLStr('Start|ϊJn');
  StartBtn.Enabled:=False;
  MenuFileStart.Enabled:=StartBtn.Enabled;

  MenuFile.Caption:=GetMLStr('File|t@C')+' (&F)';
  MenuFileAddFolder.Caption:=GetMLStr('Add source folder|摜tH_̒ǉ')+' (&O)';
  MenuFileStart.Caption:=GetMLStr('Start IPK file converting|IPKt@CϊJn')+' (&S)';
  MenuFileBootCoverMaker.Caption:=PopupBootCoverMaker.Caption;
  MenuFileExit.Caption:=GetMLStr('Exit|I')+' (&X)';
  MenuOpt.Caption:=GetMLStr('Option|IvV')+' (&O)';
  MenuOptShowCompletionDialog.Caption:=GetMLStr('Show completion dialog|_CAO\')+' (&C)';
  MenuOptOutputPath.Caption:=GetMLStr('IPK file output folder|IPKt@Co͐')+' (&O)';
  MenuOptThumb.Caption:=GetMLStr('Thumbnail|TlC')+' (&T)';
  MenuOptThumb4864_15bit.Caption:=GetMLStr('SmallSize: 15bit bitmap is used. (Unchecked uses 8bit palette.)|摜: 15bitrbg}bvgpB(`FbN8bitpbg)')+' (&S)';
  MenuOptThumb192256_15bit.Caption:=GetMLStr('LargeSize: 15bit bitmap is used. (Unchecked uses 8bit palette.)|傫摜: 15bitrbg}bvgpB(`FbN8bitpbg)')+' (&L)';
  MenuOptImage.Caption:=GetMLStr('Image quality|掿ݒ')+' (&I)';
  MenuOptUseExif.Caption:=GetMLStr('Use Exif info. from Jpeg|JpegExifg')+' (&E)';
  MenuAbout.Caption:=GetMLStr('About|o[W')+' (&A)';

  ImgOpt.ApplyLang;
//  ImgOpt.Init('');
//  ImgOpt.Visible:=True;

//  AddSourcePath('C:\imagefiles\Exif');
end;

procedure TMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if ReqStop=True then exit;
  if Encoding=True then begin
    CanClose:=False;
    if MessageDlg(GetMLStr('May I discontinue thumbnail generation?|TlC𒆎~Ă낵łH'),mtConfirmation,[mbOK,mbCancel],0)=mrCancel then exit;
    ReqStop:=True;
    exit;
  end;
end;

procedure TMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  SaveINI;
  DragAcceptFiles(Main.handle,False); // D&D Stop
end;

function TMain.CreateIPK(BasePath:string;ipkfn:string):boolean;
var
  idx:integer;
  wfs:TFileStream;
  bodycount:integer;
  bodyoffset:array of dword;
  FilesLst:TStringList;
  ImgData:TImgData;
  Cover:TImgDataBody;
  procedure writeheader;
  var
    id:string;
    state:array[0..496-1] of byte;
  begin
    wfs.Position:=0;
    id:='PackedImages01'+char(0)+char(0);
    wfs.WriteBuffer(id[1],length(id));
    fillmemory(addr(state[0]),496,0);
    wfs.WriteBuffer(state[0],496);
  end;
  procedure writevalues;
  var
    idx:integer;
  begin
    wfs.Position:=512;
    wfs.WriteBuffer(bodycount,4);
    for idx:=0 to bodycount-1 do begin
      wfs.WriteBuffer(bodyoffset[idx],4);
    end;
  end;
  procedure w8(dw:dword);
  begin
    wfs.WriteBuffer(dw,1);
  end;
  procedure w16(dw:dword);
  begin
    wfs.WriteBuffer(dw,2);
  end;
  procedure w32(dw:dword);
  begin
    wfs.WriteBuffer(dw,4);
  end;
  procedure writecover(Cover:TImgDataBody);
    procedure wid(s:ansistring);
    begin
      w8(byte(s[1]));
      w8(byte(s[2]));
      w8(byte(s[3]));
      w8(byte(s[4]));
    end;
  begin
    wid('EXT0');
    w32(Cover.bm.Width);
    w32(Cover.bm.Height);
    w32(Cover.decmpsize);
    w32(Cover.cmpsize);
    wfs.WriteBuffer(Cover.cmpdata[0],Cover.cmpsize);
  end;
begin
  FilesLst:=TStringList.Create;

  LoadImage_GetFilesLst(FilesLst,BasePath);

  BMPrgBar.Position:=0;
  BMPrgBar.Max:=FilesLst.Count;
  BMFilenameLbl.Caption:='';

  if FilesLst.Count=0 then begin
    ShowMessage(GetMLStr('can not found image files.'+CRLF+BasePath+'|摜t@C܂łB'+CRLF+BasePath));
    FilesLst.Free;
    Result:=True;
    exit;
  end;

  DataSize[0]:=0; DataSize[1]:=0; DataSize[2]:=0; DataSize[3]:=0; DataSize[4]:=0;

  wfs:=TFileStream.Create(ipkfn,fmCreate);
  wfs.Size:=0;

  writeheader;

  bodycount:=FilesLst.Count;
  setlength(bodyoffset,bodycount);
  fillmemory(addr(bodyoffset[0]),bodycount*4,0);
  writevalues;

  if CoverFilename<>'' then begin
    if LoadImage_LoadFromFile(Cover.bm,BasePath+CoverFilename,False)=True then begin
      MakeCover(Cover);
      writecover(Cover);
{
      BitBlt(Image1.Canvas.Handle,0,0,256,256,Cover.bm.Canvas.Handle,0,0,SRCCOPY);
      Image1.Refresh;
}
    end;
  end;

  for idx:=0 to bodycount-1 do begin
    BMPrgBar.Position:=idx;
    BMFilenameLbl.Caption:=FilesLst[idx];

    with ImgData do begin
      Filename:=FilesLst[idx];
      case ImgOpt.FormatLst.ItemIndex of
        0: BodyFormat:=EIPKBF_Beta15bit;
        1: BodyFormat:=EIPKBF_CustomJpegYUV411;
        else ShowMessage('unknown BodyFormat error');
      end;
    end;

    customjpeg_SetQuality(ImgOpt.customjpeg_QualityBar.Position);

    Application.ProcessMessages;

    if ReqStop=True then begin
      wfs.Free;
      DeleteFile(ipkfn);
      FilesLst.Free;
      Result:=False;
      exit;
    end;

    if LoadImage_LoadFromFile(ImgData.bmmst,BasePath+ImgData.Filename,MenuOptUseExif.Checked)=True then begin
      AutoProcessing(ImgData,ImgOpt.zlib_Dither15bitChk.Checked,Main.MenuOptThumb4864_15bit.Checked,Main.MenuOptThumb192256_15bit.Checked);
      bodyoffset[idx]:=wfs.Position;
      WriteImgData(wfs,ImgData);
      FreeImgData(ImgData);
    end;
  end;

  writevalues;

  wfs.Free;

//  ShowMessage(format('%d,%d,%d,%d,%dkbyte',[DataSize[0] div 1024,DataSize[1] div 1024,DataSize[2] div 1024,DataSize[3] div 1024,DataSize[4] div 1024]));
//  ShowMessage(format('%d,%d,%d,%d,%dbyte',[DataSize[0],DataSize[1],DataSize[2],DataSize[3],DataSize[4]]));

  FilesLst.Free;
  Result:=True;
end;

procedure TMain.StartBtnClick(Sender: TObject);
var
  BasePath:string;
  idx:integer;
  ipkfn:string;
begin
  if ReqStop=True then exit;
  if Encoding=True then begin
    if MessageDlg(GetMLStr('May I discontinue thumbnail generation?|TlC𒆎~Ă낵łH'),mtConfirmation,[mbOK,mbCancel],0)=mrCancel then exit;
    ReqStop:=True;
    exit;
  end;

  IPKPrgBar.Position:=0;
  IPKPrgBar.Max:=SrcPathLst.Count;
  IPKFilenameLbl.Caption:='';
  BMPrgBar.Position:=0;
  BMPrgBar.Max:=1;
  BMFilenameLbl.Caption:='';

  StartBtn.Kind:=bkCancel;
  StartBtn.Kind:=bkCustom;
  StartBtn.Caption:=GetMLStr('Cancel|LZ');
  StartBtn.Enabled:=True;
  MenuFileStart.Enabled:=StartBtn.Enabled;

  MenuFile.Enabled:=False;
  MenuOpt.Enabled:=False;
  MenuAbout.Enabled:=False;

  GLDPNGMemo.Visible:=False;
  PrgPanel.Visible:=True;

  Encoding:=True;

  SetPriorityLevel(1);

  for idx:=0 to SrcPathLst.Count-1 do begin
    SrcPathLst.ItemIndex:=idx;
    BasePath:=SrcPathLst.Items[idx];
    ipkfn:=GetIPKFilename(BasePath);
    IPKPrgBar.Position:=idx;
    IPKFilenameLbl.Caption:=ipkfn;
    ReqStop:=False;
    if CreateIPK(BasePath,ipkfn)=False then break;
  end;

  SetPriorityLevel(2);

  if (ReqStop=False) and (Main.MenuOptShowCompletionDialog.Checked=True) then begin
    ShowMessage(GetMLStr('IPK file created.'+CRLF+INI_OutputPath+'|IPKt@C̍쐬܂B'+CRLF+INI_OutputPath));
  end;

  Encoding:=False;
  ReqStop:=False;

  StartBtn.Kind:=bkOk;
  StartBtn.Kind:=bkCustom;
  StartBtn.Caption:=GetMLStr('Start|ϊJn');
  StartBtn.Enabled:=False;
  MenuFileStart.Enabled:=StartBtn.Enabled;

  MenuFile.Enabled:=True;
  MenuOpt.Enabled:=True;
  MenuAbout.Enabled:=True;

  PrgPanel.Visible:=False;
  GLDPNGMemo.Visible:=True;

  SrcPathLst.Clear;
end;

procedure TMain.MenuOptImageClick(Sender: TObject);
var
  srcidx:integer;
  srcpath:string;
  FilesLst:TStringList;
  imgfn:string;
begin
  imgfn:='';

  if SrcPathLst.Items.Count<>0 then begin
    srcidx:=SrcPathLst.ItemIndex;
    if srcidx=-1 then srcidx:=0;
    srcpath:=SrcPathLst.Items[srcidx];
    FilesLst:=TStringList.Create;
    LoadImage_GetFilesLst(FilesLst,srcpath);
    if FilesLst.Count<>0 then imgfn:=srcpath+FilesLst[0];
    FilesLst.Free;
    if FileExists(imgfn)=False then imgfn:='';
  end;

  ImgOpt.Visible:=False;
  ImgOpt.Init(imgfn);
  ImgOpt.Visible:=True;
end;

procedure TMain.MenuFileAddFolderClick(Sender: TObject);
begin
  OpenDlg.Title:=GetMLStr('Select images folder.|ϊ摜I itH_SĂΏۂɂȂ܂j');

  OpenDlg.InitialDir:=INI_InputPath;
  if OpenDlg.Execute=True then begin
    INI_InputPath:=ExtractFilePath(OpenDlg.FileName);
    if AddSourcePath(ExtractFilePath(OpenDlg.FileName))=False then begin
      ShowMessage(GetMLStr('Add folder error|tH_̒ǉɎs܂B'));
    end;
  end;
end;

procedure TMain.MenuFileStartClick(Sender: TObject);
begin
  StartBtnClick(Sender);
end;

procedure TMain.MenuFileExitClick(Sender: TObject);
begin
  Main.Close;
end;

procedure TMain.MenuOptShowCompletionDialogClick(Sender: TObject);
begin
  with MenuOptShowCompletionDialog do begin
    Checked:=not Checked;
  end;
end;

procedure TMain.MenuOptOutputPathClick(Sender: TObject);
begin
  IPKSaveDlg.FileName:=GetMLStr('Auto detect filename.ipk|ۑw肵ĉBt@C͎łB');
  IPKSaveDlg.Title:=GetMLStr('Save IPK as...|IPKۑI');
  IPKSaveDlg.InitialDir:=INI_OutputPath;
  if IPKSaveDlg.Execute=False then exit;
  INI_OutputPath:=ExtractFilePath(IPKSaveDlg.FileName);
end;

procedure TMain.MenuOptThumb4864_15bitClick(Sender: TObject);
begin
  with MenuOptThumb4864_15bit do begin
    Checked:=not Checked;
  end;
end;

procedure TMain.MenuOptThumb192256_15bitClick(Sender: TObject);
begin
  with MenuOptThumb192256_15bit do begin
    Checked:=not Checked;
  end;
end;

procedure TMain.MenuAboutClick(Sender: TObject);
var
  ttl,msg:string;
begin
  ttl:=GetMLStr('About...|o[W');

  msg:=ExtractFilename(Application.ExeName)+' '+VersionStr+CRLF+CRLF;
  msg:=msg+'Image files to IPK file converter.'+CRLF;
  msg:=msg+'IPK file for Image Viewer.'+CRLF;

  Application.MessageBox(PAnsiChar(msg),PAnsiChar(ttl),MB_OK);
end;

procedure TMain.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then begin
    Key:=0;
    if Encoding=True then StartBtnClick(Sender);
  end;
end;

procedure TMain.SrcPathLstMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  mpos:TPoint;
  idx:integer;
begin
  if Button<>mbRight then exit;
  
  mpos.X:=X;
  mpos.Y:=Y;
  idx:=SrcPathLst.ItemAtPos(mpos,True);
  if idx=-1 then exit;

  mpos:=SrcPathLst.ClientToScreen(mpos);

  SrcPathLst.ItemIndex:=idx;
  SrcPathLst.Refresh;
  SrcPathLst.PopupMenu.Popup(mpos.X,mpos.Y);
end;

procedure TMain.PopupRemoveFolderClick(Sender: TObject);
var
  idx:integer;
begin
  idx:=SrcPathLst.ItemIndex;
  if idx=-1 then exit;

  SrcPathLst.Items.Delete(idx);
  SrcPathLst.Refresh;

  if SrcPathLst.Count=0 then begin
    StartBtn.Enabled:=False;
    MenuFileStart.Enabled:=StartBtn.Enabled;
  end;
end;

procedure CreateDOSBOX(StartPath:string;cmdline:string;param:string);
var
  CmdStrLen:integer;
  CmdStr:String;
  SI:TStartupInfo;
  PI:TProcessInformation;
begin
  if FileExists(StartPath+cmdline)=False then begin
    ShowMessage('not found '+StartPath+cmdline);
  end;

  cmdline:='"'+StartPath+cmdline+'" '+param;

  SetLength(CmdStr,1024);
  CmdStrLen:=GetEnvironmentVariable('ComSpec',PChar(CmdStr),256);
  SetLength(CmdStr,CmdStrLen);
//  CmdStr:=CmdStr+' /c ""'+cmdline+'""'+char(0);
  CmdStr:=cmdline+char(0);

  GetStartupInfo(SI);
  SI.dwFlags:=STARTF_USESHOWWINDOW;
  SI.wShowWindow:=SW_HIDE;

  if CreateProcess(nil,PChar(CmdStr),nil,nil,False,CREATE_DEFAULT_ERROR_MODE,nil,PChar(StartPath),SI,PI)=False then begin
    ShowMessage('s܂B');
  end;
end;

procedure TMain.PopupBootCoverMakerClick(Sender: TObject);
var
  idx:integer;
  StartPath:string;
begin
  if GetMLType<>MLType_JP then begin
    ShowMessage('This application is Japanese only.');
    exit;
  end;

  idx:=SrcPathLst.ItemIndex;
  if idx=-1 then begin
    ShowMessage('쐬ΏۃtH_IĂsĂB');
    exit;
  end;

  StartPath:=ExtractFilePath(Application.ExeName);
  CreateDOSBOX(StartPath+'misc\CoverMaker\','CoverMaker.exe','"'+SrcPathLst.Items[idx]+'"');
end;

procedure TMain.MenuFileBootCoverMakerClick(Sender: TObject);
begin
  PopupBootCoverMakerClick(Sender);
end;

end.

