unit MainWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    procedure FormCreate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
var
  chkmode:boolean;
  ndsfn:string;
  rfs,wfs:TFileStream;
  arm9fileofs,arm9memofs:dword;
  arm9bodysize:integer;
  arm9body:array of dword;
  FileOffset_GUID:integer;
  idx:integer;
  xcrc:dword;
  tmp:dword;
  skipcount:integer;
  buf:array[0..3-1] of dword;
  function Read32bit(ofs:dword):dword;
  begin
    rfs.Position:=ofs;
    rfs.ReadBuffer(Result,4);
  end;
begin
  if ParamStr(1)<>'/patch' then begin
    chkmode:=False;
    ndsfn:=ParamStr(1);
    end else begin
    chkmode:=True;
    ndsfn:=ParamStr(2);
  end;

  rfs:=TFileStream.Create(ndsfn,fmOpenRead);

  arm9fileofs:=Read32bit($020);
  arm9memofs:=Read32bit($028);
  arm9bodysize:=Read32bit($02C);

  setlength(arm9body,arm9bodysize div 4);

  rfs.Position:=arm9fileofs;
  rfs.ReadBuffer(arm9body[0],arm9bodysize);
  rfs.Free;

  Memo1.Lines.Add('arm9fileofs=$'+inttohex(arm9fileofs,8));
  Memo1.Lines.Add('arm9memofs=$'+inttohex(arm9memofs,8));
  Memo1.Lines.Add('arm9bodysize=$'+inttohex(arm9bodysize,8));
  Memo1.Lines.Add('arm9body[0]=$'+inttohex(arm9body[0],4));
  Memo1.Lines.Add('arm9body[1]=$'+inttohex(arm9body[1],4));

  FileOffset_GUID:=0;

  xcrc:=0;
  skipcount:=0;
  for idx:=0 to (arm9bodysize div 4)-1 do begin
    if 0<skipcount then begin
      dec(skipcount);
      end else begin
      if arm9body[idx]=$44495547 then begin // skip GUID
        skipcount:=((6*4)-4) div 4;
        if arm9body[idx+1]=$47554944 then begin // check GUID XID
          FileOffset_GUID:=arm9fileofs+(idx*4);
        end;
        end else begin
        if arm9body[idx]=$BF8DA5ED then begin // skip DLDI
          skipcount:=((32*1024)-4) div 4;
          end else begin
          tmp:=xcrc shr 31;
          xcrc:=((xcrc shl 1) or tmp) xor arm9body[idx];
        end;
      end;
    end;
  end;

  Memo1.Lines.Add('xcrc='+inttohex(xcrc,8));
  Memo1.Lines.Add('FileOffset_GUID='+inttohex(FileOffset_GUID,8));

  if chkmode=True then begin
    buf[0]:=xcrc;
    buf[1]:=arm9memofs;
    buf[2]:=arm9memofs+arm9bodysize;
    wfs:=TFileStream.Create(ndsfn,fmOpenWrite);
    wfs.Position:=FileOffset_GUID+(2*4);
    wfs.WriteBuffer(buf[0],3*4);
    wfs.Free;
    Application.Terminate;
  end;
end;

end.
