
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <NDS.h>

#include "_const.h"
#include "_console.h"
#include "shell.h"

#include "memtool.h"

#include "gba_nds_fat.h"
#include "cimfs.h"

static bool Shell_ReadFile_IMFS(const char *path,const char *fn,void **pbuf,int *psize)
{
  *psize=0;
  *pbuf=NULL;
  
  s32 PathIndex=pIMFS->GetPathIndex(path);
  s32 FileIndex=pIMFS->GetIndexFromFilename(PathIndex,fn);
  if(FileIndex==-1) FileIndex=pIMFS->GetIndexFromLongFilename(PathIndex,fn);
  
  if((PathIndex!=-1)&&(FileIndex!=-1)){
    *psize=pIMFS->GetFileDataSizeFromIndex(PathIndex,FileIndex);
    *pbuf=pIMFS->GetFileDirectDataFromIndex(PathIndex,FileIndex);
    return(true);
  }
  return(false);
}

static bool Shell_ReadFileAlloc_IMFS(const char *path,const char *fn,void **pbuf,int *psize)
{
  *psize=0;
  *pbuf=NULL;
  
  s32 PathIndex=pIMFS->GetPathIndex(path);
  s32 FileIndex=pIMFS->GetIndexFromFilename(PathIndex,fn);
  if(FileIndex==-1) FileIndex=pIMFS->GetIndexFromLongFilename(PathIndex,fn);
  
  if((PathIndex!=-1)&&(FileIndex!=-1)){
    *psize=pIMFS->GetFileDataSizeFromIndex(PathIndex,FileIndex);
    *pbuf=safemalloc(*psize);
    pIMFS->GetFileDataFromIndex(PathIndex,FileIndex,(u8*)*pbuf);
    return(true);
  }
  return(false);
}

static bool Shell_ReadFile_FAT(const char *path,const char *fn,void **pbuf,int *psize)
{
  *psize=0;
  *pbuf=NULL;
  
  FAT_FILE *fh;
  
  {
    char fullfn[256];
    snprintf(fullfn,256,"%s/%s",path,fn);
    _consolePrintf("read from %s\n",fullfn);
    fh=FAT_fopen(fullfn,"r");
  }
  if(fh==NULL) return(false);
  
  FAT_fseek(fh,0,SEEK_END);
  *psize=FAT_ftell(fh);
  FAT_fseek(fh,0,SEEK_SET);
  *pbuf=(void*)safemalloc(*psize);
  
  FAT_fread(*pbuf,1,*psize,fh);
  FAT_fclose(fh);
  
  return(true);
}

bool Shell_ReadFile(const char *fn,void **pbuf,int *psize)
{
  char path[]="/imgview";
//  _consolePrintf("load '%s/%s'\n",path,fn);
  return(Shell_ReadFile_IMFS(path,fn,pbuf,psize));
}

bool Shell_ReadFileAlloc(const char *fn,void **pbuf,int *psize)
{
  char path[]="/imgview";
//  _consolePrintf("load '%s/%s'\n",path,fn);
  return(Shell_ReadFileAlloc_IMFS(path,fn,pbuf,psize));
}

bool Shell_ReadSEFile(const char *fn,void **pbuf,int *psize)
{
  char path[]="/imgview/se";
//  _consolePrintf("load '%s/%s'\n",path,fn);
  return(Shell_ReadFile_IMFS(path,fn,pbuf,psize));
}

