
#include <nds.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "_console.h"
#include "_consolewritelog.h"
#include "maindef.h"
#include "memtool.h"
#include "_const.h"

#include "glib/glib.h"

#include "gba_nds_fat.h"
#include "zlibhelp.h"
#include "cstream_fs.h"
#include "cipk.h"
#include "ipkfilelist.h"
#include "ipkstate.h"
#include "corner.h"

#include "proc_screen.h"

static FAT_FILE *ipk_filehandle;
static CStreamFS *ipk_stream;
static CIPK *pipk;

static s32 ImgSel_TopPos;
static s32 ImgSel_CurrentIndex;

static s32 ImgSel_LargeThumbnailLastIndex;
static s32 ImgSel_LargeThumbnailIndex;
static s32 ImgSel_LargeThumbnailStateValue;
static s32 ImgSel_LargeThumbnailWhiteOutState;

#define ImgSel_LargeThumbnailStateValueRestart (7)

static bool SCells_RequestSpriteUpdate;

static s32 ItemWidth,ItemHeight;

enum ESCellEffType {ESCET_None,ESCET_Normal,ESCET_Select,ESCET_Unselect,ESCET_PageIn,ESCET_PageOut,ESCET_FadeIn,ESCET_FadeOut};

typedef struct {
  u32 spritenum;
  u32 drawx,drawy;
  u32 posx,posy;
  s32 ImageIndex;
  ESCellEffType EffType;
  s32 StateValue;
} TSCell;

#define SCellXCount (4)
static s32 SCellYCount,SCellCount;
static TSCell *pSCells;

static s32 GetSCellIndexFromPos(s32 x,s32 y)
{
  for(s32 idx=0;idx<SCellCount;idx++){
    TSCell *pSCell=&pSCells[idx];
    s32 by=(s32)pSCell->posy-ImgSel_TopPos;
    if((by<=y)&&(y<(by+ItemHeight))){
      s32 bx=(s32)pSCell->posx;
      if((bx<=x)&&(x<(bx+ItemWidth))){
        if((0<=idx)&&(idx<(s32)pipk->GetFilesCount())){
          return(idx);
        }
      }
    }
  }
  return(-1);
}

static bool SCellIsShow(TSCell *pSCell)
{
  s32 by=(s32)pSCell->posy-ImgSel_TopPos;
  
  if(((0-(ItemHeight/2))<=by)&&(by<(AutoScreenHeight-(ItemHeight/2)))){
    return(true);
  }
  
  return(false);
}

static bool SCellIsInsideScreen(TSCell *pSCell)
{
  s32 by=(s32)pSCell->posy-ImgSel_TopPos;
  
  by--;
  if(((-ItemHeight)<=by)&&(by<AutoScreenHeight)){
    return(true);
  }
  
  return(false);
}

typedef struct {
  TIPKThumbnail thumb;
  TIPKImageInfo imginfo;
} TLargeThumbnail;

static TLargeThumbnail LargeThumbnail;

static void IPK_LargeThumbnailInit(void)
{
  TLargeThumbnail *plt=&LargeThumbnail;
  
  TIPKThumbnail *pth=&plt->thumb;
  pth->Width=0;
  pth->Height=0;
  pth->Ratio=0<<16;
  pth->pBuf=NULL;
  
  TIPKImageInfo *pif=&plt->imginfo;
  pif->Width=0;
  pif->Height=0;
  pif->MCUXCount=0;
  pif->MCUYCount=0;
}

static void IPK_LargeThumbnailFree(void)
{
  TLargeThumbnail *plt=&LargeThumbnail;
  
  TIPKThumbnail *pth=&plt->thumb;
  if(pth->pBuf!=NULL){
    safefree(pth->pBuf); pth->pBuf=NULL;
  }
  
  IPK_LargeThumbnailInit();
}

static bool IPK_LargeThumbnailUpdate(void)
{
  if(ImgSel_LargeThumbnailWhiteOutState!=-1){
    ImgSel_LargeThumbnailWhiteOutState++;
    pScreenMain->SetWhiteOut(ImgSel_LargeThumbnailWhiteOutState);
    if(ImgSel_LargeThumbnailWhiteOutState==16) ImgSel_LargeThumbnailWhiteOutState=-1;
    return(true);
  }
  
  if(ImgSel_LargeThumbnailStateValue==-1) return(false);
  if(ImgSel_LargeThumbnailLastIndex==ImgSel_LargeThumbnailIndex) return(false);
  if((s32)pipk->GetFilesCount()<=ImgSel_LargeThumbnailIndex) return(false);
  
  s32 state=ImgSel_LargeThumbnailStateValue;
  ImgSel_LargeThumbnailStateValue=state+1;
  
  if(state==(18+1)){
    ImgSel_LargeThumbnailLastIndex=ImgSel_LargeThumbnailIndex;
    ImgSel_LargeThumbnailStateValue=-1;
    return(false);
  }
  
  s32 ImageIndex=ImgSel_LargeThumbnailIndex;
  
  if(state<=8){
    pScreenMain->SetWhiteOut(state*2);
    }else{
    if(10<=state){
      pScreenMain->SetWhiteOut((8-(state-10))*2);
    }
  }
  
  TLargeThumbnail *plt=&LargeThumbnail;
  TIPKThumbnail *pth=&plt->thumb;
  TIPKImageInfo *pif=&plt->imginfo;
  
  CglCanvas *pcan=pScreenMain->pCanvas;
  
  switch(state){
    case 0: case 1: case 2: case 3: case 4: case 5: case 6: {
    } break;
    case 7: {
      IPK_LargeThumbnailFree();
      pcan->SetColor(GlobalBGColor15);
      pcan->FillAll();
    } break;
    case 8: {
      pth->pBuf=NULL;
      if(isVertical==true){
        pipk->GetThumbnail(ImageIndex,EIPKTHID_192256,pth);
        }else{
        pipk->GetThumbnail(ImageIndex,EIPKTHID_256192,pth);
      }
    } break;
    case 9: {
    } break;
    case 10: {
      u16 *psrcbuf=pth->pBuf;
      u32 srcbufw=pth->Width;
      u16 *pdstbuf=pcan->GetScanLine(0);
      u32 dstbufw=pcan->GetWidth();
      
      u32 cx=(AutoScreenWidth-pth->Width)/2;
      u32 cy=(AutoScreenHeight-pth->Height)/2;
      pdstbuf+=cx+(dstbufw*cy);
      
      for(u32 py=0;py<pth->Height;py++){
        MemCopy16DMA3(psrcbuf,pdstbuf,pth->Width*2);
        psrcbuf+=srcbufw;
        pdstbuf+=dstbufw;
      }
    } break;
    case 11: {
      pipk->GetImageInfo(ImageIndex,pif);
      
      pcan->SetCglFont(pCglFont_Large14);
      pcan->SetFontBGColor(GlobalBGColor15);
      pcan->SetFontTextColor(GlobalTextColor15);
    } break;
    case 12: {
      u32 y=AutoScreenHeight-2-(16*2);
      u32 x=2;
      
      char msg[256];
      snprintf(msg,256,"%d/%d %dx%d pixels",ImageIndex+1,pipk->GetFilesCount(),pif->Width,pif->Height);
      pcan->SetFontBGColor(GlobalTextColor15);
      pcan->SetFontTextColor(GlobalBGColor15);
      pcan->TextOutA(x-1,y-1,msg);
      pcan->TextOutA(x-1,y+1,msg);
      pcan->TextOutA(x+1,y-1,msg);
      pcan->TextOutA(x+1,y+1,msg);
      pcan->SetFontBGColor(GlobalBGColor15);
      pcan->SetFontTextColor(GlobalTextColor15);
      pcan->TextOutA(x,y,msg);
    } break;
    case 13: {
      u32 y=AutoScreenHeight-2-(16*2);
      u32 x=2;
      y+=16;
      
      UnicodeChar msgw[256];
      pipk->GetFilename(ImageIndex,msgw);
      pcan->SetFontBGColor(GlobalTextColor15);
      pcan->SetFontTextColor(GlobalBGColor15);
      pcan->TextOutW(x-1,y-1,msgw);
      pcan->TextOutW(x-1,y+1,msgw);
      pcan->TextOutW(x+1,y-1,msgw);
      pcan->TextOutW(x+1,y+1,msgw);
      pcan->SetFontBGColor(GlobalBGColor15);
      pcan->SetFontTextColor(GlobalTextColor15);
      pcan->TextOutW(x,y,msgw);
    } break;
    case 14: case 15: case 16: case 17: case 18: {
    } break;
  }
  
  return(true);
}

static void IPK_LargeThumbnail_StartPageIn(void)
{
  IPK_LargeThumbnailFree();
  ImgSel_LargeThumbnailLastIndex=-1;
  ImgSel_LargeThumbnailStateValue=ImgSel_LargeThumbnailStateValueRestart; // skip fadeout.
  ImgSel_LargeThumbnailWhiteOutState=-1;
}

static void IPK_LargeThumbnail_StartPageOut(void)
{
  IPK_LargeThumbnailFree();
  ImgSel_LargeThumbnailStateValue=-1;
  ImgSel_LargeThumbnailWhiteOutState=0;
}

static void IPK_Init_SCells(void)
{
  for(s32 idx=0;idx<SCellCount;idx++){
    u32 x=idx%SCellXCount;
    u32 y=idx/SCellXCount;
    TSCell *pSCell=&pSCells[idx];
    
    pSCell->spritenum=idx%16;
    pSCell->drawx=x*64;
    pSCell->drawy=(y%4)*64;
    pSCell->posx=x*ItemWidth;
    pSCell->posy=y*ItemHeight;
    pSCell->EffType=ESCET_None;
    pSCell->ImageIndex=idx;
    pSCell->StateValue=0;
  }
}

#define PageTransitionCount (3)
static s32 PageTransition[PageTransitionCount][16]={
{0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,},
{30,28,26,24,22,20,18,16,14,12,10,8,6,4,2,0,},
{ 0, 2, 4, 6,
 22,24,26, 8,
 20,30,28,10,
 18,16,14,12,},
};

static void IPK_Start_PageIn(void)
{
  s32 idxofs=-1;
  for(s32 idx=0;idx<SCellCount;idx++){
    TSCell *pSCell=&pSCells[idx];
    if(SCellIsShow(pSCell)==true){
      idxofs=idx;
      break;
    }
  }
  if(idxofs==-1) return;
  
  u32 TransIdx=rand()%PageTransitionCount;
  
  for(s32 idx=0;idx<16;idx++){
    TSCell *pSCell=&pSCells[idxofs+idx];
    pSCell->EffType=ESCET_PageIn;
    pSCell->StateValue=-PageTransition[TransIdx][idx];
  }
}

static void IPK_Start_PageOut(void)
{
  s32 idxofs=-1;
  for(s32 idx=0;idx<SCellCount;idx++){
    TSCell *pSCell=&pSCells[idx];
    if(SCellIsShow(pSCell)==true){
      idxofs=idx;
      break;
    }
  }
  if(idxofs==-1) return;
  
  u32 TransIdx=rand()%PageTransitionCount;
  
  for(s32 idx=0;idx<16;idx++){
    TSCell *pSCell=&pSCells[idxofs+idx];
    pSCell->EffType=ESCET_PageOut;
    pSCell->StateValue=-PageTransition[TransIdx][idx];
  }
}

static void IPK_DrawThumbnail(TSCell *pSCell)
{
  CglCanvas *pcan=pScreenSub64->pCanvas;
  const u32 thw=ItemWidth,thh=ItemHeight;
  
  u32 dx=pSCell->drawx;
  u32 dy=pSCell->drawy;
  
  pcan->SetColor(GlobalBGColor15);
  pcan->FillBox(dx,dy,thw,thh);
  
  if(pSCell->ImageIndex<(s32)pipk->GetFilesCount()){
    TIPKThumbnail th;
    if(isVertical==true){
      pipk->GetThumbnail(pSCell->ImageIndex,EIPKTHID_4864,&th);
      }else{
      pipk->GetThumbnail(pSCell->ImageIndex,EIPKTHID_6448,&th);
    }
    
    u16 *psrcbuf=th.pBuf;
    u32 srcbufw=th.Width;
    u16 *pdstbuf=pcan->GetScanLine(dy)+dx;
    u32 dstbufw=pcan->GetWidth();
    
    u32 cx=(thw-th.Width)/2;
    u32 cy=(thh-th.Height)/2;
    pdstbuf+=cx+(dstbufw*cy);
    
    for(u32 py=0;py<th.Height;py++){
      if(py!=0) MemCopy16DMA3(psrcbuf,pdstbuf,th.Width*2);
      psrcbuf+=srcbufw;
      pdstbuf+=dstbufw;
    }
    
    safefree(th.pBuf); th.pBuf=NULL;
    
    char msg[256];
    snprintf(msg,256,"%d",pSCell->ImageIndex+1);
    pcan->SetFontBGColor(GlobalBGColor15);
    pcan->SetFontTextColor(RGB15(20,19,19)|BIT15);
    u32 w=pcan->GetTextWidthA(msg);
    pcan->TextOutA(dx+ItemWidth-w-4,dy+1,msg);
    
    pcan->SetColor(RGB15(16,15,15)|BIT15);
    pcan->DrawBox(dx,dy+1,thw,thh-1);
  }
}

static void ImgSel_SetCurrentIndex(s32 idx)
{
  if(idx<0) idx=0;
  if((s32)pipk->GetFilesCount()<=idx) idx=(s32)pipk->GetFilesCount()-1;
  
  if(ImgSel_CurrentIndex!=idx){
    if(ImgSel_CurrentIndex!=-1){
      TSCell *pSCell=&pSCells[ImgSel_CurrentIndex];
      if(SCellIsShow(pSCell)==true){
        if((pSCell->EffType==ESCET_PageIn)||(pSCell->EffType==ESCET_FadeIn)) IPK_DrawThumbnail(pSCell);
        pSCell->EffType=ESCET_Unselect;
        pSCell->StateValue=0;
      }
    }
    ImgSel_CurrentIndex=idx;
    if(ImgSel_CurrentIndex!=-1){
      TSCell *pSCell=&pSCells[ImgSel_CurrentIndex];
      if(SCellIsShow(pSCell)==true){
        if(pSCell->EffType!=ESCET_Normal) IPK_DrawThumbnail(pSCell);
        pSCell->EffType=ESCET_Select;
        pSCell->StateValue=0;
      }
    }
  }
  
  if(ImgSel_LargeThumbnailLastIndex!=ImgSel_LargeThumbnailIndex){
    ImgSel_LargeThumbnailLastIndex=-1;
  }
  
  if(ImgSel_LargeThumbnailIndex!=ImgSel_CurrentIndex){
    ImgSel_LargeThumbnailIndex=ImgSel_CurrentIndex;
    s32 state=ImgSel_LargeThumbnailStateValue;
    if(state==-1){
      state=0;
      }else{
      if(ImgSel_LargeThumbnailStateValueRestart<state) state=ImgSel_LargeThumbnailStateValueRestart;
    }
    ImgSel_LargeThumbnailStateValue=state;
  }
}

static bool SCells_VSyncUpdate(void)
{
  bool ProcFlag=false;
  
  for(s32 idx=0;idx<SCellCount;idx++){
    TSCell *pSCell=&pSCells[idx];
    
    ESCellEffType EffType=pSCell->EffType;
    
    if((EffType!=ESCET_None)&&(EffType!=ESCET_Normal)){
      if(SCellIsInsideScreen(pSCell)==true){
        SCells_RequestSpriteUpdate=true;
        ProcFlag=true;
      }
      s32 state=pSCell->StateValue;
      pSCell->StateValue=state+1;
      switch(EffType){
        case ESCET_None: {
        } break;
        case ESCET_Normal: {
        } break;
        case ESCET_Select: {
          if(state==4) pSCell->EffType=ESCET_Normal;
        } break;
        case ESCET_Unselect: {
          if(state==4) pSCell->EffType=ESCET_Normal;
        } break;
        case ESCET_PageIn: {
          if(0<=state){
            if(state==0) IPK_DrawThumbnail(pSCell);
            ProcFlag=true;
            if(state==32) pSCell->EffType=ESCET_Normal;
          }
        } break;
        case ESCET_PageOut: {
          if(0<=state){
            ProcFlag=true;
            if(state==32) pSCell->EffType=ESCET_None;
          }
        } break;
        case ESCET_FadeIn: {
          if(0<=state){
            if(state==0) IPK_DrawThumbnail(pSCell);
            if(state==8) pSCell->EffType=ESCET_Normal;
          }
        } break;
        case ESCET_FadeOut: {
          if(0<=state){
            if(state==8) pSCell->EffType=ESCET_None;
          }
        } break;
      }
    }
  }
  
  return(ProcFlag);
}

static void SCells_SpriteUpdate(bool ObjNorm)
{
  u32 objidx=0;
  
  for(s32 idx=0;idx<SCellCount;idx++){
    TSCell *pSCell=&pSCells[idx];
    
    if(SCellIsInsideScreen(pSCell)==true){
      bool apply=true;
      s32 spritex=pSCell->posx;
      s32 spritey=pSCell->posy-ImgSel_TopPos;
      s32 alpha=16;
      
      s32 state=pSCell->StateValue;
      
      ESCellEffType EffType=pSCell->EffType;
      
      if((EffType!=ESCET_None)&&(EffType!=ESCET_Select)&&(EffType!=ESCET_Unselect)){
        if(idx==ImgSel_CurrentIndex){
          spritex+=4;
          spritey+=4;
        }
      }
      
      switch(pSCell->EffType){
        case ESCET_None: {
          apply=false;
        } break;
        case ESCET_Normal: {
        } break;
        case ESCET_Select: {
          spritex+=state;
          spritey+=state;
          alpha=12+(4-state);
        } break;
        case ESCET_Unselect: {
          spritex+=4-state;
          spritey+=4-state;
          alpha=12+state;
        } break;
        case ESCET_PageIn: {
          if(state<0){
            apply=false;
          }
          if(0<=state){
            s32 ofs=(state*state)/32;
            spritex+=32-ofs;
            spritey+=32-ofs;
            alpha=state/2;
          }
        } break;
        case ESCET_PageOut: {
          if(0<=state){
            s32 ofs=(state*state)/32;
            spritex-=ofs;
            spritey-=ofs;
            alpha=(32-state)/2;
          }
        } break;
        case ESCET_FadeIn: {
          if(state<0){
            apply=false;
          }
          if(0<=state){
            alpha=state*2;
          }
        } break;
        case ESCET_FadeOut: {
          if(0<=state){
            alpha=16-(state*2);
          }
        } break;
      }
      
      if((EffType!=ESCET_None)&&(EffType!=ESCET_Select)&&(EffType!=ESCET_Unselect)){
        if(idx==ImgSel_CurrentIndex) alpha-=4;
      }
      
      if(apply==true){
        u32 objnum;
        objnum=8+pSCell->spritenum;
        if(ObjNorm==true){
          objnum=8+(15-(objidx&15));
          }else{
          objnum=8+(objidx&15);
        }
        objidx++;
        if(alpha<0) alpha=0;
        pScreenSub64->SetSpritePos64(objnum,pSCell->drawx,pSCell->drawy,spritex,spritey,alpha);
      }
    }
  }
  
  for(;objidx<16;objidx++){
    u32 objnum;
    if(ObjNorm==true){
      objnum=8+(15-(objidx&15));
      }else{
      objnum=8+(objidx&15);
    }
    pScreenSub64->SetSpritePos64(objnum,0,0,0,0,0);
  }
  
  pScreenSub64->UpdateOAM();
}

static void DrawCornerIcon(bool Redraw,u32 Blend)
{
  const u32 s=CornerIconSize;
  
  if(Redraw==true){
    CglCanvas *pcan=pScreenSub64->pCanvas;
    CglB15 *pB15;
    TPoint dp;
    pB15=Corner_GetIcon(EIT_Lite);
    dp=Corner_GetPoint(1);
    pB15->pCanvas->BitBlt(pcan,dp.x,dp.y,s,s,0,0,true);
    pB15=Corner_GetIcon(EIT_Up);
    dp=Corner_GetPoint(2);
    pB15->pCanvas->BitBlt(pcan,dp.x,dp.y,s,s,0,0,true);
    pB15=Corner_GetIcon(EIT_SlideBtn);
    dp=Corner_GetPoint(3);
    pB15->pCanvas->BitBlt(pcan,dp.x,dp.y,s,s,0,0,true);
    pB15=Corner_GetIcon(EIT_ToggleDisplay);
    dp=Corner_GetPoint(4);
    pB15->pCanvas->BitBlt(pcan,dp.x,dp.y,s,s,0,0,true);
  }
  
  s32 xc=(AutoScreenWidth-s)/2;
  TPoint dp;
  
  dp=Corner_GetPoint(1);
  pScreenSub64->SetSpritePos16(0,dp.x,dp.y,0,0,Blend);
  dp=Corner_GetPoint(2);
  pScreenSub64->SetSpritePos16(1,dp.x,dp.y,AutoScreenWidth-s,0,Blend);
  dp=Corner_GetPoint(3);
  pScreenSub64->SetSpritePos16(2,dp.x,dp.y,xc,AutoScreenHeight-s,Blend);
  dp=Corner_GetPoint(4);
  pScreenSub64->SetSpritePos16(3,dp.x,dp.y,xc,0,Blend);
}

static void IPK_Start(void)
{
  CglCanvas *pcan=pScreenSub64->pCanvas;
  pcan->SetColor(0);
  pcan->FillAll();
  
  {
    char *pfullfn=IPK_GetFullFilename(CurrentIPKFileIndex);
    _consolePrintf("open [%s]\n",pfullfn);
    ipk_filehandle=FAT_fopen(pfullfn,"r");
    if(ipk_filehandle==NULL){
      _consolePrintf("file open error.\n");
      ShowLogHalt();
    }
    ipk_stream=new CStreamFS(ipk_filehandle);
    pipk=new CIPK(ipk_stream);
  }
  
  ImgSel_TopPos=0;
  ImgSel_CurrentIndex=-1;
  
  ImgSel_LargeThumbnailLastIndex=-1;
  ImgSel_LargeThumbnailIndex=-1;
  ImgSel_LargeThumbnailStateValue=-1;
  ImgSel_LargeThumbnailWhiteOutState=-1;
  
  SCellYCount=((s32)pipk->GetFilesCount()+(SCellXCount-1))/SCellXCount;
  if(SCellYCount<5) SCellYCount=5;
  SCellCount=SCellYCount*SCellXCount;
  pSCells=(TSCell*)safemalloc(sizeof(TSCell)*SCellCount);
  
  IPK_Init_SCells();
  
  s32 TopPos=IPKState.ThumbnailTopPos;
  s32 ImgIdx=IPKState.ImageIndex;
  
  {
    s32 TopLine=(TopPos+(ItemHeight-1))/ItemHeight;
    s32 BottomLine=(TopPos/ItemHeight)+3;
    if((ImgIdx/SCellXCount)<TopLine) TopPos=(ImgIdx/SCellXCount)*ItemHeight;
    if(BottomLine<(ImgIdx/SCellXCount)) TopPos=((ImgIdx/SCellXCount)-3)*ItemHeight;
  }
  
  if(TopPos<0) TopPos=0;
  if(((SCellYCount-SCellXCount)*ItemHeight)<TopPos) TopPos=(SCellYCount-SCellXCount)*ItemHeight;
  
  ImgSel_TopPos=TopPos;
  ImgSel_SetCurrentIndex(ImgIdx);
}

static void IPK_End(void)
{
  if(pSCells!=NULL){
    safefree(pSCells); pSCells=NULL;
  }
  
  if(pipk!=NULL){
    delete pipk; pipk=NULL;
  }
  if(ipk_stream!=NULL){
    delete ipk_stream; ipk_stream=NULL;
  }
  if(ipk_filehandle!=NULL){
    FAT_fclose(ipk_filehandle);
    ipk_filehandle=NULL;
  }
  
  IPKState.ThumbnailTopPos=ImgSel_TopPos;
  IPKState.ImageIndex=ImgSel_CurrentIndex;
}

static void CursorFitToScreenWithScroll(void)
{
  s32 ImgIdx=ImgSel_CurrentIndex;
  
  bool endflag=false;
  
  while(endflag==false){
    bool scrup=false,scrdown=false;
    
    s32 TopPos=ImgSel_TopPos;
    
    s32 TopLine=(TopPos+(ItemHeight-1))/ItemHeight;
    s32 BottomLine=(TopPos/ItemHeight)+3;
    if((ImgIdx/SCellXCount)<TopLine){
      TopPos-=ItemHeight;
      scrup=true;
      }else{
      if(BottomLine<(ImgIdx/SCellXCount)){
        TopPos+=ItemHeight;
        scrdown=true;
        }else{
        endflag=true;
        break;
      }
    }
    
    if(TopPos<0){
      TopPos=0;
      endflag=true;
    }
    
    if(((SCellYCount-SCellXCount)*ItemHeight)<TopPos){
      TopPos=(SCellYCount-SCellXCount)*ItemHeight;
      endflag=true;
    }
    
    ImgSel_TopPos=TopPos;
    
    s32 TopLineNew=(ImgSel_TopPos+(ItemHeight/2))/ItemHeight;
    
    if(scrup==true){
      for(u32 x=0;x<SCellXCount;x++){
        u32 idx=((TopLineNew+(SCellXCount-0))*SCellXCount)+x;
        TSCell *pSCell=&pSCells[idx];
        pSCell->EffType=ESCET_FadeOut;
        pSCell->StateValue=-((SCellXCount-1)-x)*2;
      }
      for(u32 x=0;x<SCellXCount;x++){
        u32 idx=((TopLineNew-0)*SCellXCount)+x;
        TSCell *pSCell=&pSCells[idx];
        if(idx==(u32)ImgSel_CurrentIndex){
          IPK_DrawThumbnail(pSCell);
          pSCell->EffType=ESCET_Select;
          pSCell->StateValue=0;
          }else{
          pSCell->EffType=ESCET_FadeIn;
          pSCell->StateValue=-8-((SCellXCount-1)-x)*2;
        }
      }
    }
    if(scrdown==true){
      for(u32 x=0;x<SCellXCount;x++){
        u32 idx=((TopLineNew-1)*SCellXCount)+x;
        TSCell *pSCell=&pSCells[idx];
        pSCell->EffType=ESCET_FadeOut;
        pSCell->StateValue=-x*2;
      }
      for(u32 x=0;x<SCellXCount;x++){
        u32 idx=((TopLineNew+(SCellXCount-1))*SCellXCount)+x;
        TSCell *pSCell=&pSCells[idx];
        if(idx==(u32)ImgSel_CurrentIndex){
          IPK_DrawThumbnail(pSCell);
          pSCell->EffType=ESCET_Select;
          pSCell->StateValue=0;
          }else{
          pSCell->EffType=ESCET_FadeIn;
          pSCell->StateValue=-8-x*2;
        }
      }
    }
    
    SCells_RequestSpriteUpdate=true;
  }
}

// ------------------

static bool CommandKeyDown;

static void CB_KeyDown(u32 Keys)
{
  if(CommandKeyDown==true) return;
  
  if((Keys&KEY_L)!=0){
    CommandKeyDown=true;
  }
}

static void CB_KeyPress(u32 VsyncCount,u32 Keys)
{
  if(CommandKeyDown==true) return;
  
  if((Keys&KEY_START)!=0){
    NextProc=GetNextProc_SlideOpt();
    return;
  }
  if((Keys&KEY_SELECT)!=0){
    NextProc=ENP_FileSelect;
    return;
  }
  
  s32 v=0;
  
  if((Keys&KEY_UP)!=0) v=-SCellXCount;
  if((Keys&KEY_DOWN)!=0) v=SCellXCount;
  if((Keys&KEY_LEFT)!=0) v=-1;
  if((Keys&KEY_RIGHT)!=0) v=1;
  
  if(v!=0){
    s32 lastidx=ImgSel_CurrentIndex;
    ImgSel_SetCurrentIndex(ImgSel_CurrentIndex+v);
    if(lastidx!=ImgSel_CurrentIndex) CursorFitToScreenWithScroll();
  }
}

static void CB_KeyUp(u32 Keys)
{
  if((Keys&KEY_L)!=0){
    if(CommandKeyDown==true){
      CommandKeyDown=false;
      NextProc=ENP_View;
    }
  }
  
}

static inline u16 ColorMargeBlack(const u16 col,const int Alpha)
{
  if(Alpha==32) return(RGB15(31,31,31) | BIT15);
  if(Alpha==0) return(col | BIT15);
  
  u32 r,g,b;
  
  r=((col>>0)&0x1f)*Alpha/32;
  g=((col>>5)&0x1f)*Alpha/32;
  b=((col>>10)&0x1f)*Alpha/32;
  
  return(RGB15(r,g,b)|BIT15);
}

static bool deskmf;
static ECornerItem deskCornerItem;
static s32 deskmx,deskmy;
static u32 deskpresscount;
static bool nextchk;
static s32 nextmx,nextmy;

static void CB_MouseDown(s32 x,s32 y)
{
  deskmf=false;
  
  deskCornerItem=GetInsideCornerItem(x,y);
  if((deskCornerItem==ECI_LeftUp)||(deskCornerItem==ECI_RightUp)||(deskCornerItem==ECI_CenterDown_Center)||(deskCornerItem==ECI_CenterTop_Center)) return;
  deskCornerItem=ECI_None;
  
  deskmx=x;
  deskmy=y;
  deskpresscount=0;
  
  s32 idx=GetSCellIndexFromPos(deskmx,deskmy);
  
  if(idx==ImgSel_CurrentIndex){
    nextchk=true;
    nextmx=deskmx;
    nextmy=deskmy;
  }
  
  if(idx!=-1){
    if(SCellIsShow(&pSCells[idx])==true) ImgSel_SetCurrentIndex(idx);
  }
  
  deskmf=true;
}

static void CB_MouseMove(s32 x,s32 y,bool CanIgnore)
{
  if(deskmf==false) return;
  if(CanIgnore==true) return;
  
  while(1){
    s32 vector=y-deskmy;
    if(vector==0) return;
    
    if(vector<-(ItemHeight-1)){
      vector=-(ItemHeight-1);
      }else{
      if((ItemHeight-1)<vector){
        vector=ItemHeight-1;
      }
    }
    deskmy+=vector;
    
    s32 TopLineOld=(ImgSel_TopPos+(ItemHeight/2))/ItemHeight;
    ImgSel_TopPos-=vector;
    if(((SCellYCount-SCellXCount)*ItemHeight)<ImgSel_TopPos) ImgSel_TopPos=(SCellYCount-SCellXCount)*ItemHeight;
    if(ImgSel_TopPos<0) ImgSel_TopPos=0;
    s32 TopLineNew=(ImgSel_TopPos+(ItemHeight/2))/ItemHeight;
    
    bool scrup=false,scrdown=false;
    
    if(TopLineNew<TopLineOld) scrup=true;
    if(TopLineOld<TopLineNew) scrdown=true;
    
    if(scrup==true){
      for(u32 x=0;x<SCellXCount;x++){
        TSCell *pSCell=&pSCells[((TopLineNew+(SCellXCount-0))*SCellXCount)+x];
        pSCell->EffType=ESCET_FadeOut;
        pSCell->StateValue=-((SCellXCount-1)-x)*2;
      }
      for(u32 x=0;x<SCellXCount;x++){
        TSCell *pSCell=&pSCells[((TopLineNew-0)*SCellXCount)+x];
        pSCell->EffType=ESCET_FadeIn;
        pSCell->StateValue=-8-((SCellXCount-1)-x)*2;
      }
    }
    if(scrdown==true){
      for(u32 x=0;x<SCellXCount;x++){
        TSCell *pSCell=&pSCells[((TopLineNew-1)*SCellXCount)+x];
        pSCell->EffType=ESCET_FadeOut;
        pSCell->StateValue=-x*2;
      }
      for(u32 x=0;x<SCellXCount;x++){
        TSCell *pSCell=&pSCells[((TopLineNew+(SCellXCount-1))*SCellXCount)+x];
        pSCell->EffType=ESCET_FadeIn;
        pSCell->StateValue=-8-x*2;
      }
    }
    
    SCells_RequestSpriteUpdate=true;
  }
  
  deskmx=x;
}

static void CB_MouseUp(s32 x,s32 y)
{
  if(deskmf==false){
    ECornerItem ECI=GetInsideCornerItem(x,y);
    if(ECI!=ECI_None){
      if(ECI!=deskCornerItem) return;
      switch(ECI){
        case ECI_LeftUp: {
          PressNDSL();
        } break;
        case ECI_RightUp: {
          NextProc=ENP_FileSelect;
        } break;
        case ECI_CenterDown_Center: {
          NextProc=GetNextProc_SlideOpt();
        } break;
        case ECI_CenterTop_Center: {
          IPKState.ThumbnailTopPos=ImgSel_TopPos;
          ToggleDisplayMode();
          ImgSel_TopPos=IPKState.ThumbnailTopPos;
          NextProc=ENP_Thumbnail;
        } break;
        default: break;
      }
      return;
    }
  }
  
  if(deskmf==false) return;
  
  if(nextchk==true){
    if(deskpresscount<10){
      if((abs(nextmx-deskmx)<8)&&(abs(nextmy-deskmy)<8)){
        NextProc=ENP_View;
      }
    }
  }
  
  deskmf=false;
}

static void CB_Start(void)
{
  ScreenInit(ESS_Sprite64,IPKState.DisplayMode);
  
  CommandKeyDown=false;
  deskmf=false;
  deskCornerItem=ECI_None;
  
  if(isVertical==true){
    ItemWidth=48;
    ItemHeight=64;
    }else{
    ItemWidth=64;
    ItemHeight=48;
  }
  
  IPK_Start();
  {
    CglB15 *pB15=Corner_GetIcon(EIT_Mouse);
    TPoint dp=Corner_GetPoint(0);
    pScreenSub64->Mouse_Init(dp.x,dp.y,pB15->pCanvas);
  }
  DrawCornerIcon(true,0);
  
  IPK_LargeThumbnailInit();
  
  u32 CornerIcon_Blend=0;
  IPK_LargeThumbnail_StartPageIn();
  IPK_Start_PageIn();
  while(1){
    if(SCells_VSyncUpdate()==false) break;
    WaitForVBlank(true);
    if(SCells_RequestSpriteUpdate==true){
      SCells_RequestSpriteUpdate=false;
      SCells_SpriteUpdate(true);
    }
    IPK_LargeThumbnailUpdate();
    if(CornerIcon_Blend<=16){
      DrawCornerIcon(false,CornerIcon_Blend);
      CornerIcon_Blend++;
    }
  }
  
//  pScreenSubBM->SetAlpha(8); // for Debug.
}

static void CB_VsyncUpdate(u32 VsyncCount)
{
  if(SCells_RequestSpriteUpdate==true){
    SCells_RequestSpriteUpdate=false;
    SCells_SpriteUpdate(true);
  }
  IPK_LargeThumbnailUpdate();
  SCells_VSyncUpdate();
  deskpresscount++;
}

static void CB_End(void)
{
  u32 CornerIcon_Blend=16;
  IPK_LargeThumbnail_StartPageOut();
  IPK_Start_PageOut();
  while(1){
    if(SCells_VSyncUpdate()==false) break;
    WaitForVBlank(true);
    if(SCells_RequestSpriteUpdate==true){
      SCells_RequestSpriteUpdate=false;
      SCells_SpriteUpdate(false);
    }
    IPK_LargeThumbnailUpdate();
    if(0<CornerIcon_Blend){
      CornerIcon_Blend--;
      DrawCornerIcon(false,CornerIcon_Blend);
    }
  }
  
  IPK_LargeThumbnailFree();
  
  IPK_End();
  
  ScreenEnd(ESS_Sprite64);
}

void ProcThumbnail_SetCallBack(void)
{
  CallBack_Start=CB_Start;
  CallBack_VsyncUpdate=CB_VsyncUpdate;
  CallBack_End=CB_End;
  CallBack_KeyDown=CB_KeyDown;
  CallBack_KeyPress=CB_KeyPress;
  CallBack_KeyUp=CB_KeyUp;
  CallBack_MouseDown=CB_MouseDown;
  CallBack_MouseMove=CB_MouseMove;
  CallBack_MouseUp=CB_MouseUp;
}

