
#include <nds.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "_console.h"
#include "_consolewritelog.h"
#include "maindef.h"
#include "memtool.h"
#include "_const.h"
#include "lang.h"

#include "glib/glib.h"

#include "strpcm.h"
#include "plugin.h"
#include "plug_mp3_int.h"
#include "strtool.h"

#include "gba_nds_fat.h"
#include "zlibhelp.h"
#include "cstream_fs.h"
#include "cipk.h"
#include "ipkfilelist.h"
#include "ipkstate.h"
#include "corner.h"

#include "rect.h"

#include "proc_screen.h"

#define HoriScreenWidth (256)
#define HoriScreenHeight (192)

void SetNextProc(void)
{
  if(SlidePlay_ReturnToFileSelect==true){
    SlidePlay_ReturnToFileSelect=false;
    NextProc=ENP_FileSelect;
    }else{
    NextProc=GetNextProc_SlideOpt();
  }
}

static bool SkipEndEffect;

static TIPKState_SlideSetting SlideSetting;

typedef struct {
  FAT_FILE *pfilehandle;
  CStreamFS *pstream;
  CIPK *pipk;
  ENextSelect NextSelect;
  u32 ImageIndexListCount;
  u32 *ImageIndexList;
  u32 ImageIndexListIndex;
  bool RequestNext;
  CglCanvas *pOldCanvas,*pNewCanvas;
  u32 NextWaitCount;
} TCurrent;

static TCurrent Current;

static void OpenCurrent(void)
{
  TCurrent *pcur=&Current;
  
  pcur->pfilehandle=NULL;
  pcur->pstream=NULL;
  pcur->pipk=NULL;
  
  pcur->pOldCanvas=new CglCanvas(NULL,HoriScreenWidth,HoriScreenHeight,pf15bit);
  pcur->pNewCanvas=new CglCanvas(NULL,HoriScreenWidth,HoriScreenHeight,pf15bit);
  
  pcur->pOldCanvas->SetColor(GlobalBGColor15);
  pcur->pOldCanvas->FillFast(0,0,HoriScreenWidth,HoriScreenHeight);
  pcur->pNewCanvas->SetColor(GlobalBGColor15);
  pcur->pNewCanvas->FillFast(0,0,HoriScreenWidth,HoriScreenHeight);
  
  char *pfullfn=IPK_GetFullFilename(CurrentIPKFileIndex);
  pcur->pfilehandle=FAT_fopen(pfullfn,"r");
  if(pcur->pfilehandle==NULL){
    _consolePrintf("file open error.\n[%s]\n",pfullfn);
    ShowLogHalt();
  }
  pcur->pstream=new CStreamFS(pcur->pfilehandle);
  pcur->pipk=new CIPK(pcur->pstream);
  
  TIPKState_SlideSetting *pss=&SlideSetting;
  
  pcur->NextSelect=pss->NextSelect;
  pcur->ImageIndexListCount=0;
  pcur->ImageIndexList=NULL;
  pcur->ImageIndexListIndex=0;
  
  pcur->RequestNext=false;
}

static void CloseCurrent(void)
{
  TCurrent *pcur=&Current;
  
  if(pcur->pipk!=NULL){
    delete pcur->pipk; pcur->pipk=NULL;
  }
  if(pcur->pstream!=NULL){
    delete pcur->pstream; pcur->pstream=NULL;
  }
  if(pcur->pfilehandle!=NULL){
    FAT_fclose(pcur->pfilehandle);
    pcur->pfilehandle=NULL;
  }
  
  delete pcur->pOldCanvas; pcur->pOldCanvas=NULL;
  delete pcur->pNewCanvas; pcur->pNewCanvas=NULL;
  
  if(pcur->ImageIndexList!=NULL){
    safefree(pcur->ImageIndexList); pcur->ImageIndexList=NULL;
  }
}

static void CreateImageIndexList(void)
{
  TCurrent *pcur=&Current;
  
  if(pcur->ImageIndexList!=NULL){
    safefree(pcur->ImageIndexList); pcur->ImageIndexList=NULL;
  }
  
  switch(pcur->NextSelect){
    case ENS_Sequence: {
      pcur->ImageIndexListCount=pcur->pipk->GetFilesCount();
      pcur->ImageIndexList=(u32*)safemalloc(pcur->ImageIndexListCount*4);
      for(u32 idx=0;idx<(u32)pcur->ImageIndexListCount;idx++){
        pcur->ImageIndexList[idx]=idx;
      }
    } break;
    case ENS_DeletedMode: {
      _consolePrintf("pcur->NextSelect==%d is deleted.\n",pcur->NextSelect);
      ShowLogHalt();
    } break;
    case ENS_Shuffle: {
      pcur->ImageIndexListCount=pcur->pipk->GetFilesCount();
      pcur->ImageIndexList=(u32*)safemalloc(pcur->ImageIndexListCount*4);
      {
        u32 lstcnt=pcur->ImageIndexListCount;
        u32 *plst=pcur->ImageIndexList;
        for(u32 idx=0;idx<lstcnt;idx++){
          plst[idx]=(u32)-1;
        }
        for(u32 idx=0;idx<lstcnt;idx++){
          u32 r=(rand()%lstcnt)+1;
          u32 fidx=0;
          while(r!=0){
            fidx=(fidx+1)%lstcnt;
            if(plst[fidx]==(u32)-1) r--;
          }
          plst[fidx]=idx;
        }
      }
    } break;
    default: {
      _consolePrintf("Unknown NextSelect=%d\n",pcur->NextSelect);
      ShowLogHalt();
    } break;
  }
  
  pcur->ImageIndexListIndex=0;
}

static u32 GetImageIndexFromFileIndex(u32 FileIndex)
{
  TCurrent *pcur=&Current;
  
  for(u32 idx=0;idx<(u32)pcur->ImageIndexListCount;idx++){
    if(pcur->ImageIndexList[idx]==FileIndex) return(idx);
  }
  
  _consolePrintf("Fatal error!!\nGetImageIndexFromFileIndex(%d); not found.\n",FileIndex);
  ShowLogHalt();
  return(0);
}

static u32 GetFileIndexFromImageIndex(u32 ImageIndex)
{
  TCurrent *pcur=&Current;
  
  return(pcur->ImageIndexList[ImageIndex]);
}

static void SetListIndexAndLoadImage_MargeExif(u32 ImageIndex,CglCanvas *pcan)
{
  TCurrent *pcur=&Current;
  
  pcan->SetCglFont(NULL);
  pcan->SetFontBGColor(0);
  
  char *pstr;
  u32 x,y;
  
  pstr=pcur->pipk->pFileInfoExtExif_Description;
  x=pcan->GetWidth()-(pcan->GetTextWidthA(pstr)+1);
  if(x<0) x=0;
  y=1;
  
  pcan->SetFontTextColor(1);
  for(s32 py=-1;py<=1;py++){
    for(s32 px=-1;px<=1;px++){
      if((px!=0)||(py!=0)) pcan->TextOutA(x+px,y+py,pstr);
    }
  }
  pcan->SetFontTextColor(RGB15(31,31,31)|BIT15);
  pcan->TextOutA(x,y,pstr);
  
  pstr=pcur->pipk->pFileInfoExtExif_DateTime;
  x=pcan->GetWidth()-(pcan->GetTextWidthA(pstr)+1);
  if(x<0) x=0;
  y=16+1;
  
  pcan->SetFontTextColor(1);
  for(s32 py=-1;py<=1;py++){
    for(s32 px=-1;px<=1;px++){
      if((px!=0)||(py!=0)) pcan->TextOutA(x+px,y+py,pstr);
    }
  }
  pcan->SetFontTextColor(RGB15(31,31,31)|BIT15);
  pcan->TextOutA(x,y,pstr);
}

static void SetListIndexAndLoadImage(s32 ListIndex)
{
  TCurrent *pcur=&Current;
  CglCanvas *pcan=pcur->pNewCanvas;
  
  pcur->ImageIndexListIndex=ListIndex;
  
  u32 ImageIndex=pcur->ImageIndexList[ListIndex];
  
  pcan->BitBlt(pcur->pOldCanvas,0,0,HoriScreenWidth,HoriScreenHeight,0,0,false);
  pcan->SetColor(GlobalBGColor15);
  pcan->FillFast(0,0,HoriScreenWidth,HoriScreenHeight);
  
  while(strpcmUpdate_mainloop()==true){
  }
  
  TIPKThumbnail thumb;
  thumb.pBuf=NULL;
  
  switch(IPKState.DisplayMode){
    case EDM_Vertical: {
      pcur->pipk->GetThumbnail(ImageIndex,EIPKTHID_192256,&thumb);
      if(thumb.pBuf!=NULL){
        u16 *psrcbuf=thumb.pBuf;
        u32 srcbufw=thumb.Width;
        u16 *pdstbuf=pcan->GetScanLine(0);
        u32 dstbufw=pcan->GetWidth();
        
        u32 cx=(HoriScreenWidth-thumb.Height)/2;
        u32 cy=(HoriScreenHeight-thumb.Width)/2;
        pdstbuf+=cx+(dstbufw*cy);
        
        psrcbuf+=srcbufw*(thumb.Height-1);
        
        for(u32 py=0;py<thumb.Height;py++){
          for(u32 px=0;px<thumb.Width;px++){
            pdstbuf[px*dstbufw]=psrcbuf[px];
          }
          psrcbuf-=srcbufw;
          pdstbuf++;
        }
      }
    } break;
    case EDM_Horizontal: {
      pcur->pipk->GetThumbnail(ImageIndex,EIPKTHID_256192,&thumb);
      if(thumb.pBuf!=NULL){
        u16 *psrcbuf=thumb.pBuf;
        u32 srcbufw=thumb.Width;
        u16 *pdstbuf=pcan->GetScanLine(0);
        u32 dstbufw=pcan->GetWidth();
        
        u32 cx=(HoriScreenWidth-thumb.Width)/2;
        u32 cy=(HoriScreenHeight-thumb.Height)/2;
        pdstbuf+=cx+(dstbufw*cy);
        
        for(u32 py=0;py<thumb.Height;py++){
          MemCopy16DMA3(psrcbuf,pdstbuf,thumb.Width*2);
          psrcbuf+=srcbufw;
          pdstbuf+=dstbufw;
        }
      }
    } break;
    default: {
      _consolePrintf("Unknown display mode\n");
      ShowLogHalt();
    } break;
  }
  
  while(strpcmUpdate_mainloop()==true){
  }
  
  if(thumb.pBuf==NULL){
    pcan->SetCglFont(pCglFont_Large14);
    pcan->SetFontBGColor(GlobalBGColor15);
    pcan->SetFontTextColor(GlobalTextColor15);
    
    const u32 msgcnt=5;
    const char msge[msgcnt][64]={"The image was not ",
                                 "found.",
                                 "",
                                 "Is the IPK file an ",
                                 "old version?",
                                 };
    const char msgj[msgcnt][64]={"サムネイル画像が見つかり",
                                 "ませんでした。",
                                 "",
                                 "古いバージョンのIPKファ",
                                 "イルかもしれません。",
                                 };
    
    const char *pmsgUTF8;
    u32 x=8,y=16;
    for(u32 idx=0;idx<msgcnt;idx++){
      pmsgUTF8=Lang_GetTextUTF8(msge[idx],msgj[idx]);
      pcan->TextOutUTF8(x,y+(idx*20),pmsgUTF8);
    }
  }
  
  if(thumb.pBuf!=NULL){
    safefree(thumb.pBuf); thumb.pBuf=NULL;
  }
  
  while(strpcmUpdate_mainloop()==true){
  }
  
  if(pcur->pipk->GetFileInfoExtExif(ImageIndex)==true){
    switch(IPKState.DisplayMode){
      case EDM_Vertical: {
        CglCanvas *pExifCan=new CglCanvas(NULL,192-8,(16*2)+2,pf15bit);
        pExifCan->SetColor(0);
        pExifCan->FillBox(0,0,pExifCan->GetWidth(),pExifCan->GetHeight());
        SetListIndexAndLoadImage_MargeExif(ImageIndex,pExifCan);
        {
          u32 Width=pExifCan->GetWidth();
          u32 Height=pExifCan->GetHeight();
          
          u16 *psrcbuf=pExifCan->GetScanLine(0);
          u32 srcbufw=Width;
          u16 *pdstbuf=pcan->GetScanLine(0);
          u32 dstbufw=pcan->GetWidth();
          
          u32 cx=0;
          u32 cy=0;
          pdstbuf+=cx+(dstbufw*cy);
          
          psrcbuf+=srcbufw*(Height-1);
          
          for(u32 py=0;py<Height;py++){
            for(u32 px=0;px<Width;px++){
              u16 c=psrcbuf[px];
              if(c!=0){
                if(c!=1){
                  pdstbuf[px*dstbufw]=c;
                  }else{
                  u32 s=pdstbuf[px*dstbufw];
                  u32 r,g,b;
                  r=((s>>0)&0x1f)>>2;
                  g=((s>>5)&0x1f)>>2;
                  b=((s>>10)&0x1f)>>2;
                  pdstbuf[px*dstbufw]=RGB15(r,g,b)|BIT15;
                }
              }
            }
            psrcbuf-=srcbufw;
            pdstbuf++;
          }
        }
        delete pExifCan; pExifCan=NULL;
      } break;
      case EDM_Horizontal: {
        CglCanvas *pExifCan=new CglCanvas(NULL,256-8,(14*2)+2,pf15bit);
        pExifCan->SetColor(0);
        pExifCan->FillBox(0,0,pExifCan->GetWidth(),pExifCan->GetHeight());
        SetListIndexAndLoadImage_MargeExif(ImageIndex,pExifCan);
        {
          u32 Width=pExifCan->GetWidth();
          u32 Height=pExifCan->GetHeight();
          
          u16 *psrcbuf=pExifCan->GetScanLine(0);
          u32 srcbufw=Width;
          u16 *pdstbuf=pcan->GetScanLine(0);
          u32 dstbufw=pcan->GetWidth();
          
          u32 cx=0;
          u32 cy=HoriScreenHeight-Height;
          pdstbuf+=cx+(dstbufw*cy);
          
          for(u32 py=0;py<Height;py++){
            for(u32 px=0;px<Width;px++){
              u16 c=psrcbuf[px];
              if(c!=0){
                if(c!=1){
                  pdstbuf[px]=c;
                  }else{
                  u32 s=pdstbuf[px*dstbufw];
                  u32 r,g,b;
                  r=((s>>0)&0x1f)>>2;
                  g=((s>>5)&0x1f)>>2;
                  b=((s>>10)&0x1f)>>2;
                  pdstbuf[px]=RGB15(r,g,b)|BIT15;
                }
              }
            }
            psrcbuf+=srcbufw;
            pdstbuf+=dstbufw;
          }
        }
        delete pExifCan; pExifCan=NULL;
      } break;
      default: {
        _consolePrintf("Unknown display mode\n");
        ShowLogHalt();
      } break;
    }
  }
  
  while(strpcmUpdate_mainloop()==true){
  }
  
}

static void DrawCoverImage(bool toRight)
{
  TIPKThumbnail thumb;
  
  if(Current.pipk->GetCoverImage(&thumb)==false) return;
  
  CglCanvas *pcan;
  
  if(toRight==false){
    pScreenMain->End();
    }else{
    pScreenSubBM->End();
  }
  
  if((thumb.Width==256)||(thumb.Width==192)){
    if((thumb.Height==256)||(thumb.Height==192)){
      bool isVertical;
      if(thumb.Width==256){
        isVertical=false;
        }else{
        isVertical=true;
      }
      
      if(toRight==false){
        pScreenMain->Init(isVertical);
        pcan=pScreenMain->pCanvas;
        }else{
        pScreenSubBM->Init(isVertical);
        pcan=pScreenSubBM->pCanvas;
      }
      
      if(thumb.pBuf!=NULL){
        u16 *psrcbuf=thumb.pBuf;
        u32 srcbufw=thumb.Width;
        u16 *pdstbuf=pcan->GetScanLine(0);
        u32 dstbufw=pcan->GetWidth();
        
        for(u32 py=0;py<thumb.Height;py++){
          MemCopy16DMA3(psrcbuf,pdstbuf,thumb.Width*2);
          psrcbuf+=srcbufw;
          pdstbuf+=dstbufw;
        }
      }
    }
  }
  
  if(thumb.pBuf!=NULL){
    safefree(thumb.pBuf); thumb.pBuf=NULL;
  }
}

// -------------------------

static bool deskKeyPress;

static void CB_KeyDown(u32 Keys)
{
  deskKeyPress=true;
}

static void CB_KeyPress(u32 VsyncCount,u32 Keys)
{
  if(deskKeyPress==false) return;
  
  if((Keys&KEY_START)!=0){
    SkipEndEffect=true;
    SetNextProc();
    return;
  }
}

static void CB_KeyUp(u32 Keys)
{
  if(deskKeyPress==false) return;
  deskKeyPress=false;
  
  if((Keys&KEY_L)!=0){
    if(SlideSetting.StopButton==true){
      SkipEndEffect=true;
      SetNextProc();
    }
  }
}

static bool deskmf;

static void CB_MouseDown(s32 x,s32 y)
{
  deskmf=false;
  
  deskmf=true;
}

static void CB_MouseMove(s32 x,s32 y,bool CanIgnore)
{
  if(deskmf==false) return;
  if(CanIgnore==true) return;
  
}

static void CB_MouseUp(s32 x,s32 y)
{
  if(deskmf==false) return;
  deskmf=false;
  
  SkipEndEffect=true;
  SetNextProc();
}

// -----------------------------------------------------------------

static char **ppBGMAliasList;
static u32 BGMAliasListCount;
static u32 BGMAliasListIndex;

static FAT_FILE *pBGMFileHandle;

static void BGM_CreateListFromPath(const char *pPath)
{
  _consolePrintf("FindBGMFiles.%s\n",pPath);
  
  BGMAliasListCount=0;
  
  if(FAT_CWD(pPath)==false) return;
  
  char afn[MaxFilenameLength];
  
  {
    u32 FAT_FileType;
    FAT_FileType=FAT_FindFirstFile(afn);
    
    while(FAT_FileType!=FT_NONE){
      switch(FAT_FileType){
        case FT_NONE: break;
        case FT_DIR: {
        } break;
        case FT_FILE: {
          if(isStrEqual_NoCaseSensitive(&afn[StrGetLength(afn)-4],".MP3")==true){
            BGMAliasListCount++;
          }
        } break;
      }
      
      FAT_FileType=FAT_FindNextFile(afn);
    }
  }
  
  ppBGMAliasList=(char**)safemalloc(BGMAliasListCount*4);
  for(u32 idx=0;idx<BGMAliasListCount;idx++){
    ppBGMAliasList[idx]=NULL;
  }
  
  EBGMSelect BGMSelect=IPKState.SlideSetting.BGMSelect;
  u32 seqidx=0;
  
  {
    u32 FAT_FileType;
    FAT_FileType=FAT_FindFirstFile(afn);
    
    while(FAT_FileType!=FT_NONE){
      switch(FAT_FileType){
        case FT_NONE: break;
        case FT_DIR: {
        } break;
        case FT_FILE: {
          if(isStrEqual_NoCaseSensitive(&afn[StrGetLength(afn)-4],".MP3")==true){
            switch(BGMSelect){
              case EBS_Sequence: {
                ppBGMAliasList[seqidx]=(char*)safemalloc(MaxFilenameLength);
                snprintf(ppBGMAliasList[seqidx],MaxFilenameLength,"%s/%s",pPath,afn);
                seqidx++;
              } break;
              case EBS_Shuffle: {
                u32 r=(rand()%BGMAliasListCount)+1;
                u32 fidx=0;
                while(r!=0){
                  fidx=(fidx+1)%BGMAliasListCount;
                  if(ppBGMAliasList[fidx]==NULL) r--;
                }
                ppBGMAliasList[fidx]=(char*)safemalloc(MaxFilenameLength);
                snprintf(ppBGMAliasList[fidx],MaxFilenameLength,"%s/%s",pPath,afn);
              } break;
              default: break;
            }
          }
        } break;
      }
      
      FAT_FileType=FAT_FindNextFile(afn);
    }
  }
}

static void BGM_CreateListFromFilename(const char *pFilename)
{
  BGMAliasListCount=1;
  ppBGMAliasList=(char**)safemalloc(BGMAliasListCount*4);
  ppBGMAliasList[0]=(char*)safemalloc(MaxFilenameLength);
  strcpy(ppBGMAliasList[0],pFilename);
}

static void BGM_PlayIndex(const u32 idx)
{
  pBGMFileHandle=NULL;
  
  if(BGMAliasListCount==0) return;
  
  pBGMFileHandle=FAT_fopen(ppBGMAliasList[BGMAliasListIndex],"r");
  if(pBGMFileHandle==NULL) return;
  
  _consolePrintf("pBGMFileHandle=0x%x\n",pBGMFileHandle);
  
  if(PluginMP3_Start((int)pBGMFileHandle)==false){
    FAT_fclose(pBGMFileHandle); pBGMFileHandle=NULL;
    return;
  }
  strpcmStart(true,PluginMP3_GetSampleRate(),PluginMP3_GetSamplePerFrame(),PluginMP3_GetChannelCount(),strpcmFormat_PCMx4);
}

static void BGM_Stop(bool WaitForEmpty)
{
  if(pBGMFileHandle!=NULL){
    if(WaitForEmpty==true){
      strpcmRingEmptyFlag=false;
      while(strpcmRingEmptyFlag==false){ cwl();
        swiWaitForIRQ();
      }
    }
    strpcmStop();
    PluginMP3_Free();
    FAT_fclose(pBGMFileHandle); pBGMFileHandle=NULL;
  }
}

static void Plugin_BGMStart(void)
{
  pBGMFileHandle=NULL;
  
  ppBGMAliasList=NULL;
  BGMAliasListCount=0;
  
  switch(IPK_GetBGMType(CurrentIPKFileIndex)){
    case EBT_None: {
    } break;
    case EBT_GlobalFile: {
      BGM_CreateListFromFilename(IPK_GetGlobalBGMFilename());
    } break;
    case EBT_GlobalPath: {
      BGM_CreateListFromPath(IPK_GetGlobalBGMFilePath());
    } break;
    case EBT_File: {
      BGM_CreateListFromFilename(IPK_GetBGMFilename(CurrentIPKFileIndex));
    } break;
    case EBT_Path: {
      BGM_CreateListFromPath(IPK_GetBGMPath(CurrentIPKFileIndex));
    } break;
    default: {
    }
  }
  
  if(BGMAliasListCount==0) return;
  
  BGMAliasListIndex=0;
  BGM_PlayIndex(BGMAliasListIndex);
}

static void Plugin_BGMEnd(void)
{
  BGM_Stop(false);
  if(pBGMFileHandle!=NULL){
    strpcmStop();
    PluginMP3_Free();
    FAT_fclose(pBGMFileHandle); pBGMFileHandle=NULL;
  }
  
  if(ppBGMAliasList!=NULL){
    for(u32 idx=0;idx<BGMAliasListCount;idx++){
      if(ppBGMAliasList[idx]!=NULL){
        safefree(ppBGMAliasList[idx]); ppBGMAliasList[idx]=NULL;
      }
    }
    BGMAliasListCount=0;
    safefree(ppBGMAliasList); ppBGMAliasList=NULL;
  }
}

static void CB_strpcmRequestStop(void)
{
  BGM_Stop(true);
  
  if(BGMAliasListCount==0) return;
  
  BGMAliasListIndex++;
  if(BGMAliasListIndex==BGMAliasListCount) BGMAliasListIndex=0;
  BGM_PlayIndex(BGMAliasListIndex);
}

// -----------------------------------------------------------

static void CB_Start(void)
{
  ScreenInit(ESS_Bitmap,EDM_Horizontal);
  
  if(false){ // Mouse disabled.
    const u32 s=CornerIconSize;
    const u32 x=256-s;
    const u32 y=256-s;
    CglB15 *pB15=Corner_GetIcon(EIT_Mouse);
    pScreenSubBM->Mouse_Init(x,y,pB15->pCanvas);
  }
  
  deskKeyPress=false;
  deskmf=false;
  
  SkipEndEffect=false;
  
  SlideSetting=IPKState.SlideSetting;
  
  TCurrent *pcur=&Current;
  TIPKState_SlideSetting *pss=&SlideSetting;
  
  bool SingleDisplayMode;
  
  switch(pss->FadeType){
    case EFT_RightToLeft: case EFT_LeftToRight: {
      SingleDisplayMode=false;
    } break;
    default: {
      SingleDisplayMode=true;
    } break;
  }
  
  {
    u16 bgcol=GlobalBGColor15;
    if(SingleDisplayMode==true) bgcol=RGB15(0,0,0)|BIT15;
    
    {
      CglCanvas *pcan=pScreenMain->pCanvas;
      pcan->SetColor(bgcol);
      pcan->FillAll();
    }
    {
      CglCanvas *pcan=pScreenSubBM->pCanvas;
      pcan->SetColor(bgcol);
      pcan->FillAll();
    }
  }
  
  PrintFreeMem();
  
  OpenCurrent();
  CreateImageIndexList();
  
  pcur->ImageIndexListIndex=(u32)-1;
  pcur->RequestNext=true;
  pcur->NextWaitCount=0;
  
  if(SingleDisplayMode==true){
    switch(pss->FadeSingleDisplay){
      case EFSD_Left: DrawCoverImage(true); break; // to Right
      case EFSD_Right: DrawCoverImage(false); break; // to Left
      default: break;
    }
  }
  
  pScreenMain->SetWhiteOut(0);
  pScreenSubBM->SetAlpha(16);
  
//  pScreenSubBM->SetAlpha(8); // for Debug.
  
  strpcmSetVolume16(16);
  Plugin_BGMStart();
}

static void SingleDisplay_SetAlpha(u32 Alpha)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  
  switch(pss->FadeSingleDisplay){
    case EFSD_Left: pScreenMain->SetWhiteOut(16-Alpha); break;
    case EFSD_Right: pScreenSubBM->SetAlpha(Alpha); break;
  }
}

static void CB_VsyncUpdate(u32 VsyncCount)
{
  if(IPCEX->PanelClosed==true) return;
  
  TCurrent *pcur=&Current;
  TIPKState_SlideSetting *pss=&SlideSetting;
  
  static u32 StateValue;
  static u32 LastState,BlindLastY;
  
  if(pcur->RequestNext==true){
    pcur->RequestNext=false;
    if(pcur->ImageIndexListIndex==(u32)-1){
      pcur->NextWaitCount=0;
      pcur->ImageIndexListIndex=GetImageIndexFromFileIndex(IPKState.ImageIndex);
      SetListIndexAndLoadImage(pcur->ImageIndexListIndex);
      }else{
      IPKState.ImageIndex=GetFileIndexFromImageIndex(pcur->ImageIndexListIndex);
      pcur->NextWaitCount=SlideSetting.WaitSec*60;
      if((pcur->ImageIndexListIndex+1)==pcur->ImageIndexListCount){
        if(pss->LoopPlay==true){
          pcur->ImageIndexListIndex=(u32)-1;
          }else{
          SkipEndEffect=false;
          SetNextProc();
          return;
        }
      }
      SetListIndexAndLoadImage(pcur->ImageIndexListIndex+1);
    }
    StateValue=0;
    LastState=0;
    BlindLastY=0;
    return;
  }
  
  if(pcur->NextWaitCount!=0){
    if(VsyncCount<pcur->NextWaitCount){
      pcur->NextWaitCount-=VsyncCount;
      }else{
      pcur->NextWaitCount=0;
    }
    return;
  }
  
  CglCanvas *pOldCan=pcur->pOldCanvas;
  CglCanvas *pNewCan=pcur->pNewCanvas;
  CglScreenMain *pUpScr=pScreenMain;
  CglCanvas *pUpCan=pUpScr->pCanvas;
  CglScreenSubBM *pDownScr=pScreenSubBM;
  CglCanvas *pDownCan=pDownScr->pCanvas;
  CglCanvas *pSingleCan;
  
  switch(pss->FadeSingleDisplay){
    case EFSD_Left: pSingleCan=pScreenMain->pCanvas; break;
    case EFSD_Right: pSingleCan=pScreenSubBM->pCanvas; break;
    default: {
      _consolePrintf("Unknown FadeSingleDisplay type.\n");
      return;
    } break;
  }
  
  switch(pss->FadeType){
    case EFT_RightToLeft: {
      u32 state=StateValue;
      if(StateValue==0){
        StateValue++;
        }else{
        switch(pss->FadeSpeed){
          case EFS_Slow: StateValue+=VsyncCount*1; break;
          case EFS_Norm: StateValue+=VsyncCount*2; break;
          case EFS_Fast: StateValue+=VsyncCount*4; break;
        }
      }
      if(HoriScreenHeight<=LastState){
        swiWaitForVBlank();
        REG_IME=0;
        pUpScr->SetOffsetY(64);
        pOldCan->BitBlt(pUpCan,0,64,HoriScreenWidth,HoriScreenHeight,0,0,false);
        REG_IME=1;
        swiWaitForVBlank();
        REG_IME=0;
        pDownScr->SetOffsetY(64);
        pNewCan->BitBlt(pDownCan,0,64,HoriScreenWidth,HoriScreenHeight,0,0,false);
        REG_IME=1;
        pcur->RequestNext=true;
        }else{
        if(HoriScreenHeight<state) state=HoriScreenHeight;
        
        if(pBGMFileHandle!=NULL) swiWaitForVBlank();
        REG_IME=0;
        pUpScr->SetOffsetY(64+LastState);
        pOldCan->BitBlt(pUpCan,0,(192+64+LastState)&0xff,HoriScreenWidth,state-LastState,0,LastState,false);
        REG_IME=1;
        if(pBGMFileHandle!=NULL) swiWaitForVBlank();
        REG_IME=0;
        pDownScr->SetOffsetY(64+LastState);
        pNewCan->BitBlt(pDownCan,0,(192+64+LastState)&0xff,HoriScreenWidth,state-LastState,0,LastState,false);
        REG_IME=1;
        
        LastState=state;
      }
    } break;
    case EFT_LeftToRight: {
      u32 state=StateValue;
      if(StateValue==0){
        StateValue++;
        }else{
        switch(pss->FadeSpeed){
          case EFS_Slow: StateValue+=VsyncCount*1; break;
          case EFS_Norm: StateValue+=VsyncCount*2; break;
          case EFS_Fast: StateValue+=VsyncCount*4; break;
        }
      }
      if(HoriScreenHeight<=LastState){
        swiWaitForVBlank();
        REG_IME=0;
        pDownScr->SetOffsetY(0);
        pOldCan->BitBlt(pDownCan,0,0,HoriScreenWidth,HoriScreenHeight,0,0,false);
        REG_IME=1;
        swiWaitForVBlank();
        REG_IME=0;
        pUpScr->SetOffsetY(0);
        pNewCan->BitBlt(pUpCan,0,0,HoriScreenWidth,HoriScreenHeight,0,0,false);
        REG_IME=1;
        pcur->RequestNext=true;
        }else{
        if(HoriScreenHeight<state) state=HoriScreenHeight;
        
        if(pBGMFileHandle!=NULL) swiWaitForVBlank();
        REG_IME=0;
        pDownScr->SetOffsetY(-LastState);
        pOldCan->BitBlt(pDownCan,0,(256-state)&0xff,HoriScreenWidth,state-LastState,0,HoriScreenHeight-state,false);
        REG_IME=1;
        if(pBGMFileHandle!=NULL) swiWaitForVBlank();
        REG_IME=0;
        pUpScr->SetOffsetY(-LastState);
        pNewCan->BitBlt(pUpCan,0,(256-state)&0xff,HoriScreenWidth,state-LastState,0,HoriScreenHeight-state,false);
        REG_IME=1;
        
        LastState=state;
      }
    } break;
    case EFT_SingleFade: {
      u32 state=StateValue;
      if(StateValue==0){
        StateValue++;
        }else{
        switch(pss->FadeSpeed){
          case EFS_Slow: StateValue+=VsyncCount*1; break;
          case EFS_Norm: StateValue+=VsyncCount*2; break;
          case EFS_Fast: StateValue+=VsyncCount*3; break;
        }
      }
      u32 nextstate=StateValue;
      if((32*4)<nextstate){
        pNewCan->BitBlt(pSingleCan,0,0,HoriScreenWidth,HoriScreenHeight,0,0,false);
        SingleDisplay_SetAlpha(16);
        pcur->RequestNext=true;
        }else{
        if((state<=(16*4))&&((16*4)<nextstate)){
          SingleDisplay_SetAlpha(0);
          pNewCan->BitBlt(pSingleCan,0,0,HoriScreenWidth,HoriScreenHeight,0,0,false);
        }
        u32 lev=nextstate/4;
        if(lev<16){
          SingleDisplay_SetAlpha(16-lev);
          }else{
          SingleDisplay_SetAlpha(lev-16);
        }
      }
    } break;
    case EFT_SingleFlash: {
      pNewCan->BitBlt(pSingleCan,0,0,HoriScreenWidth,HoriScreenHeight,0,0,false);
      pcur->RequestNext=true;
    } break;
    case EFT_SingleBlind: {
      u32 state=StateValue;
      if(StateValue==0){
        StateValue++;
        }else{
        switch(pss->FadeSpeed){
          case EFS_Slow: StateValue+=VsyncCount*1; break;
          case EFS_Norm: StateValue+=VsyncCount*2; break;
          case EFS_Fast: StateValue+=VsyncCount*3; break;
        }
      }
      u32 nextstate=StateValue;
      if((32*4)<nextstate){
        pNewCan->BitBlt(pSingleCan,0,0,HoriScreenWidth,HoriScreenHeight,0,0,false);
        pcur->RequestNext=true;
        }else{
        u32 sy=state/4;
        for(u32 cnt=BlindLastY+1;cnt<=sy;cnt++){
          for(u32 y=cnt;y<HoriScreenHeight;y+=32){
            pNewCan->BitBlt(pSingleCan,0,y,HoriScreenWidth,1,0,y,false);
          }
        }
        BlindLastY=sy;
      }
    } break;
    case EFT_SingleCrossFade: {
      u32 state=StateValue;
      if(StateValue==0){
        StateValue++;
        }else{
        switch(pss->FadeSpeed){
          case EFS_Slow: StateValue+=VsyncCount*1; break;
          case EFS_Norm: StateValue+=VsyncCount*2; break;
          case EFS_Fast: StateValue+=VsyncCount*3; break;
        }
      }
      u32 nextstate=StateValue;
      if((32*4)<nextstate){
        pNewCan->BitBlt(pSingleCan,0,0,HoriScreenWidth,HoriScreenHeight,0,0,false);
        pcur->RequestNext=true;
        }else{
        u32 alpha=state/4;
        u32 ialpha=32-alpha;
        u16 *pOldBuf=pOldCan->GetScanLine(0);
        u16 *pNewBuf=pNewCan->GetScanLine(0);
        u16 *pDstBufMst=(u16*)safemalloc(HoriScreenWidth*HoriScreenHeight*2);
        u16 *pDstBuf=pDstBufMst;
        for(u32 y=0;y<HoriScreenHeight;y++){
          for(u32 x=0;x<HoriScreenWidth;x++){
            u16 col1=pOldBuf[x];
            u32 r1,g1,b1;
            r1=((col1>>0)&0x1f)*ialpha/32;
            g1=((col1>>5)&0x1f)*ialpha/32;
            b1=((col1>>10)&0x1f)*ialpha/32;
            u16 col2=pNewBuf[x];
            u32 r2,g2,b2;
            r2=((col2>>0)&0x1f)*alpha/32;
            g2=((col2>>5)&0x1f)*alpha/32;
            b2=((col2>>10)&0x1f)*alpha/32;
            pDstBuf[x]=RGB15(r1+r2,g1+g2,b1+b2)|BIT15;
          }
          pOldBuf+=HoriScreenWidth;
          pNewBuf+=HoriScreenWidth;
          pDstBuf+=HoriScreenWidth;
        }
        MemCopy16DMA3(pDstBufMst,pSingleCan->GetScanLine(0),HoriScreenWidth*HoriScreenHeight*2);
        safefree(pDstBufMst); pDstBufMst=NULL;
      }
    } break;
    default: {
      _consolePrintf("Unknown FadeType=%d\n",pss->FadeType);
    } break;
  }
}

static void CB_End(void)
{
  CloseCurrent();
  
  if(SkipEndEffect==false){
    for(u32 w=0;w<SlideSetting.WaitSec*60;w++){
      while(strpcmUpdate_mainloop()==true){
      }
      WaitForVBlank(true);
    }
  }
  
  for(u32 lev=0;lev<=16;lev++){
    strpcmSetVolume16(16-lev);
    while(strpcmUpdate_mainloop()==true){
    }
    WaitForVBlank(true);
    pScreenMain->SetWhiteOut(lev);
    pScreenSubBM->SetAlpha(16-lev);
  }
  
  Plugin_BGMEnd();
  
  ScreenEnd(ESS_Bitmap);
}

void ProcSlidePlay_SetCallBack(void)
{
  CallBack_Start=CB_Start;
  CallBack_VsyncUpdate=CB_VsyncUpdate;
  CallBack_End=CB_End;
  CallBack_KeyDown=CB_KeyDown;
  CallBack_KeyPress=CB_KeyPress;
  CallBack_KeyUp=CB_KeyUp;
  CallBack_MouseDown=CB_MouseDown;
  CallBack_MouseMove=CB_MouseMove;
  CallBack_MouseUp=CB_MouseUp;
  CallBack_strpcmRequestStop=CB_strpcmRequestStop;
}

