
#include <nds.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "_console.h"
#include "_consolewritelog.h"
#include "maindef.h"
#include "memtool.h"
#include "_const.h"
#include "lang.h"
#include "extmem.h"
#include "md5_global.h"
#include "md5.h"

#include "glib/glib.h"

#include "gba_nds_fat.h"
#include "mediatype.h"
#include "zlibhelp.h"
#include "cstream_fs.h"
#include "cipk.h"
#include "ipkfilelist.h"
#include "ipkstate.h"
#include "corner.h"

#include "rect.h"
#include "component.h"

#include "proc_screen.h"

#define BGColor15 (RGB15(25,22,23) | BIT15)

static TIPKState_SlideSetting SlideSetting;

enum ECompLabels {ECLS_TitleLbl,ECLS_ROMTitle,ECLS_ROMVersion,ECLS_ROMDate,ECLS_FreeMemory,ECLS_MediaName,ECLS_ExtMemType,ECLS_ExtMemSize,
                  ECLS_ChkState,ECLS_ChkArea,ECLS_ChkStatus,ECLSCount};
#define CompLabelsCount (ECLSCount)
static TComponentLabel CompLabels[CompLabelsCount];

enum ECompChecks {ECCSCount};
#define CompChecksCount (ECCSCount)
static TComponentCheck CompChecks[CompChecksCount];

enum ECompButtons {ECBS_Page1Btn,ECBS_Page2Btn,ECBS_Page3Btn,ECBS_Page4Btn,ECBS_CancelBtn,ECBSCount};
#define CompButtonsCount (ECBSCount)
static TComponentButton CompButtons[CompButtonsCount];

typedef struct {
  EextmemType Type;
  u32 Size;
  u32 BlockSize;
  u32 BlockCount;
  u32 BlockIndex;
  u32 *pBlockHashs;
  u32 *pBlockBuf;
  bool MakeHash;
  u32 SuccessCount,ErrorCount;
  bool ErrorFlag;
} TExtMem;

static TExtMem ExtMem;

static u32 SignalLineTop;

static void SlideSetting_Redraw(bool FullDraw)
{
  if(FullDraw==true){
    CglCanvas *pcan=pScreenSubBM->pCanvas;
    
    u32 TitleHeight=30;
    pcan->SetColor(GlobalBGColor15);
    pcan->FillFast(0,0,ScreenWidth,TitleHeight);
    pcan->SetColor(BGColor15);
    pcan->FillFast(0,TitleHeight,ScreenWidth,ScreenHeight-TitleHeight);
  }
  
  if(FullDraw==true){
    for(u32 idx=0;idx<CompLabelsCount;idx++){
      ComponentLabel_Draw(&CompLabels[idx]);
    }
    for(u32 idx=0;idx<CompChecksCount;idx++){
      ComponentCheck_Draw(&CompChecks[idx]);
    }
    for(u32 idx=0;idx<CompButtonsCount;idx++){
      ComponentButton_Draw(&CompButtons[idx]);
    }
    }else{
  }
}

static void ExtMem_Redraw(void)
{
  ComponentLabel_Draw(&CompLabels[ECLS_ChkState]);
  ComponentLabel_Draw(&CompLabels[ECLS_ChkStatus]);
  ComponentLabel_Draw(&CompLabels[ECLS_ChkArea]);
}

static void CB_Page1Btn_Click(void *pComponentButton)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->SlideOptPage=1;
  NextProc=ENP_SlideOpt1;
}

static void CB_Page2Btn_Click(void *pComponentButton)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->SlideOptPage=2;
  NextProc=ENP_SlideOpt2;
}

static void CB_Page3Btn_Click(void *pComponentButton)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->SlideOptPage=3;
  NextProc=ENP_SlideOpt3;
}

static void CB_Page4Btn_Click(void *pComponentButton)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->SlideOptPage=4;
  NextProc=ENP_SlideOpt4;
}

static void CB_CancelBtn_Click(void *pComponentButton)
{
  NextProc=ENP_Thumbnail;
}

static void CompsInit(void)
{
  CglCanvas *pcan=pScreenSubBM->pCanvas;
  
  for(u32 idx=0;idx<CompLabelsCount;idx++){
    ComponentLabel_Init(&CompLabels[idx],pcan);
    CompLabels[idx].BGColor=BGColor15;
  }
  for(u32 idx=0;idx<CompChecksCount;idx++){
    ComponentCheck_Init(&CompChecks[idx],pcan);
    CompChecks[idx].BGColor=BGColor15;
  }
  for(u32 idx=0;idx<CompButtonsCount;idx++){
    ComponentButton_Init(&CompButtons[idx],pcan);
    CompButtons[idx].BGColor=BGColor15;
  }
  
  s32 chksize=16;
  
  s32 x,y;
  
  x=ScreenWidth-68-2;
  y=8-2;
  
  {
    TComponentButton *pcb=&CompButtons[ECBS_Page1Btn];
    pcb->CallBack_Click=CB_Page1Btn_Click;
    pcb->Rect=CreateRect(x,y,14,chksize+2);
    pcb->pMsgUTF8_eng="1";
    pcb->pMsgUTF8_jpn="1";
  }
  
  x+=18;
  
  {
    TComponentButton *pcb=&CompButtons[ECBS_Page2Btn];
    pcb->CallBack_Click=CB_Page2Btn_Click;
    pcb->Rect=CreateRect(x,y,14,chksize+2);
    pcb->pMsgUTF8_eng="2";
    pcb->pMsgUTF8_jpn="2";
  }
  
  x+=18;
  
  {
    TComponentButton *pcb=&CompButtons[ECBS_Page3Btn];
    pcb->CallBack_Click=CB_Page3Btn_Click;
    pcb->Rect=CreateRect(x,y,14,chksize+2);
    pcb->pMsgUTF8_eng="3";
    pcb->pMsgUTF8_jpn="3";
  }
  
  x+=18;
  
  {
    TComponentButton *pcb=&CompButtons[ECBS_Page4Btn];
    pcb->CallBack_Click=CB_Page4Btn_Click;
    pcb->Rect=CreateRect(x,y,14,chksize+2);
    pcb->pMsgUTF8_eng="4";
    pcb->pMsgUTF8_jpn="4";
    pcb->Pressing=true;
  }
  
  x=4;
  y=8;
  
  {
    TComponentLabel *pcl=&CompLabels[ECLS_TitleLbl];
    pcl->BGColor=GlobalBGColor15;
    pcl->Rect=CreateRect(x,y,0,0);
    pcl->pMsgUTF8_eng="Property sheet";
    pcl->pMsgUTF8_jpn="プロパティシート";
  }
  
  x=4;
  y+=14+8+8;
  
  {
    TComponentLabel *pcl=&CompLabels[ECLS_ROMTitle];
    pcl->Rect=CreateRect(x,y,0,0);
    pcl->pFont=NULL;
    pcl->pMsgUTF8_eng=ROMTITLE;
    pcl->pMsgUTF8_jpn=pcl->pMsgUTF8_eng;
  }
  
  y+=14;
  
  {
    TComponentLabel *pcl=&CompLabels[ECLS_ROMVersion];
    pcl->Rect=CreateRect(x,y,0,0);
    pcl->pFont=NULL;
    pcl->pMsgUTF8_eng=ROMVERSION;
    pcl->pMsgUTF8_jpn=pcl->pMsgUTF8_eng;
  }
  
  y+=14;
  
  {
    TComponentLabel *pcl=&CompLabels[ECLS_ROMDate];
    pcl->Rect=CreateRect(x,y,0,0);
    pcl->pFont=NULL;
    pcl->pMsgUTF8_eng=ROMDATE;
    pcl->pMsgUTF8_jpn=pcl->pMsgUTF8_eng;
  }
  
  y+=14;
  
  {
    TComponentLabel *pcl=&CompLabels[ECLS_FreeMemory];
    pcl->Rect=CreateRect(x,y,0,0);
    pcl->pFont=NULL;
    static char msg[64];
    snprintf(msg,64,"FreeMemory:%dbyte.",GetFreeMem());
    pcl->pMsgUTF8_eng=msg;
    pcl->pMsgUTF8_jpn=pcl->pMsgUTF8_eng;
  }
  
  y+=8;
  
  y+=16;
  
  {
    TComponentLabel *pcl=&CompLabels[ECLS_MediaName];
    pcl->Rect=CreateRect(x,y,0,0);
    pcl->pMsgUTF8_eng=DIMediaName;
    pcl->pMsgUTF8_jpn=DIMediaName;
  }
  
  y+=16;
  
  {
    TComponentLabel *pcl=&CompLabels[ECLS_ExtMemType];
    pcl->Rect=CreateRect(x,y,0,0);
    char *pe="",*pj="";
    switch(ExtMem.Type){
      case EEMT_Unknown: {
        pe="Not detect memory.";
        pj="拡張メモリ未検出";
      } break;
      case EEMT_M3: {
        pe="M3/PSRAM for GBA";
        pj=pe;
      } break;
      case EEMT_SC: {
        pe="SC/DRAM for GBA";
        pj=pe;
      } break;
      case EEMT_EZ4: {
        pe="EZ4/PSRAM for GBA";
        pj=pe;
      } break;
      case EEMT_DSBM: {
        pe="DSBrowser Memory";
        pj="DSブラウザ拡張メモリ";
      } break;
      case EEMT_EZ3in1: {
        pe="EZ3in1 ExtendPack";
        pj="EZ3in1拡張パック";
      } break;
    }
    static char msge[64],msgj[64];
    snprintf(msge,64,"Type:%s",pe);
    snprintf(msgj,64,"Type:%s",pj);
    pcl->pMsgUTF8_eng=msge;
    pcl->pMsgUTF8_jpn=msgj;
  }
  
  y+=16;
  
  {
    TComponentLabel *pcl=&CompLabels[ECLS_ExtMemSize];
    pcl->Rect=CreateRect(x,y,0,0);
    static char msg[64];
    snprintf(msg,64,"Size:%dMBit (%dMByte)",ExtMem.Size*8/1024/1024,ExtMem.Size/1024/1024);
    pcl->pMsgUTF8_eng=msg;
    pcl->pMsgUTF8_jpn=msg;
  }
  
  y+=10;
  
  y+=16;
  
  {
    TComponentLabel *pcl=&CompLabels[ECLS_ChkState];
    static char msge[64]="Standby...",msgj[64]="待機中...";
    pcl->Rect=CreateRect(x,y,192,0);
    pcl->pMsgUTF8_eng=msge;
    pcl->pMsgUTF8_jpn=msgj;
  }
  
  y+=16;
  
  {
    TComponentLabel *pcl=&CompLabels[ECLS_ChkArea];
    static char msge[64]="",msgj[64]="";
    pcl->Rect=CreateRect(x,y+1,192,0);
    pcl->pFont=NULL;
    pcl->pMsgUTF8_eng=msge;
    pcl->pMsgUTF8_jpn=msgj;
  }
  
  y+=16;
  
  {
    TComponentLabel *pcl=&CompLabels[ECLS_ChkStatus];
    static char msge[64],msgj[64];
    pcl->Rect=CreateRect(x,y,192,0);
    snprintf(msge,64,"Success.%d Error.%d",ExtMem.SuccessCount,ExtMem.ErrorCount);
    snprintf(msgj,64,"成功.%d エラー.%d",ExtMem.SuccessCount,ExtMem.ErrorCount);
    pcl->pMsgUTF8_eng=msge;
    pcl->pMsgUTF8_jpn=msgj;
  }
  
  y+=16;
  
  SignalLineTop=y;
  
  x=(ScreenWidth-((80*2)+16))/2;
  y=ScreenHeight-(chksize+2)-8;
  
  x+=16+80;
  
  {
    TComponentButton *pcb=&CompButtons[ECBS_CancelBtn];
    pcb->CallBack_Click=CB_CancelBtn_Click;
    pcb->pIconCanvas=Component_GetIcon(ECIT_Cancel)->pCanvas;
    pcb->Rect=CreateRect(x,y,80,chksize+2);
    pcb->pMsgUTF8_eng="Cancel";
    pcb->pMsgUTF8_jpn="戻る";
  }
}

static void CB_KeyDown(u32 Keys)
{
}

static void CB_KeyPress(u32 VsyncCount,u32 Keys)
{
}

static void CB_KeyUp(u32 Keys)
{
}

static bool deskmf;
static TComponentButton *pPressingButton;

static void CB_MouseDown(s32 x,s32 y)
{
  deskmf=false;
  
  for(u32 idx=0;idx<CompButtonsCount;idx++){
    TComponentButton *pcb=&CompButtons[idx];
    if(ComponentButton_GetIndexFromPos(pcb,x,y)!=-1){
      pPressingButton=pcb;
      pcb->Pressing=true;
      ComponentButton_Draw(pcb);
    }
  }
  
  deskmf=true;
}

static void CB_MouseMove(s32 x,s32 y,bool CanIgnore)
{
  if(deskmf==false) return;
  if(CanIgnore==true) return;
  
  for(u32 idx=0;idx<CompButtonsCount;idx++){
    TComponentButton *pcb=&CompButtons[idx];
    if(pcb==pPressingButton){
      if(ComponentButton_GetIndexFromPos(pcb,x,y)==-1){
        if(pcb->Pressing==true){
          pcb->Pressing=false;
          ComponentButton_Draw(pcb);
        }
        }else{
        if(pcb->Pressing==false){
          pcb->Pressing=true;
          ComponentButton_Draw(pcb);
        }
      }
    }
  }
}

static void CB_MouseUp(s32 x,s32 y)
{
  if(deskmf==false) return;
  
  deskmf=false;
  
  if(pPressingButton!=NULL){
    pPressingButton->Pressing=false;
    ComponentButton_Draw(pPressingButton);
    
    for(u32 idx=0;idx<CompButtonsCount;idx++){
      TComponentButton *pcb=&CompButtons[idx];
      if(pcb==pPressingButton){
        if(ComponentButton_GetIndexFromPos(pcb,x,y)!=-1){
          ComponentButton_MouseUp(&CompButtons[idx],x,y);
        }
      }
    }
    
    pPressingButton=NULL;
    return;
  }
  
  for(u32 idx=0;idx<CompLabelsCount;idx++){
    ComponentLabel_MouseUp(&CompLabels[idx],x,y);
  }
  for(u32 idx=0;idx<CompChecksCount;idx++){
    ComponentCheck_MouseUp(&CompChecks[idx],x,y);
  }
  for(u32 idx=0;idx<CompButtonsCount;idx++){
  }
}

static void CB_Start(void)
{
  ScreenInit(ESS_Bitmap,EDM_Vertical);
  
  {
    const u32 s=CornerIconSize;
    const u32 x=ScreenWidth;
    const u32 y=ScreenHeight-(s*8);
    CglB15 *pB15=Corner_GetIcon(EIT_Mouse);
    pScreenSubBM->Mouse_Init(x,y+(s*0),pB15->pCanvas);
  }
  
  {
    CglCanvas *pcan=pScreenMain->pCanvas;
    pcan->SetColor(BGColor15);
    pcan->FillAll();
  }
  {
    CglCanvas *pcan=pScreenSubBM->pCanvas;
    pcan->SetColor(BGColor15);
    pcan->FillAll();
  }
  
  DrawSlideOptLeft(4);
  
  deskmf=false;
  pPressingButton=NULL;
  
  pScreenMain->SetWhiteOut(16);
  pScreenSubBM->SetAlpha(0);
  
  extmem_Init();
  
  TExtMem *pem=&ExtMem;
  
  pem->Type=extmem_GetMemType();
  pem->Size=extmem_GetMemSize();
  pem->SuccessCount=0;
  pem->ErrorCount=0;
  pem->ErrorFlag=false;
  pem->BlockIndex=0;
  pem->MakeHash=true;
  if(extmem_ExistMemory()==false){
    pem->BlockSize=0;
    pem->BlockCount=0;
    pem->pBlockHashs=NULL;
    pem->pBlockBuf=NULL;
    }else{
    pem->BlockSize=128*1024; // 128kbyte
    pem->BlockCount=pem->Size/pem->BlockSize;
    pem->pBlockHashs=(u32*)safemalloc(pem->BlockCount*4);
    pem->pBlockBuf=(u32*)safemalloc(pem->BlockSize);
    extmem_SetCount(pem->BlockCount);
    for(u32 idx=0;idx<pem->BlockCount;idx++){
      if(extmem_Alloc(idx,pem->BlockSize)==false){
        _consolePrintf("extmem_Alloc(%d,%d); error.\n",idx,pem->BlockSize);
        ShowLogHalt();
      }
    }
  }
  
  CompsInit();
  
  SlideSetting=IPKState.SlideSetting;
  
//  pScreenSubBM->SetAlpha(8); // for Debug.
  
  SlideSetting_Redraw(true);
  
  for(u32 lev=0;lev<=16;lev+=2){
    WaitForVBlank(true);
    pScreenMain->SetWhiteOut(16-lev);
    pScreenSubBM->SetAlpha(lev);
  }
}

static void CB_VsyncUpdate(u32 VsyncCount)
{
  if(extmem_ExistMemory()==false) return;
  
  TExtMem *pem=&ExtMem;
  
  if(pem->MakeHash==true){
    if(pem->BlockIndex==0){
      TComponentLabel *pcl=&CompLabels[ECLS_ChkState];
      snprintf((char*)pcl->pMsgUTF8_eng,64,"MemoryTest: Make hash.");
      snprintf((char*)pcl->pMsgUTF8_jpn,64,"メモリテスト：ハッシュ生成中.");
    }
    for(u32 idx=0;idx<pem->BlockSize/4;idx++){
      pem->pBlockBuf[idx]=rand();
    }
    u32 hash;
    {
      MD5_CTX MD5CTX;
      u32 MD5Data[16/4];
      MD5Init(&MD5CTX);
      MD5Update(&MD5CTX,(u8*)pem->pBlockBuf,pem->BlockSize);
      MD5Final((unsigned char*)&MD5Data[0],&MD5CTX);
      hash=MD5Data[0];
    }
    pem->pBlockHashs[pem->BlockIndex]=hash;
    extmem_Write(pem->BlockIndex,pem->pBlockBuf,pem->BlockSize);
    pem->BlockIndex++;
    if(pem->BlockIndex<pem->BlockCount){
      TComponentLabel *pcl=&CompLabels[ECLS_ChkArea];
      u32 cur=(pem->BlockIndex*pem->BlockSize*8)/1024/1024;
      u32 max=(pem->BlockCount*pem->BlockSize*8)/1024/1024;
      snprintf((char*)pcl->pMsgUTF8_eng,64,"Make:%d/%dMBit 0x%08x",cur,max,hash);
      snprintf((char*)pcl->pMsgUTF8_jpn,64,"Make:%d/%dMBit 0x%08x",cur,max,hash);
      }else{
      pem->BlockIndex=0;
      pem->ErrorFlag=false;
      pem->MakeHash=false;
    }
    
    }else{
    if(pem->BlockIndex==0){
      TComponentLabel *pcl=&CompLabels[ECLS_ChkState];
      snprintf((char*)pcl->pMsgUTF8_eng,64,"Check memory...(Infinity)");
      snprintf((char*)pcl->pMsgUTF8_jpn,64,"メモリ検査中...(無限ループ)");
    }
    extmem_Read(pem->BlockIndex,pem->pBlockBuf,pem->BlockSize);
    u32 hash;
    {
      MD5_CTX MD5CTX;
      u32 MD5Data[16/4];
      MD5Init(&MD5CTX);
      MD5Update(&MD5CTX,(u8*)pem->pBlockBuf,pem->BlockSize);
      MD5Final((unsigned char*)&MD5Data[0],&MD5CTX);
      hash=MD5Data[0];
    }
    
    u16 col;
    if(pem->pBlockHashs[pem->BlockIndex]!=hash){
      pem->ErrorFlag=true;
      pem->ErrorCount++;
      col=RGB15(31,0,0)|BIT15;
      }else{
      col=RGB15(0,31,5)|BIT15;
    }
    u32 x=pem->BlockIndex*192/256;
    pScreenSubBM->pCanvas->SetColor(col);
    pScreenSubBM->pCanvas->DrawLine(x,SignalLineTop,x,SignalLineTop+16);
    pScreenSubBM->pCanvas->SetColor(RGB15(15,15,15)|BIT15);
    pScreenSubBM->pCanvas->DrawLine(x+1,SignalLineTop,x+1,SignalLineTop+16);
    
    pem->BlockIndex++;
    if(pem->BlockIndex<pem->BlockCount){
      {
        TComponentLabel *pcl=&CompLabels[ECLS_ChkArea];
        u32 cur=(pem->BlockIndex*pem->BlockSize*8)/1024/1024;
        u32 max=(pem->BlockCount*pem->BlockSize*8)/1024/1024;
        snprintf((char*)pcl->pMsgUTF8_eng,64,"Check:%d/%dMBit 0x%08x",cur,max,hash);
        snprintf((char*)pcl->pMsgUTF8_jpn,64,"Check:%d/%dMBit 0x%08x",cur,max,hash);
      }
      }else{
      if(pem->ErrorFlag==false) pem->SuccessCount++;
      {
        TComponentLabel *pcl=&CompLabels[ECLS_ChkStatus];
        snprintf((char*)pcl->pMsgUTF8_eng,64,"Success.%d Error.%d",ExtMem.SuccessCount,ExtMem.ErrorCount);
        snprintf((char*)pcl->pMsgUTF8_jpn,64,"成功.%d エラー.%d",ExtMem.SuccessCount,ExtMem.ErrorCount);
      }
      pem->BlockIndex=0;
      pem->ErrorFlag=false;
    }
  }
  
  swiWaitForVBlank();
  ExtMem_Redraw();
}

static void CB_End(void)
{
  for(u32 lev=0;lev<=16;lev+=2){
    WaitForVBlank(true);
    pScreenMain->SetWhiteOut(lev);
    pScreenSubBM->SetAlpha(16-lev);
  }
  
  TExtMem *pem=&ExtMem;
  
  if(pem->pBlockHashs!=NULL){
    safefree(pem->pBlockHashs); pem->pBlockHashs=NULL;
  }
  if(pem->pBlockBuf!=NULL){
    safefree(pem->pBlockBuf); pem->pBlockBuf=NULL;
  }
  
  extmem_Free();
  
  IPKState.SlideSetting=SlideSetting;
  ScreenEnd(ESS_Bitmap);
}

void ProcSlideOpt4_SetCallBack(void)
{
  CallBack_Start=CB_Start;
  CallBack_VsyncUpdate=CB_VsyncUpdate;
  CallBack_End=CB_End;
  CallBack_KeyDown=CB_KeyDown;
  CallBack_KeyPress=CB_KeyPress;
  CallBack_KeyUp=CB_KeyUp;
  CallBack_MouseDown=CB_MouseDown;
  CallBack_MouseMove=CB_MouseMove;
  CallBack_MouseUp=CB_MouseUp;
}

