
#include <nds.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "_console.h"
#include "_consolewritelog.h"
#include "maindef.h"
#include "memtool.h"
#include "_const.h"
#include "lang.h"

#include "glib/glib.h"

#include "gba_nds_fat.h"
#include "zlibhelp.h"
#include "cstream_fs.h"
#include "cipk.h"
#include "ipkfilelist.h"
#include "ipkstate.h"
#include "corner.h"

#include "rect.h"
#include "component.h"

#include "proc_screen.h"

#define BGColor15 (RGB15(25,22,23) | BIT15)

static TIPKState_SlideSetting SlideSetting;

enum ECompLabels {ECLS_TitleLbl,ECLS_FadeSingleDisplayLbl,ECLSCount};
#define CompLabelsCount (ECLSCount)
static TComponentLabel CompLabels[CompLabelsCount];

enum ECompChecks {ECCS_FadeType0Radio,ECCS_FadeType1Radio,ECCS_FadeType2Radio,ECCS_FadeType3Radio,ECCS_FadeType4Radio,ECCS_FadeType5Radio,ECCS_FadeSpeedSlowRadio,ECCS_FadeSpeedNormRadio,ECCS_FadeSpeedFastRadio,ECCS_FadeSingleDisplay_Left,ECCS_FadeSingleDisplay_Right,ECCSCount};
#define CompChecksCount (ECCSCount)
static TComponentCheck CompChecks[CompChecksCount];

enum ECompButtons {ECBS_Page1Btn,ECBS_Page2Btn,ECBS_Page3Btn,ECBS_Page4Btn,ECBS_StartBtn,ECBS_CancelBtn,ECBSCount};
#define CompButtonsCount (ECBSCount)
static TComponentButton CompButtons[CompButtonsCount];

static void SlideSetting_Redraw(bool FullDraw)
{
  if(FullDraw==true){
    CglCanvas *pcan=pScreenSubBM->pCanvas;
    
    u32 TitleHeight=30;
    pcan->SetColor(GlobalBGColor15);
    pcan->FillFast(0,0,ScreenWidth,TitleHeight);
    pcan->SetColor(BGColor15);
    pcan->FillFast(0,TitleHeight,ScreenWidth,ScreenHeight-TitleHeight);
  }
  
  TIPKState_SlideSetting *pss=&SlideSetting;
  
  {
    CompChecks[ECCS_FadeType0Radio].Checked=false;
    CompChecks[ECCS_FadeType1Radio].Checked=false;
    CompChecks[ECCS_FadeType2Radio].Checked=false;
    CompChecks[ECCS_FadeType3Radio].Checked=false;
    CompChecks[ECCS_FadeType4Radio].Checked=false;
    CompChecks[ECCS_FadeType5Radio].Checked=false;
    
    switch(pss->FadeType){
      case EFT_RightToLeft: CompChecks[ECCS_FadeType0Radio].Checked=true; break;
      case EFT_LeftToRight: CompChecks[ECCS_FadeType1Radio].Checked=true; break;
      case EFT_SingleFade: CompChecks[ECCS_FadeType2Radio].Checked=true; break;
      case EFT_SingleFlash: CompChecks[ECCS_FadeType3Radio].Checked=true; break;
      case EFT_SingleBlind: CompChecks[ECCS_FadeType4Radio].Checked=true; break;
      case EFT_SingleCrossFade: CompChecks[ECCS_FadeType5Radio].Checked=true; break;
      default: break;
    }
  }
  
  {
    u16 col;
    
    if(pss->FadeType==EFT_SingleFlash){
      col=RGB15(20,18,18)|BIT15;
      }else{
      col=GlobalTextColor15;
    }
    
    CompChecks[ECCS_FadeSpeedSlowRadio].TextColor=col;
    CompChecks[ECCS_FadeSpeedNormRadio].TextColor=col;
    CompChecks[ECCS_FadeSpeedFastRadio].TextColor=col;
  }
  
  {
    CompChecks[ECCS_FadeSpeedSlowRadio].Checked=false;
    CompChecks[ECCS_FadeSpeedNormRadio].Checked=false;
    CompChecks[ECCS_FadeSpeedFastRadio].Checked=false;
    
    switch(pss->FadeSpeed){
      case EFS_Slow: CompChecks[ECCS_FadeSpeedSlowRadio].Checked=true; break;
      case EFS_Norm: CompChecks[ECCS_FadeSpeedNormRadio].Checked=true; break;
      case EFS_Fast: CompChecks[ECCS_FadeSpeedFastRadio].Checked=true; break;
      default: break;
    }
  }
  
  {
    u16 col;
    
    switch(pss->FadeType){
      case EFT_RightToLeft: case EFT_LeftToRight: {
        col=RGB15(20,18,18)|BIT15;
      } break;
      default: {
        col=GlobalTextColor15;
      } break;
    }
    
    CompLabels[ECLS_FadeSingleDisplayLbl].TextColor=col;
    CompChecks[ECCS_FadeSingleDisplay_Left].TextColor=col;
    CompChecks[ECCS_FadeSingleDisplay_Right].TextColor=col;
  }
  
  {
    u16 col;
    
    switch(pss->FadeType){
      case EFT_RightToLeft: case EFT_LeftToRight: {
        col=RGB15(20,18,18)|BIT15;
      } break;
      default: {
        col=GlobalTextColor15;
      } break;
    }
    
    CompLabels[ECLS_FadeSingleDisplayLbl].TextColor=col;
    CompChecks[ECCS_FadeSingleDisplay_Left].TextColor=col;
    CompChecks[ECCS_FadeSingleDisplay_Right].TextColor=col;
  }
  
  {
    CompChecks[ECCS_FadeSingleDisplay_Left].Checked=false;
    CompChecks[ECCS_FadeSingleDisplay_Right].Checked=false;
    
    switch(pss->FadeSingleDisplay){
      case EFSD_Left: CompChecks[ECCS_FadeSingleDisplay_Left].Checked=true; break;
      case EFSD_Right: CompChecks[ECCS_FadeSingleDisplay_Right].Checked=true; break;
      default: break;
    }
  }
  
  if(FullDraw==true){
    for(u32 idx=0;idx<CompLabelsCount;idx++){
      ComponentLabel_Draw(&CompLabels[idx]);
    }
    for(u32 idx=0;idx<CompChecksCount;idx++){
      ComponentCheck_Draw(&CompChecks[idx]);
    }
    for(u32 idx=0;idx<CompButtonsCount;idx++){
      ComponentButton_Draw(&CompButtons[idx]);
    }
    }else{
    ComponentCheck_Draw(&CompChecks[ECCS_FadeType0Radio]);
    ComponentCheck_Draw(&CompChecks[ECCS_FadeType1Radio]);
    ComponentCheck_Draw(&CompChecks[ECCS_FadeType2Radio]);
    ComponentCheck_Draw(&CompChecks[ECCS_FadeType3Radio]);
    ComponentCheck_Draw(&CompChecks[ECCS_FadeType4Radio]);
    ComponentCheck_Draw(&CompChecks[ECCS_FadeType5Radio]);
    ComponentCheck_Draw(&CompChecks[ECCS_FadeSpeedSlowRadio]);
    ComponentCheck_Draw(&CompChecks[ECCS_FadeSpeedNormRadio]);
    ComponentCheck_Draw(&CompChecks[ECCS_FadeSpeedFastRadio]);
    ComponentLabel_Draw(&CompLabels[ECLS_FadeSingleDisplayLbl]);
    ComponentCheck_Draw(&CompChecks[ECCS_FadeSingleDisplay_Left]);
    ComponentCheck_Draw(&CompChecks[ECCS_FadeSingleDisplay_Right]);
  }
}

static void CB_FadeType0Radio_Click(void *pComponentCheck)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->FadeType=EFT_RightToLeft;
  SlideSetting_Redraw(false);
}

static void CB_FadeType1Radio_Click(void *pComponentCheck)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->FadeType=EFT_LeftToRight;
  SlideSetting_Redraw(false);
}

static void CB_FadeType2Radio_Click(void *pComponentCheck)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->FadeType=EFT_SingleFade;
  SlideSetting_Redraw(false);
}

static void CB_FadeType3Radio_Click(void *pComponentCheck)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->FadeType=EFT_SingleFlash;
  SlideSetting_Redraw(false);
}

static void CB_FadeType4Radio_Click(void *pComponentCheck)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->FadeType=EFT_SingleBlind;
  SlideSetting_Redraw(false);
}

static void CB_FadeType5Radio_Click(void *pComponentCheck)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->FadeType=EFT_SingleCrossFade;
  SlideSetting_Redraw(false);
}

static void CB_FadeSpeedSlowRadio_Click(void *pComponentCheck)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->FadeSpeed=EFS_Slow;
  SlideSetting_Redraw(false);
}

static void CB_FadeSpeedNormRadio_Click(void *pComponentCheck)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->FadeSpeed=EFS_Norm;
  SlideSetting_Redraw(false);
}

static void CB_FadeSpeedFastRadio_Click(void *pComponentCheck)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->FadeSpeed=EFS_Fast;
  SlideSetting_Redraw(false);
}

static void CB_FadeSingleDisplay_Left_Click(void *pComponentCheck)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->FadeSingleDisplay=EFSD_Left;
  SlideSetting_Redraw(false);
}

static void CB_FadeSingleDisplay_Right_Click(void *pComponentCheck)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->FadeSingleDisplay=EFSD_Right;
  SlideSetting_Redraw(false);
}

static void CB_Page1Btn_Click(void *pComponentButton)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->SlideOptPage=1;
  NextProc=ENP_SlideOpt1;
}

static void CB_Page2Btn_Click(void *pComponentButton)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->SlideOptPage=2;
  NextProc=ENP_SlideOpt2;
}

static void CB_Page3Btn_Click(void *pComponentButton)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->SlideOptPage=3;
  NextProc=ENP_SlideOpt3;
}

static void CB_Page4Btn_Click(void *pComponentButton)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->SlideOptPage=4;
  NextProc=ENP_SlideOpt4;
}

static void CB_StartBtn_Click(void *pComponentButton)
{
  NextProc=ENP_SlidePlay;
}

static void CB_CancelBtn_Click(void *pComponentButton)
{
  NextProc=ENP_Thumbnail;
}

static void CompsInit(void)
{
  CglCanvas *pcan=pScreenSubBM->pCanvas;
  
  for(u32 idx=0;idx<CompLabelsCount;idx++){
    ComponentLabel_Init(&CompLabels[idx],pcan);
    CompLabels[idx].BGColor=BGColor15;
  }
  for(u32 idx=0;idx<CompChecksCount;idx++){
    ComponentCheck_Init(&CompChecks[idx],pcan);
    CompChecks[idx].BGColor=BGColor15;
  }
  for(u32 idx=0;idx<CompButtonsCount;idx++){
    ComponentButton_Init(&CompButtons[idx],pcan);
    CompButtons[idx].BGColor=BGColor15;
  }
  
  s32 chksize=16;
  
  s32 x,y;
  
  x=ScreenWidth-68-2;
  y=8-2;
  
  {
    TComponentButton *pcb=&CompButtons[ECBS_Page1Btn];
    pcb->CallBack_Click=CB_Page1Btn_Click;
    pcb->Rect=CreateRect(x,y,14,chksize+2);
    pcb->pMsgUTF8_eng="1";
    pcb->pMsgUTF8_jpn="1";
  }
  
  x+=18;
  
  {
    TComponentButton *pcb=&CompButtons[ECBS_Page2Btn];
    pcb->CallBack_Click=CB_Page2Btn_Click;
    pcb->Rect=CreateRect(x,y,14,chksize+2);
    pcb->pMsgUTF8_eng="2";
    pcb->pMsgUTF8_jpn="2";
    pcb->Pressing=true;
  }
  
  x+=18;
  
  {
    TComponentButton *pcb=&CompButtons[ECBS_Page3Btn];
    pcb->CallBack_Click=CB_Page3Btn_Click;
    pcb->Rect=CreateRect(x,y,14,chksize+2);
    pcb->pMsgUTF8_eng="3";
    pcb->pMsgUTF8_jpn="3";
  }
  
  x+=18;
  
  {
    TComponentButton *pcb=&CompButtons[ECBS_Page4Btn];
    pcb->CallBack_Click=CB_Page4Btn_Click;
    pcb->Rect=CreateRect(x,y,14,chksize+2);
    pcb->pMsgUTF8_eng="4";
    pcb->pMsgUTF8_jpn="4";
  }
  
  x=4;
  y=8;
  
  {
    TComponentLabel *pcl=&CompLabels[ECLS_TitleLbl];
    pcl->BGColor=GlobalBGColor15;
    pcl->Rect=CreateRect(x,y,0,0);
    pcl->pMsgUTF8_eng="Fade type";
    pcl->pMsgUTF8_jpn="画面効果設定";
  }
  
  x=24;
  y+=14+8+16;
  
  {
    TComponentCheck *pcc=&CompChecks[ECCS_FadeType0Radio];
    pcc->CallBack_Click=CB_FadeType0Radio_Click;
    pcc->pOnCanvas=Component_GetIcon(ECIT_RadioOn)->pCanvas;
    pcc->pOffCanvas=Component_GetIcon(ECIT_RadioOff)->pCanvas;
    pcc->pMsgUTF8_eng="Right -> Left";
    pcc->pMsgUTF8_jpn="右から左へ";
    pcc->Rect=CreateRect(x,y,chksize,chksize);
  }
  
  y+=20;
  
  {
    TComponentCheck *pcc=&CompChecks[ECCS_FadeType1Radio];
    pcc->CallBack_Click=CB_FadeType1Radio_Click;
    pcc->pOnCanvas=Component_GetIcon(ECIT_RadioOn)->pCanvas;
    pcc->pOffCanvas=Component_GetIcon(ECIT_RadioOff)->pCanvas;
    pcc->pMsgUTF8_eng="Left -> Right";
    pcc->pMsgUTF8_jpn="左から右へ";
    pcc->Rect=CreateRect(x,y,chksize,chksize);
  }
  
  y+=20;
  
  {
    TComponentCheck *pcc=&CompChecks[ECCS_FadeType2Radio];
    pcc->CallBack_Click=CB_FadeType2Radio_Click;
    pcc->pOnCanvas=Component_GetIcon(ECIT_RadioOn)->pCanvas;
    pcc->pOffCanvas=Component_GetIcon(ECIT_RadioOff)->pCanvas;
    pcc->pMsgUTF8_eng="Single fade";
    pcc->pMsgUTF8_jpn="単画面 フェード";
    pcc->Rect=CreateRect(x,y,chksize,chksize);
  }
  
  y+=20;
  
  {
    TComponentCheck *pcc=&CompChecks[ECCS_FadeType3Radio];
    pcc->CallBack_Click=CB_FadeType3Radio_Click;
    pcc->pOnCanvas=Component_GetIcon(ECIT_RadioOn)->pCanvas;
    pcc->pOffCanvas=Component_GetIcon(ECIT_RadioOff)->pCanvas;
    pcc->pMsgUTF8_eng="Single flash";
    pcc->pMsgUTF8_jpn="単画面 フラッシュ";
    pcc->Rect=CreateRect(x,y,chksize,chksize);
  }
  
  y+=20;
  
  {
    TComponentCheck *pcc=&CompChecks[ECCS_FadeType4Radio];
    pcc->CallBack_Click=CB_FadeType4Radio_Click;
    pcc->pOnCanvas=Component_GetIcon(ECIT_RadioOn)->pCanvas;
    pcc->pOffCanvas=Component_GetIcon(ECIT_RadioOff)->pCanvas;
    pcc->pMsgUTF8_eng="Single blind";
    pcc->pMsgUTF8_jpn="単画面 ブラインド";
    pcc->Rect=CreateRect(x,y,chksize,chksize);
  }
  
  y+=20;
  
  {
    TComponentCheck *pcc=&CompChecks[ECCS_FadeType5Radio];
    pcc->CallBack_Click=CB_FadeType5Radio_Click;
    pcc->pOnCanvas=Component_GetIcon(ECIT_RadioOn)->pCanvas;
    pcc->pOffCanvas=Component_GetIcon(ECIT_RadioOff)->pCanvas;
    pcc->pMsgUTF8_eng="Single CrossFade";
    pcc->pMsgUTF8_jpn="単画面 クロスフェード";
    pcc->Rect=CreateRect(x,y,chksize,chksize);
  }
  
  x=6;
  y=ScreenHeight-80;
  
  {
    TComponentCheck *pcc=&CompChecks[ECCS_FadeSpeedSlowRadio];
    pcc->CallBack_Click=CB_FadeSpeedSlowRadio_Click;
    pcc->pOnCanvas=Component_GetIcon(ECIT_RadioOn)->pCanvas;
    pcc->pOffCanvas=Component_GetIcon(ECIT_RadioOff)->pCanvas;
    pcc->pMsgUTF8_eng="Slow";
    pcc->pMsgUTF8_jpn="遅い";
    pcc->Rect=CreateRect(x,y,chksize,chksize);
  }
  
  x+=64;
  
  {
    TComponentCheck *pcc=&CompChecks[ECCS_FadeSpeedNormRadio];
    pcc->CallBack_Click=CB_FadeSpeedNormRadio_Click;
    pcc->pOnCanvas=Component_GetIcon(ECIT_RadioOn)->pCanvas;
    pcc->pOffCanvas=Component_GetIcon(ECIT_RadioOff)->pCanvas;
    pcc->pMsgUTF8_eng="Norm";
    pcc->pMsgUTF8_jpn="普通";
    pcc->Rect=CreateRect(x,y,chksize,chksize);
  }
  
  x+=64;
  
  {
    TComponentCheck *pcc=&CompChecks[ECCS_FadeSpeedFastRadio];
    pcc->CallBack_Click=CB_FadeSpeedFastRadio_Click;
    pcc->pOnCanvas=Component_GetIcon(ECIT_RadioOn)->pCanvas;
    pcc->pOffCanvas=Component_GetIcon(ECIT_RadioOff)->pCanvas;
    pcc->pMsgUTF8_eng="Fast";
    pcc->pMsgUTF8_jpn="速い";
    pcc->Rect=CreateRect(x,y,chksize,chksize);
  }
  
  x=6;
  y+=24;
  
  {
    TComponentLabel *pcl=&CompLabels[ECLS_FadeSingleDisplayLbl];
    pcl->Rect=CreateRect(x,y,0,0);
    pcl->Center=true;
    pcl->pMsgUTF8_eng="Single";
    pcl->pMsgUTF8_jpn="単画面";
  }
  
  x+=64;
  
  {
    TComponentCheck *pcc=&CompChecks[ECCS_FadeSingleDisplay_Left];
    pcc->CallBack_Click=CB_FadeSingleDisplay_Left_Click;
    pcc->pOnCanvas=Component_GetIcon(ECIT_RadioOn)->pCanvas;
    pcc->pOffCanvas=Component_GetIcon(ECIT_RadioOff)->pCanvas;
    pcc->pMsgUTF8_eng="Left";
    pcc->pMsgUTF8_jpn="左";
    pcc->Rect=CreateRect(x,y,chksize,chksize);
  }
  
  x+=48;
  
  {
    TComponentCheck *pcc=&CompChecks[ECCS_FadeSingleDisplay_Right];
    pcc->CallBack_Click=CB_FadeSingleDisplay_Right_Click;
    pcc->pOnCanvas=Component_GetIcon(ECIT_RadioOn)->pCanvas;
    pcc->pOffCanvas=Component_GetIcon(ECIT_RadioOff)->pCanvas;
    pcc->pMsgUTF8_eng="Right";
    pcc->pMsgUTF8_jpn="右";
    pcc->Rect=CreateRect(x,y,chksize,chksize);
  }
  
  x=(ScreenWidth-((80*2)+16))/2;
  y=ScreenHeight-(chksize+2)-8;
  
  {
    TComponentButton *pcb=&CompButtons[ECBS_StartBtn];
    pcb->CallBack_Click=CB_StartBtn_Click;
    pcb->pIconCanvas=Component_GetIcon(ECIT_Ok)->pCanvas;
    pcb->Rect=CreateRect(x,y,80,chksize+2);
    pcb->pMsgUTF8_eng="Start";
    pcb->pMsgUTF8_jpn="開始";
  }
  
  x+=16+80;
  
  {
    TComponentButton *pcb=&CompButtons[ECBS_CancelBtn];
    pcb->CallBack_Click=CB_CancelBtn_Click;
    pcb->pIconCanvas=Component_GetIcon(ECIT_Cancel)->pCanvas;
    pcb->Rect=CreateRect(x,y,80,chksize+2);
    pcb->pMsgUTF8_eng="Cancel";
    pcb->pMsgUTF8_jpn="戻る";
  }
}

static void CB_KeyDown(u32 Keys)
{
}

static void CB_KeyPress(u32 VsyncCount,u32 Keys)
{
  if((Keys&KEY_START)!=0) CB_StartBtn_Click(NULL);
}

static void CB_KeyUp(u32 Keys)
{
}

static bool deskmf;
static TComponentButton *pPressingButton;

static void CB_MouseDown(s32 x,s32 y)
{
  deskmf=false;
  
  for(u32 idx=0;idx<CompButtonsCount;idx++){
    TComponentButton *pcb=&CompButtons[idx];
    if(ComponentButton_GetIndexFromPos(pcb,x,y)!=-1){
      pPressingButton=pcb;
      pcb->Pressing=true;
      ComponentButton_Draw(pcb);
    }
  }
  
  deskmf=true;
}

static void CB_MouseMove(s32 x,s32 y,bool CanIgnore)
{
  if(deskmf==false) return;
  if(CanIgnore==true) return;
  
  for(u32 idx=0;idx<CompButtonsCount;idx++){
    TComponentButton *pcb=&CompButtons[idx];
    if(pcb==pPressingButton){
      if(ComponentButton_GetIndexFromPos(pcb,x,y)==-1){
        if(pcb->Pressing==true){
          pcb->Pressing=false;
          ComponentButton_Draw(pcb);
        }
        }else{
        if(pcb->Pressing==false){
          pcb->Pressing=true;
          ComponentButton_Draw(pcb);
        }
      }
    }
  }
}

static void CB_MouseUp(s32 x,s32 y)
{
  if(deskmf==false) return;
  
  deskmf=false;
  
  if(pPressingButton!=NULL){
    pPressingButton->Pressing=false;
    ComponentButton_Draw(pPressingButton);
    
    for(u32 idx=0;idx<CompButtonsCount;idx++){
      TComponentButton *pcb=&CompButtons[idx];
      if(pcb==pPressingButton){
        if(ComponentButton_GetIndexFromPos(pcb,x,y)!=-1){
          ComponentButton_MouseUp(&CompButtons[idx],x,y);
        }
      }
    }
    
    pPressingButton=NULL;
    return;
  }
  
  for(u32 idx=0;idx<CompLabelsCount;idx++){
    ComponentLabel_MouseUp(&CompLabels[idx],x,y);
  }
  for(u32 idx=0;idx<CompChecksCount;idx++){
    ComponentCheck_MouseUp(&CompChecks[idx],x,y);
  }
  for(u32 idx=0;idx<CompButtonsCount;idx++){
  }
}

static void CB_Start(void)
{
  ScreenInit(ESS_Bitmap,EDM_Vertical);
  
  {
    const u32 s=CornerIconSize;
    const u32 x=ScreenWidth;
    const u32 y=ScreenHeight-(s*8);
    CglB15 *pB15=Corner_GetIcon(EIT_Mouse);
    pScreenSubBM->Mouse_Init(x,y+(s*0),pB15->pCanvas);
  }
  
  {
    CglCanvas *pcan=pScreenMain->pCanvas;
    pcan->SetColor(BGColor15);
    pcan->FillAll();
  }
  {
    CglCanvas *pcan=pScreenSubBM->pCanvas;
    pcan->SetColor(BGColor15);
    pcan->FillAll();
  }
  
  DrawSlideOptLeft(2);
  
  deskmf=false;
  pPressingButton=NULL;
  
  pScreenMain->SetWhiteOut(16);
  pScreenSubBM->SetAlpha(0);
  
  CompsInit();
  
  SlideSetting=IPKState.SlideSetting;
  
//  pScreenSubBM->SetAlpha(8); // for Debug.
  
  SlideSetting_Redraw(true);
  
  for(u32 lev=0;lev<=16;lev+=2){
    WaitForVBlank(true);
    pScreenMain->SetWhiteOut(16-lev);
    pScreenSubBM->SetAlpha(lev);
  }
}

static void CB_VsyncUpdate(u32 VsyncCount)
{
}

static void CB_End(void)
{
  for(u32 lev=0;lev<=16;lev+=2){
    WaitForVBlank(true);
    pScreenMain->SetWhiteOut(lev);
    pScreenSubBM->SetAlpha(16-lev);
  }
  
  IPKState.SlideSetting=SlideSetting;
  ScreenEnd(ESS_Bitmap);
}

void ProcSlideOpt2_SetCallBack(void)
{
  CallBack_Start=CB_Start;
  CallBack_VsyncUpdate=CB_VsyncUpdate;
  CallBack_End=CB_End;
  CallBack_KeyDown=CB_KeyDown;
  CallBack_KeyPress=CB_KeyPress;
  CallBack_KeyUp=CB_KeyUp;
  CallBack_MouseDown=CB_MouseDown;
  CallBack_MouseMove=CB_MouseMove;
  CallBack_MouseUp=CB_MouseUp;
}

