
#include <nds.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "_console.h"
#include "_consolewritelog.h"
#include "maindef.h"
#include "memtool.h"
#include "_const.h"
#include "lang.h"

#include "glib/glib.h"

#include "gba_nds_fat.h"
#include "zlibhelp.h"
#include "cstream_fs.h"
#include "cipk.h"
#include "ipkfilelist.h"
#include "ipkstate.h"
#include "corner.h"

#include "rect.h"
#include "component.h"

#include "proc_screen.h"

#define BGColor15 (RGB15(25,22,23) | BIT15)

static TIPKState_SlideSetting SlideSetting;

enum ECompLabels {ECLS_TitleLbl,ECLS_WaitSecLbl,ECLS_WaitSecValueLbl,ECLSCount};
#define CompLabelsCount (ECLSCount)
static TComponentLabel CompLabels[CompLabelsCount];

enum ECompChecks {ECCS_WaitSecMinBtn,ECCS_WaitSecPlusBtn,ECCS_NextSequenceRadio,ECCS_NextShuffleRadio,ECCS_LoopPlayChk,ECCS_StopButtonChk,ECCSCount};
#define CompChecksCount (ECCSCount)
static TComponentCheck CompChecks[CompChecksCount];

enum ECompButtons {ECBS_Page1Btn,ECBS_Page2Btn,ECBS_Page3Btn,ECBS_Page4Btn,ECBS_StartBtn,ECBS_CancelBtn,ECBSCount};
#define CompButtonsCount (ECBSCount)
static TComponentButton CompButtons[CompButtonsCount];

static void SlideSetting_Redraw(bool FullDraw)
{
  if(FullDraw==true){
    CglCanvas *pcan=pScreenSubBM->pCanvas;
    
    u32 TitleHeight=30;
    pcan->SetColor(GlobalBGColor15);
    pcan->FillFast(0,0,ScreenWidth,TitleHeight);
    pcan->SetColor(BGColor15);
    pcan->FillFast(0,TitleHeight,ScreenWidth,ScreenHeight-TitleHeight);
  }
  
  TIPKState_SlideSetting *pss=&SlideSetting;
  
  {
    TComponentLabel *pcl=&CompLabels[ECLS_WaitSecValueLbl];
    
    static char msg[8];
    snprintf(msg,8,"%d",SlideSetting.WaitSec);
    
    pcl->pMsgUTF8_eng=msg;
    pcl->pMsgUTF8_jpn=msg;
  }
  
  {
    CompChecks[ECCS_NextSequenceRadio].Checked=false;
    CompChecks[ECCS_NextShuffleRadio].Checked=false;
    
    switch(pss->NextSelect){
      case ENS_Sequence: CompChecks[ECCS_NextSequenceRadio].Checked=true; break;
      case ENS_DeletedMode: break;
      case ENS_Shuffle: CompChecks[ECCS_NextShuffleRadio].Checked=true; break;
      default: break;
    }
  }
  
  CompChecks[ECCS_LoopPlayChk].Checked=pss->LoopPlay;
  CompChecks[ECCS_StopButtonChk].Checked=pss->StopButton;
  
  if(FullDraw==true){
    for(u32 idx=0;idx<CompLabelsCount;idx++){
      ComponentLabel_Draw(&CompLabels[idx]);
    }
    for(u32 idx=0;idx<CompChecksCount;idx++){
      ComponentCheck_Draw(&CompChecks[idx]);
    }
    for(u32 idx=0;idx<CompButtonsCount;idx++){
      ComponentButton_Draw(&CompButtons[idx]);
    }
    }else{
    ComponentLabel_Draw(&CompLabels[ECLS_WaitSecValueLbl]);
    ComponentCheck_Draw(&CompChecks[ECCS_NextSequenceRadio]);
    ComponentCheck_Draw(&CompChecks[ECCS_NextShuffleRadio]);
    ComponentCheck_Draw(&CompChecks[ECCS_LoopPlayChk]);
    ComponentCheck_Draw(&CompChecks[ECCS_StopButtonChk]);
  }
}

static void CB_WaitSecMinBtn_Click(void *pComponentCheck)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  if(2<=pss->WaitSec) pss->WaitSec--;
  SlideSetting_Redraw(false);
}

static void CB_WaitSecPlusBtn_Click(void *pComponentCheck)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  if(pss->WaitSec<99) pss->WaitSec++;
  SlideSetting_Redraw(false);
}

static void CB_NextSequenceRadio_Click(void *pComponentCheck)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->NextSelect=ENS_Sequence;
  SlideSetting_Redraw(false);
}

static void CB_NextShuffleRadio_Click(void *pComponentCheck)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->NextSelect=ENS_Shuffle;
  SlideSetting_Redraw(false);
}

static void CB_LoopPlayChk_Click(void *pComponentCheck)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->LoopPlay=!pss->LoopPlay;
  SlideSetting_Redraw(false);
}

static void CB_StopButtonChk_Click(void *pComponentCheck)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->StopButton=!pss->StopButton;
  SlideSetting_Redraw(false);
}

static void CB_Page1Btn_Click(void *pComponentButton)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->SlideOptPage=1;
  NextProc=ENP_SlideOpt1;
}

static void CB_Page2Btn_Click(void *pComponentButton)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->SlideOptPage=2;
  NextProc=ENP_SlideOpt2;
}

static void CB_Page3Btn_Click(void *pComponentButton)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->SlideOptPage=3;
  NextProc=ENP_SlideOpt3;
}

static void CB_Page4Btn_Click(void *pComponentButton)
{
  TIPKState_SlideSetting *pss=&SlideSetting;
  pss->SlideOptPage=4;
  NextProc=ENP_SlideOpt4;
}

static void CB_StartBtn_Click(void *pComponentButton)
{
  NextProc=ENP_SlidePlay;
}

static void CB_CancelBtn_Click(void *pComponentButton)
{
  NextProc=ENP_Thumbnail;
}

static void CompsInit(void)
{
  CglCanvas *pcan=pScreenSubBM->pCanvas;
  
  for(u32 idx=0;idx<CompLabelsCount;idx++){
    ComponentLabel_Init(&CompLabels[idx],pcan);
    CompLabels[idx].BGColor=BGColor15;
  }
  for(u32 idx=0;idx<CompChecksCount;idx++){
    ComponentCheck_Init(&CompChecks[idx],pcan);
    CompChecks[idx].BGColor=BGColor15;
  }
  for(u32 idx=0;idx<CompButtonsCount;idx++){
    ComponentButton_Init(&CompButtons[idx],pcan);
    CompButtons[idx].BGColor=BGColor15;
  }
  
  s32 chksize=16;
  
  s32 x,y;
  
  x=ScreenWidth-68-2;
  y=8-2;
  
  {
    TComponentButton *pcb=&CompButtons[ECBS_Page1Btn];
    pcb->CallBack_Click=CB_Page1Btn_Click;
    pcb->Rect=CreateRect(x,y,14,chksize+2);
    pcb->pMsgUTF8_eng="1";
    pcb->pMsgUTF8_jpn="1";
    pcb->Pressing=true;
  }
  
  x+=18;
  
  {
    TComponentButton *pcb=&CompButtons[ECBS_Page2Btn];
    pcb->CallBack_Click=CB_Page2Btn_Click;
    pcb->Rect=CreateRect(x,y,14,chksize+2);
    pcb->pMsgUTF8_eng="2";
    pcb->pMsgUTF8_jpn="2";
  }
  
  x+=18;
  
  {
    TComponentButton *pcb=&CompButtons[ECBS_Page3Btn];
    pcb->CallBack_Click=CB_Page3Btn_Click;
    pcb->Rect=CreateRect(x,y,14,chksize+2);
    pcb->pMsgUTF8_eng="3";
    pcb->pMsgUTF8_jpn="3";
  }
  
  x+=18;
  
  {
    TComponentButton *pcb=&CompButtons[ECBS_Page4Btn];
    pcb->CallBack_Click=CB_Page4Btn_Click;
    pcb->Rect=CreateRect(x,y,14,chksize+2);
    pcb->pMsgUTF8_eng="4";
    pcb->pMsgUTF8_jpn="4";
  }
  
  x=4;
  y=8;
  
  {
    TComponentLabel *pcl=&CompLabels[ECLS_TitleLbl];
    pcl->BGColor=GlobalBGColor15;
    pcl->Rect=CreateRect(x,y,0,0);
    pcl->pMsgUTF8_eng="Slide show";
    pcl->pMsgUTF8_jpn="スライドショー";
  }
  
  x=12;
  y+=14+8+16;
  
  {
    TComponentLabel *pcl=&CompLabels[ECLS_WaitSecLbl];
    pcl->Rect=CreateRect(x,y,0,0);
    pcl->pMsgUTF8_eng="Wait second";
    pcl->pMsgUTF8_jpn="待機時間(秒)";
  }
  
  x=120;
  
  {
    TComponentCheck *pcc=&CompChecks[ECCS_WaitSecMinBtn];
    pcc->CallBack_Click=CB_WaitSecMinBtn_Click;
    pcc->pOnCanvas=Component_GetIcon(ECIT_BoxMin)->pCanvas;
    pcc->pOffCanvas=pcc->pOnCanvas;
    pcc->Checked=true;
    pcc->Rect=CreateRect(x,y,chksize,chksize);
  }
  
  x+=chksize;
  
  {
    TComponentLabel *pcl=&CompLabels[ECLS_WaitSecValueLbl];
    pcl->Rect=CreateRect(x,y,32,0);
    pcl->Center=true;
    pcl->pMsgUTF8_eng="";
    pcl->pMsgUTF8_jpn="";
  }
  
  x+=32;
  
  {
    TComponentCheck *pcc=&CompChecks[ECCS_WaitSecPlusBtn];
    pcc->CallBack_Click=CB_WaitSecPlusBtn_Click;
    pcc->pOnCanvas=Component_GetIcon(ECIT_BoxPlus)->pCanvas;
    pcc->pOffCanvas=pcc->pOnCanvas;
    pcc->Checked=true;
    pcc->Rect=CreateRect(x,y,chksize,chksize);
  }
  
  x=24;
  y+=32;
  
  {
    TComponentCheck *pcc=&CompChecks[ECCS_NextSequenceRadio];
    pcc->CallBack_Click=CB_NextSequenceRadio_Click;
    pcc->pOnCanvas=Component_GetIcon(ECIT_RadioOn)->pCanvas;
    pcc->pOffCanvas=Component_GetIcon(ECIT_RadioOff)->pCanvas;
    pcc->pMsgUTF8_eng="Sequencial current";
    pcc->pMsgUTF8_jpn="現在位置から順再生";
    pcc->Rect=CreateRect(x,y,chksize,chksize);
  }
  
  y+=24;
  
  {
    TComponentCheck *pcc=&CompChecks[ECCS_NextShuffleRadio];
    pcc->CallBack_Click=CB_NextShuffleRadio_Click;
    pcc->pOnCanvas=Component_GetIcon(ECIT_RadioOn)->pCanvas;
    pcc->pOffCanvas=Component_GetIcon(ECIT_RadioOff)->pCanvas;
    pcc->pMsgUTF8_eng="Shuffle play";
    pcc->pMsgUTF8_jpn="シャッフル再生";
    pcc->Rect=CreateRect(x,y,chksize,chksize);
  }
  
  x=12;
  y+=32;
  
  {
    TComponentCheck *pcc=&CompChecks[ECCS_LoopPlayChk];
    pcc->CallBack_Click=CB_LoopPlayChk_Click;
    pcc->pOnCanvas=Component_GetIcon(ECIT_CheckOn)->pCanvas;
    pcc->pOffCanvas=Component_GetIcon(ECIT_CheckOff)->pCanvas;
    pcc->pMsgUTF8_eng="Loop play";
    pcc->pMsgUTF8_jpn="ループ再生";
    pcc->Rect=CreateRect(x,y,chksize,chksize);
  }
  
  x=12;
  y+=32;
  
  {
    TComponentCheck *pcc=&CompChecks[ECCS_StopButtonChk];
    pcc->CallBack_Click=CB_StopButtonChk_Click;
    pcc->pOnCanvas=Component_GetIcon(ECIT_CheckOn)->pCanvas;
    pcc->pOffCanvas=Component_GetIcon(ECIT_CheckOff)->pCanvas;
    pcc->pMsgUTF8_eng="When L/R btns, stops";
    pcc->pMsgUTF8_jpn="L/Rボタンで停止する";
    pcc->Rect=CreateRect(x,y,chksize,chksize);
  }
  
  x=(ScreenWidth-((80*2)+16))/2;
  y=ScreenHeight-(chksize+2)-8;
  
  {
    TComponentButton *pcb=&CompButtons[ECBS_StartBtn];
    pcb->CallBack_Click=CB_StartBtn_Click;
    pcb->pIconCanvas=Component_GetIcon(ECIT_Ok)->pCanvas;
    pcb->Rect=CreateRect(x,y,80,chksize+2);
    pcb->pMsgUTF8_eng="Start";
    pcb->pMsgUTF8_jpn="開始";
  }
  
  x+=16+80;
  
  {
    TComponentButton *pcb=&CompButtons[ECBS_CancelBtn];
    pcb->CallBack_Click=CB_CancelBtn_Click;
    pcb->pIconCanvas=Component_GetIcon(ECIT_Cancel)->pCanvas;
    pcb->Rect=CreateRect(x,y,80,chksize+2);
    pcb->pMsgUTF8_eng="Cancel";
    pcb->pMsgUTF8_jpn="戻る";
  }
}

// -----------------------------

static void CB_KeyDown(u32 Keys)
{
}

static void CB_KeyPress(u32 VsyncCount,u32 Keys)
{
  if((Keys&KEY_START)!=0) CB_StartBtn_Click(NULL);
}

static void CB_KeyUp(u32 Keys)
{
}

static bool deskmf;
static TComponentButton *pPressingButton;

static void CB_MouseDown(s32 x,s32 y)
{
  deskmf=false;
  
  for(u32 idx=0;idx<CompButtonsCount;idx++){
    TComponentButton *pcb=&CompButtons[idx];
    if(ComponentButton_GetIndexFromPos(pcb,x,y)!=-1){
      pPressingButton=pcb;
      pcb->Pressing=true;
      ComponentButton_Draw(pcb);
    }
  }
  
  deskmf=true;
}

static void CB_MouseMove(s32 x,s32 y,bool CanIgnore)
{
  if(deskmf==false) return;
  if(CanIgnore==true) return;
  
  for(u32 idx=0;idx<CompButtonsCount;idx++){
    TComponentButton *pcb=&CompButtons[idx];
    if(pcb==pPressingButton){
      if(ComponentButton_GetIndexFromPos(pcb,x,y)==-1){
        if(pcb->Pressing==true){
          pcb->Pressing=false;
          ComponentButton_Draw(pcb);
        }
        }else{
        if(pcb->Pressing==false){
          pcb->Pressing=true;
          ComponentButton_Draw(pcb);
        }
      }
    }
  }
}

static void CB_MouseUp(s32 x,s32 y)
{
  if(deskmf==false) return;
  
  deskmf=false;
  
  if(pPressingButton!=NULL){
    pPressingButton->Pressing=false;
    ComponentButton_Draw(pPressingButton);
    
    for(u32 idx=0;idx<CompButtonsCount;idx++){
      TComponentButton *pcb=&CompButtons[idx];
      if(pcb==pPressingButton){
        if(ComponentButton_GetIndexFromPos(pcb,x,y)!=-1){
          ComponentButton_MouseUp(&CompButtons[idx],x,y);
        }
      }
    }
    
    pPressingButton=NULL;
    return;
  }
  
  for(u32 idx=0;idx<CompLabelsCount;idx++){
    ComponentLabel_MouseUp(&CompLabels[idx],x,y);
  }
  for(u32 idx=0;idx<CompChecksCount;idx++){
    ComponentCheck_MouseUp(&CompChecks[idx],x,y);
  }
  for(u32 idx=0;idx<CompButtonsCount;idx++){
  }
}

static void CB_Start(void)
{
  ScreenInit(ESS_Bitmap,EDM_Vertical);
  
  {
    const u32 s=CornerIconSize;
    const u32 x=ScreenWidth;
    const u32 y=ScreenHeight-(s*8);
    CglB15 *pB15=Corner_GetIcon(EIT_Mouse);
    pScreenSubBM->Mouse_Init(x,y+(s*0),pB15->pCanvas);
  }
  
  {
    CglCanvas *pcan=pScreenMain->pCanvas;
    pcan->SetColor(BGColor15);
    pcan->FillAll();
  }
  {
    CglCanvas *pcan=pScreenSubBM->pCanvas;
    pcan->SetColor(BGColor15);
    pcan->FillAll();
  }
  
  DrawSlideOptLeft(1);
  
  deskmf=false;
  pPressingButton=NULL;
  
  pScreenMain->SetWhiteOut(16);
  pScreenSubBM->SetAlpha(0);
  
  CompsInit();
  
  SlideSetting=IPKState.SlideSetting;
  
//  pScreenSubBM->SetAlpha(8); // for Debug.
  
  SlideSetting_Redraw(true);
  
  for(u32 lev=0;lev<=16;lev+=2){
    WaitForVBlank(true);
    pScreenMain->SetWhiteOut(16-lev);
    pScreenSubBM->SetAlpha(lev);
  }
}

static void CB_VsyncUpdate(u32 VsyncCount)
{
}

static void CB_End(void)
{
  for(u32 lev=0;lev<=16;lev+=2){
    WaitForVBlank(true);
    pScreenMain->SetWhiteOut(lev);
    pScreenSubBM->SetAlpha(16-lev);
  }
  
  IPKState.SlideSetting=SlideSetting;
  ScreenEnd(ESS_Bitmap);
}

void ProcSlideOpt1_SetCallBack(void)
{
  CallBack_Start=CB_Start;
  CallBack_VsyncUpdate=CB_VsyncUpdate;
  CallBack_End=CB_End;
  CallBack_KeyDown=CB_KeyDown;
  CallBack_KeyPress=CB_KeyPress;
  CallBack_KeyUp=CB_KeyUp;
  CallBack_MouseDown=CB_MouseDown;
  CallBack_MouseMove=CB_MouseMove;
  CallBack_MouseUp=CB_MouseUp;
}

