
#ifndef proc_screen_h
#define proc_screen_h

#define VRAMWriteCache_Enable() { \
  asm volatile( \
    "mov r0,#0b00000111 \n" \
    "mcr p15, 0, r0, c3, c0, 0 \n" \
    : : : "r0" \
  ); \
}

#define VRAMWriteCache_Disable() { \
  asm volatile( \
    "mov r0,#0b00000110 \n" \
    "mcr p15, 0, r0, c3, c0, 0 \n" \
    : : : "r0" \
  ); \
}

static bool isVertical;
static s32 AutoScreenWidth,AutoScreenHeight;

enum ESubScr {ESS_Bitmap,ESS_Sprite64};

static void ScreenInit(ESubScr ESS,EDisplayMode DisplayMode)
{
  switch(DisplayMode){
    case EDM_Vertical: isVertical=true; break;
    case EDM_Horizontal: isVertical=false; break;
    default: isVertical=true; break;
  }
  
  if(isVertical==true){
    AutoScreenWidth=192;
    AutoScreenHeight=256;
    }else{
    AutoScreenWidth=256;
    AutoScreenHeight=192;
  }
  
  pScreenMain->Init(isVertical);
  
  switch(ESS){
    case ESS_Bitmap: pScreenSubBM->Init(isVertical); break;
    case ESS_Sprite64: pScreenSub64->Init(isVertical); break;
  }
  
  Global_isVertical=isVertical;
  Global_ScreenWidth=AutoScreenWidth;
  Global_ScreenHeight=AutoScreenHeight;
}

static void ScreenEnd(ESubScr ESS)
{
  pScreenMain->End();
  
  switch(ESS){
    case ESS_Bitmap: pScreenSubBM->End(); break;
    case ESS_Sprite64: pScreenSub64->End(); break;
  }
}

#include "lang.h"
#include "component.h"

static void DrawSlideOptLeft(u32 page)
{
  CglCanvas *pcan=pScreenMain->pCanvas;
  
  pcan->SetCglFont(pCglFont_Large14);
  pcan->SetFontBGColor(GlobalBGColor15);
  pcan->SetFontTextColor(GlobalTextColor15);
  
  const u32 msgcnt=12;
  const char msge[msgcnt][64]={"Page.1",
                               "Slide show menu",
                               "",
                               "Page.2",
                               "Fade type setting",
                               "",
                               "Page.3",
                               "BGM setting",
                               "",
                               "Page.4",
                               "Property sheet",
                               "",
                               };
  const char msgj[msgcnt][64]={"Page.1",
                               "スライドショーメニュー",
                               "",
                               "Page.2",
                               "画面効果設定メニュー",
                               "",
                               "Page.3",
                               "BGM設定メニュー",
                               "",
                               "Page.4",
                               "プロパティシート",
                               "",
                               };
  
  const char *pmsgUTF8;
  u32 x=(4*2)+16,y=32;
  for(u32 idx=0;idx<msgcnt;idx++){
    pmsgUTF8=Lang_GetTextUTF8(msge[idx],msgj[idx]);
    pcan->TextOutUTF8(x,y+(idx*16),pmsgUTF8);
  }
  
  CglB15 *pb15=Component_GetIcon(ECIT_Ok);
  
  if(pb15!=NULL){
    pb15->pCanvas->BitBlt(pcan,4,y+(((page-1)*3)*16)+8,16,16,0,0,true);
  }
}

#endif

