
#include <nds.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "_console.h"
#include "_consolewritelog.h"
#include "maindef.h"
#include "memtool.h"
#include "_const.h"
#include "lang.h"
#include "inifile.h"

#include "glib/glib.h"

#include "gba_nds_fat.h"
#include "zlibhelp.h"
#include "cstream_fs.h"
#include "cipk.h"
#include "ipkfilelist.h"
#include "corner.h"
#include "ipkstate.h"

#include "shell.h"

#include "proc_screen.h"

static s32 ImgSel_LargeThumbnailLastIndex;
static s32 ImgSel_LargeThumbnailIndex;
static s32 ImgSel_LargeThumbnailStateValue;
static s32 ImgSel_LargeThumbnailWhiteOutState;
static s32 ImgSel_LargeThumbnailChangeEffect;

#define ImgSel_LargeThumbnailStateValueRestart (6)

static CglB15 *pCoverB15;

typedef struct {
  FAT_FILE *pfilehandle;
  CStreamFS *pstream;
  CIPK *pipk;
  TIPKThumbnail thumb;
  TIPKImageInfo imginfo;
} TLargeThumbnail;

static TLargeThumbnail LargeThumbnail;

static void IPK_LargeThumbnailInit(void)
{
  TLargeThumbnail *plt=&LargeThumbnail;
  
  plt->pfilehandle=NULL;
  plt->pstream=NULL;
  plt->pipk=NULL;
  
  TIPKThumbnail *pth=&plt->thumb;
  pth->Width=0;
  pth->Height=0;
  pth->Ratio=0<<16;
  pth->pBuf=NULL;
  
  TIPKImageInfo *pif=&plt->imginfo;
  pif->Width=0;
  pif->Height=0;
  pif->MCUXCount=0;
  pif->MCUYCount=0;
}

static void IPK_LargeThumbnailFree(void)
{
  TLargeThumbnail *plt=&LargeThumbnail;
  
  if(plt->pipk!=NULL){
    delete plt->pipk; plt->pipk=NULL;
  }
  if(plt->pstream!=NULL){
    delete plt->pstream; plt->pstream=NULL;
  }
  if(plt->pfilehandle!=NULL){
    FAT_fclose(plt->pfilehandle);
    plt->pfilehandle=NULL;
  }
  
  TIPKThumbnail *pth=&plt->thumb;
  if(pth->pBuf!=NULL){
    safefree(pth->pBuf); pth->pBuf=NULL;
  }
  
  IPK_LargeThumbnailInit();
}

static bool DrawCoverImage(CIPK *pipk)
{
  TIPKThumbnail thumb;
  
  if(pipk->GetCoverImage(&thumb)==false) return(false);
  
  CglCanvas *pcan;
  
  if( ((thumb.Width==256)&&(thumb.Height==192)) || ((thumb.Width==192)||(thumb.Height==256)) ){
    pScreenMain->End();
    if(thumb.Width==256){
      pScreenMain->Init(false);
      }else{
      pScreenMain->Init(true);
    }
    
    pcan=pScreenMain->pCanvas;
    
    if(thumb.pBuf!=NULL){
      u16 *psrcbuf=thumb.pBuf;
      u32 srcbufw=thumb.Width;
      u16 *pdstbuf=pcan->GetScanLine(0);
      u32 dstbufw=pcan->GetWidth();
      
      for(u32 py=0;py<thumb.Height;py++){
        MemCopy16DMA3(psrcbuf,pdstbuf,thumb.Width*2);
        psrcbuf+=srcbufw;
        pdstbuf+=dstbufw;
      }
    }
  }
  
  if(thumb.pBuf!=NULL){
    safefree(thumb.pBuf); thumb.pBuf=NULL;
  }
  
  return(true);
}

static bool IPK_LargeThumbnailUpdate(void)
{
  if(ImgSel_LargeThumbnailWhiteOutState!=-1){
    ImgSel_LargeThumbnailWhiteOutState++;
    pScreenMain->SetWhiteOut(ImgSel_LargeThumbnailWhiteOutState);
    if(ImgSel_LargeThumbnailWhiteOutState==16) ImgSel_LargeThumbnailWhiteOutState=-1;
    return(true);
  }
  
  if(ImgSel_LargeThumbnailStateValue==-1) return(false);
  if(ImgSel_LargeThumbnailLastIndex==ImgSel_LargeThumbnailIndex) return(false);
  if(IPKFileListCount<=ImgSel_LargeThumbnailIndex) return(false);
  
  s32 state=ImgSel_LargeThumbnailStateValue;
  ImgSel_LargeThumbnailStateValue=state+1;
  
  if(state==(18+1)){
    ImgSel_LargeThumbnailLastIndex=ImgSel_LargeThumbnailIndex;
    ImgSel_LargeThumbnailStateValue=-1;
    return(false);
  }
  
  s32 ImageIndex=ImgSel_LargeThumbnailIndex;
  
  if(state<=8){
    s32 ofs=state;
    pScreenMain->SetWhiteOut(ofs*2);
    pScreenMain->SetOffsetPos(0,ofs*ImgSel_LargeThumbnailChangeEffect*-1);
    }else{
    if(10<=state){
      s32 ofs=8-(state-10);
      pScreenMain->SetWhiteOut(ofs*2);
      pScreenMain->SetOffsetPos(0,ofs*ImgSel_LargeThumbnailChangeEffect*1);
    }
  }
  
  TLargeThumbnail *plt=&LargeThumbnail;
  TIPKThumbnail *pth=&plt->thumb;
//  TIPKImageInfo *pif=&plt->imginfo;
  
  static bool CoverMode;
  
  CglCanvas *pcan=pScreenMain->pCanvas;
  
  switch(state){
    case 0: case 1: case 2: case 3: case 4: case 5: {
    } break;
    case 6: {
      IPK_LargeThumbnailFree();
      
      char *pfullfn=IPK_GetFullFilename(ImageIndex);
      plt->pfilehandle=FAT_fopen(pfullfn,"r");
      if(plt->pfilehandle==NULL){
        _consolePrintf("file open error.\n[%s]\n",pfullfn);
        ShowLogHalt();
      }
      plt->pstream=new CStreamFS(plt->pfilehandle);
      plt->pipk=new CIPK(plt->pstream);
    } break;
    case 7: {
      pcan->SetColor(GlobalBGColor15);
      pcan->FillAll();
    } break;
    case 8: {
      if(DrawCoverImage(plt->pipk)==true){
        CoverMode=true;
        }else{
        CoverMode=false;
        pScreenMain->End();
        if(GlobalINI.System.FileSelectVertical==true){
          pScreenMain->Init(true);
          plt->pipk->GetThumbnail(0,EIPKTHID_192256,pth);
          }else{
          pScreenMain->Init(false);
          plt->pipk->GetThumbnail(0,EIPKTHID_256192,pth);
        }
      }
    } break;
    case 9: {
    } break;
    case 10: {
      if(CoverMode==false){
        u16 *psrcbuf=pth->pBuf;
        u32 srcbufw=pth->Width;
        u16 *pdstbuf=pcan->GetScanLine(0);
        u32 dstbufw=pcan->GetWidth();
        
        u32 cx=(AutoScreenWidth-pth->Width)/2;
        u32 cy=(AutoScreenHeight-pth->Height)/2;
        pdstbuf+=cx+(dstbufw*cy);
        
        for(u32 py=0;py<pth->Height;py++){
          MemCopy16DMA3(psrcbuf,pdstbuf,pth->Width*2);
          psrcbuf+=srcbufw;
          pdstbuf+=dstbufw;
        }
      }
    } break;
    case 11: {
      if(CoverMode==false){
        pcan->SetCglFont(pCglFont_Large14);
        pcan->SetFontBGColor(GlobalBGColor15);
        pcan->SetFontTextColor(GlobalTextColor15);
      }
    } break;
    case 12: {
      if(CoverMode==false){
        u32 y=AutoScreenHeight-2-(16*3);
        u32 x=2;
        y+=16*0;
        
        char msg[256];
        {
          u32 size=plt->pstream->GetSize();
          if(size<1024){
            snprintf(msg,256,"%d/%d %dByte",ImageIndex+1,IPKFileListCount,size);
            }else{
            if(size<1024*1024){
              snprintf(msg,256,"%d/%d %dKByte",ImageIndex+1,IPKFileListCount,size/1024);
              }else{
              if(size<1024*1024*1024){
                snprintf(msg,256,"%d/%d %dMByte",ImageIndex+1,IPKFileListCount,size/1024/1024);
                }else{
                snprintf(msg,256,"%d/%d %dGByte",ImageIndex+1,IPKFileListCount,size/1024/1024/1024);
              }
            }
          }
        }
        pcan->SetFontBGColor(GlobalTextColor15);
        pcan->SetFontTextColor(GlobalBGColor15);
        pcan->TextOutA(x-1,y-1,msg);
        pcan->TextOutA(x-1,y+1,msg);
        pcan->TextOutA(x+1,y-1,msg);
        pcan->TextOutA(x+1,y+1,msg);
        pcan->SetFontBGColor(GlobalBGColor15);
        pcan->SetFontTextColor(GlobalTextColor15);
        pcan->TextOutA(x,y,msg);
      }
    } break;
    case 13: {
      if(CoverMode==false){
        u32 y=AutoScreenHeight-2-(16*3);
        u32 x=2;
        y+=16*1;
        
        UnicodeChar *msgw=IPKFileList[ImageIndex].pUnicodePath;
        pcan->SetFontBGColor(GlobalTextColor15);
        pcan->SetFontTextColor(GlobalBGColor15);
        pcan->TextOutW(x-1,y-1,msgw);
        pcan->TextOutW(x-1,y+1,msgw);
        pcan->TextOutW(x+1,y-1,msgw);
        pcan->TextOutW(x+1,y+1,msgw);
        pcan->SetFontBGColor(GlobalBGColor15);
        pcan->SetFontTextColor(GlobalTextColor15);
        pcan->TextOutW(x,y,msgw);
      }
    } break;
    case 14: {
      if(CoverMode==false){
        u32 y=AutoScreenHeight-2-(16*3);
        u32 x=2;
        y+=16*2;
        
        UnicodeChar *msgw=IPKFileList[ImageIndex].pUnicodeFilename;
        pcan->SetFontBGColor(GlobalTextColor15);
        pcan->SetFontTextColor(GlobalBGColor15);
        pcan->TextOutW(x-1,y-1,msgw);
        pcan->TextOutW(x-1,y+1,msgw);
        pcan->TextOutW(x+1,y-1,msgw);
        pcan->TextOutW(x+1,y+1,msgw);
        pcan->SetFontBGColor(GlobalBGColor15);
        pcan->SetFontTextColor(GlobalTextColor15);
        pcan->TextOutW(x,y,msgw);
      }
    } break;
    case 15: case 16: case 17: case 18: {
    } break;
  }
  
  return(true);
}

static void IPK_LargeThumbnail_StartPageIn(void)
{
  IPK_LargeThumbnailFree();
  ImgSel_LargeThumbnailLastIndex=-1;
  ImgSel_LargeThumbnailStateValue=ImgSel_LargeThumbnailStateValueRestart; // skip fadeout.
  ImgSel_LargeThumbnailWhiteOutState=-1;
  ImgSel_LargeThumbnailChangeEffect=0;
}

static void IPK_LargeThumbnail_StartPageOut(void)
{
  IPK_LargeThumbnailFree();
  ImgSel_LargeThumbnailStateValue=-1;
  ImgSel_LargeThumbnailWhiteOutState=0;
  ImgSel_LargeThumbnailChangeEffect=0;
}

static void DrawCornerIcon(void)
{
  const u32 s=CornerIconSize;
  
  CglCanvas *pcan=pScreenSubBM->pCanvas;
  CglB15 *pB15;
  
  pB15=Corner_GetIcon(EIT_Lite);
  pB15->pCanvas->BitBlt(pcan,0,0,s,s,0,0,true);
}

// -------------------------------------------------------------------

static const s32 ItemOffsetX=2;
static s32 ItemOffsetY;
static const s32 ItemLinePadWidth=6;
static const s32 ItemLinePadHeight=3;
static s32 ItemWidth;
static const s32 ItemHeight=24;
static const s32 ItemTextOfsX=4;
static const s32 ItemTextOfsY=(ItemHeight-(ItemLinePadHeight*2)-14)/2;
static const s32 ItemSelectOfsX=2;
static const s32 ItemSelectOfsY=2;

static s32 ItemShowCount;

typedef struct {
  bool RedrawFlag;
  s32 x,y;
  CglCanvas *pBGCanvas,*pTextCanvas;
} TFileItem;

static s32 FileItemCount;
static TFileItem *pFileItems;
static s32 FileItem_TopIndex;
static s32 FileItem_OffsetWait;
static s32 FileItem_OffsetX;

static bool FileList_IsInside(s32 fileidx)
{
  if((fileidx<FileItem_TopIndex)||((FileItem_TopIndex+ItemShowCount)<=fileidx)) return(false);
  if(FileItemCount<=fileidx) return(false);
  
  s32 y=ItemOffsetY+ItemLinePadHeight+((fileidx-FileItem_TopIndex)*ItemHeight);
  
  if((0<=y)&&(y<(AutoScreenHeight-ItemHeight))) return(true);
  
  return(false);
}

static s32 FileList_GetIndexFromPos(s32 x,s32 y)
{
  for(s32 idx=0;idx<IPKFileListCount;idx++){
    s32 iy=ItemOffsetY+((idx-FileItem_TopIndex)*ItemHeight);
    if((iy<=y)&&(y<(iy+ItemHeight))){
      if(FileList_IsInside(idx)==true) return(idx);
    }
  }
  return(-1);
}

static void FileItem_Init(void)
{
  FileItemCount=IPKFileListCount;
  pFileItems=(TFileItem*)safemalloc(FileItemCount*sizeof(TFileItem));
  
  FileItem_TopIndex=0;
  
  for(s32 idx=0;idx<FileItemCount;idx++){
    TFileItem *pfi=&pFileItems[idx];
    pfi->RedrawFlag=true;
    pfi->x=0;
    pfi->y=0;
    pfi->pBGCanvas=new CglCanvas(NULL,1,1,pf15bit);
    
    pfi->pTextCanvas=new CglCanvas(NULL,1,1,pf15bit);
    
    UnicodeChar *ufn=IPKFileList[idx].pUnicodeFilename;
    pfi->pTextCanvas->SetCglFont(pCglFont_Large14);
    u32 tw=pfi->pTextCanvas->GetTextWidthW(ufn)+16;
    u32 th=pCglFont_Large14->GetFontHeight();
    u16 bgcol=RGB15(31,31,31)|BIT15;
    
    pfi->pTextCanvas->SetVRAMBuf(NULL,tw,th,pf15bit);
    pfi->pTextCanvas->SetColor(bgcol);
    pfi->pTextCanvas->FillAll();
    pfi->pTextCanvas->SetFontBGColor(bgcol);
    pfi->pTextCanvas->SetFontTextColor(RGB15(0,0,0)|BIT15);
    pfi->pTextCanvas->TextOutW(0,0,ufn);
    
    u16 *pbuf=pfi->pTextCanvas->GetVRAMBuf();
    for(u32 idx=0;idx<tw*th;idx++){
      pbuf[idx]=pbuf[idx]&31;
    }
  }
  
  if((FileItem_TopIndex+ItemShowCount)<=CurrentIPKFileIndex){
    FileItem_TopIndex=CurrentIPKFileIndex-(ItemShowCount-1);
  }
}

static void FileItem_Free(void)
{
  for(s32 idx=0;idx<FileItemCount;idx++){
    TFileItem *pfi=&pFileItems[idx];
    pfi->x=0;
    pfi->y=0;
    delete pfi->pBGCanvas; pfi->pBGCanvas=NULL;
    delete pfi->pTextCanvas; pfi->pTextCanvas=NULL;
  }
  
  FileItemCount=0;
  safefree(pFileItems); pFileItems=NULL;
}

static inline void getrgb(u32 col,u32 *r,u32 *g,u32 *b)
{
  *r=(col>>0)&0x1f;
  *g=(col>>5)&0x1f;
  *b=(col>>10)&0x1f;
}

static void FileItem_Refresh(s32 fileidx,s32 ofsx)
{
  if(FileList_IsInside(fileidx)==false) return;
  
  CglCanvas *pCanvas=pScreenSubBM->pCanvas;
  TFileItem *pfi=&pFileItems[fileidx];
  
  s32 x=pfi->x;
  s32 y=pfi->y;
  s32 bgw=pfi->pBGCanvas->GetWidth();
  s32 bgh=pfi->pBGCanvas->GetHeight();
  s32 tw=pfi->pTextCanvas->GetWidth();
  s32 th=pfi->pTextCanvas->GetHeight();
  
  pfi->pBGCanvas->BitBlt(pCanvas,x,y,bgw,bgh,0,0,false);
  
  if(tw<=bgw){
    u16 *psrcbuf=pfi->pTextCanvas->GetVRAMBuf();
    u16 *pdstbuf=pCanvas->GetVRAMBuf();
    pdstbuf+=pfi->x+(pfi->y*pCanvas->GetWidth());
    for(s32 y=0;y<th;y++){
      for(s32 x=0;x<tw;x++){
        u32 a=psrcbuf[x];
        if(a!=31){
          u32 r,g,b;
          getrgb(pdstbuf[x],&r,&g,&b);
          pdstbuf[x]=RGB15(r*a/32,g*a/32,b*a/32)|BIT15;
        }
      }
      psrcbuf+=pfi->pTextCanvas->GetWidth();
      pdstbuf+=pCanvas->GetWidth();
    }
    }else{
    u16 *psrcbuf=pfi->pTextCanvas->GetVRAMBuf();
    u16 *pdstbuf=pCanvas->GetVRAMBuf();
    pdstbuf+=pfi->x+(pfi->y*pCanvas->GetWidth());
    for(s32 y=0;y<bgh;y++){
      for(s32 x=0;x<bgw;x++){
        u32 a=psrcbuf[(x+ofsx)%tw];
        if(a!=31){
          u32 r,g,b;
          getrgb(pdstbuf[x],&r,&g,&b);
          pdstbuf[x]=RGB15(r*a/32,g*a/32,b*a/32)|BIT15;
        }
      }
      psrcbuf+=pfi->pTextCanvas->GetWidth();
      pdstbuf+=pCanvas->GetWidth();
    }
  }
}

static void DrawFileList(void)
{
  CglCanvas *pCanvas=pScreenSubBM->pCanvas;
  
  u32 TextHeight=pCglFont_Large14->GetFontHeight();
  
  for(s32 idx=0;idx<ItemShowCount;idx++){
    s32 fileidx=FileItem_TopIndex+idx;
    if(FileList_IsInside(fileidx)==true){
      if(pFileItems[fileidx].RedrawFlag==true){
        pFileItems[fileidx].RedrawFlag=false;
        s32 x=ItemOffsetX+ItemLinePadWidth;
        s32 y=ItemOffsetY+(idx*ItemHeight)+ItemLinePadHeight;
        u16 bgcol,textcol;
        
        u32 fx=x;
        u32 fy=y;
        u32 fw=ItemWidth;
        u32 fh=ItemHeight-ItemLinePadHeight;
        
        pCoverB15->pCanvas->BitBlt(pCanvas,fx,fy,fw,fh,fx,fy,false);
        fh-=ItemLinePadHeight;
        
        if(CurrentIPKFileIndex==fileidx){
          x+=ItemSelectOfsX;
          y+=ItemSelectOfsY;
          fx+=ItemSelectOfsX;
          fy+=ItemSelectOfsY;
          fw-=ItemSelectOfsX;
        }
        
        if(CurrentIPKFileIndex==fileidx){
          bgcol=RGB15(4,4,3)|BIT15;
          textcol=GlobalBGColor15;
          u16 *pBuf=pCanvas->GetScanLine(fy)+fx;
          u32 BufSize=pCanvas->GetWidth();
          for(u32 y=0;y<fh;y++){
            if((y==0)||(y==(fh-1))){
              for(u32 x=2;x<fw;x++){
                u32 r,g,b;
                getrgb(pBuf[x],&r,&g,&b);
                pBuf[x]=RGB15((r*7)/8,(g*7)/8,(b*7)/8)|BIT15;
              }
              }else{
              if((y==1)||(y==(fh-1-1))){
                {
                  u32 x=1;
                  u32 r,g,b;
                  getrgb(pBuf[x],&r,&g,&b);
                  pBuf[x]=RGB15((r*7)/8,(g*7)/8,(b*7)/8)|BIT15;
                }
                for(u32 x=2;x<fw;x++){
                  u32 r,g,b;
                  getrgb(pBuf[x],&r,&g,&b);
                  pBuf[x]=RGB15((r*6)/8,(g*6)/8,(b*6)/8)|BIT15;
                }
                }else{
                {
                  u32 x=0;
                  u32 r,g,b;
                  getrgb(pBuf[x],&r,&g,&b);
                  pBuf[x]=RGB15((r*7)/8,(g*7)/8,(b*7)/8)|BIT15;
                }
                {
                  u32 x=1;
                  u32 r,g,b;
                  getrgb(pBuf[x],&r,&g,&b);
                  pBuf[x]=RGB15((r*6)/8,(g*6)/8,(b*6)/8)|BIT15;
                }
                for(u32 x=2;x<fw;x++){
                  u32 r,g,b;
                  getrgb(pBuf[x],&r,&g,&b);
                  pBuf[x]=RGB15((r*5)/8,(g*5)/8,(b*5)/8)|BIT15;
                }
              }
            }
            pBuf+=BufSize;
          }
          }else{
          bgcol=RGB15(24,24,21)|BIT15;
          textcol=GlobalTextColor15;
          u16 *pBuf=pCanvas->GetScanLine(fy)+fx;
          u32 BufSize=pCanvas->GetWidth();
          for(u32 y=0;y<fh;y++){
            if((y==0)||(y==(fh-1))){
              for(u32 x=1;x<fw;x++){
                u32 r,g,b;
                getrgb(pBuf[x],&r,&g,&b);
                pBuf[x]=RGB15((r*7)/8,(g*7)/8,(b*7)/8)|BIT15;
              }
              }else{
              for(u32 x=0;x<fw;x++){
                u32 r,g,b;
                getrgb(pBuf[x],&r,&g,&b);
                pBuf[x]=RGB15((r*7)/8,(g*7)/8,(b*7)/8)|BIT15;
              }
            }
            pBuf+=BufSize;
          }
        }
        
        TFileItem *pfi=&pFileItems[fileidx];
        
        pfi->x=x+ItemTextOfsX;
        pfi->y=y+ItemTextOfsY;
        pfi->pBGCanvas->SetVRAMBuf(NULL,AutoScreenWidth-pfi->x,TextHeight,pf15bit);
        pCanvas->BitBlt(pfi->pBGCanvas,0,0,pfi->pBGCanvas->GetWidth(),pfi->pBGCanvas->GetHeight(),pfi->x,pfi->y,false);
        
        FileItem_Refresh(fileidx,0);
      }
    }
  }
}

// -------------------------------------------------------------------

static void FullDrawFileList(void)
{
  CglCanvas *pCanvas=pScreenSubBM->pCanvas;
  
  pCoverB15->pCanvas->BitBlt(pCanvas,0,0,AutoScreenWidth,AutoScreenHeight,0,0,false);
  
  pCanvas->SetCglFont(pCglFont_Large14);
  pCanvas->SetFontBGColor(RGB15(31,31,29)|BIT15);
  pCanvas->SetFontTextColor(GlobalTextColor15);
  
  const char *pmsg=Lang_GetTextUTF8("Please choose package","IPKファイル選択");
  pCanvas->TextOutUTF8(ItemTextOfsX+((AutoScreenWidth-ItemTextOfsX-pCanvas->GetTextWidthUTF8(pmsg))/2),8,pmsg);
  
  pCanvas->SetCglFont(NULL);
  pCanvas->SetFontBGColor(RGB15(31,31,29)|BIT15);
  pCanvas->SetFontTextColor(GlobalTextColor15);
  
  u32 h=pCanvas->GetTextHeight();
  char msg[256];
  snprintf(msg,256,"%s",ROMDATE);
  pCanvas->TextOutA(0,AutoScreenHeight-(h*2),msg);
  snprintf(msg,256,"%s %s",ROMTITLE,ROMVERSION);
  pCanvas->TextOutA(0,AutoScreenHeight-(h*1),msg);
  
  for(s32 idx=0;idx<FileItemCount;idx++){
    pFileItems[idx].RedrawFlag=true;
  }
  
  DrawCornerIcon();
  
  FileItem_OffsetWait=60;
  FileItem_OffsetX=0;
  DrawFileList();
}

static void SelectIndex(s32 idx)
{
  if(idx<0) idx=0;
  if(IPKFileListCount<=idx) idx=IPKFileListCount-1;
  
  bool fullredraw=false;
  
  if(idx<FileItem_TopIndex){
    fullredraw=true;
    FileItem_TopIndex=idx;
  }
  
  if((FileItem_TopIndex+ItemShowCount)<=idx){
    fullredraw=true;
    FileItem_TopIndex=idx-(ItemShowCount-1);
  }
  
  if(fullredraw==true){
    for(s32 idx=0;idx<FileItemCount;idx++){
      pFileItems[idx].RedrawFlag=true;
    }
  }
  
  if(CurrentIPKFileIndex!=idx){
    if(GlobalINI.CustomConfig.SwitchModeEffect==true){
      if(CurrentIPKFileIndex<idx){
        ImgSel_LargeThumbnailChangeEffect=-1;
        }else{
        if(CurrentIPKFileIndex>idx){
          ImgSel_LargeThumbnailChangeEffect=1;
          }else{
          ImgSel_LargeThumbnailChangeEffect=0;
        }
      }
      }else{
      ImgSel_LargeThumbnailChangeEffect=0;
    }
    
    if(CurrentIPKFileIndex!=-1) pFileItems[CurrentIPKFileIndex].RedrawFlag=true;
    pFileItems[idx].RedrawFlag=true;
    CurrentIPKFileIndex=idx;
    
    FileItem_OffsetWait=60;
    FileItem_OffsetX=0;
    DrawFileList();
    
    if(ImgSel_LargeThumbnailLastIndex!=ImgSel_LargeThumbnailIndex){
      ImgSel_LargeThumbnailLastIndex=-1;
    }
    
    if(ImgSel_LargeThumbnailIndex!=CurrentIPKFileIndex){
      ImgSel_LargeThumbnailIndex=CurrentIPKFileIndex;
      s32 state=ImgSel_LargeThumbnailStateValue;
      if(state==-1){
        state=0;
        }else{
        if(ImgSel_LargeThumbnailStateValueRestart<state) state=ImgSel_LargeThumbnailStateValueRestart;
      }
      ImgSel_LargeThumbnailStateValue=state;
    }
  }
}

static void SelectMousePos(s32 x,s32 y)
{
  SelectIndex(FileList_GetIndexFromPos(x,y));
}

// -------------------------

static bool CommandKeyDown;

static void CB_KeyDown(u32 Keys)
{
  if(CommandKeyDown==true) return;
  
  if((Keys&KEY_L)!=0){
    CommandKeyDown=true;
  }
}

static void CB_KeyPress(u32 VsyncCount,u32 Keys)
{
  if(CommandKeyDown==true) return;
  
  if((Keys&KEY_START)!=0){
    SlidePlay_ReturnToFileSelect=true;
    NextProc=ENP_SlidePlay;
    return;
  }
  
  s32 vy=0;
  
  if((Keys&KEY_UP)!=0) vy=-1;
  if((Keys&KEY_DOWN)!=0) vy=1;
  if((Keys&KEY_LEFT)!=0) vy=-(ItemShowCount-1);
  if((Keys&KEY_RIGHT)!=0) vy=ItemShowCount-1;
  
  SelectIndex(CurrentIPKFileIndex+vy);
}

static void CB_KeyUp(u32 Keys)
{
  if(CommandKeyDown==true){
    CommandKeyDown=false;
    if((Keys&KEY_L)!=0){
      NextProc=ENP_Thumbnail;
    }
  }
}

static bool deskmf;
static ECornerItem deskCornerItem;
static s32 deskmx,deskmy;
static u32 deskpresscount;
static s32 lastidx;

static void CB_MouseDown(s32 x,s32 y)
{
  deskmf=false;
  
  deskCornerItem=GetInsideCornerItem(x,y);
  if(deskCornerItem==ECI_LeftUp) return;
  deskCornerItem=ECI_None;
  
  deskmx=x;
  deskmy=y;
  deskpresscount=0;
  
  lastidx=CurrentIPKFileIndex;
  
  SelectMousePos(x,y);
  
  deskmf=true;
}

static void CB_MouseMove(s32 x,s32 y,bool CanIgnore)
{
  if(deskmf==false) return;
  if(CanIgnore==true) return;
  SelectMousePos(x,y);
}

static void CB_MouseUp(s32 x,s32 y)
{
  if(deskmf==false){
    ECornerItem ECI=GetInsideCornerItem(x,y);
    if(ECI!=ECI_None){
      if(ECI!=deskCornerItem) return;
      switch(ECI){
        case ECI_LeftUp: {
          PressNDSL();
        } break;
        default: break;
      }
      return;
    }
  }
  
  if(deskmf==false) return;
  
  SelectMousePos(x,y);
  
  s32 idx=FileList_GetIndexFromPos(x,y);
  
  if(idx!=-1){
    if(lastidx==CurrentIPKFileIndex){
      if(deskpresscount<10){
        if((abs(x-deskmx)<8)&&(abs(y-deskmy)<8)){
          NextProc=ENP_Thumbnail;
        }
      }
    }
  }
  
  deskmf=false;
}

static void CB_Start(void)
{
  if(GlobalINI.System.FileSelectVertical==true){
    ScreenInit(ESS_Bitmap,EDM_Vertical);
    }else{
    ScreenInit(ESS_Bitmap,EDM_Horizontal);
  }
  
  pScreenMain->SetOffsetPos(0,0);
  
  if(isVertical==true){
    ItemShowCount=8;
    ItemOffsetY=30;
    }else{
    ItemShowCount=6;
    ItemOffsetY=24;
  }
  ItemWidth=AutoScreenWidth-ItemOffsetX-ItemLinePadWidth;
  
  {
    const u32 s=CornerIconSize;
    u32 x=AutoScreenWidth;
    u32 y=AutoScreenHeight;
    if(isVertical==true){
      y-=s*8;
      }else{
      x-=s*8;
    }
    CglB15 *pB15=Corner_GetIcon(EIT_Mouse);
    pScreenSubBM->Mouse_Init(x,y,pB15->pCanvas);
  }
  
  CommandKeyDown=false;
  deskmf=false;
  deskCornerItem=ECI_None;
  
  {
    u8 *pb15;
    int b15size;
    if(Shell_ReadFileAlloc("cover256.b15",(void**)&pb15,&b15size)==false){
      _consolePrintf("File not found.\n");
      ShowLogHalt();
    }
    pCoverB15=new CglB15(pb15,b15size);
    safefree(pb15); pb15=NULL;
  }
  
  _consolePrint("FileItem_Init();\n");
  FileItem_Init();
  
  pScreenSubBM->SetAlpha(0);
//  pScreenSubBM->SetAlpha(4); // for Debug.
  _consolePrint("FullDrawFileList();\n");
  FullDrawFileList();
  
  _consolePrint("IPK_LargeThumbnailInit();\n");
  IPK_LargeThumbnailInit();
  
  ImgSel_LargeThumbnailIndex=CurrentIPKFileIndex;
  _consolePrint("IPK_LargeThumbnail_StartPageIn();\n");
  IPK_LargeThumbnail_StartPageIn();
  s32 blend=0;
  while(1){
    WaitForVBlank(true);
    blend++;
    pScreenSubBM->SetAlpha(blend);
    IPK_LargeThumbnailUpdate();
    if(blend==16) break;
  }
  
  _consolePrint("Initialized.\n");
}

static void CB_VsyncUpdate(u32 VsyncCount)
{
  IPK_LargeThumbnailUpdate();
  deskpresscount++;
  
  if(FileItem_OffsetWait!=0){
    FileItem_OffsetWait--;
    }else{
    FileItem_OffsetWait=1;
    FileItem_OffsetX++;
    FileItem_Refresh(CurrentIPKFileIndex,FileItem_OffsetX);
  }
}

static void CB_End(void)
{
  IPK_LargeThumbnail_StartPageOut();
  s32 blend=16;
  while(1){
    WaitForVBlank(true);
    blend--;
    pScreenSubBM->SetAlpha(blend);
    IPK_LargeThumbnailUpdate();
    if(blend==0) break;
  }
  
  IPK_LargeThumbnailFree();
  
  FileItem_Free();
  
  delete pCoverB15; pCoverB15=NULL;
  
  pScreenMain->SetOffsetPos(0,0);
  
  ScreenEnd(ESS_Bitmap);
}

void ProcFileSelect_SetCallBack(void)
{
  CallBack_Start=CB_Start;
  CallBack_VsyncUpdate=CB_VsyncUpdate;
  CallBack_End=CB_End;
  CallBack_KeyDown=CB_KeyDown;
  CallBack_KeyPress=CB_KeyPress;
  CallBack_KeyUp=CB_KeyUp;
  CallBack_MouseDown=CB_MouseDown;
  CallBack_MouseMove=CB_MouseMove;
  CallBack_MouseUp=CB_MouseUp;
}

