
#include <nds.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "_console.h"
#include "_consolewritelog.h"
#include "maindef.h"
#include "memtool.h"
#include "_const.h"

#include "glib/glib.h"

#include "ipkstate.h"
#include "proc_screen.h"

#include "gba_nds_fat.h"
#include "shell.h"

#include "ipkfilelist.h"

#define BGColor15 (RGB15(28,25,26) | BIT15)

// -----------------------------

static CglFont *pCglFont_ChkDsk;

#include "proc_chkdsk_body.h"

static void CB_Start(void)
{
  _consolePrint("Start check disk.\n");
  
  {
    u8 *pglf;
    int glfsize;
    if(Shell_ReadFileAlloc("jp12pix_chkdsk.glf",(void**)&pglf,&glfsize)==false){
      _consolePrintf("File not found.\n");
      ShowLogHalt();
    }
    pCglFont_ChkDsk=new CglFont(pglf,glfsize);
    safefree(pglf); pglf=NULL;
  }
  
  ScreenInit(ESS_Bitmap,EDM_Horizontal);
  
  pScreenSubBM->SetAlpha(16);
  pScreenSubBM->pCanvas->FillFull(GlobalBGColor15);
  
  {
    CglCanvas *pCanvas=pScreenMain->pCanvas;
    
    pCanvas->FillFull(GlobalBGColor15);
    
    pCanvas->SetCglFont(pCglFont_ChkDsk);
    pCanvas->SetFontTextColor(GlobalTextColor15);
    pCanvas->SetFontBGColor(GlobalBGColor15);
    
    pCanvas->TextOutUTF8(16,8+(16*0),ROMTITLE " " ROMVERSION);
    pCanvas->TextOutUTF8(16,8+(16*1),ROMDATE);
    pCanvas->TextOutUTF8(16,8+(16*2),ROMENV);
    
    pCanvas->TextOutUTF8(16,8+(16*4),"簡易ディスク検査を開始しました。");
  }
  
  chkdsk_DuplicateCluster();
  
  chkdsk_WriteTest();
  
  {
    CglCanvas *pCanvas=pScreenMain->pCanvas;
    pCanvas->TextOutUTF8(16,8+(16*10),"簡易ディスク検査を正常に終了しました。");
  }
  
}

static void CB_VsyncUpdate(u32 VsyncCount)
{
  if(IPKFileListCount==1){
    NextProc=ENP_Thumbnail;
    }else{
    NextProc=ENP_FileSelect;
  }
}

static void CB_End(void)
{
  ScreenEnd(ESS_Bitmap);
  
  if(pCglFont_ChkDsk!=NULL){
    delete pCglFont_ChkDsk; pCglFont_ChkDsk=NULL;
  }
}

void ProcChkDsk_SetCallBack(void)
{
  CallBack_Start=CB_Start;
  CallBack_VsyncUpdate=CB_VsyncUpdate;
  CallBack_End=CB_End;
}

