
static void boot_VRAM_GetBody(FAT_FILE *FileHandle,u32 FileSize,u32 BootAddress)
{
  u32 *pdstbuf32=(u32*)BootAddress;
  
/*
  {
    u32 *prb=(u32*)malloc(512);
    
    FAT_fseek(FileHandle,0,SEEK_SET);
    FAT_fread_fast(prb,1,512,FileHandle);
    FAT_fseek(FileHandle,0,SEEK_SET);
    
    if((prb[1]!=0x00000000)||(prb[2]!=0x00000000)){
      FAT_fseek(FileHandle,512,SEEK_SET);
      }else{
      FAT_fseek(FileHandle,0,SEEK_SET);
    }
    
    free(prb); prb=NULL;
  }
  
  {
    _consolePrint("Transfer BootStrap.\n");
    
    u32 *pBootStrap=(u32*)BootStrap_bin;
    u32 BootStrapSize=BootStrap_bin_size;
    
    MemCopy32DMA3(pBootStrap,pdstbuf32,BootStrapSize);
    pdstbuf32[0x62]=BootAddress+0x0200;
    pdstbuf32[0x65]=BootAddress+0x01a0;
    
    pdstbuf32+=BootStrapSize/4;
  }
*/
  
  _consolePrint("Load ROM\n");
  FAT_fread(pdstbuf32,1,MSE_CanVRAMSize-512,FileHandle);
}

static void boot_VRAM(FAT_FILE *FileHandle,u32 FileSize)
{
  REG_IME = IME_DISABLE;	// Disable interrupts
  REG_IF = REG_IF;	// Acknowledge interrupt
  
  IPCEX->RESET_BootAddress=0;
  IPCEX->RESET=RESET_MainMemory;
  
  VRAM_C_CR = VRAM_ENABLE | _VRAM_CD_MAIN_BG_0x6000000;
  VRAM_D_CR = VRAM_ENABLE | _VRAM_CD_MAIN_BG_0x6020000;
  
  u32 BootAddress=(u32)_VRAM_PTR;
  boot_VRAM_GetBody(FileHandle,FileSize,BootAddress);
  
  DC_FlushAll();
  
  _consolePrint("FAT_fclose\n");
  FAT_fclose(FileHandle);
  _consolePrint("FAT_FreeFiles\n");
  FAT_FreeFiles();
  
  {
    u16 KEYS_CUR;
    
    KEYS_CUR=(~REG_KEYINPUT)&0x3ff;
    while(KEYS_CUR!=0){
      KEYS_CUR=(~REG_KEYINPUT)&0x3ff;
    }
  }
  
//  _consolePrint("resetMemory1_ARM9\n");
  lp_resetMemory1_ARM9();
//  _consolePrint("resetMemory2_ARM9\n");
  lp_resetMemory2_ARM9();
  
//  _consolePrintf("Reset to 0x%08x\n",BootAddress);
  
  VRAM_C_CR = VRAM_ENABLE | _VRAM_CD_ARM7_0x6000000;
  VRAM_D_CR = VRAM_ENABLE | _VRAM_CD_ARM7_0x6020000;
  *((vu32*)0x027FFE04) = (u32)0xE59FF018;  // ldr pc, 0x027FFE24
  *((vu32*)0x027FFE24) = (u32)0x027FFE04;  // Set ARM9 Loop address
  IPCEX->RESET_BootAddress=BootAddress;
  swiSoftReset();  // Reset
  
  return; // Ăяoɂ͋AȂB
}

