
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <NDS.h>

#include "../../../ipcex.h"

#ifndef USENDSROM

bool BootNDSROM(u32 FileIndex)
{
  return(false);
}

#else

#include "../_console.h"

#include "../_const.h"

#include "gba_nds_fat.h"

#include "../memtool.h"

#include "plug_ndsrom.h"

#include "../mse.h"

#include "BootStrap_bin.h"

void videoSetModeSub_SetShowLog(bool f)
{
  videoSetModeSub(MODE_2_2D | DISPLAY_BG2_ACTIVE);
}

extern void videoSetModeSub_SetShowLog(bool e); // from main.cpp

#define _VRAM_OFFSET(n) ((n)<<3)
#define _VRAM_PTR ((u16*)0x06000000)
#define _VRAM_CD_MAIN_BG_0x6000000 (1 | _VRAM_OFFSET(0))
#define _VRAM_CD_MAIN_BG_0x6020000 (1 | _VRAM_OFFSET(1))
#define _VRAM_CD_ARM7_0x6000000 (2 | _VRAM_OFFSET(0))
#define _VRAM_CD_ARM7_0x6020000 (2 | _VRAM_OFFSET(1))

#include "mediatype.h"
#include "plug_ndsrom_resetmem.h"
#include "plug_ndsrom_vram.h"

enum EBootType {EBT_None,EBT_VRAM};

bool BootNDSROM(const char *pFilename)
{
  REG_IME=0;
  DMA0_CR=0;
  DMA1_CR=0;
  DMA2_CR=0;
  DMA3_CR=0;
  
  videoSetModeSub_SetShowLog(true);
  
  FAT_FILE *FileHandle=FAT_fopen(pFilename,"r");
  
  if(FileHandle==NULL){
    _consolePrint("Can not open NDS file.\n");
    ShowLogHalt();
  }
  
  FAT_fseek(FileHandle,0,SEEK_END);
  u32 FileSize=FAT_ftell(FileHandle);
  FAT_fseek(FileHandle,0,SEEK_SET);
  
  if(FileSize==0){
    _consolePrint("Can not open NDS file.\n");
    ShowLogHalt();
  }
  
  {
    u16 _VRAM_C_CR=VRAM_C_CR;
    u16 _VRAM_D_CR=VRAM_D_CR;
    VRAM_C_CR = VRAM_ENABLE | _VRAM_CD_MAIN_BG_0x6000000;
    VRAM_D_CR = VRAM_ENABLE | _VRAM_CD_MAIN_BG_0x6020000;
    MakeMSEINFO();
    VRAM_C_CR = _VRAM_C_CR;
    VRAM_D_CR = _VRAM_D_CR;
  }
  
  EBootType BootType=EBT_None;
  
  switch(DIMediaType){
    default: break;
  }
  
  if(BootType==EBT_None){
    if((512+FileSize)<MSE_CanVRAMSize) BootType=EBT_VRAM;
  }
  
  switch(BootType){
    case EBT_VRAM: boot_VRAM(FileHandle,FileSize); break;
    default: break;
  }
  
  _consolePrint("not support adapter type.\n");
  
  return(false);
}

#endif
