
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <NDS.h>

#include "_const.h"
#include "_console.h"

#include "unicode.h"

#include "plugin.h"
#include "plugin_def.h"


// -----------------

// ------------------------------------------------------------------------------------

extern "C" {
bool StartMP3(int _FileHandle);
void FreeMP3(void);
u32 UpdateMP3(s16 *lbuf,s16 *rbuf);
s32 MP3_GetFileSize(void);
s32 MP3_GetFileOffset(void);
void MP3_SetFileOffset(s32 ofs);
u32 MP3_GetChannelCount(void);
u32 MP3_GetSampleRate(void);
u32 MP3_GetSamplePerFrame(void);
int MP3_GetInfoIndexCount(void);
bool MP3_GetInfoStrL(int idx,char *str,int len);
bool MP3_GetInfoStrW(int idx,UnicodeChar *str,int len);
bool MP3_GetInfoStrUTF8(int idx,char *str,int len);
}

bool PluginMP3_Start(int FileHandle)
{
  return(StartMP3(FileHandle));
}

void PluginMP3_Free(void)
{
  FreeMP3();
}

u32 PluginMP3_Update(s16 *lbuf,s16 *rbuf)
{
  return(UpdateMP3(lbuf,rbuf));
}

s32 PluginMP3_GetPosMax(void)
{
  return(MP3_GetFileSize());
}

s32 PluginMP3_GetPosOffset(void)
{
  return(MP3_GetFileOffset());
}

void PluginMP3_SetPosOffset(s32 ofs)
{
  MP3_SetFileOffset(ofs);
}

u32 PluginMP3_GetChannelCount(void)
{
  return(MP3_GetChannelCount());
}

u32 PluginMP3_GetSampleRate(void)
{
  return(MP3_GetSampleRate());
}

u32 PluginMP3_GetSamplePerFrame(void)
{
  return(MP3_GetSamplePerFrame());
}

int PluginMP3_GetInfoIndexCount(void)
{
  return(MP3_GetInfoIndexCount());
}

bool PluginMP3_GetInfoStrL(int idx,char *str,int len)
{
  return(MP3_GetInfoStrL(idx,str,len));
}

bool PluginMP3_GetInfoStrW(int idx,UnicodeChar *str,int len)
{
  return(MP3_GetInfoStrW(idx,str,len));
}

bool PluginMP3_GetInfoStrUTF8(int idx,char *str,int len)
{
  return(MP3_GetInfoStrUTF8(idx,str,len));
}

// -----------------------------------------------------------

