
#ifndef mse_h
#define mse_h

#define MSE_CanVRAMSize ((256*1024)-1024)

#define MSEINFO_SIZE (1024)
#define MSEINFO_ADDR (0x06040000-MSEINFO_SIZE)

#define MSEINFO_EID (0x01010101)
#define MSEINFO_StrLength (128)
#define MSEINFO_AliasLength (16)

typedef u16 MSE_UnicodeChar;

typedef struct {
  u32 EID;
  char AdapterName[8];
  char ShellPath[MSEINFO_StrLength];
  char FilePath[MSEINFO_StrLength];
  char FileAlias[MSEINFO_AliasLength];
  MSE_UnicodeChar UnicodeFilename[MSEINFO_StrLength];
  u8 dummy[MSEINFO_SIZE];
} TMSEINFO;

// for MoonShell

#define MSEFN_Reset ("RESET.MSE")
#define MSEFN_Text ("TEXT.MSE")

extern void MSEList_Init(void);
extern const char* MSEList_GetPluginFilename(char *extstr);
extern bool MSEList_isExists(const char *pmsefn);
extern u32 MSEList_GetCount(void);
extern const char* MSEList_GetFilename(u32 Index);
extern void MakeMSEINFO(void);
extern void MSE_Exec(const char *pmsefn);

// for MSE body

extern bool MSE_GetMSEINFO(TMSEINFO *pMSEINFO);

#endif

