/*---------------------------------------------------------------------------------
	$Id: template.c,v 1.4 2005/09/17 23:15:13 wntrmute Exp $

	Basic Hello World

	$Log: template.c,v $
	Revision 1.4  2005/09/17 23:15:13  wntrmute
	corrected iprintAt in templates
	
	Revision 1.3  2005/09/05 00:32:20  wntrmute
	removed references to IPC struct
	replaced with API functions
	
	Revision 1.2  2005/08/31 01:24:21  wntrmute
	updated for new stdio support

	Revision 1.1  2005/08/03 06:29:56  wntrmute
	added templates


---------------------------------------------------------------------------------*/
#include <nds.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef USENDSROM

#else 

#include "_console.h"
#include "maindef.h"
#include "memtool.h"
#include "_const.h"

#include "memtool.h"

#include "mse.h"

#include "plugin/plug_ndsrom.h"

#include "disc_io.h"
#include "mediatype.h"

#define _VRAM_OFFSET(n) ((n)<<3)
#define _VRAM_PTR ((u16*)0x06000000)
#define _VRAM_CD_MAIN_BG_0x6000000 (1 | _VRAM_OFFSET(0))
#define _VRAM_CD_MAIN_BG_0x6020000 (1 | _VRAM_OFFSET(1))
#define _VRAM_CD_ARM7_0x6000000 (2 | _VRAM_OFFSET(0))
#define _VRAM_CD_ARM7_0x6020000 (2 | _VRAM_OFFSET(1))

extern const char AdapterDetect[13];
extern s32 FS_CursorIndex;

#define FATShellPath ("")
#define FS_CursorIndex (0)

static inline char *FileSys_GetPathName(void)
{
  return("");
}

static inline char *FileSys_GetAlias(u32 CursorIndex)
{
  return("");
}

static inline MSE_UnicodeChar *FileSys_GetFilename(u32 CursorIndex)
{
  static MSE_UnicodeChar fn[2]={0,0};
  
  return(fn);
}

void MakeMSEINFO(void)
{
  TMSEINFO msei;
  MemSet8CPU(0,&msei,sizeof(TMSEINFO));
  
  msei.EID=MSEINFO_EID;
  
  *(u32*)&msei.AdapterName[0]=*(u32*)&DIMediaID[0];
  *(u32*)&msei.AdapterName[4]=0;
  
  strncpy(&msei.ShellPath[0],FATShellPath,MSEINFO_StrLength-1);
  
  strncpy(&msei.FilePath[0],FileSys_GetPathName(),MSEINFO_StrLength-1);
  strncpy(&msei.FileAlias[0],FileSys_GetAlias(FS_CursorIndex),MSEINFO_AliasLength-1);
  
  MSE_UnicodeChar *punifn=FileSys_GetFilename(FS_CursorIndex);
  u32 idx=0;
  
  while(punifn[idx]!=0){
    msei.UnicodeFilename[idx]=punifn[idx];
    idx++;
    if(idx==(MSEINFO_StrLength-1)) break;
  }
  msei.UnicodeFilename[idx]=0;
  
  MemCopy16CPU(&msei,(u16*)MSEINFO_ADDR,MSEINFO_SIZE);
}

void MSE_Exec(const char *pmsefn)
{
  if(BootNDSROM(pmsefn)==false){
    _consolePrintf("Can not boot MSE.\n%s\n",pmsefn);
//    ShowLogHalt();
  }
}

#endif

