
#ifndef memtool_h
#define memtool_h

#ifdef __cplusplus
extern "C" {
#endif

void MemCopy8CPU(void *src,void *dst,u32 len);
void MemCopy16CPU(void *src,void *dst,u32 len);
void MemCopy32CPU(void *src,void *dst,u32 len);
void MemSet8CPU(vu8 v,void *dst,u32 len);
void MemSet16CPU(vu16 v,void *dst,u32 len);
void MemSet32CPU(u32 v,void *dst,u32 len);
void MemCopy16DMA3(void *src,void *dst,u32 len);
void MemCopy32DMA3(void *src,void *dst,u32 len);
void MemSet16DMA3(vu16 v,void *dst,u32 len);
void MemSet32DMA3(u32 v,void *dst,u32 len);
void MemSet8DMA3(u8 v,void *dst,u32 len);

void MemCopy16DMA2(void *src,void *dst,u32 len);
void MemSet16DMA2(u16 v,void *dst,u32 len);

void MemSet32swi256bit(u32 v,void *dst,u32 len);
void MemCopy32swi256bit(void *src,void *dst,u32 len);

void atype_init(void);
void atype_showallocated(void);
void atype_lockall(void);
void atype_checkmemoryleak(void);
void atype_checkoverrange(void);

extern const char *pmalloctext;

extern bool (*safemalloc_RequestFreeArea)(void);

void *safemalloc(int size);
void *safemalloc_nocheck(int size);
void safefree(void *ptr);
bool testmalloc(int size);
void PrintFreeMem(void);
u32 GetFreeMem(void);

void PrintAccuracyFreeMem(void);

#ifdef __cplusplus
}
#endif

#endif

