/*---------------------------------------------------------------------------------
	$Id: template.c,v 1.4 2005/09/17 23:15:13 wntrmute Exp $

	Basic Hello World

	$Log: template.c,v $
	Revision 1.4  2005/09/17 23:15:13  wntrmute
	corrected iprintAt in templates
	
	Revision 1.3  2005/09/05 00:32:20  wntrmute
	removed references to IPC struct
	replaced with API functions
	
	Revision 1.2  2005/08/31 01:24:21  wntrmute
	updated for new stdio support

	Revision 1.1  2005/08/03 06:29:56  wntrmute
	added templates


---------------------------------------------------------------------------------*/
#include <nds.h>
#include "../../ipcex.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "_console.h"
#include "_consolewritelog.h"
#include "maindef.h"
#include "memtool.h"
#include "_const.h"
#include "arm9tcm.h"

#include "gba_nds_fat.h"
#include "zlibhelp.h"
#include "cstream_fs.h"

#include "cimfs.h"
#include "inifile.h"
#include "shell.h"
#include "unicode.h"
#include "lang.h"
#include "mse.h"

#include "strpcm.h"

#include "ipkfilelist.h"
#include "component.h"
#include "corner.h"

#include "ipkstate.h"

#include "customjpeg.h"

#include "filesys.h"

#include "plugin.h"
#include "plug_mp3_int.h"

#include "setarm9_reg_waitcr.h"

void (*CallBack_Start)(void);
void (*CallBack_VsyncUpdate)(u32 VsyncCount);
void (*CallBack_End)(void);
void (*CallBack_KeyDown)(u32 Keys);
void (*CallBack_KeyPress)(u32 VsyncCount,u32 Keys);
void (*CallBack_KeyUp)(u32 Keys);
void (*CallBack_MouseDown)(s32 x,s32 y);
void (*CallBack_MouseMove)(s32 x,s32 y,bool CanIgnore);
void (*CallBack_MouseUp)(s32 x,s32 y);
void (*CallBack_strpcmRequestStop)(void);

bool RequestSoftReset;

ENextProc NextProc;
CglFont *pCglFont_Large14;
s32 CurrentIPKFileIndex;

bool Global_isVertical;
s32 Global_ScreenWidth,Global_ScreenHeight;

bool SlidePlay_ReturnToFileSelect;

//---------------------------------------------------------------------------------

bool strpcmUpdate_mainloop(void)
{
  if((strpcmRingLBuf==NULL)||(strpcmRingRBuf==NULL)) return(false);
  
  u32 BaseSamples=IPCEX->strpcmSamples;
  u32 Samples=0;
  
  REG_IME=0;
  
  u32 CurIndex=(strpcmRingBufWriteIndex+1) & strpcmRingBufBitMask;
  u32 PlayIndex=strpcmRingBufReadIndex;
  bool EmptyFlag;
  
  EmptyFlag=strpcmRingEmptyFlag;
  strpcmRingEmptyFlag=false;
  
  REG_IME=1;
  
  if(CurIndex==PlayIndex) return(false);
  
  if(EmptyFlag==true){
    _consolePrintf("strpcm:CPU overflow.\n");
  }
  
  s16 *ldst=&strpcmRingLBuf[BaseSamples*CurIndex];
  s16 *rdst=&strpcmRingRBuf[BaseSamples*CurIndex];
  
  if(strpcmRequestStop==true){
    Samples=0;
    }else{
    Samples=PluginMP3_Update(ldst,rdst);
    if(Samples!=BaseSamples) strpcmRequestStop=true;
  }
  
  if(Samples<BaseSamples){
    for(u32 idx=Samples;idx<BaseSamples;idx++){
      ldst[idx]=0;
      rdst[idx]=0;
    }
  }
  
  REG_IME=0;
  strpcmRingBufWriteIndex=CurIndex;
  REG_IME=1;
  
  if(Samples==0) return(false);
  
  return(true);
}


//---------------------------------------------------------------------------------

static TPlugin_StdLib sPlugin_StdLib={
  _consolePrint,
  _consolePrintf,
  _consolePrintSet,
  ShowLogHalt,
  
  MemCopy8CPU,
  MemCopy16CPU,
  MemCopy32CPU,
  MemSet16CPU,
  MemSet32CPU,
  MemCopy16DMA3,
  MemCopy32DMA3,
  MemSet16DMA3,
  MemSet32DMA3,
  MemSet8DMA3,
  safemalloc,
  safefree,
  
  calloc,
  malloc,
  free,
  realloc,
  
  rand,
  
  FileSys_fread,
  FileSys_fseek,
  FileSys_ftell,
  
  sprintf,
  snprintf,
  
  memchr,
  memcmp,
  memcpy,
  memmove,
  memset,
  
  abs,
  labs,
  llabs,
  
  atof,
  atoi,
  atol,
  atoll,
  
  strcat,
  strchr,
  strcmp,
  strcoll,
  strcpy,
  strcspn,
  strdup,
  strlen,
  strncat,
  strncmp,
  strncpy,
  strpbrk,
  strrchr,
  strsep,
  strspn,
  strstr,
  strtok,
  strxfrm,
};

TPlugin_StdLib *pStdLib;

//---------------------------------------------------------------------------------

void ShowLog(void)
{
  _consolePrint("\n");
  
  BG_PALETTE_SUB[(0*16)+0] = RGB15(0,0,0); // unuse (transparent)
  BG_PALETTE_SUB[(0*16)+1] = RGB15(0,0,8) | BIT(15); // BG color
  BG_PALETTE_SUB[(0*16)+2] = RGB15(0,0,0) | BIT(15); // Shadow color
  BG_PALETTE_SUB[(0*16)+3] = RGB15(31,31,31) | BIT(15); // Text color
  
  videoSetModeSub(MODE_2_2D | DISPLAY_BG2_ACTIVE);
  SUB_BLEND_CR=0;
}

void ShowLogHalt(void)
{
  REG_IME=0;
  
  ShowLog();
  while(1){
    swiWaitForVBlank();
  }
}

#ifdef WriteBMPFunction
#include "hio.h"
#endif

void WriteBMPFileAndHalt(void)
{
#ifdef WriteBMPFunction
  ShowLog();
  
  PrintAccuracyFreeMem();
  
  SetARM9_REG_WaitCR();
  
  {
    u32 size;
    u8 *pbuf;
    FAT_FILE *pf;
    
    _consolePrintf("write scrmain.bmp\n");
    pbuf=pScreenMain->CreateBMPImage(&size);
    if(pbuf!=NULL){
      pf=FAT_fopen("scrmain.bmp","w");
      FAT_fwrite(pbuf,1,size,pf);
      FAT_fclose(pf);
//      free(pbuf); pbuf=NULL;
    }
    
    _consolePrintf("write scrsubbm.bmp\n");
    pbuf=pScreenSubBM->CreateBMPImage(&size);
    if(pbuf!=NULL){
      pf=FAT_fopen("scrsubbm.bmp","w");
      FAT_fwrite(pbuf,1,size,pf);
      FAT_fclose(pf);
//      free(pbuf); pbuf=NULL;
    }
    
    _consolePrintf("write scrsub64.bmp\n");
    pbuf=pScreenSub64->CreateBMPImage(&size);
    if(pbuf!=NULL){
      pf=FAT_fopen("scrsub64.bmp","w");
      FAT_fwrite(pbuf,1,size,pf);
      FAT_fclose(pf);
//      free(pbuf); pbuf=NULL;
    }
    
    _consolePrintf("writed.\n");
  }
#endif
  ShowLogHalt();
}

volatile bool VBlankPassed;
static volatile u32 VBlankPassedCount;

static void InterruptHandler_VBlank(void)
{
  VBlankPassed=true;
  VBlankPassedCount++;
}

u32 GlobalSkip_LastKey;
bool GlobalSkip_WaitForVBlank;

void WaitForVBlank(bool CheckForGlobalSkip)
{
  if(GlobalSkip_WaitForVBlank==false){
    if(VBlankPassed==false){
      swiWaitForVBlank();
    }
    if(CheckForGlobalSkip==true){
      TIPCEXTouchPad TouchPad;
      MemCopy32CPU((void*)&IPCEX->IPCEXTouchPad,&TouchPad,sizeof(TIPCEXTouchPad));
      
      if(TouchPad.ReadPos==TouchPad.WritePos){
        }else{
        while(TouchPad.ReadPos!=TouchPad.WritePos){
          u32 rpos=TouchPad.ReadPos;
          bool tpress=(bool)TouchPad.Press[rpos];
          if(tpress==true) GlobalSkip_WaitForVBlank=true;
          TouchPad.ReadPos=(rpos+1)&IPCEXTouchPadMaxMask;
        }
        
        IPCEX->IPCEXTouchPad.ReadPos=TouchPad.ReadPos;
      }
      
      u32 KEYS_Cur=(~REG_KEYINPUT)&0x3ff;
      
      {
        u32 btns=~IPC->buttons;
        
        KEYS_Cur|=(~REG_KEYINPUT)&0x3ff;
        if((btns&IPC_PEN_DOWN)!=0) KEYS_Cur|=KEY_TOUCH;
        if((btns&IPC_X)!=0) KEYS_Cur|=KEY_X;
        if((btns&IPC_Y)!=0) KEYS_Cur|=KEY_Y;
      }
      
      if(KEYS_Cur!=0){
        if(GlobalSkip_LastKey==0) GlobalSkip_WaitForVBlank=true;
      }
      GlobalSkip_LastKey=KEYS_Cur;
    }
  }
  VBlankPassed=false;
}

extern u32 _pGUID;

void CheckGUID_Pre(void)
{
  u32 *pGUID=&_pGUID;
  
  if(pGUID[2]==pGUID[5]) return;
  
  _consolePrintf("pGUID=0x%x\n",pGUID);
  
  _consolePrintf("ID=0x%x\n",pGUID[0]);
  _consolePrintf("XID=0x%x\n",pGUID[1]);
  _consolePrintf("xcrc=0x%x\n",pGUID[2]);
  _consolePrintf("MemStartAddr=0x%x\n",pGUID[3]);
  _consolePrintf("MemEndAddr=0x%x\n",pGUID[4]);
  _consolePrintf("chkxcrc=0x%x\n",pGUID[5]);
  
  _consolePrint("\n");
  _consolePrint("  --- Detected fatal error !! ---\n");
  _consolePrint("\n");
  _consolePrint("  There is a loss in the main body of \n");
  _consolePrint("  The ARM9 code.\n");
  _consolePrint("  Please copy imgview.nds with Windows \n");
  _consolePrint("  again.\n");
  _consolePrint("  The cause might be a loose connection \n");
  _consolePrint("  of the equipment.\n");
  _consolePrint("\n");
}

void CheckGUID_Body(void)
{
  u32 *pGUID=&_pGUID;
  
  if(pGUID[2]==pGUID[5]) return;
  
  CglB15 *pBGBM;
  
  {
    void *pbuf;
    s32 size;
    Shell_ReadFileAlloc("guidxcrcerror.b15",&pbuf,&size);
    pBGBM=new CglB15((u8*)pbuf,size);
//    safefree(pbuf); pbuf=NULL;
  }
  
  pScreenMain->Init(false);
  pBGBM->pCanvas->BitBlt(pScreenMain->pCanvas,0,0,256,192,0,0,false);
  
  delete pBGBM; pBGBM=NULL;
  
  ShowLogHalt();
}

//---------------------------------------------------------------------------------
int main(void) {
//---------------------------------------------------------------------------------
  REG_IME=0;
  SetARM9_REG_WaitCR();
  
  REG_POWERCNT = POWER_ALL_2D;
  REG_POWERCNT |= POWER_SWAP_LCDS;
  
  atype_init();
  
  safemalloc_RequestFreeArea=NULL;
  
  glSetFuncDebugPrint(_consolePrint);
  glDefaultMemorySetting();
  
  {
    SUB_BG2_CR = BG_256_COLOR | BG_RS_64x64 | BG_MAP_BASE(8) | BG_TILE_BASE(0) | BG_PRIORITY_3; // Tile16kb Map2kb(64x32)
    
    BG_PALETTE_SUB[(0*16)+0] = RGB15(0,0,0); // unuse (transparent)
    BG_PALETTE_SUB[(0*16)+1] = RGB15(0,0,8) | BIT(15); // BG color
    BG_PALETTE_SUB[(0*16)+2] = RGB15(0,0,0) | BIT(15); // Shadow color
    BG_PALETTE_SUB[(0*16)+3] = RGB15(31,31,31) | BIT(15); // Text color
    
    u16 XDX=(u16)((8.0/6)*0x100);
    u16 YDY=(u16)((8.0/6)*0x100);
    
    SUB_BG2_XDX = XDX;
    SUB_BG2_XDY = 0;
    SUB_BG2_YDX = 0;
    SUB_BG2_YDY = YDY;
    
    SUB_BG2_CX=-1;
    SUB_BG2_CY=-1;
    
    //consoleInit() is a lot more flexible but this gets you up and running quick
    _consoleInitDefault((u16*)(SCREEN_BASE_BLOCK_SUB(8)), (u16*)(CHAR_BASE_BLOCK_SUB(0)));
    _consoleClear();
  }
  
  _consolePrintf("boot %s %s\n%s\n%s\n%s\n%s\n\n",ROMTITLE,ROMVERSION,ROMDATE,ROMAUTHOR1,ROMAUTHOR2,ROMENV);
  
  CheckGUID_Pre();
  
  glDefaultClassCreate();
  
#ifdef USEIMFS
  pIMFS=new CIMFS();
  if(pIMFS->InitIMFS()==false){
    _consolePrintf("IMFS open error.\n");
    while(1);
  }
#else
  _consolePrintf("IMFS disabled!!\n");
  while(1);
#endif
  
  CheckGUID_Body();
  
  pScreenMainOverlay->SetVisible(false);
  pScreenMain->pCanvas->SetColor(GlobalBGColor15);
  pScreenMain->pCanvas->FillAll();
  
  PrintAccuracyFreeMem();
  
  strpcmInit();
  strpcmSetVolume16(16);
  
  InitInterrupts();
  irqSet(IRQ_VBLANK, InterruptHandler_VBlank);
  irqEnable(IRQ_VBLANK);
  
  pStdLib=&sPlugin_StdLib;
  
  IPCEX->strpcmLBuf=NULL;
  IPCEX->strpcmRBuf=NULL;
  
  SetLang(EL_JPN);
  
  _consolePrintf("Initialize FAT file system.\n");
  if(FAT_InitFiles()==false){
    for(vu32 w=0;w<0x10000;w++){
    }
    if(FAT_InitFiles()==false){
      for(vu32 w=0;w<0x10000;w++){
      }
      if(FAT_InitFiles()==false){
        _consolePrintf("Fatal error! FAT_InitFiles()==false;\n");
        while(1);
      }
    }
  }
  SetARM9_REG_WaitCR();
  
  IPKFileList_FindFiles();
  atype_checkoverrange();
  
  InitINI();
  if(AliasINIFilename[0]!=0){
    FAT_FILE *pf=FAT_fopen(AliasINIFilename,"r");
    if(pf!=NULL){
      CStreamFS *pstream=new CStreamFS(pf);
      if(pstream->GetSize()!=0){
        u32 INIFileSize=pstream->GetSize();
        char *pINIFileBuf=(char*)safemalloc(INIFileSize+1);
        pINIFileBuf[INIFileSize]=(char)0;
        pstream->ReadBuffer(pINIFileBuf,INIFileSize);
        LoadINI(pINIFileBuf,INIFileSize);
        safefree(pINIFileBuf); pINIFileBuf=NULL;
        INIFileSize=0;
      }
      delete pstream; pstream=NULL;
      FAT_fclose(pf);
    }
  }
  
  IPKFileList_SetupGlobalBGMFolder(GlobalINI.System.GlobalMP3Folder);
  
  {
    void mainloop_init(void);
    void mainloop(void);
    SetARM9_REG_WaitCR();
    PrintAccuracyFreeMem();
    mainloop_init();
    PrintAccuracyFreeMem();
    mainloop();
  }
  
  ShowLogHalt();
}

static bool mf;
static s32 mx,my;

static void Proc_TouchPad(u32 VsyncCount,bool ProcCB)
{
//  u16 KEYS_CUR=(~REG_KEYINPUT)&0x3ff;
  
  TIPCEXTouchPad TouchPad;
  {
    u32 wpos=IPCEX->IPCEXTouchPad.WritePos;
    MemCopy32CPU((void*)&IPCEX->IPCEXTouchPad,&TouchPad,sizeof(TIPCEXTouchPad));
    if(wpos!=IPCEX->IPCEXTouchPad.WritePos) return;
  }
  
  static u32 MouseCursorHiddenTime;
  
  if(mf==false){
    if(MouseCursorHiddenTime!=0){
      if(MouseCursorHiddenTime<=VsyncCount){ cwl();
        MouseCursorHiddenTime=0;
        }else{ cwl();
        MouseCursorHiddenTime-=VsyncCount;
        pScreenSubBM->Mouse_SetAlpha(MouseCursorHiddenTime);
      }
      if(MouseCursorHiddenTime==0){
        pScreenSubBM->Mouse_Show(false);
        pScreenSub64->Mouse_Show(false);
      }
    }
  }
  
  if(TouchPad.ReadPos==TouchPad.WritePos) return;
  
  while(TouchPad.ReadPos!=TouchPad.WritePos){
    u32 rpos=TouchPad.ReadPos;
    if(ProcCB==true){
      bool tpress=(bool)TouchPad.Press[rpos];
      s32 tx=(s32)TouchPad.X[rpos];
      s32 ty=(s32)TouchPad.Y[rpos];
      
      if(Global_isVertical==true) convh2v(&tx,&ty);
      
      if(tpress==true){
        if(mf==false){
          mf=true;
          pScreenSubBM->Mouse_SetAlpha(32);
          pScreenSubBM->Mouse_SetPos(tx,ty);
          pScreenSubBM->Mouse_Show(true);
          pScreenSub64->Mouse_SetPos(tx,ty);
          pScreenSub64->Mouse_Show(true);
          if(CallBack_MouseDown!=NULL) CallBack_MouseDown(tx,ty);
          mx=tx;
          my=ty;
          }else{
          s32 dx=abs(mx-tx);
          s32 dy=abs(my-ty);
          if((1<=dx)||(1<=dy)){
            {//if((dx<64)&&(dy<64)){
              bool CanIgnore=true;
              if(TouchPad.WritePos==((rpos+1)&IPCEXTouchPadMaxMask)) CanIgnore=false;
              if(CanIgnore==false){
                pScreenSubBM->Mouse_SetPos(tx,ty);
                pScreenSub64->Mouse_SetPos(tx,ty);
              }
              if(CallBack_MouseMove!=NULL) CallBack_MouseMove(tx,ty,CanIgnore);
              mx=tx;
              my=ty;
            }
          }
        }
        }else{
        if(mf==true){
          mf=false;
          pScreenSubBM->Mouse_SetPos(mx,my);
          pScreenSub64->Mouse_SetPos(mx,my);
          if(CallBack_MouseUp!=NULL) CallBack_MouseUp(mx,my);
          MouseCursorHiddenTime=32;
        }
      }
    }
    TouchPad.ReadPos=(rpos+1)&IPCEXTouchPadMaxMask;
  }
  
  IPCEX->IPCEXTouchPad.ReadPos=TouchPad.ReadPos;
}

#include "main_keyrepeat.h"

static u32 KEYS_Last;
static bool KEYS_PressedL;

void Proc_KeyInput_Init(void)
{
  KEYS_Last=~0;
  KEYS_PressedL=false;
}

void Proc_KeyInput(u32 VsyncCount)
{
  if(KeyRepeatFlag==true){ cwl();
    if(KeyRepeatCount<=VsyncCount){ cwl();
      KeyRepeatCount=0;
      }else{ cwl();
      KeyRepeatCount-=VsyncCount;
    }
  }
  
  u32 KEYS_Cur=(~REG_KEYINPUT)&0x3ff;
  
#ifdef WriteBMPFunction
  if((KEYS_Cur & KEY_SELECT)!=0) WriteBMPFileAndHalt();
#endif
  
  {
    u32 btns=~IPC->buttons;
    
    KEYS_Cur|=(~REG_KEYINPUT)&0x3ff;
    if((btns&IPC_PEN_DOWN)!=0) KEYS_Cur|=KEY_TOUCH;
    if((btns&IPC_X)!=0) KEYS_Cur|=KEY_X;
    if((btns&IPC_Y)!=0) KEYS_Cur|=KEY_Y;
  }
  
  if(GlobalINI.System.StartButtonFunction==ESSBF_SoftReset){
    if((KEYS_Cur&KEY_START)!=0){
      RequestSoftReset=true;
      return;
    }
  }
  
  {
    u32 cur=KEYS_Cur;
    u32 trans=0;
    if((cur&KEY_START)!=0) trans|=KEY_START;
    if((cur&KEY_SELECT)!=0) trans|=KEY_SELECT;
    if((cur&KEY_L)!=0) trans|=KEY_L;
    if((cur&KEY_R)!=0) trans|=KEY_L;
    if(Global_isVertical==true){
      if((cur&KEY_UP)!=0) trans|=KEY_LEFT;
      if((cur&KEY_DOWN)!=0) trans|=KEY_RIGHT;
      if((cur&KEY_LEFT)!=0) trans|=KEY_DOWN;
      if((cur&KEY_RIGHT)!=0) trans|=KEY_UP;
      if((cur&KEY_X)!=0) trans|=KEY_LEFT;
      if((cur&KEY_B)!=0) trans|=KEY_RIGHT;
      if((cur&KEY_Y)!=0) trans|=KEY_DOWN;
      if((cur&KEY_A)!=0) trans|=KEY_UP;
      }else{
      if((cur&KEY_UP)!=0) trans|=KEY_UP;
      if((cur&KEY_DOWN)!=0) trans|=KEY_DOWN;
      if((cur&KEY_LEFT)!=0) trans|=KEY_LEFT;
      if((cur&KEY_RIGHT)!=0) trans|=KEY_RIGHT;
      if((cur&KEY_X)!=0) trans|=KEY_UP;
      if((cur&KEY_B)!=0) trans|=KEY_DOWN;
      if((cur&KEY_Y)!=0) trans|=KEY_LEFT;
      if((cur&KEY_A)!=0) trans|=KEY_RIGHT;
    }
    KEYS_Cur=trans;
  }
  
  if((KEYS_Last&KEY_L)==0){
    if((KEYS_Cur&KEY_L)!=0){
      if(KEYS_PressedL==false){
        KEYS_PressedL=true;
        if(CallBack_KeyDown!=NULL) CallBack_KeyDown(KEY_L);
      }
    }
  }
  if((KEYS_Last&KEY_L)!=0){
    if((KEYS_Cur&KEY_L)==0){
      if(KEYS_PressedL==true){
        KEYS_PressedL=false;
        if(CallBack_KeyDown!=NULL) CallBack_KeyUp(KEY_L);
      }
    }
  }
  
  KEYS_Last=KEYS_Cur;
  
  KEYS_Cur=KeyRepeat_Proc(KEYS_Cur);
  
  if(8<VsyncCount) VsyncCount=8;
  
  if(KEYS_Cur!=0){
    if(CallBack_KeyPress!=NULL) CallBack_KeyPress(VsyncCount,KEYS_Cur);
  }
}

static void mainloop_init_RandomInit(void)
{
#ifdef notuseIPCKey
  return;
#endif
  
  _consolePrintf("Initialize random seed.\n");
  
  IPCEX->RequestCurTime=true;
  while(IPCEX->RequestCurTime==true){
  }
  
  u32 chk=0;
  
  for(u32 cnt=0;cnt<8;cnt++){ cwl();
    chk=(chk*60)+IPCEX->curtime[cnt];
  }
  
  srand(chk);
  for(u32 idx=0;idx<(chk&0xff);idx++) rand();
  
  _consolePrintf("Initialized. random seed = %d\n",chk);
}

void mainloop_init_CanNotFoundIPK(void)
{
  CglCanvas *pcan=pScreenMain->pCanvas;
  
  pcan->SetColor(GlobalBGColor15);
  pcan->FillAll();
  
  pcan->SetCglFont(pCglFont_Large14);
  pcan->SetFontBGColor(GlobalBGColor15);
  
  const u32 msgcnt=12;
  const char msge[msgcnt][64]={"The IPK file was not ","found.",
                               "",
                               "Please convert the ","picture file into IPK ","with img2ipk.exe.",
                               "","","",
                               };
  const char msgj[msgcnt][64]={"IPKファイルが一つも","見つかりませんでした。",
                               "",
                               "img2ipk.exeを使って","画像ファイルをIPKファイル","に変換して下さい。",
                               "",
                               "あまり詳しくないですが、","readme.txtも読んでくれると","嬉しいですわはー。",
                               };
  
  for(u32 idx=0;idx<msgcnt;idx++){
    if(idx<2){
      pcan->SetFontTextColor(RGB15(8,0,0)|BIT15);
      }else{
      pcan->SetFontTextColor(GlobalTextColor15);
    }
    const char *pmsg=Lang_GetTextUTF8(msge[idx],msgj[idx]);
    pcan->TextOutUTF8(8,16+(idx*16),pmsg);
  }
}

void mainloop_init(void)
{
  {
    u32 UserLanguage=(u32)-1;
    u32 Timeout=0x10000;
    
    while(UserLanguage==(u32)-1){
      UserLanguage=IPCEX->UserLanguage;
      Timeout--;
      if(Timeout==0){
        _consolePrintf("NDS farmware language read error. ARM7CPU stopped...?\n");
        while(1);
      }
    }
    _consolePrintf("NDS farmware language ID : %d\n",UserLanguage);
    
    if(GlobalINI.System.OverrideLanguageID!=(u32)-1){
      UserLanguage=GlobalINI.System.OverrideLanguageID;
      _consolePrintf("Override language ID : %d\n",UserLanguage);
    }
    
    switch(UserLanguage){
      case 1: SetLang(EL_ENG); break; // eng
      case 2: SetLang(EL_ENG); break; // fre
      case 4: SetLang(EL_ENG); break; // ita
      case 3: SetLang(EL_ENG); break; // deu
      case 5: SetLang(EL_ENG); break; // esp
      case 0: SetLang(EL_JPN); break; // jpn
      default: SetLang(EL_ENG); break;
    }
    
  }
  
  {
    u8 *pglf;
    int glfsize;
    if(Shell_ReadFileAlloc("jp14pix2bpp.glf",(void**)&pglf,&glfsize)==false){
      _consolePrintf("File not found.\n");
      ShowLogHalt();
    }
    pCglFont_Large14=new CglFont(pglf,glfsize);
    safefree(pglf); pglf=NULL;
  }
  
  mainloop_init_RandomInit();
  
  if(IPKFileListCount==0){
    mainloop_init_CanNotFoundIPK();
    while(1) swiWaitForVBlank();
  }
}


static u32 NDSL_Brightness;

void PressNDSL(void)
{
  if(IPCEX->isNDSLite==false) return;
  NDSL_Brightness=(NDSL_Brightness+1)&3;
  IPCEX->Brightness=NDSL_Brightness;
}

void CallBackInit(void)
{
  CallBack_Start=NULL;
  CallBack_VsyncUpdate=NULL;
  CallBack_End=NULL;
  CallBack_KeyDown=NULL;
  CallBack_KeyPress=NULL;
  CallBack_KeyUp=NULL;
  CallBack_MouseDown=NULL;
  CallBack_MouseMove=NULL;
  CallBack_MouseUp=NULL;
  CallBack_strpcmRequestStop=NULL;
}

void mainloop(void)
{
  _consolePrint("mainloop\n");
  
  RequestSoftReset=false;
  
  mf=false;
  mx=0;
  my=0;
  
  Component_Init();
  Corner_Init();
  
  customjpeg_InitYUV2RGBTable();
  
  if(IPCEX->isNDSLite==false){
    NDSL_Brightness=0;
    }else{
    NDSL_Brightness=IPCEX->DefaultBrightness;
    IPCEX->Brightness=NDSL_Brightness;
  }
  
  if(0){
    _consolePrintf("\nPress any key.\n");
    u16 KEYS_CUR=(~REG_KEYINPUT)&0x3ff;
    while(KEYS_CUR==0){
      KEYS_CUR=(~REG_KEYINPUT)&0x3ff;
    }
  }
  
  GlobalSkip_LastKey=~0;
  GlobalSkip_WaitForVBlank=false;
  VBlankPassed=false;
  VBlankPassedCount=0;
  
  BG_PALETTE_SUB[(0*16)+0] = GlobalBGColor15; // unuse (transparent)
  BG_PALETTE_SUB[(0*16)+1] = GlobalBGColor15; // BG color
  BG_PALETTE_SUB[(0*16)+2] = GlobalBGColor15; // Shadow color
  BG_PALETTE_SUB[(0*16)+3] = GlobalBGColor15; // Text color
  
  KEYS_Last=0;
  KeyRepeatLastKey=0;
  KeyRepeatFlag=false;
  KeyRepeatCount=0;
  
  CurrentIPKFileIndex=0;
  SlidePlay_ReturnToFileSelect=false;
  
  if(GlobalINI.System.UseCheckDisk==true){
    NextProc=ENP_ChkDsk;
    }else{
    if(IPKFileListCount==1){
      NextProc=ENP_Thumbnail;
      }else{
      NextProc=ENP_FileSelect;
    }
  }
  
  IPKState_Init();
  
  pScreenMain->End();
  pScreenSubBM->End();
  pScreenSub64->End();
  
  atype_lockall();
  atype_showallocated();
  atype_checkoverrange();
  atype_checkmemoryleak();
  
  glMemLeak_Init();
  
  PrintAccuracyFreeMem();
  
  IPKState_Change(CurrentIPKFileIndex);
  
//  NextProc=ENP_View;
//  NextProc=GetNextProc_SlideOpt();
//  NextProc=ENP_SlidePlay;
//  NextProc=ENP_SlideOpt4;
  
  while(1){
    CallBackInit();
    
    switch(NextProc){
      case ENP_Loop: {
        _consolePrintf("Illigal process error! NextProc==ENP_Loop\n");
        ShowLogHalt();
      } break;
      case ENP_ChkDsk: ProcChkDsk_SetCallBack(); break;
      case ENP_FileSelect: ProcFileSelect_SetCallBack(); break;
      case ENP_Thumbnail: ProcThumbnail_SetCallBack(); break;
      case ENP_View: ProcView_SetCallBack(); break;
      case ENP_SlideOpt1: ProcSlideOpt1_SetCallBack(); break;
      case ENP_SlideOpt2: ProcSlideOpt2_SetCallBack(); break;
      case ENP_SlideOpt3: ProcSlideOpt3_SetCallBack(); break;
      case ENP_SlideOpt4: ProcSlideOpt4_SetCallBack(); break;
      case ENP_SlidePlay: ProcSlidePlay_SetCallBack(); break;
      default: {
        _consolePrintf("Unknown process error! NextProc==%d\n",NextProc);
        ShowLogHalt();
      } break;
    }
    
    NextProc=ENP_Loop;
    
    if(CallBack_Start!=NULL) CallBack_Start();
    
    atype_checkoverrange();
    PrintAccuracyFreeMem();
    
    GlobalSkip_LastKey=~0;
    GlobalSkip_WaitForVBlank=false;
    VBlankPassed=false;
    VBlankPassedCount=0;
    Proc_TouchPad(0,false);
    Proc_KeyInput_Init();
    
    while((NextProc==ENP_Loop)&&(RequestSoftReset==false)){
      if(CallBack_strpcmRequestStop!=NULL){
        if(strpcmRequestStop==true) CallBack_strpcmRequestStop();
        while(strpcmUpdate_mainloop()==true){
        }
      }
      
      WaitForVBlank(false);
      
      REG_IME=0;
      u32 vsynccount=VBlankPassedCount;
      VBlankPassedCount=0;
      REG_IME=1;
      
      if(CallBack_VsyncUpdate!=NULL) CallBack_VsyncUpdate(vsynccount);
      
      Proc_TouchPad(vsynccount,true);
      Proc_KeyInput(vsynccount);
    }
    
    GlobalSkip_LastKey=~0;
    if(GlobalINI.CustomConfig.SwitchModeEffect==true){
      GlobalSkip_WaitForVBlank=false;
      }else{
      GlobalSkip_WaitForVBlank=true;
    }
    VBlankPassed=false;
    VBlankPassedCount=0;
    if(CallBack_End!=NULL) CallBack_End();
    
    IPKState_Save();
    IPKState_Change(CurrentIPKFileIndex);
    
    atype_checkoverrange();
    atype_checkmemoryleak();
    glMemLeak_CheckAndHalt();
    
    PrintAccuracyFreeMem();
    
    if(RequestSoftReset==true){
      MSE_Exec(ResetMSEFilename);
      ShowLogHalt();
    }
  }
  
  Component_Free();
  Corner_Free();
}

ENextProc GetNextProc_SlideOpt(void)
{
  switch(IPKState.SlideSetting.SlideOptPage){
    case 1: return(ENP_SlideOpt1); break;
    case 2: return(ENP_SlideOpt2); break;
    case 3: return(ENP_SlideOpt3); break;
    case 4: return(ENP_SlideOpt4); break;
    default: return(ENP_SlideOpt1); break;
  }
}

void ToggleDisplayMode(void)
{
  EDisplayMode EDM=IPKState.DisplayMode;
  float TopPos=IPKState.ThumbnailTopPos;
  
  switch(EDM){
    case EDM_Vertical: {
      EDM=EDM_Horizontal;
      TopPos/=64;
      TopPos*=48;
    } break;
    case EDM_Horizontal: {
      EDM=EDM_Vertical;
      TopPos/=48;
      TopPos*=64;
    } break;
    default: {
      EDM=EDM_Vertical;
      TopPos=0;
    } break;
  }
  
  IPKState.DisplayMode=EDM;
  IPKState.ThumbnailTopPos=(s32)TopPos;
}

