
#ifndef ipkstate_h
#define ipkstate_h

extern s32 CurrentThumbnailTopPos;
extern s32 CurrentImageIndex;

extern void IPKState_Init(void);
extern void IPKState_Change(u32 IPKFileIndex);
extern void IPKState_Save(void);

enum ENextSelect {ENS_Sequence,ENS_DeletedMode,ENS_Shuffle};
enum EFadeType {EFT_RightToLeft,EFT_LeftToRight,EFT_SingleFade,EFT_SingleFlash,EFT_SingleBlind,EFT_SingleCrossFade};
enum EFadeSpeed {EFS_Slow,EFS_Norm,EFS_Fast};
enum EFadeSingleDisplay {EFSD_Left,EFSD_Right};
enum EBGMSelect {EBS_Sequence,EBS_Shuffle};

typedef struct {
  u32 WaitSec;
  u32 SlideOptPage;
  ENextSelect NextSelect;
  bool LoopPlay;
  bool StopButton;
  EFadeType FadeType;
  EFadeSpeed FadeSpeed;
  EBGMSelect BGMSelect;
  EFadeSingleDisplay FadeSingleDisplay;
  u32 dummy1;
  u32 dummy2;
} TIPKState_SlideSetting;

enum EStartPos {ESP_LeftTop,ESP_RightTop,ESP_LeftDown,ESP_RightDown};
enum EDisplayMode {EDM_Vertical,EDM_Horizontal};

typedef struct {
  s32 ThumbnailTopPos;
  s32 ImageIndex;
  s32 ScreenRatio;
  TIPKState_SlideSetting SlideSetting;
  EStartPos StartPos;
  EDisplayMode DisplayMode;
  bool DoubleScreen;
} TIPKState;

extern TIPKState IPKState;

#endif

