
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <NDS.h>

#include "_console.h"
#include "_consolewritelog.h"
#include "_const.h"
#include "memtool.h"
#include "inifile.h"

#include "ipkstate.h"

#include "directdisk.h"
#include "ipkfilelist.h"
#include "cipk.h"

#define CurrentIPKStateVersion (1)

TIPKState IPKState;

static u32 LastIPKFileIndex;

static u8 SectorBuf[DD_SectorSize];

static void state_Init(void)
{
  TIPKState *pstate=&IPKState;
  
  pstate->ThumbnailTopPos=0;
  pstate->ImageIndex=0;
  pstate->ScreenRatio=(s32)(1.0*0x100);
  
  TIPKState_SlideSetting *pss=&pstate->SlideSetting;
  
  pss->WaitSec=5;
  pss->SlideOptPage=1;
  pss->NextSelect=ENS_Sequence;
  pss->LoopPlay=true;
  pss->StopButton=false;
  pss->FadeType=EFT_RightToLeft;
  pss->FadeSpeed=EFS_Norm;
  pss->BGMSelect=EBS_Shuffle;
  pss->FadeSingleDisplay=EFSD_Left;
  pss->dummy1=0;
  pss->dummy2=0;
  
  pstate->StartPos=ESP_LeftTop;
  if(GlobalINI.System.FileSelectVertical==true){
    pstate->DisplayMode=EDM_Vertical;
    }else{
    pstate->DisplayMode=EDM_Horizontal;
  }
  pstate->DoubleScreen=false;
}

static void state_ReadFromV0(u8 *pBulkBuf)
{
}

static void state_ReadFromCurrentVersion(u8 *pBulkBuf)
{
  TIPKState_SlideSetting SlideSettingBackup=IPKState.SlideSetting;
  
  TIPKState *pDiskIPKState=(TIPKState*)pBulkBuf;
  IPKState=*pDiskIPKState;
  
  if(IPKState.ScreenRatio==0) IPKState.ScreenRatio=(s32)(1.0*0x100);
  if(IPKState.SlideSetting.NextSelect==ENS_DeletedMode) IPKState.SlideSetting.NextSelect=ENS_Sequence;
  if(IPKState.SlideSetting.WaitSec==0) IPKState.SlideSetting=SlideSettingBackup;
}

static void state_WriteToCurrentVersion(u8 *pBulkBuf)
{
  TIPKState *pDiskIPKState=(TIPKState*)pBulkBuf;
  *pDiskIPKState=IPKState;
}

void IPKState_Init(void)
{
  LastIPKFileIndex=-1;
}

void IPKState_Change(u32 IPKFileIndex)
{
  if(LastIPKFileIndex==IPKFileIndex) return;
  LastIPKFileIndex=IPKFileIndex;
  
  DD_InitFile(IPK_GetFullFilename(IPKFileIndex));
  DD_ReadFile(SectorBuf,DD_SectorSize);
  
  state_Init();
  
  s32 *pVersion=(s32*)&SectorBuf[IPKID_Size];
  u8 *pBulkBuf=(u8*)&SectorBuf[IPKID_Size+4];
  
  switch(*pVersion){
    case 0: state_ReadFromV0(pBulkBuf); break;
    case CurrentIPKStateVersion: state_ReadFromCurrentVersion(pBulkBuf); break;
    default: break;
  }
}

void IPKState_Save(void)
{
  s32 *pVersion=(s32*)&SectorBuf[IPKID_Size];
  u8 *pBulkBuf=(u8*)&SectorBuf[IPKID_Size+4];
  
  *pVersion=CurrentIPKStateVersion;
  state_WriteToCurrentVersion(pBulkBuf);
  
  DD_WriteFile(SectorBuf,DD_SectorSize);
}

