
#ifndef ipkfilename_h
#define ipkfilename_h

#include "unicode.h"

#define MaxFilenameLength (256)

enum EBGMType {EBT_None,EBT_GlobalFile,EBT_GlobalPath,EBT_File,EBT_Path};

typedef struct {
  char *pAliasPath;
  char *pAliasFilename;
  UnicodeChar *pUnicodePath;
  UnicodeChar *pUnicodeFilename;
  char *pAliasBGMPath;
  char *pAliasBGMFilename;
  EBGMType BGMType;
} TIPKFileListItem;

#define IPKFileListMax (512)
extern s32 IPKFileListCount;
extern TIPKFileListItem IPKFileList[IPKFileListMax];

extern char AliasINIFilename[MaxFilenameLength];
extern char ResetMSEFilename[MaxFilenameLength];

extern void IPKFileList_FindFiles(void);
extern void IPKFileList_SetupGlobalBGMFolder(const char *GlobalBGMFolder);

extern char *IPK_GetFullFilename(s32 IPKFileIndex);
extern char *IPK_GetGlobalBGMFilename(void);
extern char *IPK_GetGlobalBGMFilePath(void);
extern char *IPK_GetBGMPath(s32 IPKFileIndex);
extern char *IPK_GetBGMFilename(s32 IPKFileIndex);
extern EBGMType IPK_GetBGMType(s32 IPKFileIndex);

#endif

