
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <NDS.h>

#include "_console.h"
#include "_consolewritelog.h"
#include "_const.h"
#include "memtool.h"

#include "ipkfilelist.h"
#include "gba_nds_fat.h"
#include "unicode.h"
#include "strtool.h"

#include "cstream_fs.h"
#include "cipk.h"

s32 IPKFileListCount;
TIPKFileListItem IPKFileList[IPKFileListMax];

char AliasINIFilename[MaxFilenameLength];
char ResetMSEFilename[MaxFilenameLength];

static char AliasGlobalBGMFilename[MaxFilenameLength];
static char AliasGlobalBGMFilePath[MaxFilenameLength];

static bool chkipk(char *pAliasPath,char *pAliasFilename)
{
  bool res=false;
  
  FAT_FILE *pfilehandle;
  CStreamFS *pstream;
  CIPK *pipk;
  
  char fullfn[MaxFilenameLength];
  if(strcmp(pAliasPath,"/")==0){
    snprintf(fullfn,MaxFilenameLength,"/%s",pAliasFilename);
    }else{
    snprintf(fullfn,MaxFilenameLength,"%s/%s",pAliasPath,pAliasFilename);
  }
  _consolePrintf("check [%s] ",fullfn);
  
  pfilehandle=FAT_fopen(fullfn,"r");
  if(pfilehandle!=NULL){
    pstream=new CStreamFS(pfilehandle);
    pipk=new CIPK(pstream);
    if(pipk->GetFilesCount()!=0) res=true;
    delete pipk; pipk=NULL;
    delete pstream; pstream=NULL;
    FAT_fclose(pfilehandle);
    pfilehandle=NULL;
  }
  
  if(res==false){
    _consolePrintf("error. Illigal ipk version?\n");
    }else{
    _consolePrintf("ok.\n");
  }
  
  return(res);
}

#define FindPathMax (1024)
static u32 PathCount;
static char **ppAliasPaths;
static UnicodeChar **ppUnicodePaths;

__attribute__((noinline)) static void IPKFileList_FindPathIns(char *pBaseAliasPath,UnicodeChar *pBaseUnicodePath)
{
  char topaliaspath[2]={'/',0};
  if(pBaseAliasPath==NULL) pBaseAliasPath=topaliaspath;
  UnicodeChar topunicodepath[2];
  topunicodepath[0]=(UnicodeChar)'/';
  topunicodepath[1]=(UnicodeChar)0;
  if(pBaseUnicodePath==NULL) pBaseUnicodePath=topunicodepath;
  
  _consolePrintf("FindPaths.%s\n",pBaseAliasPath);
  
  if(FAT_CWD(pBaseAliasPath)==false){
    _consolePrintf("Change path error.\n");
    return;
  }
  
  u32 StartPathIndex=PathCount;
  u32 EndPathIndex=PathCount;
  
  char afn[MaxFilenameLength];
  UnicodeChar ufn[MaxFilenameLength];
  
  {
    u32 FAT_FileType;
    FAT_FileType=FAT_FindFirstFile(afn);
    
    while(FAT_FileType!=FT_NONE){
      switch(FAT_FileType){
        case FT_NONE: break;
        case FT_DIR: {
          if(FAT_GetLongFilenameUnicode(ufn,MaxFilenameLength)==false){
            _consolePrintf("Unicode filename read error.\n Alias='%s'\n",afn);
            }else{
            if((strcmp(afn,".")!=0)&&(strcmp(afn,"..")!=0)){
              if(PathCount<FindPathMax){
                char *papath=(char*)safemalloc(MaxFilenameLength);
                UnicodeChar *pupath=(UnicodeChar*)safemalloc(MaxFilenameLength*2);
                papath[0]=(char)0;
                pupath[0]=(UnicodeChar)0;
                
                UnicodeChar uslash[2];
                uslash[0]=(UnicodeChar)'/';
                uslash[1]=(UnicodeChar)0;
                
                if(strcmp(pBaseAliasPath,"/")==0){
                  snprintf(papath,MaxFilenameLength,"/%s",afn);
                  Unicode_Add(pupath,uslash);
                  Unicode_Add(pupath,ufn);
                  }else{
                  snprintf(papath,MaxFilenameLength,"%s/%s",pBaseAliasPath,afn);
                  Unicode_Add(pupath,pBaseUnicodePath);
                  Unicode_Add(pupath,uslash);
                  Unicode_Add(pupath,ufn);
                }
                
                ppAliasPaths[PathCount]=papath;
                ppUnicodePaths[PathCount]=pupath;
                
                PathCount++;
                EndPathIndex++;
                
                }else{
                _consolePrintf("FindPath buffer overflow.\n");
              }
            }
          }
        } break;
        case FT_FILE: {
        } break;
      }
      
      FAT_FileType=FAT_FindNextFile(afn);
    }
  }
  
  for(u32 idx=StartPathIndex;idx<EndPathIndex;idx++){
    IPKFileList_FindPathIns(ppAliasPaths[idx],ppUnicodePaths[idx]);
  }
}

// -----------------------------------------------------------------

static char *pTextPoolStart=NULL;
static char *pTextPoolEnd;
static char *pTextPoolPos;

static void InitTextPool(void)
{
  u32 size=1024*1024;
  
  pTextPoolStart=(char*)malloc(size);
  pTextPoolEnd=&pTextPoolStart[size];
  pTextPoolPos=pTextPoolStart;
}

static void EndTextPool(void)
{
  _consolePrintf("pTextPool used.%dkbyte remain.%dkbyte\n",(pTextPoolPos-pTextPoolStart)/1024,(pTextPoolEnd-pTextPoolPos)/1024);
  
  char *ptmp=(char*)realloc(pTextPoolStart,pTextPoolPos-pTextPoolStart);
  
  if(pTextPoolStart==ptmp){
    _consolePrint("Succeeded memory optimization.\n");
    }else{
    _consolePrintf("Fatal error!! realloc. 0x%x!=0x%x\n",pTextPoolStart,ptmp);
    ShowLogHalt();
  }
  
//  ExeclusiveWaitForPressButton();
  
//  pTextPoolStart=NULL;
  pTextPoolEnd=NULL;
  pTextPoolPos=NULL;
}

void FreeTextPool(void)
{
  if(pTextPoolStart!=NULL){
    free(pTextPoolStart); pTextPoolStart=NULL;
  }
}

static char* GetTextPool(u32 size)
{
  size=(size+3)&~3;
  
  char *p=pTextPoolPos;
  
  if(pTextPoolEnd<=(p+size)) return(NULL);
  
  pTextPoolPos+=size;
  
  return(p);
}

static char* GetTextPoolChar(u32 size)
{
  return((char*)GetTextPool(size*1));
}

static UnicodeChar* GetTextPoolUnicode(u32 size)
{
  return((UnicodeChar*)GetTextPool(size*2));
}

// -----------------------------------------------------------------

__attribute__((noinline)) static void IPKFileList_FindFilesIns(char *pBaseAliasPath,UnicodeChar *pBaseUnicodePath)
{
  _consolePrintf("FindFiles.%s\n",pBaseAliasPath);
  
  if(FAT_CWD(pBaseAliasPath)==false) return;
  
  {
    char INIFilename[]="imgview.ini";
    FAT_FILE *pf=FAT_fopen(INIFilename,"r");
    if(pf!=NULL){
      FAT_fclose(pf);
      char Alias[MaxFilenameLength];
      if(strcmp(pBaseAliasPath,"/")==0){
        snprintf(Alias,MaxFilenameLength,"/%s",INIFilename);
        }else{
        snprintf(Alias,MaxFilenameLength,"%s/%s",pBaseAliasPath,INIFilename);
      }
      strncpy(AliasINIFilename,Alias,MaxFilenameLength);
      _consolePrintf("INI file found. [%s]\n",AliasINIFilename);
    }
  }
  
  {
    const char msefn[]="reset.mse";
    FAT_FILE *pf=FAT_fopen(msefn,"r");
    if(pf!=NULL){
      FAT_fclose(pf);
      if(strcmp(pBaseAliasPath,"/")==0){
        snprintf(ResetMSEFilename,MaxFilenameLength,"/%s",msefn);
        }else{
        snprintf(ResetMSEFilename,MaxFilenameLength,"%s/%s",pBaseAliasPath,msefn);
      }
      _consolePrintf("Reset.mse file found. [%s]\n",ResetMSEFilename);
    }
  }
  
  {
    char BGMFilename[]="imgview.mp3";
    FAT_FILE *pf=FAT_fopen(BGMFilename,"r");
    if(pf!=NULL){
      FAT_fclose(pf);
      char Alias[MaxFilenameLength];
      if(strcmp(pBaseAliasPath,"/")==0){
        snprintf(Alias,MaxFilenameLength,"/%s",BGMFilename);
        }else{
        snprintf(Alias,MaxFilenameLength,"%s/%s",pBaseAliasPath,BGMFilename);
      }
      strncpy(AliasGlobalBGMFilename,Alias,MaxFilenameLength);
      _consolePrintf("Glolbal BGM file found. [%s]\n",AliasGlobalBGMFilename);
    }
  }
  
  char afn[MaxFilenameLength];
  UnicodeChar ufn[MaxFilenameLength];
  
  bool Stored=false;
  char *pStoreAliasPath=NULL;
  UnicodeChar *pStoreUnicodePath=NULL;
  
  {
    u32 FAT_FileType;
    FAT_FileType=FAT_FindFirstFile(afn);
    
    while(FAT_FileType!=FT_NONE){
      switch(FAT_FileType){
        case FT_NONE: break;
        case FT_DIR: {
        } break;
        case FT_FILE: {
          if(isStrEqual_NoCaseSensitive(&afn[StrGetLength(afn)-4],".IPK")==true){
            if(chkipk(pBaseAliasPath,afn)==true){
              if(FAT_GetLongFilenameUnicode(ufn,MaxFilenameLength)==false){
                _consolePrintf("Unicode filename read error.\n Alias='%s'\n",afn);
                }else{
                if((IPKFileListCount+1)<=IPKFileListMax){
                  if(Stored==false){
                    Stored=true;
                    pStoreAliasPath=GetTextPoolChar(strlen(pBaseAliasPath)+1);
                    strcpy(pStoreAliasPath,pBaseAliasPath);
                    pStoreUnicodePath=GetTextPoolUnicode(Unicode_GetLength(pBaseUnicodePath)+1);
                    Unicode_Copy(pStoreUnicodePath,pBaseUnicodePath);
                  }
                  TIPKFileListItem *pipkfn=&IPKFileList[IPKFileListCount];
                  
                  pipkfn->pAliasPath=pStoreAliasPath;
                  
                  pipkfn->pAliasFilename=GetTextPoolChar(strlen(afn)+1);
                  strcpy(pipkfn->pAliasFilename,afn);
                  
                  pipkfn->pUnicodePath=pStoreUnicodePath;
                  
                  pipkfn->pUnicodeFilename=GetTextPoolUnicode(Unicode_GetLength(ufn)+1);
                  Unicode_Copy(pipkfn->pUnicodeFilename,ufn);
                  
                  pipkfn->pAliasBGMPath=NULL;
                  pipkfn->pAliasBGMFilename=NULL;
                  IPKFileListCount++;
                }
              }
            }
          }
        } break;
      }
      
      FAT_FileType=FAT_FindNextFile(afn);
    }
  }
}

__attribute__((noinline)) static void IPKFileList_FindBGM(TIPKFileListItem *pipkfn)
{
  pipkfn->pAliasBGMPath=NULL;
  pipkfn->pAliasBGMFilename=NULL;
  
  if(FAT_CWD(pipkfn->pAliasPath)==false) return;
  
  char afn[MaxFilenameLength];
  UnicodeChar ufn[MaxFilenameLength];
  
  {
    u32 FAT_FileType;
    FAT_FileType=FAT_FindFirstFile(afn);
    
    while(FAT_FileType!=FT_NONE){
      switch(FAT_FileType){
        case FT_NONE: break;
        case FT_DIR: {
          if(FAT_GetLongFilenameUnicode(ufn,MaxFilenameLength)==false){
            _consolePrintf("Unicode filename read error.\n Alias='%s'\n",afn);
            }else{
            u32 ulen=Unicode_GetLength(ufn);
            ufn[ulen+0]='.'; ufn[ulen+1]='i'; ufn[ulen+2]='p'; ufn[ulen+3]='k'; ufn[ulen+4]=0;
            if(Unicode_isEqual_NoCaseSensitive(pipkfn->pUnicodeFilename,ufn)==true){
              pipkfn->pAliasBGMPath=GetTextPoolChar(strlen(afn)+1);
              strcpy(pipkfn->pAliasBGMPath,afn);
            }
          }
        } break;
        case FT_FILE: {
          if(isStrEqual_NoCaseSensitive(&afn[StrGetLength(afn)-4],".MP3")==true){
            if(FAT_GetLongFilenameUnicode(ufn,MaxFilenameLength)==false){
              _consolePrintf("Unicode filename read error.\n Alias='%s'\n",afn);
              }else{
              u32 ulen=Unicode_GetLength(ufn);
              ufn[ulen-4]='.'; ufn[ulen-3]='i'; ufn[ulen-2]='p'; ufn[ulen-1]='k';
              if(Unicode_isEqual_NoCaseSensitive(pipkfn->pUnicodeFilename,ufn)==true){
                pipkfn->pAliasBGMFilename=GetTextPoolChar(strlen(afn)+1);
                strcpy(pipkfn->pAliasBGMFilename,afn);
              }
            }
          }
        } break;
      }
      
      FAT_FileType=FAT_FindNextFile(afn);
    }
  }
  
  if(pipkfn->pAliasBGMFilename==NULL){
    pipkfn->pAliasBGMFilename=GetTextPoolChar(1);
    pipkfn->pAliasBGMFilename[0]=0;
  }
  
  if(pipkfn->pAliasBGMPath==NULL){
    pipkfn->pAliasBGMPath=GetTextPoolChar(1);
    pipkfn->pAliasBGMPath[0]=0;
  }
  
  if(pipkfn->pAliasBGMPath[0]!=0){
    pipkfn->BGMType=EBT_Path;
    }else{
    if(pipkfn->pAliasBGMFilename[0]!=0){
      pipkfn->BGMType=EBT_File;
      }else{
      if(AliasGlobalBGMFilename[0]!=0){
        pipkfn->BGMType=EBT_GlobalFile;
        }else{
        pipkfn->BGMType=EBT_None;
      }
    }
  }
}

inline static bool isSwapPath(TIPKFileListItem *pf0,TIPKFileListItem *pf1)
{
  UnicodeChar *puc0=pf0->pUnicodePath;
  UnicodeChar *puc1=pf1->pUnicodePath;
  
  while(1){
    u32 uc0=*puc0;
    u32 uc1=*puc1;
    if(((u32)'A'<=uc0)&&(uc0<=(u32)'Z')) uc0+=0x20;
    if(((u32)'A'<=uc1)&&(uc1<=(u32)'Z')) uc1+=0x20;
    
    if(uc0==uc1){
      if(uc0==0) return(false);
      }else{
      // t@C`FbN
      if(uc0==0) return(false);
      if(uc1==0) return(true);
      // r
      if(uc0<uc1) return(false);
      if(uc0>uc1) return(true);
    }
    
    puc0++; puc1++;
  }
  return(false);
}

inline static bool isEqualPath(TIPKFileListItem *pf0,TIPKFileListItem *pf1)
{
  UnicodeChar *puc0=pf0->pUnicodePath;
  UnicodeChar *puc1=pf1->pUnicodePath;
  
  while(1){
    u32 uc0=*puc0;
    u32 uc1=*puc1;
    
    if((uc0==0)&&(uc1==0)) break;
    
    if(((u32)'A'<=uc0)&&(uc0<=(u32)'Z')) uc0+=0x20;
    if(((u32)'A'<=uc1)&&(uc1<=(u32)'Z')) uc1+=0x20;
    
    if(uc0!=uc1){
      return(false);
    }
    
    puc0++; puc1++;
  }
  
  return(true);
}

inline static bool isSwapFile(TIPKFileListItem *pf0,TIPKFileListItem *pf1)
{
  UnicodeChar *puc0=pf0->pUnicodeFilename;
  UnicodeChar *puc1=pf1->pUnicodeFilename;
  
  while(1){
    u32 uc0=*puc0;
    u32 uc1=*puc1;
    if(((u32)'A'<=uc0)&&(uc0<=(u32)'Z')) uc0+=0x20;
    if(((u32)'A'<=uc1)&&(uc1<=(u32)'Z')) uc1+=0x20;
    
    if(uc0==uc1){
      if(uc0==0) return(false);
      }else{
      // t@C`FbN
      if(uc0==0) return(false);
      if(uc1==0) return(true);
      // r
      if(uc0<uc1) return(false);
      if(uc0>uc1) return(true);
    }
    
    puc0++; puc1++;
  }
  return(false);
}

static void IPKFileList_SortList(void)
{
  u32 Count=(u32)IPKFileListCount;
  
  if(Count<2) return;
  
  for(u32 idx0=0;idx0<Count-1;idx0++){
    for(u32 idx1=idx0+1;idx1<Count;idx1++){
      TIPKFileListItem *pf0=&IPKFileList[idx0];
      TIPKFileListItem *pf1=&IPKFileList[idx1];
      if(isSwapPath(pf0,pf1)==true){
        TIPKFileListItem ftemp=*pf0;
        *pf0=*pf1;
        *pf1=ftemp;
      }
    }
  }
  
  for(u32 idx0=0;idx0<Count-1;idx0++){
    for(u32 idx1=idx0+1;idx1<Count;idx1++){
      TIPKFileListItem *pf0=&IPKFileList[idx0];
      TIPKFileListItem *pf1=&IPKFileList[idx1];
      if(isEqualPath(pf0,pf1)==true){
        if(isSwapFile(pf0,pf1)==true){
          TIPKFileListItem ftemp=*pf0;
          *pf0=*pf1;
          *pf1=ftemp;
        }
      }
    }
  }
}

void IPKFileList_FindFiles(void)
{
  AliasINIFilename[0]=0;
  
  AliasGlobalBGMFilename[0]=0;
  AliasGlobalBGMFilePath[0]=0;
  
  _consolePrintf("find ipk files...\n");
  
  ppAliasPaths=(char**)safemalloc(FindPathMax*4);
  ppUnicodePaths=(UnicodeChar**)safemalloc(FindPathMax*4);
  for(u32 idx=0;idx<FindPathMax;idx++){
    ppAliasPaths[idx]=NULL;
    ppUnicodePaths[idx]=NULL;
  }
  
  PathCount=0;
  {
    char *papath=(char*)safemalloc(2);
    UnicodeChar *pupath=(UnicodeChar*)safemalloc(2*2);
    papath[0]='/';
    papath[1]=(char)0;
    pupath[0]=(UnicodeChar)'/';
    pupath[1]=(UnicodeChar)0;
    
    ppAliasPaths[PathCount]=papath;
    ppUnicodePaths[PathCount]=pupath;
    PathCount++;
  }
  IPKFileList_FindPathIns(NULL,NULL);
  _consolePrintf("PathCount=%d\n",PathCount);
  
  InitTextPool();
  
  IPKFileListCount=0;
  for(u32 idx=0;idx<PathCount;idx++){
    IPKFileList_FindFilesIns(ppAliasPaths[idx],ppUnicodePaths[idx]);
  }
  _consolePrintf("IPKFileListCount=%d\n",IPKFileListCount);
  
  for(u32 idx=0;idx<(u32)IPKFileListCount;idx++){
    IPKFileList_FindBGM(&IPKFileList[idx]);
  }
  
  EndTextPool();
  
  for(u32 idx=0;idx<FindPathMax;idx++){
    if(ppAliasPaths[idx]!=NULL){
      safefree(ppAliasPaths[idx]); ppAliasPaths[idx]=NULL;
    }
    if(ppUnicodePaths[idx]!=NULL){
      safefree(ppUnicodePaths[idx]); ppUnicodePaths[idx]=NULL;
    }
  }
  safefree(ppAliasPaths); ppAliasPaths=NULL;
  safefree(ppUnicodePaths); ppUnicodePaths=NULL;
  
  IPKFileList_SortList();
  
  if(IPKFileListCount==0) _consolePrintf("can not found ipk file.\n");
}

void IPKFileList_SetupGlobalBGMFolder(const char *pGlobalBGMFolder)
{
  AliasGlobalBGMFilePath[0]=0;
  
  if(pGlobalBGMFolder[0]==0) return;
  
  _consolePrintf("Check global BGM folder.\n");
  
  if(FAT_CWD(pGlobalBGMFolder)==false) return;
  
  char afn[MaxFilenameLength];
  
  {
    u32 FAT_FileType;
    FAT_FileType=FAT_FindFirstFile(afn);
    
    while(FAT_FileType!=FT_NONE){
      switch(FAT_FileType){
        case FT_NONE: break;
        case FT_DIR: break;
        case FT_FILE: {
          if(isStrEqual_NoCaseSensitive(&afn[StrGetLength(afn)-4],".MP3")==true){
            StrCopy(pGlobalBGMFolder,AliasGlobalBGMFilePath);
            _consolePrintf("Finded. '%s'\n",AliasGlobalBGMFilePath);
            for(u32 idx=0;idx<(u32)IPKFileListCount;idx++){
              TIPKFileListItem *pipkfn=&IPKFileList[idx];
              if(pipkfn->BGMType==EBT_None) pipkfn->BGMType=EBT_GlobalPath;
            }
            return;
          }
        } break;
      }
      
      FAT_FileType=FAT_FindNextFile(afn);
    }
  }
}

char *IPK_GetFullFilename(s32 IPKFileIndex)
{
  static char fullfn[MaxFilenameLength];
  if(strcmp(IPKFileList[IPKFileIndex].pAliasPath,"/")==0){
    snprintf(fullfn,MaxFilenameLength,"/%s",IPKFileList[IPKFileIndex].pAliasFilename);
    }else{
    snprintf(fullfn,MaxFilenameLength,"%s/%s",IPKFileList[IPKFileIndex].pAliasPath,IPKFileList[IPKFileIndex].pAliasFilename);
  }
  return(fullfn);
}

char *IPK_GetGlobalBGMFilename(void)
{
  return(AliasGlobalBGMFilename);
}

char *IPK_GetGlobalBGMFilePath(void)
{
  return(AliasGlobalBGMFilePath);
}

char *IPK_GetBGMPath(s32 IPKFileIndex)
{
  static char bgmfn[MaxFilenameLength];
  
  char *paliasfn=IPKFileList[IPKFileIndex].pAliasBGMPath;
  
  if((paliasfn==NULL)||(paliasfn[0]==0)){
    bgmfn[0]=0;
    }else{
    if(strcmp(IPKFileList[IPKFileIndex].pAliasPath,"/")==0){
      snprintf(bgmfn,MaxFilenameLength,"/%s",paliasfn);
      }else{
      snprintf(bgmfn,MaxFilenameLength,"%s/%s",IPKFileList[IPKFileIndex].pAliasPath,paliasfn);
    }
  }
  
  return(bgmfn);
}

char *IPK_GetBGMFilename(s32 IPKFileIndex)
{
  static char bgmfn[MaxFilenameLength];
  
  char *paliasfn=IPKFileList[IPKFileIndex].pAliasBGMFilename;
  
  if((paliasfn==NULL)||(paliasfn[0]==0)){
    bgmfn[0]=0;
    }else{
    if(strcmp(IPKFileList[IPKFileIndex].pAliasPath,"/")==0){
      snprintf(bgmfn,MaxFilenameLength,"/%s",paliasfn);
      }else{
      snprintf(bgmfn,MaxFilenameLength,"%s/%s",IPKFileList[IPKFileIndex].pAliasPath,paliasfn);
    }
  }
  
  return(bgmfn);
}

EBGMType IPK_GetBGMType(s32 IPKFileIndex)
{
  return(IPKFileList[IPKFileIndex].BGMType);
}

