
#ifndef inifile_h
#define inifile_h

#include "rect.h"

enum EiniSystemStartButtonFunction {ESSBF_ShortCut=0,ESSBF_SoftReset=1};

typedef struct {
  bool UseCheckDisk;
  u32 OverrideLanguageID;
  EiniSystemStartButtonFunction StartButtonFunction;
  bool FileSelectVertical;
  char GlobalMP3Folder[256];
} TiniSystem;

typedef struct {
  u32 DelayCount;
  u32 RateCount;
} TiniKeyRepeat;

typedef struct {
  bool SwitchModeEffect;
  bool ViewMode_DoubleScreenCompulsorily;
  u32 ViewMode_CornerIconTimeoutSec;
} TiniCustomConfig;

typedef struct {
  bool EnabledWrite;
  bool SC_EnabledDRAM;
  u32 EZ4_PSRAMSizeMByte;
} TiniAdapterConfig;

typedef struct {
  TiniSystem System;
  TiniKeyRepeat KeyRepeat;
  TiniCustomConfig CustomConfig;
  TiniAdapterConfig AdapterConfig;
} TGlobalINI;

extern TGlobalINI GlobalINI;

extern void InitINI(void);
extern void LoadINI(char *pINIFileBuf,u32 INIFileSize);

#endif


